###--- >>> `xmp11.06' <<<----- data from Example 11.6

	## alias	 help(xmp11.06)

##___ Examples ___:

data(xmp11.06)
xmp11.06$Stimulus <- factor(xmp11.06$Stimulus,
  labels = c("L1", "L2", "T", "L1 + L2", "L1 + T", "L2 + T"))
xmp11.06$Subject <- factor(xmp11.06$Subject)
plot(Resp ~ Stimulus, data = xmp11.06, col = "lightgray",
     main = "Data from Example 11.6",
     ylab = "Mean number of responses")
for (i in seq(along = levels(xmp11.06$Subject))) {
    attach(xmp11.06[ xmp11.06$Subject == i, ])
    lines(Resp ~ as.integer(Stimulus), col = i+1, type = "b")
}
legend(0.8, 95, paste("Subject", levels(xmp11.06$Subject)),
       col = 1 + seq(along = levels(xmp11.06$Subject)),
       lty = 1)
fm1 <- lm(Resp ~ Stimulus + Subject, data = xmp11.06)
anova(fm1)     # compare to Table 11.5, page 443
attach(xmp11.06)
means <- sort(tapply(Resp, Stimulus, mean))
means
diff(means)    # successive differences
qtukey(0.95, nmeans = 6, df = 15)  #for Tukey comparisons
detach()

## Keywords: 'datasets'.


