###--- >>> `amif' <<<----- Auto Mutual Information Function

	## alias	 help(amif)
	## alias	 help(plot.amif)

##___ Examples ___:

n <- 1000  # Length of simulated time series

e <- rnorm (n)  # Generate ARCH(1) process
x <- double (n)
x[1] <- rnorm (1)
for (i in 2:n)
{
  x[i] <- e[i]*sqrt(0.1+0.4*x[i-1]^2)
}
x <- ts(x)
plot (x)

# Each test takes about 3 sec on a Pentium II 300MHz

amif (x, lag.max=5)  # i.i.d. vs. any dependence 
amif (x, lag.max=5, fft=T)  # linear vs. non-linear 
amif (x, lag.max=5, fft=T, amplitude=T)

e <- rnorm (n)  # Generate AR(1) process
x <- double (n)
x[1] <- rnorm (1)
for (i in 2:n)
{
  x[i] <- 0.4*x[i-1]+e[i]
}
x <- ts(x)
plot (x)

amif (x, lag.max=5)  # i.i.d. vs. any dependence 
amif (x, lag.max=5, fft=T)  # linear vs. non-linear 
amif (x, lag.max=5, fft=T, amplitude=T)

## Keywords: 'ts'.


