###--- >>> `survfit' <<<----- Compute a Survival Curve for Censored Data

	## alias	 help(survfit)

##___ Examples ___:

#fit a Kaplan-Meier and plot it
data(aml)
fit <- survfit(Surv(time, status) ~ x, data=aml)
plot(fit)

# plot only 1 of the 2 curves from above
plot(fit[2])

#fit a cox proportional hazards model and plot the 
#predicted survival curve
data(ovarian)
fit <- coxph( Surv(futime,fustat)~resid.ds+rx+ecog.ps,data=ovarian)
plot( survfit( fit))

## Keywords: 'survival'.


