###--- >>> `partition' <<<----- Partitioning by Iterative Optimization

	## alias	 help(partition)

##___ Examples ___:

# Firstly, specifying the desired number of groups.
ng <- 3
pp <- partition(a,ng)
# How well did the partitioning do?
pp$ctot
# Plot the results in the plane comprising the first two columns of `a'
x <- a[,1]       # for convenience
y <- a[,2]
plot(x, y, type="n")     # set up plot scales, etc.
points(x[pp$memgp==1], y[pp$memgp==1],pch="*")
points(x[pp$memgp==2], y[pp$memgp==2],pch=".")
points(x[pp$memgp==3], y[pp$memgp==3],pch="o")

# Secondly, specifying guesses at cluster centers.
irismean <- t(apply(iris, c(2, 3), 'mean'))
x <- rbind(iris[,,1], iris[,,2], iris[,,3])
km <- partition(x, irismean)
wrong <- km$cluster!=rep(1:3, c(50, 50, 50))
spin(x, highlight=wrong)
plot(x[,2], x[,3], type="n")
text(x[!wrong, 2], x[!wrong, 3], km$cluster)
# identify cluster membership that is correct
points(x[wrong, 2], x[wrong, 3], pch=15)
# boxes for points in error
title(main="K-Means Clustering of the Iris Data")

# Now the hierarchy slicing case.
# Produce a hierarchical clustering and plot it.
clhier    <- hierclust(a)
motif()
plclust(clhier)
# Derive the 4-cluster partition from this.  Update plot of dendrogram.
clresult2 <- partition(clhier, 4, showslice=T)

## Keywords: 'clustering', 'partition', 'multivariate', 'optimization'.


