###--- >>> `multilm.summaries' <<<----- Stabilized Multivariate Tests

	## alias	 help(summary.multilm)

##___ Examples ___:

# Edgar Anderson's famous iris data
data(iris)
# one-classification MANOVA, Y response matrix, X designmatrix
Y <- as.matrix(iris[,1:4]);
x <- c(rep(1,50), rep(0,150), rep(1, 50), rep(0,150), rep(1,50))
X <- matrix(x, ncol=3)
# restrictions: sum of effects equal zero
Z <- c(0,1,1,1);
# test for equal effects
K <- cbind(0,diag(2),-1);
# model (this method returns a multilm object)
mod <- multilm(Y ~ X, K,Z);
# output and stable tests
summary(mod)		# Hotelling T^2: pvalue = 0
summary(mod, "SS")	# SS-Test: pvalue = 0
summary(mod, "PC-q")	# PC-q-Test: pvalue = 0
summary(mod, "PC-1")	# PC-1-Test: pvalue = 0
summary(mod, "CS")	# CS-Test: pvalue = 0
# the iris data is to good -> simulate a "bad" multivariate dataset 
# only 8 observations in 2 groups, 4 variables
observ <- c(1:4,51:54);
rY <- Y[observ,]
rX <- X[observ,1:2]
rZ <- c(0,1,1);
rK <- c(0,1,-1);
rmod <- multilm(rY ~ rX, rK, rZ);
summary(rmod)		# T^2: pvalue = .00052
summary(rmod, "SS")	# SS-Test: pvalue = .008
summary(rmod, "PC-q")	# PC-q-Test: pvalue = .000012
summary(rmod, "PC-1")	# PC-1-Test: pvalue = .0000038
summary(rmod, "CS")	# CS-Test: pvalue = .0002

## Keywords: 'multivariate linear models'.


