###--- >>> `G.Warpingreg' <<<----- Cross-validation for WARPing regression

	## alias	 help(G.Warpingreg)

##___ Examples ___:

data(faithful)
# Figure 6.3
gcv<-G.Warpingreg(faithful$eruptions,faithful$waiting,0.05,Mend=40)
aic<-G.Warpingreg(faithful$eruptions,faithful$waiting,0.05, selector=1, Mend=40)
plot(aic$h, aic$score, ylim=c(29.1,29.7), type="l")
lines(gcv$h, gcv$score, lty=2)

# Figure 6.4
plot(faithful$eruptions,faithful$waiting)
nw<-NW.kernel(faithful$eruptions, faithful$waiting, 0.65)
lines(nw$grid, nw$m)
nw<-NW.kernel(faithful$eruptions, faithful$waiting, 1.75)
lines(nw$grid, nw$m, lty=2)

data(dat.reg)
# Figure 6.5
gw <- G.Warpingreg(dat.reg$x, dat.reg$y, 0.0025,
  selector=1, Mstart=7, Mend=45)
plot(gw$h, gw$score, ylim=c(0.082,0.102), type="l")
gw <- G.Warpingreg(dat.reg$x, dat.reg$y, 0.0025,
  selector=2, Mstart=7, Mend=45)
lines(gw$h, gw$score, lty=2)
gw <- G.Warpingreg(dat.reg$x, dat.reg$y, 0.0025,
  selector=3, Mstart=7, Mend=45)
lines(gw$h, gw$score, lty=3)
gw <- G.Warpingreg(dat.reg$x, dat.reg$y, 0.0025,
  selector=4, Mstart=7,  Mend=45)
lines(gw$h, gw$score, lty=4)
gw <- G.Warpingreg(dat.reg$x, dat.reg$y, 0.0025,
  selector=5, Mstart=7, Mend=45)
lines(gw$h, gw$score, lty=5)

# Figure 6.6
plot(dat.reg)
lines(dat.reg$x, dat.reg$m)
nw<-NW.kernel(dat.reg$x, dat.reg$y, 0.0625)
lines(nw$grid, nw$m, lty=2)
nw<-NW.kernel(dat.reg$x, dat.reg$y, 0.025)
lines(nw$grid, nw$m, lty=3)

# Figure S.6.1
gw<-G.Warpingreg(faithful$eruptions,faithful$waiting,0.05,
   Mstart=8, Mend=40, boundary=0)
plot(gw$h, gw$score,ylim=c(29,33), type="l")
gw<-G.Warpingreg(faithful$eruptions,faithful$waiting,0.05,
   Mstart=8, Mend=40, boundary=0.05)
lines(gw$h, gw$score, lty=2)
gw<-G.Warpingreg(faithful$eruptions,faithful$waiting,0.05,
   Mstart=8, Mend=40, boundary=0.1)
lines(gw$h, gw$score, lty=3)

# Figure S.6.2
gw<-G.Warpingreg(dat.reg$x,dat.reg$y,0.0025,
   Mstart=8, Mend=40, boundary=0)
plot(gw$h, gw$score,ylim=c(0.085,0.110), type="l")
gw<-G.Warpingreg(dat.reg$x,dat.reg$y,0.0025,
   Mstart=8, Mend=40, boundary=0.05)
lines(gw$h, gw$score, lty=2)
gw<-G.Warpingreg(dat.reg$x,dat.reg$y,0.0025,
   Mstart=8, Mend=40, boundary=0.1)
lines(gw$h, gw$score, lty=3)




