###--- >>> `gnlr' <<<----- Fit a Generalized Nonlinear Regression Model

	## alias	 help(gnlr)
	## alias	 help(coefficients.gnlr)
	## alias	 help(deviance.gnlr)
	## alias	 help(df.residual.gnlr)
	## alias	 help(fitted.values.gnlr)
	## alias	 help(residuals.gnlr)
	## alias	 help(weights.gnlr)

##___ Examples ___:

y <- rgamma(10,2,5)
sex <- c(rep(0,5),rep(1,5))
sexf <- gl(2,5)
age <- rpois(10,10)
# linear regression with inverse Gauss distribution
mu <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr(y, dist="inverse Gauss", mu=mu, pmu=rep(1,3), pshape=1)
# or equivalently
gnlr(y, dist="inverse Gauss", mu=~sexf+age, pmu=rep(1,3), pshape=1)
# or
gnlr(y, dist="inverse Gauss", linear=~sex+age, pmu=rep(1,3), pshape=1)
# or
gnlr(y, dist="inverse Gauss", mu=~b0+b1*sex+b2*age,
	pmu=list(b0=1,b1=1,b2=1), pshape=1)
#
# nonlinear regression with inverse Gauss distribution
mu <- function(p, linear) p[1]+exp(linear)
gnlr(y, dist="inverse Gauss", mu=mu, linear=~sex+age, pmu=rep(1,4),
	pshape=1)
# or equivalently
gnlr(y, dist="inverse Gauss", mu=~b4+exp(b0+b1*sex+b2*age),
	pmu=list(b0=1,b1=1,b2=1,b4=1), pshape=1)
# one explicit parameter in mu, three in linear, one for shape
#
# include regression for the shape parameter with same mu function
shape <- function(p) p[1]+p[2]*sex+p[3]*age
gnlr(y, dist="inverse Gauss", mu=mu, linear=~sex+age, shape=shape,
	pmu=rep(1,4), pshape=rep(1,3))
# or equivalently
gnlr(y, dist="inverse Gauss", mu=mu, linear=~sexf+age,
	shape=~sexf+age, pmu=rep(1,4), pshape=rep(1,3))
# or
gnlr(y, dist="inverse Gauss", mu=mu, linear=list(~sex+age,~sex+age),
	pmu=rep(1,4),pshape=rep(1,3))
# or
gnlr(y, dist="inverse Gauss", mu=mu, linear=~sex+age,
	shape=~c0+c1*sex+c2*age, pmu=rep(1,4),
	pshape=list(c0=1,c1=1,c2=1))
# shape as a function of the mean
shape <- function(p, mu) p[1]+p[2]*sex+p[3]*mu
gnlr(y, dist="inverse Gauss", mu=~age, shape=shape, pmu=rep(1,2),
	pshape=rep(1,3), shfn=T)



