###--- >>> `fmr' <<<----- Fit a Generalized Nonlinear Regression Model with a Two or Three Point Mixture

	## alias	 help(fmr)
	## alias	 help(coefficients.fmr)
	## alias	 help(deviance.fmr)
	## alias	 help(df.residual.fmr)
	## alias	 help(fitted.values.fmr)
	## alias	 help(residuals.fmr)
	## alias	 help(weights.fmr)

##___ Examples ___:

y <- cbind(rweibull(20,2,5),rbinom(20,1,0.7))
sex <- c(rep(0,10),rep(1,10))
sexf <- gl(2,10)
age <- rpois(20,10)
# linear regression with Weibull distribution with a point mass
# for right censored individuals
mu <- function(p) p[1]+p[2]*sex+p[3]*age
fmr(y, dist="Weibull", mu=mu, pmu=rep(1,3), pmix=1, pshape=1)
# or equivalently
fmr(y, dist="Weibull", mu=~sexf+age, pmu=rep(1,3), pmix=1, pshape=1)
# or
fmr(y, dist="Weibull", linear=~sex+age, pmu=rep(1,3), pmix=1, pshape=1)
# or
fmr(y, dist="Weibull", mu=~b0+b1*sex+b2*age, pmu=list(b0=1,b1=1,b2=1),
	pmix=1, pshape=1)
#
# nonlinear regression with Weibull distribution
mu <- function(p, linear) p[1]*exp(linear)
fmr(y, dist="Weibull", mu=mu, linear=~sex+age, pmu=rep(1,4),
	pmix=1, pshape=1)
# or equivalently
fmr(y, dist="Weibull", mu=~b4*exp(b0+b1*sex+b2*age),
	pmu=list(b0=1,b1=1,b2=1,b4=1), pmix=1, pshape=1)
#
# include logistic regression for the mixture parameter
mix <- function(p) p[1]+p[2]*sex
fmr(y, dist="Weibull", mu=~age, mix=mix, pmu=rep(1,2),
	pmix=rep(1,2), pshape=1)
# or equivalently
fmr(y, dist="Weibull", linear=list(~age,~sex), pmu=rep(1,2),
	pmix=rep(1,2), pshape=1)
# or
fmr(y, dist="Weibull", mu=~b0+b1*age, mix=~c0+c1*sex,
	pmu=list(b0=1,b1=1), pmix=list(c0=1,c1=1), pshape=1)



