###--- >>> `fracdiff.var' <<<----- Recompute Covariance Estimate for fracdiff

##___ Examples ___:

# generate a fractionally-differenced ARIMA(1,d,1)
# model given initial values
ts.test <- fracdiff.sim( 10000, ar = .2, ma = .4, d = .3)
# estimate the parameters in an ARIMA(1,d,1)
# model for the simulated series
fd.out <- fracdiff(ts.test$ser, nar=length(ts.test$ar),
                   nma=length(ts.test$ma))
# modify the covariance estimate by changing the
# finite-difference interval
fracdiff.var(ts.test$series, fd.out, h = .0001) 



