###--- >>> `kalsurv' <<<----- Repeated Events Models for Changes over Time in the Presence of Time-varying Covariates and with Frailty or Various Types of Serial Dependence

##___ Examples ___:

treat <- c(0,0,1,1)
tr <- tcctomat(treat)
cens <- matrix(rbinom(20,1,0.9),ncol=5)
times <- # matrix(rweibull(20,2,1+3*rep(treat,5)),ncol=5)
	matrix(c(1.36,0.18,0.84,0.65,1.44,1.79,1.04,0.43,1.35,1.63,2.15,1.15,
		1.21,5.46,1.58,3.44,4.40,2.75,4.78,2.44),ncol=5,byrow=T)
times <- restovec(times, censor=cens)
reps <- rmna(times, ccov=tr)
# exponential intensity model with independence
kalsurv(times, pinitial=0.1, preg=1,
	dep="independence", intensity="exponential")
# Weibull intensity model with independence
kalsurv(times, pinitial=0.1, preg=1, pshape=1,
	dep="independence", intensity="Weibull")
# same model with serial update
kalsurv(times, pinitial=0.1, pdep=0.1, preg=1, pshape=1,
	dep="serial", intensity="Weibull")
# treatment effect with log link
kalsurv(times, pinitial=0.1, preg=c(1,0), pshape=1,
	intensity="Weibull", ccov=treat)
# or equivalently
kalsurv(times, mu=~exp(a+b*treat), pinitial=0.1, preg=c(1,0), pshape=1,
	intensity="Weibull", envir=reps)
# with identity link instead
kalsurv(times, mu=~treat, pinitial=0.1, preg=c(1,0), pshape=1,
	intensity="Weibull")
# or equivalently
kalsurv(times, mu=~a+b*treat, pinitial=0.1, preg=c(1,0), pshape=1,
	intensity="Weibull", envir=reps)
# add the birth model
kalsurv(times, pinitial=0.1, preg=c(1,0), pshape=1,
	intensity="Weibull", ccov=treat, pbirth=0)
# switch to gamma intensity model without birth effect
kalsurv(times, pinitial=0.1, preg=c(1,0), pshape=1, intensity="gamma",
	ccov=treat)
# try frailty dependence
kalsurv(times, pinitial=0.1, preg=c(1,0), pshape=1, dep="frailty",
	intensity="gamma", ccov=treat)



