

match.fun {base}                             R Documentation

_F_u_n_c_t_i_o_n _V_e_r_i_f_i_c_a_t_i_o_n _f_o_r _`_`_F_u_n_c_t_i_o_n _V_a_r_i_a_b_l_e_s_'_'

_D_e_s_c_r_i_p_t_i_o_n_:

     This function is called inside functions that take a
     function as argument. It's purpose is to extract the
     desired function object while avoiding undesired match-
     ing to objects of other types.

_U_s_a_g_e_:

     match.fun(FUN, descend = TRUE)

_A_r_g_u_m_e_n_t_s_:

     FUN: item to match as function.

 descend: logical; control whether to search past non-func-
          tion objects.

_D_e_t_a_i_l_s_:

     `match.fun' is not intended to be used at the top level
     since it will perform matching in the parent of the
     caller.

     It is assumed that `FUN' is an argument passed to the
     caller and is a function or a character string contain-
     ing the name of a function.

     Returns an error if no matching function is found.

_V_a_l_u_e_:

     A function matching `FUN' or an error is generated.

_B_u_g_s_:

     The `descend' argument is a bit of misnomer and proba-
     bly not actually needed by anything. It may go away in
     the future.

     It is impossible to fully foolproof this. If one
     `attach'es a list or data frame containing a character
     object with the same name of a system function, it will
     be used.

_A_u_t_h_o_r_(_s_)_:

     Peter Dalgaard and Robert Gentleman, based on an ear-
     lier version by Jonathan Rougier

_S_e_e _A_l_s_o_:

     `match.arg', `get'

_E_x_a_m_p_l_e_s_:

     # Same as get("*"):
     match.fun("*")
     # Overwrite outer with a vector
     outer <- 1:5

     match.fun(outer, descend = FALSE) #-> Error:  not a function

     match.fun(outer) # finds it anyway
     is.function(match.fun("outer")) # as well

