/*
 * Copyright (C) 1998 Albrecht Gebhardt
 *

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 * This is a library of functions for QIC volume table modification.
 * The functions are taken from the vtblc utility  distributed with the 
 * Linux ftape driver version 3.04d.
 *
 * The original Copyright notice follows:
 */

/*
 *      Copyright (C) 1997 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $Source: /usr/local/cvsroot/libvtblc/vtblc.h,v $
 * $Revision: 1.3 $
 * $Date: 1998/03/09 16:44:49 $
 *
 *     This file contains the definitions for the volume table
 *     manipulation tool for the the QIC-40/80/3010/3020 floppy-tape
 *     driver "ftape" for Linux.
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
/* #include <time.h> */
#include <getopt.h>
#include <ctype.h>
#include <time.h>

#include <linux/ftape.h>
#include <linux/ftape-vendors.h>
#include <linux/zftape.h>
#include <linux/ftape-header-segment.h>

#define VTBL_SIZE 128 /* bytes */

/* The following are offsets in the vtbl.  */
#define VTBL_SIG   0
#define VTBL_START 4
#define VTBL_END   6
#define VTBL_DESC  8
#define VTBL_DATE  52
#define VTBL_FLAGS 56
#define VTBL_FL_VENDOR_SPECIFIC (1<<0)
#define VTBL_FL_MUTLI_CARTRIDGE (1<<1)
#define VTBL_FL_NOT_VERIFIED    (1<<2)
#define VTBL_FL_REDIR_INHIBIT   (1<<3)
#define VTBL_FL_SEG_SPANNING    (1<<4)
#define VTBL_FL_DIRECTORY_LAST  (1<<5)
#define VTBL_FL_RESERVED_6      (1<<6)
#define VTBL_FL_RESERVED_7      (1<<7)
#define VTBL_M_NO  57
#define VTBL_EXT   58
#define EXT_ZFTAPE_SIG     0
#define EXT_ZFTAPE_BLKSZ  10
#define EXT_ZFTAPE_CMAP   12
#define EXT_ZFTAPE_QIC113 13
#define VTBL_PWD   84
#define VTBL_DIR_SIZE 92
#define VTBL_DATA_SIZE 96
#define VTBL_OS_VERSION 104
#define VTBL_SRC_DRIVE  106
#define VTBL_DEV        122
#define VTBL_RESERVED_1 123
#define VTBL_CMPR       124
#define VTBL_CMPR_UNREG 0x3f
#define VTBL_CMPR_USED  0x80
#define VTBL_FMT        125
#define VTBL_RESERVED_2 126
#define VTBL_RESERVED_3 127
/* compatability with pre revision K */
#define VTBL_K_CMPR     120 

/*  the next is used by QIC-3020 tapes with format code 6 (>2^16
 *  segments) It is specified in QIC-113, Rev. G, Section 5 (SCSI
 *  volume table). The difference is simply, that we only store the
 *  number of segments used, not the starting segment.
 */
#define VTBL_SCSI_SEGS  4 /* is a 4 byte value */

/*  one vtbl is 128 bytes, that results in a maximum number of
 *  29*1024/128 = 232 volumes.
 */
#define MAX_VOLUMES (FT_SEGMENT_SIZE/VTBL_SIZE)
#define VTBL_IDS { "VTBL", "XTBL", "UTID", "EXVT" } /* valid ids */

typedef struct vtbl {
    u_int8_t id[4];
    int fmt_code;
    u_int32_t date;
    u_int8_t  label[45];
    int start;
    int end;
    unsigned int modified:1;
} vtbl;

#define FTAPE_RAW_DEV "/dev/rawft0"
#define VTBLC_VERSION "$Revision: 1.3 $"

int raw_tape_open(const char *name, int mode);
int raw_tape_close(int tape_fd);
int read_vtbl(int tape_fd, vtbl *volumes, u_int8_t *buffer,
	      int *first_data_segment, int *last_data_segment);
int write_vtbl(int tape_fd, const vtbl *volumes, u_int8_t *buffer,
	       int vtbl_cnt, int first_data_segment, int write);
int read_header_segment(const int tape_fd,
			int *first_data_segment,
			int *last_data_segment);
void print_vtbl(const vtbl *volumes, int maxnum,
		int first_seg, int last_seg);
void print_one_vtbl(const vtbl *volumes,
		    int vtbl_no, int first_seg, int last_seg);
char *decode_date(u_int32_t timestamp);
int set_date(/* const */ char *date,
	     vtbl *volumes, int maxnum, int vtbl_no);
int set_label(const char *desc, vtbl *volumes, int maxnum, int vtbl_no);
int set_start(int end, vtbl *volumes, int maxnum, int vtbl_no);
int set_end(int end, vtbl *volumes, int maxnum, int vtbl_no);
int set_id(vtbl *volumes, int maxnum, int vtbl_no);
void set_vtbl_cntl(int verbose);
void get_vtbl_cntl(char *errstr, char *drivetype);


static vtbl volumes[MAX_VOLUMES];
static u_int8_t vtbl_buffer[FT_SEGMENT_SIZE];
static int num_volumes;



static enum {
    vtbl_none  = -1,
    vtbl_label = 0,
    vtbl_date  = 1,
    vtbl_start = 2,
    vtbl_end   = 3
} vtbl_tag = vtbl_none;

static enum {
    none     = 0,
    append   = 1,
    modify   = 2,
    trunc    = 3
} op_mode = none;


typedef struct vtbl_cntl {
    int verbose;
    char errstr[256];
    char drivetype[256];
} vtbl_cntl;

static vtbl_cntl volume_cntl = { 0, "", ""};

