package ONVIF::Analytics::Types::ReceiverConfiguration;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Mode_of :ATTR(:get<Mode>);
my %MediaUri_of :ATTR(:get<MediaUri>);
my %StreamSetup_of :ATTR(:get<StreamSetup>);

__PACKAGE__->_factory(
    [ qw(        Mode
        MediaUri
        StreamSetup

    ) ],
    {
        'Mode' => \%Mode_of,
        'MediaUri' => \%MediaUri_of,
        'StreamSetup' => \%StreamSetup_of,
    },
    {
        'Mode' => 'ONVIF::Analytics::Types::ReceiverMode',
        'MediaUri' => 'SOAP::WSDL::XSD::Typelib::Builtin::anyURI',
        'StreamSetup' => 'ONVIF::Analytics::Types::StreamSetup',
    },
    {

        'Mode' => 'Mode',
        'MediaUri' => 'MediaUri',
        'StreamSetup' => 'StreamSetup',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::ReceiverConfiguration

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ReceiverConfiguration from the namespace http://www.onvif.org/ver10/schema.

Describes the configuration of a receiver. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Mode


=item * MediaUri


=item * StreamSetup




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::ReceiverConfiguration
   Mode => $some_value, # ReceiverMode
   MediaUri =>  $some_value, # anyURI
   StreamSetup =>  { # ONVIF::Analytics::Types::StreamSetup
     Stream => $some_value, # StreamType
     Transport =>  { # ONVIF::Analytics::Types::Transport
       Protocol => $some_value, # TransportProtocol
     },
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

