//  mkgeo_grid -e 1000 -a -2 -b 2 > line2.geo
//  ./convect line2 1e-3 5 > line2.branch 
//  ./convect2 line2 1e-3 5 > line22.branch 
//  (./convect_error < line2.branch > line2-cmp.branch) 2>&1|g -v trace |g -v load |tee cv.gdat
//  (./convect_error < line22.branch > line22-cmp.branch) 2>&1|g -v trace |g -v load |tee cv2.gdat
#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "rotating-hill.h"
int main (int argc, char **argv) {
  environment rheolef (argc,argv);
  geo omega (argv[1]);
  string approx = (argc > 2) ? argv[2] : "P1";
  Float  nu     = (argc > 3) ? atof(argv[3]) : 1e-2;
  size_t n_max  = (argc > 4) ? atoi(argv[4]) : 50;
  size_t d = omega.dimension();
  Float delta_t = 2*acos(-1.)/n_max;
  space Vh (omega, approx, "vector");
  field uh = interpolate (Vh, u(d));
  space Xh (omega, approx);
  Xh.block ("boundary");
  field phi_h      = interpolate (Xh, phi(d,nu,0));
  field phi_h_prec = interpolate (Xh, phi(d,nu,0));
  characteristic X1 (  -delta_t*uh);
  characteristic X2 (-2*delta_t*uh);
  quadrature_option_type qopt;
  qopt.set_family (quadrature_option_type::gauss_lobatto);
  qopt.set_order (Xh.degree());
  trial varphi (Xh); test psi (Xh);
  branch event ("t","phi");
  dout << catchmark("nu") << nu << endl
       << event (0, phi_h);
  for (size_t n = 1; n <= n_max; n++) {
    Float t = n*delta_t;
    Float alpha = Float(1.5) + delta_t*phi::sigma(d,nu,t);
    Float beta  = delta_t*nu;
    form c = integrate (alpha*varphi*psi + beta*dot(grad(varphi),grad(psi)), qopt);
    field lh =  Float(2.0)*integrate (compose(phi_h,      X1)*psi, qopt)
              - Float(0.5)*integrate (compose(phi_h_prec, X2)*psi, qopt);
#ifdef TODO // boost::proto & g++-4.8
    field lh = integrate ((Float(2)*compose(phi_h, X1) - Float(0.5)*compose(phi_h_prec, X2))*psi, qopt);
#endif // TODO
    solver sc (c.uu());
    phi_h_prec = phi_h;
    phi_h.set_u() = sc.solve (lh.u() - c.ub()*phi_h.b());
    dout << event (t, phi_h);
  }
}
