% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{RelativeCounts}
\alias{RelativeCounts}
\title{Normalize raw data to fractions}
\usage{
RelativeCounts(data, scale.factor = 1, verbose = TRUE)
}
\arguments{
\item{data}{Matrix with the raw count data}

\item{scale.factor}{Scale the result. Default is 1}

\item{verbose}{Print progress}
}
\value{
Returns a matrix with the relative counts
}
\description{
Normalize count data to relative counts per cell by dividing by the total
per cell. Optionally use a scale factor, e.g. for counts per million (CPM)
use \code{scale.factor = 1e6}.
}
\examples{
mat <- matrix(data = rbinom(n = 25, size = 5, prob = 0.2), nrow = 5)
mat
mat_norm <- RelativeCounts(data = mat)
mat_norm

}
\concept{preprocessing}
