/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2020 - 2025 Intel Corporation
 */

#ifndef IPU7_ISYS_CSI2_REG_H
#define IPU7_ISYS_CSI2_REG_H

/* IS main regs base */
#define IS_MAIN_BASE				(0x240000U)
#define IS_MAIN_S2B_BASE			(IS_MAIN_BASE + 0x22000U)
#define IS_MAIN_B2O_BASE			(IS_MAIN_BASE + 0x26000U)
#define IS_MAIN_ISD_M0_BASE			(IS_MAIN_BASE + 0x2b000U)
#define IS_MAIN_ISD_M1_BASE			(IS_MAIN_BASE + 0x2b100U)
#define IS_MAIN_ISD_INT_BASE			(IS_MAIN_BASE + 0x2b200U)
#define IS_MAIN_GDA_BASE			(IS_MAIN_BASE + 0x32000U)
#define IS_MAIN_GPREGS_MAIN_BASE		(IS_MAIN_BASE + 0x32500U)
#define IS_MAIN_IRQ_CTRL_BASE			(IS_MAIN_BASE + 0x32700U)
#define IS_MAIN_PWM_CTRL_BASE			(IS_MAIN_BASE + 0x32b00U)

#define S2B_IRQ_COMMON_0_CTL_STATUS		(IS_MAIN_S2B_BASE + 0x1cU)
#define S2B_IRQ_COMMON_0_CTL_CLEAR		(IS_MAIN_S2B_BASE + 0x20U)
#define S2B_IRQ_COMMON_0_CTL_ENABLE		(IS_MAIN_S2B_BASE + 0x24U)
#define S2B_IID_IRQ_CTL_STATUS(iid)		(IS_MAIN_S2B_BASE + 0x94U + \
						 0x100U * (iid))

#define B2O_IRQ_COMMON_0_CTL_STATUS		(IS_MAIN_B2O_BASE + 0x30U)
#define B2O_IRQ_COMMON_0_CTL_CLEAR		(IS_MAIN_B2O_BASE + 0x34U)
#define B2O_IRQ_COMMON_0_CTL_ENABLE		(IS_MAIN_B2O_BASE + 0x38U)
#define B2O_IID_IRQ_CTL_STATUS(oid)		(IS_MAIN_B2O_BASE + 0x3dcU + \
						 0x200U * (oid))

#define ISD_M0_IRQ_CTL_STATUS			(IS_MAIN_ISD_M0_BASE + 0x1cU)
#define ISD_M0_IRQ_CTL_CLEAR			(IS_MAIN_ISD_M0_BASE + 0x20U)
#define ISD_M0_IRQ_CTL_ENABLE			(IS_MAIN_ISD_M0_BASE + 0x24U)

#define ISD_M1_IRQ_CTL_STATUS			(IS_MAIN_ISD_M1_BASE + 0x1cU)
#define ISD_M1_IRQ_CTL_CLEAR			(IS_MAIN_ISD_M1_BASE + 0x20U)
#define ISD_M1_IRQ_CTL_ENABLE			(IS_MAIN_ISD_M1_BASE + 0x24U)

#define ISD_INT_IRQ_CTL_STATUS			(IS_MAIN_ISD_INT_BASE + 0x1cU)
#define ISD_INT_IRQ_CTL_CLEAR			(IS_MAIN_ISD_INT_BASE + 0x20U)
#define ISD_INT_IRQ_CTL_ENABLE			(IS_MAIN_ISD_INT_BASE + 0x24U)

#define GDA_IRQ_CTL_STATUS			(IS_MAIN_GDA_BASE + 0x1cU)
#define GDA_IRQ_CTL_CLEAR			(IS_MAIN_GDA_BASE + 0x20U)
#define GDA_IRQ_CTL_ENABLE			(IS_MAIN_GDA_BASE + 0x24U)

#define IS_MAIN_IRQ_CTL_EDGE			IS_MAIN_IRQ_CTRL_BASE
#define IS_MAIN_IRQ_CTL_MASK			(IS_MAIN_IRQ_CTRL_BASE + 0x4U)
#define IS_MAIN_IRQ_CTL_STATUS			(IS_MAIN_IRQ_CTRL_BASE + 0x8U)
#define IS_MAIN_IRQ_CTL_CLEAR			(IS_MAIN_IRQ_CTRL_BASE + 0xcU)
#define IS_MAIN_IRQ_CTL_ENABLE			(IS_MAIN_IRQ_CTRL_BASE + 0x10U)
#define IS_MAIN_IRQ_CTL_LEVEL_NOT_PULSE		(IS_MAIN_IRQ_CTRL_BASE + 0x14U)

/* IS IO regs base */
#define IS_PHY_NUM				(4U)
#define IS_IO_BASE				(0x280000U)

/* dwc csi cdphy registers */
#define IS_IO_CDPHY_BASE(i)			(IS_IO_BASE + 0x10000U * (i))
#define PPI_STARTUP_RW_COMMON_DPHY_0			0x1800U
#define PPI_STARTUP_RW_COMMON_DPHY_1			0x1802U
#define PPI_STARTUP_RW_COMMON_DPHY_2			0x1804U
#define PPI_STARTUP_RW_COMMON_DPHY_3			0x1806U
#define PPI_STARTUP_RW_COMMON_DPHY_4			0x1808U
#define PPI_STARTUP_RW_COMMON_DPHY_5			0x180aU
#define PPI_STARTUP_RW_COMMON_DPHY_6			0x180cU
#define PPI_STARTUP_RW_COMMON_DPHY_7			0x180eU
#define PPI_STARTUP_RW_COMMON_DPHY_8			0x1810U
#define PPI_STARTUP_RW_COMMON_DPHY_9			0x1812U
#define PPI_STARTUP_RW_COMMON_DPHY_A			0x1814U
#define PPI_STARTUP_RW_COMMON_DPHY_10			0x1820U
#define PPI_STARTUP_RW_COMMON_STARTUP_1_1		0x1822U
#define PPI_STARTUP_RW_COMMON_STARTUP_1_2		0x1824U
#define PPI_CALIBCTRL_RW_COMMON_CALIBCTRL_2_0		0x1840U
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_1		0x1842U
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_2		0x1844U
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_3		0x1846U
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_4		0x1848U
#define PPI_CALIBCTRL_R_COMMON_CALIBCTRL_2_5		0x184aU
#define PPI_CALIBCTRL_RW_COMMON_BG_0			0x184cU
#define PPI_CALIBCTRL_RW_COMMON_CALIBCTRL_2_7		0x184eU
#define PPI_CALIBCTRL_RW_ADC_CFG_0			0x1850U
#define PPI_CALIBCTRL_RW_ADC_CFG_1			0x1852U
#define PPI_CALIBCTRL_R_ADC_DEBUG			0x1854U
#define PPI_RW_LPDCOCAL_TOP_OVERRIDE			0x1c00U
#define PPI_RW_LPDCOCAL_TIMEBASE			0x1c02U
#define PPI_RW_LPDCOCAL_NREF				0x1c04U
#define PPI_RW_LPDCOCAL_NREF_RANGE			0x1c06U
#define PPI_RW_LPDCOCAL_NREF_TRIGGER_MAN		0x1c08U
#define PPI_RW_LPDCOCAL_TWAIT_CONFIG			0x1c0aU
#define PPI_RW_LPDCOCAL_VT_CONFIG			0x1c0cU
#define PPI_R_LPDCOCAL_DEBUG_RB				0x1c0eU
#define PPI_RW_LPDCOCAL_COARSE_CFG			0x1c10U
#define PPI_R_LPDCOCAL_DEBUG_COARSE_RB			0x1c12U
#define PPI_R_LPDCOCAL_DEBUG_COARSE_MEAS_0_RB		0x1c14U
#define PPI_R_LPDCOCAL_DEBUG_COARSE_MEAS_1_RB		0x1c16U
#define PPI_R_LPDCOCAL_DEBUG_COARSE_FWORD_RB		0x1c18U
#define PPI_R_LPDCOCAL_DEBUG_MEASURE_CURR_ERROR		0x1c1aU
#define PPI_R_LPDCOCAL_DEBUG_MEASURE_LAST_ERROR		0x1c1cU
#define PPI_R_LPDCOCAL_DEBUG_VT				0x1c1eU
#define PPI_RW_LB_TIMEBASE_CONFIG			0x1c20U
#define PPI_RW_LB_STARTCMU_CONFIG			0x1c22U
#define PPI_R_LBPULSE_COUNTER_RB			0x1c24U
#define PPI_R_LB_START_CMU_RB				0x1c26U
#define PPI_RW_LB_DPHY_BURST_START			0x1c28U
#define PPI_RW_LB_CPHY_BURST_START			0x1c2aU
#define PPI_RW_DDLCAL_CFG_0				0x1c40U
#define PPI_RW_DDLCAL_CFG_1				0x1c42U
#define PPI_RW_DDLCAL_CFG_2				0x1c44U
#define PPI_RW_DDLCAL_CFG_3				0x1c46U
#define PPI_RW_DDLCAL_CFG_4				0x1c48U
#define PPI_RW_DDLCAL_CFG_5				0x1c4aU
#define PPI_RW_DDLCAL_CFG_6				0x1c4cU
#define PPI_RW_DDLCAL_CFG_7				0x1c4eU
#define PPI_R_DDLCAL_DEBUG_0				0x1c50U
#define PPI_R_DDLCAL_DEBUG_1				0x1c52U
#define PPI_RW_PARITY_TEST				0x1c60U
#define PPI_RW_STARTUP_OVR_0				0x1c62U
#define PPI_RW_STARTUP_STATE_OVR_1			0x1c64U
#define PPI_RW_DTB_SELECTOR				0x1c66U
#define PPI_RW_DPHY_CLK_SPARE				0x1c6aU
#define PPI_RW_COMMON_CFG				0x1c6cU
#define PPI_RW_TERMCAL_CFG_0				0x1c80U
#define PPI_R_TERMCAL_DEBUG_0				0x1c82U
#define PPI_RW_TERMCAL_CTRL_0				0x1c84U
#define PPI_RW_OFFSETCAL_CFG_0				0x1ca0U
#define PPI_R_OFFSETCAL_DEBUG_LANE0			0x1ca2U
#define PPI_R_OFFSETCAL_DEBUG_LANE1			0x1ca4U
#define PPI_R_OFFSETCAL_DEBUG_LANE2			0x1ca6U
#define PPI_R_OFFSETCAL_DEBUG_LANE3			0x1ca8U
#define PPI_R_OFFSETCAL_DEBUG_LANE4			0x1caaU
#define PPI_RW_HSDCOCAL_CFG_O				0x1d00U
#define PPI_RW_HSDCOCAL_CFG_1				0x1d02U
#define PPI_RW_HSDCOCAL_CFG_2				0x1d04U
#define PPI_RW_HSDCOCAL_CFG_3				0x1d06U
#define PPI_RW_HSDCOCAL_CFG_4				0x1d08U
#define PPI_RW_HSDCOCAL_CFG_5				0x1d0aU
#define PPI_RW_HSDCOCAL_CFG_6				0x1d0cU
#define PPI_RW_HSDCOCAL_CFG_7				0x1d0eU
#define PPI_RW_HSDCOCAL_CFG_8				0x1d10U
#define PPI_R_HSDCOCAL_DEBUG_RB				0x1d12U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_0	0x2000U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_1	0x2002U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_2	0x2004U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_3	0x2006U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_4	0x2008U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_5	0x200aU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_6	0x200cU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_7	0x200eU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE0_OVR_0_8	0x2010U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_9	0x2012U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_10	0x2014U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_11	0x2016U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_12	0x2018U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_13	0x201aU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_14	0x201cU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE0_OVR_0_15	0x201eU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_0	0x2020U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_1	0x2022U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_2	0x2024U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_3	0x2026U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_4	0x2028U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_5	0x202aU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_6	0x202cU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_7	0x202eU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_8	0x2030U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_1_9	0x2032U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_10	0x2034U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_11	0x2036U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_12	0x2038U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_13	0x203aU
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_14	0x203cU
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_1_15	0x203eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_0		0x2040U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_1		0x2042U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_2		0x2044U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_3		0x2046U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_4		0x2048U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_5		0x204aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_6		0x204cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_7		0x204eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_8		0x2050U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_9		0x2052U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_10		0x2054U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_11		0x2056U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_12		0x2058U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_13		0x205aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_14		0x205cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_2_15		0x205eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_0		0x2060U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_1		0x2062U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_2		0x2064U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_3		0x2066U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_4		0x2068U
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_5		0x206aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_6		0x206cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE0_CTRL_3_7		0x206eU
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_8		0x2070U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_9		0x2072U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_10		0x2074U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_11		0x2076U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_12		0x2078U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_13		0x207aU
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_14		0x207cU
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_3_15		0x207eU
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_0		0x2080U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_1		0x2082U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_2		0x2084U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_3		0x2086U
#define CORE_DIG_IOCTRL_R_AFE_LANE0_CTRL_4_4		0x2088U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_5_0	0x20a0U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_5_1	0x20a2U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_5_2	0x20a4U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE0_OVR_5_3	0x20a6U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE0_OVR_5_4	0x20a8U
#define CORE_DIG_RW_TRIO0_0				0x2100U
#define CORE_DIG_RW_TRIO0_1				0x2102U
#define CORE_DIG_RW_TRIO0_2				0x2104U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_0	0x2400U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_1	0x2402U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_2	0x2404U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_3	0x2406U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_4	0x2408U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_5	0x240aU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_6	0x240cU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_7	0x240eU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE1_OVR_0_8	0x2410U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_9	0x2412U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_10	0x2414U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_11	0x2416U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_12	0x2418U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_13	0x241aU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_14	0x241cU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE1_OVR_0_15	0x241eU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_0	0x2420U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_1	0x2422U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_2	0x2424U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_3	0x2426U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_4	0x2428U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_5	0x242aU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_6	0x242cU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_7	0x242eU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_8	0x2430U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_1_9	0x2432U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_10	0x2434U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_11	0x2436U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_12	0x2438U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_13	0x243aU
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_14	0x243cU
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_1_15	0x243eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_0		0x2440U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_1		0x2442U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_2		0x2444U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_3		0x2446U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_4		0x2448U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_5		0x244aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_6		0x244cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_7		0x244eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_8		0x2450U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_9		0x2452U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_10		0x2454U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_11		0x2456U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_12		0x2458U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_13		0x245aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_14		0x245cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_2_15		0x245eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_0		0x2460U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_1		0x2462U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_2		0x2464U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_3		0x2466U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_4		0x2468U
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_5		0x246aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_6		0x246cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE1_CTRL_3_7		0x246eU
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_8		0x2470U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_9		0x2472U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_10		0x2474U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_11		0x2476U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_12		0x2478U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_13		0x247aU
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_14		0x247cU
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_3_15		0x247eU
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_0		0x2480U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_1		0x2482U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_2		0x2484U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_3		0x2486U
#define CORE_DIG_IOCTRL_R_AFE_LANE1_CTRL_4_4		0x2488U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_5_0	0x24a0U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_5_1	0x24a2U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_5_2	0x24a4U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE1_OVR_5_3	0x24a6U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE1_OVR_5_4	0x24a8U
#define CORE_DIG_RW_TRIO1_0				0x2500U
#define CORE_DIG_RW_TRIO1_1				0x2502U
#define CORE_DIG_RW_TRIO1_2				0x2504U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_0	0x2800U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_1	0x2802U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_2	0x2804U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_3	0x2806U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_4	0x2808U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_5	0x280aU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_6	0x280cU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_7	0x280eU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE2_OVR_0_8	0x2810U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_9	0x2812U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_10	0x2814U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_11	0x2816U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_12	0x2818U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_13	0x281aU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_14	0x281cU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE2_OVR_0_15	0x281eU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_0	0x2820U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_1	0x2822U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_2	0x2824U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_3	0x2826U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_4	0x2828U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_5	0x282aU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_6	0x282cU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_7	0x282eU
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_8	0x2830U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_1_9	0x2832U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_10	0x2834U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_11	0x2836U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_12	0x2838U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_13	0x283aU
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_14	0x283cU
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_1_15	0x283eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_0		0x2840U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_1		0x2842U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_2		0x2844U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_3		0x2846U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_4		0x2848U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_5		0x284aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_6		0x284cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_7		0x284eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_8		0x2850U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_9		0x2852U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_10		0x2854U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_11		0x2856U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_12		0x2858U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_13		0x285aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_14		0x285cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_2_15		0x285eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_0		0x2860U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_1		0x2862U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_2		0x2864U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_3		0x2866U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_4		0x2868U
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_5		0x286aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_6		0x286cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE2_CTRL_3_7		0x286eU
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_8		0x2870U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_9		0x2872U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_10		0x2874U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_11		0x2876U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_12		0x2878U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_13		0x287aU
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_14		0x287cU
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_3_15		0x287eU
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_0		0x2880U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_1		0x2882U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_2		0x2884U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_3		0x2886U
#define CORE_DIG_IOCTRL_R_AFE_LANE2_CTRL_4_4		0x2888U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_5_0	0x28a0U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_5_1	0x28a2U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_5_2	0x28a4U
#define CORE_DIG_IOCTRL_RW_CPHY_PPI_LANE2_OVR_5_3	0x28a6U
#define CORE_DIG_IOCTRL_R_CPHY_PPI_LANE2_OVR_5_4	0x28a8U
#define CORE_DIG_RW_TRIO2_0				0x2900U
#define CORE_DIG_RW_TRIO2_1				0x2902U
#define CORE_DIG_RW_TRIO2_2				0x2904U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_0	0x2c00U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_1	0x2c02U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_2	0x2c04U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_3	0x2c06U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_4	0x2c08U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_5	0x2c0aU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_6	0x2c0cU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_7	0x2c0eU
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_LANE3_OVR_0_8	0x2c10U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_9	0x2c12U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_10	0x2c14U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_11	0x2c16U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_12	0x2c18U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_13	0x2c1aU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_14	0x2c1cU
#define CORE_DIG_IOCTRL_R_DPHY_PPI_LANE3_OVR_0_15	0x2c1eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_0		0x2c40U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_1		0x2c42U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_2		0x2c44U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_3		0x2c46U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_4		0x2c48U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_5		0x2c4aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_6		0x2c4cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_7		0x2c4eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_8		0x2c50U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_9		0x2c52U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_10		0x2c54U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_11		0x2c56U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_12		0x2c58U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_13		0x2c5aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_14		0x2c5cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_2_15		0x2c5eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_0		0x2c60U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_1		0x2c62U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_2		0x2c64U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_3		0x2c66U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_4		0x2c68U
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_5		0x2c6aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_6		0x2c6cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE3_CTRL_3_7		0x2c6eU
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_8		0x2c70U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_9		0x2c72U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_10		0x2c74U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_11		0x2c76U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_12		0x2c78U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_13		0x2c7aU
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_14		0x2c7cU
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_3_15		0x2c7eU
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_0		0x2c80U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_1		0x2c82U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_2		0x2c84U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_3		0x2c86U
#define CORE_DIG_IOCTRL_R_AFE_LANE3_CTRL_4_4		0x2c88U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_0		0x3040U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_1		0x3042U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_2		0x3044U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_3		0x3046U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_4		0x3048U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_5		0x304aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_6		0x304cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_7		0x304eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_8		0x3050U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_9		0x3052U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_10		0x3054U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_11		0x3056U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_12		0x3058U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_13		0x305aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_14		0x305cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_2_15		0x305eU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_0		0x3060U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_1		0x3062U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_2		0x3064U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_3		0x3066U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_4		0x3068U
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_5		0x306aU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_6		0x306cU
#define CORE_DIG_IOCTRL_RW_AFE_LANE4_CTRL_3_7		0x306eU
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_8		0x3070U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_9		0x3072U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_10		0x3074U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_11		0x3076U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_12		0x3078U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_13		0x307aU
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_14		0x307cU
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_3_15		0x307eU
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_0		0x3080U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_1		0x3082U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_2		0x3084U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_3		0x3086U
#define CORE_DIG_IOCTRL_R_AFE_LANE4_CTRL_4_4		0x3088U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_CLK_OVR_0_0		0x3400U
#define CORE_DIG_IOCTRL_RW_DPHY_PPI_CLK_OVR_0_1		0x3402U
#define CORE_DIG_IOCTRL_R_DPHY_PPI_CLK_OVR_0_2		0x3404U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_0		0x3800U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_1		0x3802U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_2		0x3804U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_3		0x3806U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_4		0x3808U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_5		0x380aU
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_6		0x380cU
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_7		0x380eU
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_8		0x3810U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_9		0x3812U
#define CORE_DIG_IOCTRL_RW_COMMON_PPI_OVR_0_10		0x3814U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_11		0x3816U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_12		0x3818U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_13		0x381aU
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_14		0x381cU
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_0_15		0x381eU
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_0		0x3820U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_1		0x3822U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_2		0x3824U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_3		0x3826U
#define CORE_DIG_IOCTRL_R_COMMON_PPI_OVR_1_4		0x3828U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_0		0x3840U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_1		0x3842U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_2		0x3844U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_3		0x3846U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_4		0x3848U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_5		0x384aU
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_6		0x384cU
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_7		0x384eU
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_8		0x3850U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_9		0x3852U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_10		0x3854U
#define CORE_DIG_IOCTRL_RW_AFE_CB_CTRL_2_11		0x3856U
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_12		0x3858U
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_13		0x385aU
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_14		0x385cU
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_2_15		0x385eU
#define CORE_DIG_IOCTRL_R_AFE_CB_CTRL_3_0		0x3860U
#define CORE_DIG_RW_COMMON_0				0x3880U
#define CORE_DIG_RW_COMMON_1				0x3882U
#define CORE_DIG_RW_COMMON_2				0x3884U
#define CORE_DIG_RW_COMMON_3				0x3886U
#define CORE_DIG_RW_COMMON_4				0x3888U
#define CORE_DIG_RW_COMMON_5				0x388aU
#define CORE_DIG_RW_COMMON_6				0x388cU
#define CORE_DIG_RW_COMMON_7				0x388eU
#define CORE_DIG_RW_COMMON_8				0x3890U
#define CORE_DIG_RW_COMMON_9				0x3892U
#define CORE_DIG_RW_COMMON_10				0x3894U
#define CORE_DIG_RW_COMMON_11				0x3896U
#define CORE_DIG_RW_COMMON_12				0x3898U
#define CORE_DIG_RW_COMMON_13				0x389aU
#define CORE_DIG_RW_COMMON_14				0x389cU
#define CORE_DIG_RW_COMMON_15				0x389eU
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_0		0x39e0U
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_1		0x39e2U
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_2		0x39e4U
#define CORE_DIG_ANACTRL_RW_COMMON_ANACTRL_3		0x39e6U
#define CORE_DIG_COMMON_RW_DESKEW_FINE_MEM		0x3fe0U
#define CORE_DIG_COMMON_R_DESKEW_FINE_MEM		0x3fe2U
#define PPI_RW_DPHY_LANE0_LBERT_0			0x4000U
#define PPI_RW_DPHY_LANE0_LBERT_1			0x4002U
#define PPI_R_DPHY_LANE0_LBERT_0			0x4004U
#define PPI_R_DPHY_LANE0_LBERT_1			0x4006U
#define PPI_RW_DPHY_LANE0_SPARE				0x4008U
#define PPI_RW_DPHY_LANE1_LBERT_0			0x4400U
#define PPI_RW_DPHY_LANE1_LBERT_1			0x4402U
#define PPI_R_DPHY_LANE1_LBERT_0			0x4404U
#define PPI_R_DPHY_LANE1_LBERT_1			0x4406U
#define PPI_RW_DPHY_LANE1_SPARE				0x4408U
#define PPI_RW_DPHY_LANE2_LBERT_0			0x4800U
#define PPI_RW_DPHY_LANE2_LBERT_1			0x4802U
#define PPI_R_DPHY_LANE2_LBERT_0			0x4804U
#define PPI_R_DPHY_LANE2_LBERT_1			0x4806U
#define PPI_RW_DPHY_LANE2_SPARE				0x4808U
#define PPI_RW_DPHY_LANE3_LBERT_0			0x4c00U
#define PPI_RW_DPHY_LANE3_LBERT_1			0x4c02U
#define PPI_R_DPHY_LANE3_LBERT_0			0x4c04U
#define PPI_R_DPHY_LANE3_LBERT_1			0x4c06U
#define PPI_RW_DPHY_LANE3_SPARE				0x4c08U
#define CORE_DIG_DLANE_0_RW_CFG_0			0x6000U
#define CORE_DIG_DLANE_0_RW_CFG_1			0x6002U
#define CORE_DIG_DLANE_0_RW_CFG_2			0x6004U
#define CORE_DIG_DLANE_0_RW_LP_0			0x6080U
#define CORE_DIG_DLANE_0_RW_LP_1			0x6082U
#define CORE_DIG_DLANE_0_RW_LP_2			0x6084U
#define CORE_DIG_DLANE_0_R_LP_0				0x60a0U
#define CORE_DIG_DLANE_0_R_LP_1				0x60a2U
#define CORE_DIG_DLANE_0_R_HS_TX_0			0x60e0U
#define CORE_DIG_DLANE_0_RW_HS_RX_0			0x6100U
#define CORE_DIG_DLANE_0_RW_HS_RX_1			0x6102U
#define CORE_DIG_DLANE_0_RW_HS_RX_2			0x6104U
#define CORE_DIG_DLANE_0_RW_HS_RX_3			0x6106U
#define CORE_DIG_DLANE_0_RW_HS_RX_4			0x6108U
#define CORE_DIG_DLANE_0_RW_HS_RX_5			0x610aU
#define CORE_DIG_DLANE_0_RW_HS_RX_6			0x610cU
#define CORE_DIG_DLANE_0_RW_HS_RX_7			0x610eU
#define CORE_DIG_DLANE_0_RW_HS_RX_8			0x6110U
#define CORE_DIG_DLANE_0_RW_HS_RX_9			0x6112U
#define CORE_DIG_DLANE_0_R_HS_RX_0			0x6120U
#define CORE_DIG_DLANE_0_R_HS_RX_1			0x6122U
#define CORE_DIG_DLANE_0_R_HS_RX_2			0x6124U
#define CORE_DIG_DLANE_0_R_HS_RX_3			0x6126U
#define CORE_DIG_DLANE_0_R_HS_RX_4			0x6128U
#define CORE_DIG_DLANE_0_RW_HS_TX_0			0x6200U
#define CORE_DIG_DLANE_0_RW_HS_TX_1			0x6202U
#define CORE_DIG_DLANE_0_RW_HS_TX_2			0x6204U
#define CORE_DIG_DLANE_0_RW_HS_TX_3			0x6206U
#define CORE_DIG_DLANE_0_RW_HS_TX_4			0x6208U
#define CORE_DIG_DLANE_0_RW_HS_TX_5			0x620aU
#define CORE_DIG_DLANE_0_RW_HS_TX_6			0x620cU
#define CORE_DIG_DLANE_0_RW_HS_TX_7			0x620eU
#define CORE_DIG_DLANE_0_RW_HS_TX_8			0x6210U
#define CORE_DIG_DLANE_0_RW_HS_TX_9			0x6212U
#define CORE_DIG_DLANE_0_RW_HS_TX_10			0x6214U
#define CORE_DIG_DLANE_0_RW_HS_TX_11			0x6216U
#define CORE_DIG_DLANE_0_RW_HS_TX_12			0x6218U
#define CORE_DIG_DLANE_1_RW_CFG_0			0x6400U
#define CORE_DIG_DLANE_1_RW_CFG_1			0x6402U
#define CORE_DIG_DLANE_1_RW_CFG_2			0x6404U
#define CORE_DIG_DLANE_1_RW_LP_0			0x6480U
#define CORE_DIG_DLANE_1_RW_LP_1			0x6482U
#define CORE_DIG_DLANE_1_RW_LP_2			0x6484U
#define CORE_DIG_DLANE_1_R_LP_0				0x64a0U
#define CORE_DIG_DLANE_1_R_LP_1				0x64a2U
#define CORE_DIG_DLANE_1_R_HS_TX_0			0x64e0U
#define CORE_DIG_DLANE_1_RW_HS_RX_0			0x6500U
#define CORE_DIG_DLANE_1_RW_HS_RX_1			0x6502U
#define CORE_DIG_DLANE_1_RW_HS_RX_2			0x6504U
#define CORE_DIG_DLANE_1_RW_HS_RX_3			0x6506U
#define CORE_DIG_DLANE_1_RW_HS_RX_4			0x6508U
#define CORE_DIG_DLANE_1_RW_HS_RX_5			0x650aU
#define CORE_DIG_DLANE_1_RW_HS_RX_6			0x650cU
#define CORE_DIG_DLANE_1_RW_HS_RX_7			0x650eU
#define CORE_DIG_DLANE_1_RW_HS_RX_8			0x6510U
#define CORE_DIG_DLANE_1_RW_HS_RX_9			0x6512U
#define CORE_DIG_DLANE_1_R_HS_RX_0			0x6520U
#define CORE_DIG_DLANE_1_R_HS_RX_1			0x6522U
#define CORE_DIG_DLANE_1_R_HS_RX_2			0x6524U
#define CORE_DIG_DLANE_1_R_HS_RX_3			0x6526U
#define CORE_DIG_DLANE_1_R_HS_RX_4			0x6528U
#define CORE_DIG_DLANE_1_RW_HS_TX_0			0x6600U
#define CORE_DIG_DLANE_1_RW_HS_TX_1			0x6602U
#define CORE_DIG_DLANE_1_RW_HS_TX_2			0x6604U
#define CORE_DIG_DLANE_1_RW_HS_TX_3			0x6606U
#define CORE_DIG_DLANE_1_RW_HS_TX_4			0x6608U
#define CORE_DIG_DLANE_1_RW_HS_TX_5			0x660aU
#define CORE_DIG_DLANE_1_RW_HS_TX_6			0x660cU
#define CORE_DIG_DLANE_1_RW_HS_TX_7			0x660eU
#define CORE_DIG_DLANE_1_RW_HS_TX_8			0x6610U
#define CORE_DIG_DLANE_1_RW_HS_TX_9			0x6612U
#define CORE_DIG_DLANE_1_RW_HS_TX_10			0x6614U
#define CORE_DIG_DLANE_1_RW_HS_TX_11			0x6616U
#define CORE_DIG_DLANE_1_RW_HS_TX_12			0x6618U
#define CORE_DIG_DLANE_2_RW_CFG_0			0x6800U
#define CORE_DIG_DLANE_2_RW_CFG_1			0x6802U
#define CORE_DIG_DLANE_2_RW_CFG_2			0x6804U
#define CORE_DIG_DLANE_2_RW_LP_0			0x6880U
#define CORE_DIG_DLANE_2_RW_LP_1			0x6882U
#define CORE_DIG_DLANE_2_RW_LP_2			0x6884U
#define CORE_DIG_DLANE_2_R_LP_0				0x68a0U
#define CORE_DIG_DLANE_2_R_LP_1				0x68a2U
#define CORE_DIG_DLANE_2_R_HS_TX_0			0x68e0U
#define CORE_DIG_DLANE_2_RW_HS_RX_0			0x6900U
#define CORE_DIG_DLANE_2_RW_HS_RX_1			0x6902U
#define CORE_DIG_DLANE_2_RW_HS_RX_2			0x6904U
#define CORE_DIG_DLANE_2_RW_HS_RX_3			0x6906U
#define CORE_DIG_DLANE_2_RW_HS_RX_4			0x6908U
#define CORE_DIG_DLANE_2_RW_HS_RX_5			0x690aU
#define CORE_DIG_DLANE_2_RW_HS_RX_6			0x690cU
#define CORE_DIG_DLANE_2_RW_HS_RX_7			0x690eU
#define CORE_DIG_DLANE_2_RW_HS_RX_8			0x6910U
#define CORE_DIG_DLANE_2_RW_HS_RX_9			0x6912U
#define CORE_DIG_DLANE_2_R_HS_RX_0			0x6920U
#define CORE_DIG_DLANE_2_R_HS_RX_1			0x6922U
#define CORE_DIG_DLANE_2_R_HS_RX_2			0x6924U
#define CORE_DIG_DLANE_2_R_HS_RX_3			0x6926U
#define CORE_DIG_DLANE_2_R_HS_RX_4			0x6928U
#define CORE_DIG_DLANE_2_RW_HS_TX_0			0x6a00U
#define CORE_DIG_DLANE_2_RW_HS_TX_1			0x6a02U
#define CORE_DIG_DLANE_2_RW_HS_TX_2			0x6a04U
#define CORE_DIG_DLANE_2_RW_HS_TX_3			0x6a06U
#define CORE_DIG_DLANE_2_RW_HS_TX_4			0x6a08U
#define CORE_DIG_DLANE_2_RW_HS_TX_5			0x6a0aU
#define CORE_DIG_DLANE_2_RW_HS_TX_6			0x6a0cU
#define CORE_DIG_DLANE_2_RW_HS_TX_7			0x6a0eU
#define CORE_DIG_DLANE_2_RW_HS_TX_8			0x6a10U
#define CORE_DIG_DLANE_2_RW_HS_TX_9			0x6a12U
#define CORE_DIG_DLANE_2_RW_HS_TX_10			0x6a14U
#define CORE_DIG_DLANE_2_RW_HS_TX_11			0x6a16U
#define CORE_DIG_DLANE_2_RW_HS_TX_12			0x6a18U
#define CORE_DIG_DLANE_3_RW_CFG_0			0x6c00U
#define CORE_DIG_DLANE_3_RW_CFG_1			0x6c02U
#define CORE_DIG_DLANE_3_RW_CFG_2			0x6c04U
#define CORE_DIG_DLANE_3_RW_LP_0			0x6c80U
#define CORE_DIG_DLANE_3_RW_LP_1			0x6c82U
#define CORE_DIG_DLANE_3_RW_LP_2			0x6c84U
#define CORE_DIG_DLANE_3_R_LP_0				0x6ca0U
#define CORE_DIG_DLANE_3_R_LP_1				0x6ca2U
#define CORE_DIG_DLANE_3_R_HS_TX_0			0x6ce0U
#define CORE_DIG_DLANE_3_RW_HS_RX_0			0x6d00U
#define CORE_DIG_DLANE_3_RW_HS_RX_1			0x6d02U
#define CORE_DIG_DLANE_3_RW_HS_RX_2			0x6d04U
#define CORE_DIG_DLANE_3_RW_HS_RX_3			0x6d06U
#define CORE_DIG_DLANE_3_RW_HS_RX_4			0x6d08U
#define CORE_DIG_DLANE_3_RW_HS_RX_5			0x6d0aU
#define CORE_DIG_DLANE_3_RW_HS_RX_6			0x6d0cU
#define CORE_DIG_DLANE_3_RW_HS_RX_7			0x6d0eU
#define CORE_DIG_DLANE_3_RW_HS_RX_8			0x6d10U
#define CORE_DIG_DLANE_3_RW_HS_RX_9			0x6d12U
#define CORE_DIG_DLANE_3_R_HS_RX_0			0x6d20U
#define CORE_DIG_DLANE_3_R_HS_RX_1			0x6d22U
#define CORE_DIG_DLANE_3_R_HS_RX_2			0x6d24U
#define CORE_DIG_DLANE_3_R_HS_RX_3			0x6d26U
#define CORE_DIG_DLANE_3_R_HS_RX_4			0x6d28U
#define CORE_DIG_DLANE_3_RW_HS_TX_0			0x6e00U
#define CORE_DIG_DLANE_3_RW_HS_TX_1			0x6e02U
#define CORE_DIG_DLANE_3_RW_HS_TX_2			0x6e04U
#define CORE_DIG_DLANE_3_RW_HS_TX_3			0x6e06U
#define CORE_DIG_DLANE_3_RW_HS_TX_4			0x6e08U
#define CORE_DIG_DLANE_3_RW_HS_TX_5			0x6e0aU
#define CORE_DIG_DLANE_3_RW_HS_TX_6			0x6e0cU
#define CORE_DIG_DLANE_3_RW_HS_TX_7			0x6e0eU
#define CORE_DIG_DLANE_3_RW_HS_TX_8			0x6e10U
#define CORE_DIG_DLANE_3_RW_HS_TX_9			0x6e12U
#define CORE_DIG_DLANE_3_RW_HS_TX_10			0x6e14U
#define CORE_DIG_DLANE_3_RW_HS_TX_11			0x6e16U
#define CORE_DIG_DLANE_3_RW_HS_TX_12			0x6e18U
#define CORE_DIG_DLANE_CLK_RW_CFG_0			0x7000U
#define CORE_DIG_DLANE_CLK_RW_CFG_1			0x7002U
#define CORE_DIG_DLANE_CLK_RW_CFG_2			0x7004U
#define CORE_DIG_DLANE_CLK_RW_LP_0			0x7080U
#define CORE_DIG_DLANE_CLK_RW_LP_1			0x7082U
#define CORE_DIG_DLANE_CLK_RW_LP_2			0x7084U
#define CORE_DIG_DLANE_CLK_R_LP_0			0x70a0U
#define CORE_DIG_DLANE_CLK_R_LP_1			0x70a2U
#define CORE_DIG_DLANE_CLK_R_HS_TX_0			0x70e0U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_0			0x7100U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_1			0x7102U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_2			0x7104U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_3			0x7106U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_4			0x7108U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_5			0x710aU
#define CORE_DIG_DLANE_CLK_RW_HS_RX_6			0x710cU
#define CORE_DIG_DLANE_CLK_RW_HS_RX_7			0x710eU
#define CORE_DIG_DLANE_CLK_RW_HS_RX_8			0x7110U
#define CORE_DIG_DLANE_CLK_RW_HS_RX_9			0x7112U
#define CORE_DIG_DLANE_CLK_R_HS_RX_0			0x7120U
#define CORE_DIG_DLANE_CLK_R_HS_RX_1			0x7122U
#define CORE_DIG_DLANE_CLK_R_HS_RX_2			0x7124U
#define CORE_DIG_DLANE_CLK_R_HS_RX_3			0x7126U
#define CORE_DIG_DLANE_CLK_R_HS_RX_4			0x7128U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_0			0x7200U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_1			0x7202U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_2			0x7204U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_3			0x7206U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_4			0x7208U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_5			0x720aU
#define CORE_DIG_DLANE_CLK_RW_HS_TX_6			0x720cU
#define CORE_DIG_DLANE_CLK_RW_HS_TX_7			0x720eU
#define CORE_DIG_DLANE_CLK_RW_HS_TX_8			0x7210U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_9			0x7212U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_10			0x7214U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_11			0x7216U
#define CORE_DIG_DLANE_CLK_RW_HS_TX_12			0x7218U
#define PPI_RW_CPHY_TRIO0_LBERT_0			0x8000U
#define PPI_RW_CPHY_TRIO0_LBERT_1			0x8002U
#define PPI_R_CPHY_TRIO0_LBERT_0			0x8004U
#define PPI_R_CPHY_TRIO0_LBERT_1			0x8006U
#define PPI_RW_CPHY_TRIO0_SPARE				0x8008U
#define PPI_RW_CPHY_TRIO1_LBERT_0			0x8400U
#define PPI_RW_CPHY_TRIO1_LBERT_1			0x8402U
#define PPI_R_CPHY_TRIO1_LBERT_0			0x8404U
#define PPI_R_CPHY_TRIO1_LBERT_1			0x8406U
#define PPI_RW_CPHY_TRIO1_SPARE				0x8408U
#define PPI_RW_CPHY_TRIO2_LBERT_0			0x8800U
#define PPI_RW_CPHY_TRIO2_LBERT_1			0x8802U
#define PPI_R_CPHY_TRIO2_LBERT_0			0x8804U
#define PPI_R_CPHY_TRIO2_LBERT_1			0x8806U
#define PPI_RW_CPHY_TRIO2_SPARE				0x8808U
#define CORE_DIG_CLANE_0_RW_CFG_0			0xa000U
#define CORE_DIG_CLANE_0_RW_CFG_2			0xa004U
#define CORE_DIG_CLANE_0_RW_LP_0			0xa080U
#define CORE_DIG_CLANE_0_RW_LP_1			0xa082U
#define CORE_DIG_CLANE_0_RW_LP_2			0xa084U
#define CORE_DIG_CLANE_0_R_LP_0				0xa0a0U
#define CORE_DIG_CLANE_0_R_LP_1				0xa0a2U
#define CORE_DIG_CLANE_0_RW_HS_RX_0			0xa100U
#define CORE_DIG_CLANE_0_RW_HS_RX_1			0xa102U
#define CORE_DIG_CLANE_0_RW_HS_RX_2			0xa104U
#define CORE_DIG_CLANE_0_RW_HS_RX_3			0xa106U
#define CORE_DIG_CLANE_0_RW_HS_RX_4			0xa108U
#define CORE_DIG_CLANE_0_RW_HS_RX_5			0xa10aU
#define CORE_DIG_CLANE_0_RW_HS_RX_6			0xa10cU
#define CORE_DIG_CLANE_0_R_RX_0				0xa120U
#define CORE_DIG_CLANE_0_R_RX_1				0xa122U
#define CORE_DIG_CLANE_0_R_TX_0				0xa124U
#define CORE_DIG_CLANE_0_R_RX_2				0xa126U
#define CORE_DIG_CLANE_0_R_RX_3				0xa128U
#define CORE_DIG_CLANE_0_RW_HS_TX_0			0xa200U
#define CORE_DIG_CLANE_0_RW_HS_TX_1			0xa202U
#define CORE_DIG_CLANE_0_RW_HS_TX_2			0xa204U
#define CORE_DIG_CLANE_0_RW_HS_TX_3			0xa206U
#define CORE_DIG_CLANE_0_RW_HS_TX_4			0xa208U
#define CORE_DIG_CLANE_0_RW_HS_TX_5			0xa20aU
#define CORE_DIG_CLANE_0_RW_HS_TX_6			0xa20cU
#define CORE_DIG_CLANE_0_RW_HS_TX_7			0xa20eU
#define CORE_DIG_CLANE_0_RW_HS_TX_8			0xa210U
#define CORE_DIG_CLANE_0_RW_HS_TX_9			0xa212U
#define CORE_DIG_CLANE_0_RW_HS_TX_10			0xa214U
#define CORE_DIG_CLANE_0_RW_HS_TX_11			0xa216U
#define CORE_DIG_CLANE_0_RW_HS_TX_12			0xa218U
#define CORE_DIG_CLANE_0_RW_HS_TX_13			0xa21aU
#define CORE_DIG_CLANE_1_RW_CFG_0			0xa400U
#define CORE_DIG_CLANE_1_RW_CFG_2			0xa404U
#define CORE_DIG_CLANE_1_RW_LP_0			0xa480U
#define CORE_DIG_CLANE_1_RW_LP_1			0xa482U
#define CORE_DIG_CLANE_1_RW_LP_2			0xa484U
#define CORE_DIG_CLANE_1_R_LP_0				0xa4a0U
#define CORE_DIG_CLANE_1_R_LP_1				0xa4a2U
#define CORE_DIG_CLANE_1_RW_HS_RX_0			0xa500U
#define CORE_DIG_CLANE_1_RW_HS_RX_1			0xa502U
#define CORE_DIG_CLANE_1_RW_HS_RX_2			0xa504U
#define CORE_DIG_CLANE_1_RW_HS_RX_3			0xa506U
#define CORE_DIG_CLANE_1_RW_HS_RX_4			0xa508U
#define CORE_DIG_CLANE_1_RW_HS_RX_5			0xa50aU
#define CORE_DIG_CLANE_1_RW_HS_RX_6			0xa50cU
#define CORE_DIG_CLANE_1_R_RX_0				0xa520U
#define CORE_DIG_CLANE_1_R_RX_1				0xa522U
#define CORE_DIG_CLANE_1_R_TX_0				0xa524U
#define CORE_DIG_CLANE_1_R_RX_2				0xa526U
#define CORE_DIG_CLANE_1_R_RX_3				0xa528U
#define CORE_DIG_CLANE_1_RW_HS_TX_0			0xa600U
#define CORE_DIG_CLANE_1_RW_HS_TX_1			0xa602U
#define CORE_DIG_CLANE_1_RW_HS_TX_2			0xa604U
#define CORE_DIG_CLANE_1_RW_HS_TX_3			0xa606U
#define CORE_DIG_CLANE_1_RW_HS_TX_4			0xa608U
#define CORE_DIG_CLANE_1_RW_HS_TX_5			0xa60aU
#define CORE_DIG_CLANE_1_RW_HS_TX_6			0xa60cU
#define CORE_DIG_CLANE_1_RW_HS_TX_7			0xa60eU
#define CORE_DIG_CLANE_1_RW_HS_TX_8			0xa610U
#define CORE_DIG_CLANE_1_RW_HS_TX_9			0xa612U
#define CORE_DIG_CLANE_1_RW_HS_TX_10			0xa614U
#define CORE_DIG_CLANE_1_RW_HS_TX_11			0xa616U
#define CORE_DIG_CLANE_1_RW_HS_TX_12			0xa618U
#define CORE_DIG_CLANE_1_RW_HS_TX_13			0xa61aU
#define CORE_DIG_CLANE_2_RW_CFG_0			0xa800U
#define CORE_DIG_CLANE_2_RW_CFG_2			0xa804U
#define CORE_DIG_CLANE_2_RW_LP_0			0xa880U
#define CORE_DIG_CLANE_2_RW_LP_1			0xa882U
#define CORE_DIG_CLANE_2_RW_LP_2			0xa884U
#define CORE_DIG_CLANE_2_R_LP_0				0xa8a0U
#define CORE_DIG_CLANE_2_R_LP_1				0xa8a2U
#define CORE_DIG_CLANE_2_RW_HS_RX_0			0xa900U
#define CORE_DIG_CLANE_2_RW_HS_RX_1			0xa902U
#define CORE_DIG_CLANE_2_RW_HS_RX_2			0xa904U
#define CORE_DIG_CLANE_2_RW_HS_RX_3			0xa906U
#define CORE_DIG_CLANE_2_RW_HS_RX_4			0xa908U
#define CORE_DIG_CLANE_2_RW_HS_RX_5			0xa90aU
#define CORE_DIG_CLANE_2_RW_HS_RX_6			0xa90cU
#define CORE_DIG_CLANE_2_R_RX_0				0xa920U
#define CORE_DIG_CLANE_2_R_RX_1				0xa922U
#define CORE_DIG_CLANE_2_R_TX_0				0xa924U
#define CORE_DIG_CLANE_2_R_RX_2				0xa926U
#define CORE_DIG_CLANE_2_R_RX_3				0xa928U
#define CORE_DIG_CLANE_2_RW_HS_TX_0			0xaa00U
#define CORE_DIG_CLANE_2_RW_HS_TX_1			0xaa02U
#define CORE_DIG_CLANE_2_RW_HS_TX_2			0xaa04U
#define CORE_DIG_CLANE_2_RW_HS_TX_3			0xaa06U
#define CORE_DIG_CLANE_2_RW_HS_TX_4			0xaa08U
#define CORE_DIG_CLANE_2_RW_HS_TX_5			0xaa0aU
#define CORE_DIG_CLANE_2_RW_HS_TX_6			0xaa0cU
#define CORE_DIG_CLANE_2_RW_HS_TX_7			0xaa0eU
#define CORE_DIG_CLANE_2_RW_HS_TX_8			0xaa10U
#define CORE_DIG_CLANE_2_RW_HS_TX_9			0xaa12U
#define CORE_DIG_CLANE_2_RW_HS_TX_10			0xaa14U
#define CORE_DIG_CLANE_2_RW_HS_TX_11			0xaa16U
#define CORE_DIG_CLANE_2_RW_HS_TX_12			0xaa18U
#define CORE_DIG_CLANE_2_RW_HS_TX_13			0xaa1aU

/* dwc csi host controller registers */
#define IS_IO_CSI2_HOST_BASE(i)			(IS_IO_BASE + 0x40000U + \
						 0x2000U * (i))
#define VERSION					0
#define N_LANES					0x4U
#define CSI2_RESETN				0x8U
#define INT_ST_MAIN				0xcU
#define DATA_IDS_1				0x10U
#define DATA_IDS_2				0x14U
#define CDPHY_MODE				0x1cU
#define DATA_IDS_VC_1				0x30U
#define DATA_IDS_VC_2				0x34U
#define PHY_SHUTDOWNZ				0x40U
#define DPHY_RSTZ				0x44U
#define PHY_RX					0x48U
#define PHY_STOPSTATE				0x4cU
#define PHY_TEST_CTRL0				0x50U
#define PHY_TEST_CTRL1				0x54U
#define PPI_PG_PATTERN_VRES			0x60U
#define PPI_PG_PATTERN_HRES			0x64U
#define PPI_PG_CONFIG				0x68U
#define PPI_PG_ENABLE				0x6cU
#define PPI_PG_STATUS				0x70U
#define VC_EXTENSION				0xc8U
#define PHY_CAL					0xccU
#define INT_ST_PHY_FATAL			0xe0U
#define INT_MSK_PHY_FATAL			0xe4U
#define INT_FORCE_PHY_FATAL			0xe8U
#define INT_ST_PKT_FATAL			0xf0U
#define INT_MSK_PKT_FATAL			0xf4U
#define INT_FORCE_PKT_FATAL			0xf8U
#define INT_ST_PHY				0x110U
#define INT_MSK_PHY				0x114U
#define INT_FORCE_PHY				0x118U
#define INT_ST_LINE				0x130U
#define INT_MSK_LINE				0x134U
#define INT_FORCE_LINE				0x138U
#define INT_ST_BNDRY_FRAME_FATAL		0x280U
#define INT_MSK_BNDRY_FRAME_FATAL		0x284U
#define INT_FORCE_BNDRY_FRAME_FATAL		0x288U
#define INT_ST_SEQ_FRAME_FATAL			0x290U
#define INT_MSK_SEQ_FRAME_FATAL			0x294U
#define INT_FORCE_SEQ_FRAME_FATAL		0x298U
#define INT_ST_CRC_FRAME_FATAL			0x2a0U
#define INT_MSK_CRC_FRAME_FATAL			0x2a4U
#define INT_FORCE_CRC_FRAME_FATAL		0x2a8U
#define INT_ST_PLD_CRC_FATAL			0x2b0U
#define INT_MSK_PLD_CRC_FATAL			0x2b4U
#define INT_FORCE_PLD_CRC_FATAL			0x2b8U
#define INT_ST_DATA_ID				0x2c0U
#define INT_MSK_DATA_ID				0x2c4U
#define INT_FORCE_DATA_ID			0x2c8U
#define INT_ST_ECC_CORRECTED			0x2d0U
#define INT_MSK_ECC_CORRECTED			0x2d4U
#define INT_FORCE_ECC_CORRECTED			0x2d8U
#define SCRAMBLING				0x300U
#define SCRAMBLING_SEED1			0x304U
#define SCRAMBLING_SEED2			0x308U
#define SCRAMBLING_SEED3			0x30cU
#define SCRAMBLING_SEED4			0x310U
#define SCRAMBLING				0x300U

#define IS_IO_CSI2_ADPL_PORT_BASE(i)		(IS_IO_BASE + 0x40800U + \
						 0x2000U * (i))
#define CSI2_ADPL_INPUT_MODE			0
#define CSI2_ADPL_CSI_RX_ERR_IRQ_CLEAR_EN	0x4U
#define CSI2_ADPL_CSI_RX_ERR_IRQ_CLEAR_ADDR	0x8U
#define CSI2_ADPL_CSI_RX_ERR_IRQ_STATUS		0xcU
#define CSI2_ADPL_IRQ_CTL_COMMON_STATUS		0xa4U
#define CSI2_ADPL_IRQ_CTL_COMMON_CLEAR		0xa8U
#define CSI2_ADPL_IRQ_CTL_COMMON_ENABLE		0xacU
#define CSI2_ADPL_IRQ_CTL_FS_STATUS		0xbcU
#define CSI2_ADPL_IRQ_CTL_FS_CLEAR		0xc0U
#define CSI2_ADPL_IRQ_CTL_FS_ENABLE		0xc4U
#define CSI2_ADPL_IRQ_CTL_FE_STATUS		0xc8U
#define CSI2_ADPL_IRQ_CTL_FE_CLEAR		0xccU
#define CSI2_ADPL_IRQ_CTL_FE_ENABLE		0xd0U

/* software control the legacy csi irq */
#define IS_IO_CSI2_ERR_LEGACY_IRQ_CTL_BASE(i)	(IS_IO_BASE + 0x40c00U + \
						 0x2000U * (i))
#define IS_IO_CSI2_SYNC_LEGACY_IRQ_CTL_BASE(i)	(IS_IO_BASE + 0x40d00U + \
						 0x2000U * (i))
#define IS_IO_CSI2_LEGACY_IRQ_CTRL_BASE		(IS_IO_BASE + 0x49000U)
#define IS_IO_CSI2_IRQ_CTRL_BASE		(IS_IO_BASE + 0x4e100)

#define IRQ_CTL_EDGE				0
#define IRQ_CTL_MASK				0x4U
#define IRQ_CTL_STATUS				0x8U
#define IRQ_CTL_CLEAR				0xcU
#define IRQ_CTL_ENABLE				0x10U
/* FE irq for PTL */
#define IRQ1_CTL_MASK				0x14U
#define IRQ1_CTL_STATUS				0x18U
#define IRQ1_CTL_CLEAR				0x1cU
#define IRQ1_CTL_ENABLE				0x20U

/* software to set the clock gate to use the port or mgc */
#define IS_IO_GPREGS_BASE			(IS_IO_BASE + 0x49200U)
#define SRST_PORT_ARB				0
#define SRST_MGC				0x4U
#define SRST_WIDTH_CONV				0x8U
#define SRST_CSI_IRQ				0xcU
#define SRST_CSI_LEGACY_IRQ			0x10U
#define CLK_EN_TXCLKESC				0x14U
#define CLK_DIV_FACTOR_IS_CLK			0x18U
#define CLK_DIV_FACTOR_APB_CLK			0x1cU
#define CSI_PORT_CLK_GATE			0x20U
#define CSI_PORTAB_AGGREGATION			0x24U
#define MGC_CLK_GATE				0x2cU
#define CG_CTRL_BITS				0x3cU
#define SPARE_RW				0xf8U
#define SPARE_RO				0xfcU

#define IS_IO_CSI2_MPF_PORT_BASE(i)		(IS_IO_BASE + 0x53000U + \
						 0x1000U * (i))
#define MPF_16_IRQ_CNTRL_STATUS			0x238U
#define MPF_16_IRQ_CNTRL_CLEAR			0x23cU
#define MPF_16_IRQ_CNTRL_ENABLE			0x240U

/* software config the phy */
#define IS_IO_CSI2_GPREGS_BASE		(IS_IO_BASE + 0x53400U)
#define IPU8_IS_IO_CSI2_GPREGS_BASE	(IS_IO_BASE + 0x40e00U)
#define CSI_ADAPT_LAYER_SRST		0
#define MPF_SRST_RST			0x4U
#define CSI_ERR_IRQ_CTRL_SRST		0x8U
#define CSI_SYNC_RC_SRST		0xcU
#define CSI_CG_CTRL_BITS		0x10U
#define SOC_CSI2HOST_SELECT		0x14U
#define PHY_RESET			0x18U
#define PHY_SHUTDOWN			0x1cU
#define PHY_MODE			0x20U
#define PHY_READY			0x24U
#define PHY_CLK_LANE_FORCE_CONTROL	0x28U
#define PHY_CLK_LANE_CONTROL		0x2cU
#define PHY_CLK_LANE_STATUS		0x30U
#define PHY_LANE_RX_ESC_REQ		0x34U
#define PHY_LANE_RX_ESC_DATA		0x38U
#define PHY_LANE_TURNDISABLE		0x3cU
#define PHY_LANE_DIRECTION		0x40U
#define PHY_LANE_FORCE_CONTROL		0x44U
#define PHY_LANE_CONTROL_EN		0x48U
#define PHY_LANE_CONTROL_DATAWIDTH	0x4cU
#define PHY_LANE_STATUS			0x50U
#define PHY_LANE_ERR			0x54U
#define PHY_LANE_RXALP			0x58U
#define PHY_LANE_RXALP_NIBBLE		0x5cU
#define PHY_PARITY_ERROR		0x60U
#define PHY_DEBUG_REGS_CLK_GATE_EN	0x64U
#define SPARE_RW			0xf8U
#define SPARE_RO			0xfcU

/* software not touch */
#define PORT_ARB_BASE				(IS_IO_BASE + 0x4e000)
#define PORT_ARB_IRQ_CTL_STATUS			0x4U
#define PORT_ARB_IRQ_CTL_CLEAR			0x8U
#define PORT_ARB_IRQ_CTL_ENABLE			0xcU

#define MGC_PPC					4U
#define MGC_DTYPE_RAW(i)			(((i) - 8) / 2)
#define IS_IO_MGC_BASE				(IS_IO_BASE + 0x48000U)
#define MGC_KICK				0
#define MGC_ASYNC_STOP				0x4U
#define MGC_PORT_OFFSET				0x100U
#define MGC_CSI_PORT_MAP(i)			(0x8 + (i) * 0x4)
#define MGC_MG_PORT(i)				(IS_IO_MGC_BASE +	\
						 (i) * MGC_PORT_OFFSET)
/* per mgc instance */
#define MGC_MG_CSI_ADAPT_LAYER_TYPE		0x28U
#define MGC_MG_MODE				0x2cU
#define MGC_MG_INIT_COUNTER			0x30U
#define MGC_MG_MIPI_VC				0x34U
#define MGC_MG_MIPI_DTYPES			0x38U
#define MGC_MG_MULTI_DTYPES_MODE		0x3cU
#define MGC_MG_NOF_FRAMES			0x40U
#define MGC_MG_FRAME_DIM			0x44U
#define MGC_MG_HBLANK				0x48U
#define MGC_MG_VBLANK				0x4cU
#define MGC_MG_TPG_MODE				0x50U
#define MGC_MG_TPG_R0				0x54U
#define MGC_MG_TPG_G0				0x58U
#define MGC_MG_TPG_B0				0x5cU
#define MGC_MG_TPG_R1				0x60U
#define MGC_MG_TPG_G1				0x64U
#define MGC_MG_TPG_B1				0x68U
#define MGC_MG_TPG_FACTORS			0x6cU
#define MGC_MG_TPG_MASKS			0x70U
#define MGC_MG_TPG_XY_MASK			0x74U
#define MGC_MG_TPG_TILE_DIM			0x78U
#define MGC_MG_PRBS_LFSR_INIT_0			0x7cU
#define MGC_MG_PRBS_LFSR_INIT_1			0x80U
#define MGC_MG_SYNC_STOP_POINT			0x84U
#define MGC_MG_SYNC_STOP_POINT_LOC		0x88U
#define MGC_MG_ERR_INJECT			0x8cU
#define MGC_MG_ERR_LOCATION			0x90U
#define MGC_MG_DTO_SPEED_CTRL_EN		0x94U
#define MGC_MG_DTO_SPEED_CTRL_INCR_VAL		0x98U
#define MGC_MG_HOR_LOC_STTS			0x9cU
#define MGC_MG_VER_LOC_STTS			0xa0U
#define MGC_MG_FRAME_NUM_STTS			0xa4U
#define MGC_MG_BUSY_STTS			0xa8U
#define MGC_MG_STOPPED_STTS			0xacU
/* tile width and height in pixels for Chess board and Color palette */
#define MGC_TPG_TILE_WIDTH			64U
#define MGC_TPG_TILE_HEIGHT			64U

#define IPU_CSI_PORT_A_ADDR_OFFSET		0
#define IPU_CSI_PORT_B_ADDR_OFFSET		0
#define IPU_CSI_PORT_C_ADDR_OFFSET		0
#define IPU_CSI_PORT_D_ADDR_OFFSET		0

/*
 * 0 - CSI RX Port 0 interrupt;
 * 1 - MPF Port 0 interrupt;
 * 2 - CSI RX Port 1 interrupt;
 * 3 - MPF Port 1 interrupt;
 * 4 - CSI RX Port 2 interrupt;
 * 5 - MPF Port 2 interrupt;
 * 6 - CSI RX Port 3 interrupt;
 * 7 - MPF Port 3 interrupt;
 * 8 - Port ARB FIFO 0 overflow;
 * 9 - Port ARB FIFO 1 overflow;
 * 10 - Port ARB FIFO 2 overflow;
 * 11 - Port ARB FIFO 3 overflow;
 * 12 - isys_cfgnoc_err_probe_intl;
 * 13-15 - reserved
 */
#define IPU7_CSI_IS_IO_IRQ_MASK		0xffffU

/* Adapter layer irq */
#define IPU7_CSI_ADPL_IRQ_MASK		0xffffU

/* sw irq from legacy irq control
 * legacy irq status
 * IPU7
 * 0 - CSI Port 0 error interrupt
 * 1 - CSI Port 0 sync interrupt
 * 2 - CSI Port 1 error interrupt
 * 3 - CSI Port 1 sync interrupt
 * 4 - CSI Port 2 error interrupt
 * 5 - CSI Port 2 sync interrupt
 * 6 - CSI Port 3 error interrupt
 * 7 - CSI Port 3 sync interrupt
 * IPU7P5
 * 0 - CSI Port 0 error interrupt
 * 1 - CSI Port 0 fs interrupt
 * 2 - CSI Port 0 fe interrupt
 * 3 - CSI Port 1 error interrupt
 * 4 - CSI Port 1 fs interrupt
 * 5 - CSI Port 1 fe interrupt
 * 6 - CSI Port 2 error interrupt
 * 7 - CSI Port 2 fs interrupt
 * 8 - CSI Port 2 fe interrupt
 */
#define IPU7_CSI_RX_LEGACY_IRQ_MASK		0x1ffU

/* legacy error status per port
 * 0 - Error handler FIFO full;
 * 1 - Reserved Short Packet encoding detected;
 * 2 - Reserved Long Packet encoding detected;
 * 3 - Received packet is too short (fewer data words than specified in header);
 * 4 - Received packet is too long (more data words than specified in header);
 * 5 - Short packet discarded due to errors;
 * 6 - Long packet discarded due to errors;
 * 7 - CSI Combo Rx interrupt;
 * 8 - IDI CDC FIFO overflow; remaining bits are reserved and tied to 0;
 */
#define IPU7_CSI_RX_ERROR_IRQ_MASK		0xfffU

/*
 * 0 - VC0 frame start received
 * 1 - VC0 frame end received
 * 2 - VC1 frame start received
 * 3 - VC1 frame end received
 * 4 - VC2 frame start received
 * 5 - VC2 frame end received
 * 6 - VC3 frame start received
 * 7 - VC3 frame end received
 * 8 - VC4 frame start received
 * 9 - VC4 frame end received
 * 10 - VC5 frame start received
 * 11 - VC5 frame end received
 * 12 - VC6 frame start received
 * 13 - VC6 frame end received
 * 14 - VC7 frame start received
 * 15 - VC7 frame end received
 * 16 - VC8 frame start received
 * 17 - VC8 frame end received
 * 18 - VC9 frame start received
 * 19 - VC9 frame end received
 * 20 - VC10 frame start received
 * 21 - VC10 frame end received
 * 22 - VC11 frame start received
 * 23 - VC11 frame end received
 * 24 - VC12 frame start received
 * 25 - VC12 frame end received
 * 26 - VC13 frame start received
 * 27 - VC13 frame end received
 * 28 - VC14 frame start received
 * 29 - VC14 frame end received
 * 30 - VC15 frame start received
 * 31 - VC15 frame end received
 */

#define IPU7_CSI_RX_SYNC_IRQ_MASK		0 /* 0xffffffff */
#define IPU7P5_CSI_RX_SYNC_FE_IRQ_MASK		0 /* 0xffffffff */

#define CSI_RX_NUM_ERRORS_IN_IRQ		12U
#define CSI_RX_NUM_SYNC_IN_IRQ			32U

enum CSI_FE_MODE_TYPE {
	CSI_FE_DPHY_MODE = 0,
	CSI_FE_CPHY_MODE = 1,
};

enum CSI_FE_INPUT_MODE {
	CSI_SENSOR_INPUT = 0,
	CSI_MIPIGEN_INPUT = 1,
};

enum MGC_CSI_ADPL_TYPE {
	MGC_MAPPED_2_LANES = 0,
	MGC_MAPPED_4_LANES = 1,
};

enum CSI2HOST_SELECTION {
	CSI2HOST_SEL_SOC = 0,
	CSI2HOST_SEL_CSI2HOST = 1,
};

#define IPU7_ISYS_LEGACY_IRQ_CSI2(port)		(0x3U << (port))
#define IPU7P5_ISYS_LEGACY_IRQ_CSI2(port)	(0x7U << (port))

/* ---------------------------------------------------------------- */
#define CSI_REG_BASE				0x220000U
#define CSI_REG_BASE_PORT(id)			((id) * 0x1000)

/* CSI Port General Purpose Registers */
#define CSI_REG_PORT_GPREG_SRST			0
#define CSI_REG_PORT_GPREG_CSI2_SLV_REG_SRST	0x4U
#define CSI_REG_PORT_GPREG_CSI2_PORT_CONTROL	0x8U

#define CSI_RX_NUM_IRQ				32U

#define IPU7_CSI_RX_SYNC_FS_VC			0x55555555U
#define IPU7_CSI_RX_SYNC_FE_VC			0xaaaaaaaaU
#define IPU7P5_CSI_RX_SYNC_FS_VC		0xffffU
#define IPU7P5_CSI_RX_SYNC_FE_VC		0xffffU

#endif /* IPU7_ISYS_CSI2_REG_H */
