------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2006 Maxim Reznik.                                        --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-object.ads,v 1.2 2006/06/17 05:58:30 vagul Exp $

with OCI.Thick.Statements;
with OCI.Thick.Connections;

generic
   type Object_Node is private;
   --  Object_Node represents record correspond to Oracle Named Type
   --  Use ott tools to get C struct definition and write equal Ada type.

   type Indicator is private;
   --  Indicator is record contains indicators for whole object and
   --  for each field. 'ott' names it as "struct *_ind"

   Type_Name : in String;
   --  name of Oracle Named Type

package OCI.Thick.Object is

   type Object_Access is access all Object_Node;
   type Indicator_Access is access all Indicator;

   type Variable is limited private;

   procedure Create
     (Connect : in     Connections.Connection;
      Item    :    out Variable);

   procedure Free  (Item : in out Variable);

   function Get_Value (Item : Variable) return Object_Access;

   function Get_Value (Item : Variable) return Object_Node;

   procedure Set_Value
     (Item  : in out Variable;
      Value : in     Object_Node);

   function Get_Indicator (Item : Variable) return Indicator_Access;

   function Get_Indicator (Item : Variable) return Indicator;

   procedure Set_Indicator
     (Item    : in out Variable;
      Nullity : in     Indicator);

   procedure Bind
     (Stmt     : in     Statements.Statement;
      Item     : in out Variable;
      Position : in     Positive);

   procedure Bind
     (Stmt     : in     Statements.Statement;
      Item     : in out Variable;
      Name     : in     String);

   procedure Define
     (Stmt     : in     Statements.Statement;
      Item     : in out Variable;
      Position : in     Positive);

   Type_Size_Error : exception;
   --  Raised by Get_Value & Get_Indicator is size of Ada record doesn't
   --  match value returned by Oracle

private
   use type C.long;

   type Variable is record
      Bind    : aliased OCIBind   := OCIBind (Empty_Handle);
      Define  : aliased OCIDefine := OCIDefine (Empty_Handle);
      Data    : aliased OCIHandle := Empty_Handle;
      Ind     : aliased OCIHandle := Empty_Handle;
   end record;

end OCI.Thick.Object;
