-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/files.adb,v $
--  Description     : Utitlity package for file handling
--  Author          : Michael Erdmann
--  Created         : 24.8.2001
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2002/06/09 09:46:38 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;                           use Ada.Text_IO;

with Config;
with Environment;                           use Environment;

package body Files is

    Version             : constant String :=
       "$Id: files.adb,v 1.8 2002/06/09 09:46:38 merdmann Exp $";

    Directory_Seperator : constant Character := '/';
    Path_Seperator      : constant Character := ':';

    Last_Position       : Positive := 1;
    Unnamed_Cnt         : Natural  := 0;

    ---------------
    -- Base_Name --
    ---------------
    function Base_Name(
       S : in String ) return String is
       --- return the base name of a file
       N : Positive range S'First .. S'Last := S'First;
    begin
       for I in S'Range loop
          if S(I) = Directory_Seperator then
             N := I+1;
          end if;
       end loop;

       return S(N..S'Last);
    end Base_Name;

    ---------------
    -- Scan_Path --
    ---------------
    function Scan_Path(
       Path  : in String;
       Reset : in Boolean := False ) return String is
       Start : Positive := Last_Position;
    begin
       if Reset then
          Last_Position := Path'First;
       end if;

       -- end of path
       if not ( Last_Position in Path'Range ) then
          return No_More_Elements;
       end if;

       while Last_Position in Path'Range loop
          exit when Path(Last_Position) = Path_Seperator;

          Last_Position := Last_Position + 1;
       end loop;

       return Path( Start..Last_Position-1 );
    end Scan_Path;

   ------------------
   -- Buffer_Name  --
   ------------------
   function Buffer_Name(
      Name : in Unbounded_String := Null_Unbounded_String) return Unbounded_String is
   begin
      if Name = Null_Unbounded_String then

         Unnamed_Cnt := Environment.Get("unnamed_cnt") + 1;
         Environment.Set( "unnamed_cnt", Unnamed_Cnt );

         return To_Unbounded_String("unnamed" & Positive'Image(Unnamed_Cnt));
      end if;

      return Name;
   end Buffer_Name;

   -----------------
   -- Shared_File --
   -----------------
   function Shared_File(
      N    : in String ) return String is
      F    : File_Type;
      Name : constant String := Config.Shared_Path & "/" & N;
   begin
      Open( Name => Name, File => F, Mode => In_File );
      Close( F );
      return Name;

   exception
      when others =>
         return N;
   end Shared_File;

end Files;
