# For Win32 MinGW setup the object files er stored in seprarate folders
win32_setup {
    win32:qf_static {
        CONFIG(debug, debug|release):MY_DIR = debug
        CONFIG(release, debug|release):MY_DIR = release
    }
    win32:qf_shared {
        CONFIG(debug, debug|release):MY_DIR = debug/shared
        CONFIG(release, debug|release):MY_DIR = release/shared
    }
    win32:vs_proj {
        CONFIG(debug, debug|release):MY_DIR = debug/vs
        CONFIG(release, debug|release):MY_DIR = release/vs
    }
    DESTDIR = $$MY_DIR
    OBJECTS_DIR = $$MY_DIR
    MOC_DIR = $$MY_DIR
}

# ### Common Libraries ################
qf_libs_common{
    LIBS += ../lib/$$ARCH$$ARCHBIT/librfftw.a \
            ../lib/$$ARCH$$ARCHBIT/libfftw.a \
            ../lib/$$ARCH$$ARCHBIT/libgsl.a \
            ../lib/$$ARCH$$ARCHBIT/libgslcblas.a \
            ../lib/$$ARCH$$ARCHBIT/libxpa.a
    unix:!mac {
        contains(QMAKE_HOST.arch, x86_64):{
            LIBS += ../lib/$$ARCH$$ARCHBIT/libmng.a
        }
    }
    contains(DEFINES, HAS_PGPLOT) {
        LIBS += ../lib/$$ARCH$$ARCHBIT/libcpgplot.a
        mac {
            LIBS += ../lib/$$ARCH$$ARCHBIT/libpgplot_qf.a
        } else {
            LIBS += ../lib/$$ARCH$$ARCHBIT/libpgplot.a
        }
        LIBS += ../lib/$$ARCH$$ARCHBIT/libf2c.a
    }
}

qf_libs_vtk:LIBS += ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkGUISupportQt-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkGUISupportQtOpenGL-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkInteractionStyle-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingAnnotation-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingVolumeOpenGL-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingOpenGL-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingFreeTypeOpenGL-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingFreeType-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkftgl-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkfreetype-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkzlib-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingVolume-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkRenderingCore-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonMath-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonTransforms-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonSystem-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkFiltersExtraction-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkFiltersSources-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkFiltersGeneral-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkImagingCore-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonExecutionModel-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonDataModel-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonCore-6.1.a \ 
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonMisc-6.1.a \ 
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtksys-6.1.a \
                    ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkIOImage-6.1.a

qf_libs_vtk_mac:LIBS += ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkFiltersCore-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkpng-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkDICOMParser-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtktiff-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkjpeg-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkCommonComputationalGeometry-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkmetaio-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkFiltersStatistics-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkImagingFourier-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkalglib-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkFiltersGeometry-6.1.a \
                        ../lib/$$ARCH$$ARCHBIT/$$VTK_PATH/libvtkImagingHybrid-6.1.a

qf_libs_shared:LIBS += \
                    -L../lib/$$ARCH$$ARCHBIT/$$VTK_PATH \
                    -lQVTK.dll \
                    -lvtkHybrid.dll \
                    -lvtkVolumeRendering.dll \
                    -lvtkRendering.dll \
                    -lvtkIO.dll \
                    -lvtkGenericFiltering.dll \
                    -lvtkGraphics.dll \
                    -lvtkImaging.dll \
                    -lvtkFiltering.dll \
                    -lvtkCommon.dll \
                    -lvtksys.dll \
                    -lvtkftgl.dll \
                    -lvtkfreetype.dll \
                    -lvtkDICOMParser.dll \
                    -lvtkexpat.dll \
                    -lvtksys.dll \
                    -lvtktiff.dll \
                    -lvtkpng.dll \
                    -lvtkjpeg.dll \
                    -lvtkzlib.dll                    

# ### QFitsView sources & headers ################
qf_sources {
    SOURCES =       main.cpp \
                    QFitsMainWindow.cpp \
                    QFitsMainView.cpp \
                    QFitsBuffers/QFitsBaseBuffer.cpp \
                    QFitsBuffers/QFitsSingleBuffer.cpp \
                    QFitsBuffers/QFitsMultiBuffer.cpp \
                    QFitsScroller.cpp \
                    QFitsWidgets/QFitsBaseWidget.cpp \
                    QFitsWidgets/QFitsWidget1D.cpp \
                    QFitsWidgets/QFitsWidget2D.cpp \
                    QFitsWidgets/QFitsWidgetWiregrid.cpp \
                    QFitsWidgets/QFitsWidgetContour.cpp \
                    QFitsWidgets/QFitsWidgetTable.cpp \
                    QFitsViews/QFitsBaseView.cpp \
                    QFitsViews/QFitsView1D.cpp \
                    QFitsViews/QFitsView2D.cpp \
                    QFitsGlobal.cpp \
                    QFitsMarkers.cpp \
                    QFits2dFit.cpp \
                    QFitsWedge.cpp \
                    lut.cpp \
                    QFitsCubeSpectrum.cpp \
                    RGBDialog.cpp \
                    QFitsHeaderView.cpp \
                    QFitsToolBar.cpp \
                    dialogs.cpp \
                    events.cpp \
                    imred.cpp \
                    QFitsViewingTools.cpp \
                    qtdpuser.cpp \
                    qt_mainwindow.cpp \
                    qt_mdichild.cpp \
                    highlighter.cpp \
                    QFitsPreferences.cpp \
                    extra/tetrixboard.cpp \
                    extra/tetrixpiece.cpp \
                    extra/tetrixwindow.cpp \
										QPgplot.cpp

    contains(DEFINES, HAS_VTK):SOURCES += QFitsWidgets/QFitsWidget3D.cpp

    HEADERS =       QFitsMainWindow.h \
                    QFitsMainView.h \
                    QFitsBuffers/QFitsBaseBuffer.h \
                    QFitsBuffers/QFitsSingleBuffer.h \
                    QFitsBuffers/QFitsMultiBuffer.h \
                    QFitsScroller.h \
                    QFitsWidgets/QFitsBaseWidget.h \
                    QFitsWidgets/QFitsWidget1D.h \
                    QFitsWidgets/QFitsWidget2D.h \
                    QFitsWidgets/QFitsWidgetWiregrid.h \
                    QFitsWidgets/QFitsWidgetContour.h \
                    QFitsWidgets/QFitsWidgetTable.h \
                    QFitsViews/QFitsBaseView.h \
                    QFitsViews/QFitsView1D.h \
                    QFitsViews/QFitsView2D.h \
                    QFitsGlobal.h \
                    QFitsMarkers.h \
                    QFits2dFit.h \
                    QFitsWedge.h \
                    lut.h \
                    QFitsCubeSpectrum.h \
                    RGBDialog.h \
                    QFitsHeaderView.h \
                    QFitsToolBar.h \
                    dialogs.h \
                    events.h \
                    imred.h \
                    QFitsViewingTools.h \
                    qtdpuser.h \
                    qt_mainwindow.h \
                    qt_mdichild.h \
                    highlighter.h \
                    QFitsPreferences.h \
                    extra/tetrixboard.h \
                    extra/tetrixpiece.h \
                    extra/tetrixwindow.h \
										QPgplot.h

    contains(DEFINES, HAS_VTK):HEADERS += QFitsWidgets/QFitsWidget3D.h
}

# ### DPUSER sources & headers ################
dp_sources {
    SOURCES +=      ../dpuser/dpuser.cpp \
                    ../dpuser/dpuser.yacchelper.cpp \
                    ../dpuser/dpuser_funcs.cpp \
                    ../dpuser/parser/y.tab.cpp \
                    ../dpuser/dpuser.input.cpp \
                    ../dpuser/dpuser.pgplot.cpp \
                    ../dpuser/parser/lex.yy.cpp \
                    ../dpuser/parser/svn_revision.cpp \
                    ../libfits/misc.c \
                    ../dpuser/dpuser2c/utils.cpp \
                    ../dpuser/dpuser_utils.cpp \
                    ../dpuser/dpuser.procs.cpp \
                    ../dpuser/dpuser2c/eso.cpp \
                    ../dpuser/dpuser2c/functions.cpp \
                    ../dpuser/dpuser2c/tools.cpp \
                    ../dpuser/dpuser2c/y.dpuser2c.cpp \
                    ../dpuser/idl2c/y.idl2c.cpp \
                    ../dpuser/dpuser2c/lex.dpuser2c.cpp \
                    ../dpuser/idl2c/lex.idl2c.cpp \
                    ../dpuser/dpuser2c/procedures.cpp \
                    ../dpuser/dpuser2c/dpuserType.cpp

    contains(DEFINES, HAS_PGPLOT) {
        contains(DEFINES, HAS_DPPGPLOT) {
            SOURCES += ../utils/cpg3d.c
            HEADERS += ../utils/cpg3d.h
        }
    }

    SOURCES +=      ../utils/dpstring.cpp \
                    ../utils/dpstringlist.cpp \
                    ../utils/regex/regex_sr.cpp \
                    ../utils/cmpfit/mpfit.c \
                    ../libfits/3d_stuff.cpp \
                    ../libfits/cube.c \
                    ../libfits/dpheader.cpp \
                    ../libfits/fits.cpp \
                    ../libfits/fits_cube.cpp \
                    ../libfits/fits_dpl.cpp \
                    ../libfits/fits_exc.cpp \
                    ../libfits/fits_file.cpp \
                    ../libfits/fits_filters.cpp \
                    ../libfits/fits_funcs.cpp \
                    ../libfits/fits_mem.cpp \
                    ../libfits/fits_ops.cpp \
                    ../libfits/fits_procs.cpp \
                    ../libfits/fits_range.cpp \
                    ../libfits/fits_red.cpp \
                    ../libfits/JulianDay.cpp \
                    ../libfits/math_utils.cpp \
                    ../libfits/platform.cpp \
                    ../libfits/dpComplex.cpp \
                    ../libfits/fitting.cpp \
                    ../libfits/voronoi.cpp \
                    ../libfits/fits_logic.cpp \
                    ../libfits/functions/astrolib/astrolib.cpp \
                    ../libfits/functions/astrolib/primes.cpp

    HEADERS +=      ../dpuser/dpuser.h \
                    ../dpuser/dpuser.yacchelper.h \
                    ../dpuser/dpuser_funcs.h \
                    ../dpuser/dpuser.pgplot.h \
                    ../dpuser/dpuser.procs.h \
                    ../dpuser/dpuser_utils.h \
                    ../dpuser/parser/y.tab.h \
                    ../dpuser/parser/svn_revision.h \
                    ../dpuser/dpuser2c/dpuserType.h \
                    ../dpuser/dpuser2c/utils.h \
                    ../dpuser/dpuser2c/eso.h \
                    ../dpuser/dpuser2c/functions.h \
                    ../dpuser/dpuser2c/procedures.h \
                    ../dpuser/dpuser2c/y.tab.h \
                    ../dpuser/idl2c/y.tab.h \
                    ../utils/dpstring.h \
                    ../utils/dpstringlist.h \
                    ../utils/regex/regex_sr.h \
                    ../utils/cmpfit/mpfit.h \
                    ../libfits/misc.h \
                    ../libfits/cube.h \
                    ../libfits/defines.h \
                    ../libfits/fits.h \
                    ../libfits/collapse_helper.cpp \
										../libfits/logic_helper.cpp \
                    ../libfits/JulianDay.h \
                    ../libfits/math_utils.h \
                    ../libfits/platform.h \
                    ../libfits/dpComplex.h \
                    ../libfits/fitting.h \
                    ../libfits/functions/astrolib/astrolib.h
}
