/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <boost/shared_ptr.hpp>

#include <libwpd-stream/libwpd-stream.h>

#include "libebook_utils.h"
#include "EBOOKMemoryStream.h"
#include "IMPLZSSStream.h"

#include "IMPLZSSStreamTest.h"

using boost::shared_ptr;

using libebook::EBOOKMemoryStream;
using libebook::IMPLZSSStream;

using std::string;

namespace test
{

namespace
{

static const unsigned OFFSET_BITS = 14;
static const unsigned LENGTH_BITS = 3;

shared_ptr<WPXInputStream> makeLZSSStream(const unsigned char *const data, const unsigned length, const unsigned uncompressedLength)
{
  EBOOKMemoryStream dataStream(data, length);
  IMPLZSSStream::Configuration configuration;

  configuration.offsetBits = OFFSET_BITS;
  configuration.lengthBits = LENGTH_BITS;
  configuration.uncompressedLength = uncompressedLength;
  configuration.allowOverflow = false;
  configuration.bigEndian = true;
  configuration.fillPos = 1;

  shared_ptr<WPXInputStream> lzssStream(new IMPLZSSStream(&dataStream, configuration));
  return lzssStream;
}

shared_ptr<WPXInputStream> makeLZSSStream(const unsigned char *const data, const unsigned length)
{
  EBOOKMemoryStream dataStream(data, length);
  shared_ptr<WPXInputStream> lzssStream(new IMPLZSSStream(&dataStream));
  return lzssStream;
}

}

void IMPLZSSStreamTest::setUp()
{
}

void IMPLZSSStreamTest::tearDown()
{
}

void IMPLZSSStreamTest::testRead()
{
  {
    const string plain("\013aaaa bbbb aaaaa bb \012");
    const unsigned char encoded[] = {0x85, 0xd8, 0x40, 1, 9, 5, 0x88, 0, 0x38, 0x90, 0, 2, 0x20, 1, 0x4c, 0x82, 0x14, 0, 0};
    shared_ptr<WPXInputStream> stream = makeLZSSStream(encoded, sizeof encoded, plain.size());
    testReadAll(plain, stream.get());
  }
}

void IMPLZSSStreamTest::testSeek()
{
}

void IMPLZSSStreamTest::testReadAll(const std::string &plain, WPXInputStream *const stream)
{
  CPPUNIT_ASSERT(!stream->atEOS());

  const unsigned char *data = 0;
  CPPUNIT_ASSERT_NO_THROW(data = libebook::readNBytes(stream, plain.size()));
  CPPUNIT_ASSERT(stream->atEOS());
  const string decoded(reinterpret_cast<const char *>(data), plain.size());
  CPPUNIT_ASSERT_EQUAL(plain, decoded);
}

CPPUNIT_TEST_SUITE_REGISTRATION(IMPLZSSStreamTest);

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
