static const char* op_c_source =
"/* Video4Linux operation for GEGL                                             \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2004-2008 Øyvind Kolås <pippin@gimp.org>                       \n"
" *                     originally written for gggl                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path,   _(\"Path\"), \"/dev/video0\")                     \n"
"  description (_(\"Path to v4l device\"))                                     \n"
"property_int  (width,  _(\"Width\"), 320)                                     \n"
"  description (_(\"Width for rendered image\"))                               \n"
"  value_range (0, G_MAXINT)                                                   \n"
"property_int  (height, _(\"Height\"), 240)                                    \n"
"  description (_(\"Height for rendered image\"))                              \n"
"  value_range (0, G_MAXINT)                                                   \n"
"property_int  (frame,  _(\"Frame\"), 0)                                       \n"
"  description (_(\"current frame number, can be changed to trigger a reload of the image.\"))\n"
"  value_range (0, G_MAXINT)                                                   \n"
"property_int  (fps,    _(\"FPS\"), 0)                                         \n"
"  description (_(\"autotrigger reload this many times a second.\"))           \n"
"  value_range (0, G_MAXINT)                                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE v4l.c                                                \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include \"v4lutils/v4lutils.h\"                                              \n"
"#define GEGL_OP_C_SOURCE v4lutils/v4lutils.c                                  \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint active;                                                                \n"
"  gint w;                                                                     \n"
"  gint h;                                                                     \n"
"  gint w_stored;                                                              \n"
"  gint h_stored;                                                              \n"
"  gint frame;                                                                 \n"
"  gint decode;                                                                \n"
"  v4ldevice *vd;                                                              \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"                                                                              \n"
"  if (p==NULL)                                                                \n"
"    {                                                                         \n"
"      p = g_new0 (Priv, 1);                                                   \n"
"      o->user_data = (void*) p;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->w = 320;                                                                 \n"
"  p->h = 240;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result ={0,0,320,200};                                        \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  result.width = o->width;                                                    \n"
"  result.height = o->height;                                                  \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p= (Priv*)o->user_data;                                               \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                            babl_format_new (                                 \n"
"                                  babl_model (\"R'G'B'\"),                    \n"
"                                  babl_type (\"u8\"),                         \n"
"                                  babl_component (\"B'\"),                    \n"
"                                  babl_component (\"G'\"),                    \n"
"                                  babl_component (\"R'\"),                    \n"
"                                  NULL));                                     \n"
"                                                                              \n"
"  p->w = o->width;                                                            \n"
"  p->h = o->height;                                                           \n"
"                                                                              \n"
"  if (!p->vd)                                                                 \n"
"    {                                                                         \n"
"      p->vd = g_malloc0 (sizeof (v4ldevice));                                 \n"
"                                                                              \n"
"      if (v4lopen (o->path, p->vd))                                           \n"
"        return;                                                               \n"
"                                                                              \n"
"      p->active = 1;                                                          \n"
"                                                                              \n"
"      if (v4lmmap (p->vd))                                                    \n"
"        return;                                                               \n"
"                                                                              \n"
"      v4lsetdefaultnorm (p->vd, VIDEO_MODE_PAL);                              \n"
"      v4lgetcapability (p->vd);                                               \n"
"                                                                              \n"
"      if (!(p->vd->capability.type & VID_TYPE_CAPTURE)) {                     \n"
"          g_warning (                                                         \n"
"               \"video_init: This device seems not to support video capturing.\\n\");\n"
"         return;                                                              \n"
"      }                                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p->w != p->w_stored || p->h != p->h_stored)                             \n"
"    {                                                                         \n"
"                                                                              \n"
"      if (p->w > p->vd->capability.maxwidth                                   \n"
"          || p->h > p->vd->capability.maxheight)                              \n"
"        {                                                                     \n"
"          p->w = p->vd->capability.maxwidth;                                  \n"
"          p->h = p->vd->capability.maxheight;                                 \n"
"          o->width = p->w;                                                    \n"
"          o->height = p->h;                                                   \n"
"          g_warning ( \"capturing size is set to %dx%d.\\n\", p->w, p->h);    \n"
"        }                                                                     \n"
"      else if (p->w < p->vd->capability.minwidth                              \n"
"               || p->h < p->vd->capability.minheight)                         \n"
"        {                                                                     \n"
"          p->w = p->vd->capability.minwidth;                                  \n"
"          p->h = p->vd->capability.minheight;                                 \n"
"          o->width = p->w;                                                    \n"
"          o->height = p->h;                                                   \n"
"          g_warning ( \"capturing size is set to %dx%d.\\n\", p->w, p->h);    \n"
"        }                                                                     \n"
"                                                                              \n"
"      p->w_stored = p->w;                                                     \n"
"      p->h_stored = p->h;                                                     \n"
"                                                                              \n"
"      /* FIXME: try other palettes as well, do some profiling on the spca     \n"
"       * based cameras to see what is the ideal format wrt performance        \n"
"       */                                                                     \n"
"                                                                              \n"
"      if (!v4lsetpalette (p->vd, VIDEO_PALETTE_RGB24))                        \n"
"        {                                                                     \n"
"           p->decode=0;                                                       \n"
"        }                                                                     \n"
"      else if (!v4lsetpalette (p->vd, VIDEO_PALETTE_YUV420P))                 \n"
"        {                                                                     \n"
"           p->decode=1;                                                       \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          g_warning ( \"oops,. no usable v4l format found\\n\");              \n"
"          return;                                                             \n"
"        }                                                                     \n"
"      v4lgrabinit (p->vd, p->w, p->h);                                        \n"
"      v4lgrabf (p->vd);                                                       \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
" GeglProperties *o = GEGL_PROPERTIES (object);                                \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"                                                                              \n"
"      if (p->vd)                                                              \n"
"        {                                                                     \n"
"          v4lmunmap (p->vd);                                                  \n"
"          v4lclose (p->vd);                                                   \n"
"          g_free (p->vd);                                                     \n"
"        }                                                                     \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean update (gpointer operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle bounds = gegl_operation_get_bounding_box (operation);         \n"
"  gegl_operation_invalidate (operation, &bounds, FALSE);                      \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"  guchar     *capbuf;                                                         \n"
"  static gboolean inited = FALSE;                                             \n"
"                                                                              \n"
"    if (!inited && o->fps != 0)                                               \n"
"      {                                                                       \n"
"        inited= TRUE;                                                         \n"
"        g_timeout_add (1000/o->fps, update, operation);                       \n"
"      }                                                                       \n"
"                                                                              \n"
"  if (!p->active)                                                             \n"
"    return FALSE;                                                             \n"
"                                                                              \n"
"  v4lgrabf (p->vd);                                                           \n"
"  capbuf = v4lgetaddress (p->vd);                                             \n"
"  v4lsyncf (p->vd);                                                           \n"
"                                                                              \n"
"  if (!capbuf)                                                                \n"
"    {                                                                         \n"
"      g_warning (\"no capbuf found\");                                        \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p->decode)                                                              \n"
"    {                                                                         \n"
"      guchar foobuf[o->width*o->height*3];                                    \n"
"          /* XXX: foobuf is unneeded the conversions resets for every         \n"
"           * scanline and could thus have been done in a line by line         \n"
"           * manner an fed into the output buffer                             \n"
"           */                                                                 \n"
"      gint y;                                                                 \n"
"      for (y = 0; y < p->h; y++)                                              \n"
"        {                                                                     \n"
"          gint       x;                                                       \n"
"                                                                              \n"
"          guchar *dst = &foobuf[y*p->w*3];                                    \n"
"          guchar *ysrc = (guchar *) (capbuf + (y) * (p->w) * 1);              \n"
"          guchar *usrc = (guchar *) (capbuf + (p->w) * (p->h) + (y) / 2 * (p->w) / 2);\n"
"          guchar *vsrc = (guchar *) (capbuf + (p->w) * (p->h) + ((p->w) * (p->h)) / 4 + (y) / 2 * (p->w) / 2);\n"
"                                                                              \n"
"          for (x = 0; x < p->w; x++)                                          \n"
"            {                                                                 \n"
"                                                                              \n"
"              gint       R, G, B;                                             \n"
"                                                                              \n"
"#ifndef byteclamp                                                             \n"
"#define byteclamp(j) do{if(j<0)j=0; else if(j>255)j=255;}while(0)             \n"
"#endif                                                                        \n"
"                                                                              \n"
"#define YUV82RGB8(Y,U,V,R,G,B)do{\\                                           \n"
"                  R= ((Y<<15)                 + 37355*(V-128))>>15;\\         \n"
"                  G= ((Y<<15) -12911* (U-128) - 19038*(V-128))>>15;\\         \n"
"                  B= ((Y<<15) +66454* (U-128)                )>>15;\\         \n"
"                  byteclamp(R);\\                                             \n"
"                  byteclamp(G);\\                                             \n"
"                  byteclamp(B);\\                                             \n"
"              }while(0)                                                       \n"
"                                                                              \n"
"      /* the format support for this code is not very good, but it            \n"
"       * works for the devices I have tested with, conversion even            \n"
"       * for chroma subsampled images is something we should let              \n"
"       * babl handle.                                                         \n"
"       */                                                                     \n"
"              YUV82RGB8 (*ysrc, *usrc, *vsrc, R, G, B);                       \n"
"              dst[0] = B;                                                     \n"
"              dst[1] = G;                                                     \n"
"              dst[2] = R;                                                     \n"
"                                                                              \n"
"              dst += 3;                                                       \n"
"              ysrc++;                                                         \n"
"              if (x % 2)                                                      \n"
"                {                                                             \n"
"                  usrc++;                                                     \n"
"                  vsrc++;                                                     \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"      gegl_buffer_set (output, NULL, 0, NULL, foobuf, GEGL_AUTO_ROWSTRIDE);   \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_buffer_set (output, NULL, 0, NULL, capbuf, GEGL_AUTO_ROWSTRIDE);   \n"
"    }                                                                         \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process             = process;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->prepare          = prepare;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:v4l\",                                           \n"
"    \"title\",        _(\"Video4Linux Frame Source\"),                        \n"
"    \"categories\",   \"input:video\",                                        \n"
"    \"description\",  _(\"Video4Linux input, webcams framegrabbers and similar devices.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#endif                                                                        \n"
;
