//  Copyright (c) 2007 John Maddock
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 495> bessel_i_int_data = {{
      {{ SC_(0.0), SC_(0.177219114266335964202880859375e-2), SC_(0.1000000785165515654790765567976560128368e1) }}, 
      {{ SC_(0.0), SC_(0.22177286446094512939453125e-2), SC_(0.1000001229580463247166647265657459686513e1) }}, 
      {{ SC_(0.0), SC_(0.7444499991834163665771484375e-2), SC_(0.1000013855193023439561602999309818071557e1) }}, 
      {{ SC_(0.0), SC_(0.1433600485324859619140625e-1), SC_(0.100005138091877460790808253311381371617e1) }}, 
      {{ SC_(0.0), SC_(0.1760916970670223236083984375e-1), SC_(0.1000077522216818092267597684468025144708e1) }}, 
      {{ SC_(0.0), SC_(0.6152711808681488037109375e-1), SC_(0.1000946620505179168127565717529250425225e1) }}, 
      {{ SC_(0.0), SC_(0.11958599090576171875e0), SC_(0.1003578399092795290959506558979668000986e1) }}, 
      {{ SC_(0.0), SC_(0.15262925624847412109375e0), SC_(0.1005832407473077490942708958509537944332e1) }}, 
      {{ SC_(0.0), SC_(0.408089816570281982421875e0), SC_(0.1042069688780878266908906813963061201236e1) }}, 
      {{ SC_(0.0), SC_(0.6540834903717041015625e0), SC_(0.1109850431257999241542412962070021625239e1) }}, 
      {{ SC_(0.0), SC_(0.1097540378570556640625e1), SC_(0.1324594459649893673687924138468203300537e1) }}, 
      {{ SC_(0.0), SC_(0.30944411754608154296875e1), SC_(0.5270503008520823311035815313268274322688e1) }}, 
      {{ SC_(0.0), SC_(0.51139926910400390625e1), SC_(0.3016460113324413124385977969424656719006e2) }}, 
      {{ SC_(0.0), SC_(0.95070552825927734375e1), SC_(0.1765221230864037183559483071058505259281e4) }}, 
      {{ SC_(0.0), SC_(0.24750102996826171875e2), SC_(0.4520582716299093122418957895745838047526e10) }}, 
      {{ SC_(0.0), SC_(0.637722015380859375e2), SC_(0.248523599457696979135532431768725854655e27) }}, 
      {{ SC_(0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(0.8860959191975001520307655146348128981208e-3) }}, 
      {{ SC_(0.1e1), SC_(0.22177286446094512939453125e-2), SC_(0.1108865004023609343492425973877677708278e-2) }}, 
      {{ SC_(0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(0.3722275782133396649790935284938128705517e-2) }}, 
      {{ SC_(0.1e1), SC_(0.1433600485324859619140625e-1), SC_(0.7168186575111060974651037851905127311172e-2) }}, 
      {{ SC_(0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(0.8804926126614467969087386987026758424778e-2) }}, 
      {{ SC_(0.1e1), SC_(0.6152711808681488037109375e-1), SC_(0.307781186030490619563031243121873491391e-1) }}, 
      {{ SC_(0.1e1), SC_(0.11958599090576171875e0), SC_(0.5989994518931145664339323232552863277613e-1) }}, 
      {{ SC_(0.1e1), SC_(0.15262925624847412109375e0), SC_(0.7653706917131299515526663760316122678536e-1) }}, 
      {{ SC_(0.1e1), SC_(0.408089816570281982421875e0), SC_(0.2083221213089251435227012018452735830071e0) }}, 
      {{ SC_(0.1e1), SC_(0.6540834903717041015625e0), SC_(0.3448458972066057120326871217765728528051e0) }}, 
      {{ SC_(0.1e1), SC_(0.1097540378570556640625e1), SC_(0.6356539293968716593197570138590683019623e0) }}, 
      {{ SC_(0.1e1), SC_(0.30944411754608154296875e1), SC_(0.4304586767845429639244166020309162877221e1) }}, 
      {{ SC_(0.1e1), SC_(0.51139926910400390625e1), SC_(0.2702631060982870150322284389310299253322e2) }}, 
      {{ SC_(0.1e1), SC_(0.95070552825927734375e1), SC_(0.1669630395093490324472744646621461529409e4) }}, 
      {{ SC_(0.1e1), SC_(0.24750102996826171875e2), SC_(0.4428295881367777978681563662886643036499e10) }}, 
      {{ SC_(0.1e1), SC_(0.637722015380859375e2), SC_(0.2465673119157042745018873572402000151201e27) }}, 
      {{ SC_(0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(0.2568686424002909205919386454789887238475e-13) }}, 
      {{ SC_(0.4e1), SC_(0.22177286446094512939453125e-2), SC_(0.629944815795979203946014830217428242984e-13) }}, 
      {{ SC_(0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(0.7998565658415621562337103146472082554028e-11) }}, 
      {{ SC_(0.4e1), SC_(0.1433600485324859619140625e-1), SC_(0.1099982550547901452676110099180043770797e-9) }}, 
      {{ SC_(0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(0.250398097475533981445277556832601328223e-9) }}, 
      {{ SC_(0.4e1), SC_(0.6152711808681488037109375e-1), SC_(0.3732650011579987791541719677211396374467e-7) }}, 
      {{ SC_(0.4e1), SC_(0.11958599090576171875e0), SC_(0.5329672477129410019119113447394893295596e-6) }}, 
      {{ SC_(0.4e1), SC_(0.15262925624847412109375e0), SC_(0.141489997131418627857066995095369938696e-5) }}, 
      {{ SC_(0.4e1), SC_(0.408089816570281982421875e0), SC_(0.7282921216911263304294810852632628068137e-4) }}, 
      {{ SC_(0.4e1), SC_(0.6540834903717041015625e0), SC_(0.4869396484162391070562181449261259775595e-3) }}, 
      {{ SC_(0.4e1), SC_(0.1097540378570556640625e1), SC_(0.4012161862208555247000124967949382739361e-2) }}, 
      {{ SC_(0.4e1), SC_(0.30944411754608154296875e1), SC_(0.3787138783037547310647400896688635049979e0) }}, 
      {{ SC_(0.4e1), SC_(0.51139926910400390625e1), SC_(0.5868359078308841151534796428362771527491e1) }}, 
      {{ SC_(0.4e1), SC_(0.95070552825927734375e1), SC_(0.7357193068805439491961808818463893925223e3) }}, 
      {{ SC_(0.4e1), SC_(0.24750102996826171875e2), SC_(0.3252313835173492963089917060960028522653e10) }}, 
      {{ SC_(0.4e1), SC_(0.637722015380859375e2), SC_(0.2190135725660260903026664293135379072029e27) }}, 
      {{ SC_(0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(0.8510076576264637138875125872170131898096e-25) }}, 
      {{ SC_(0.7e1), SC_(0.22177286446094512939453125e-2), SC_(0.4089953800055587124509461216692582736447e-24) }}, 
      {{ SC_(0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(0.1964305273103342680910343954984308619768e-20) }}, 
      {{ SC_(0.7e1), SC_(0.1433600485324859619140625e-1), SC_(0.1929120066647206188436854652387114727807e-18) }}, 
      {{ SC_(0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(0.8138340472907783210251698976282644477818e-18) }}, 
      {{ SC_(0.7e1), SC_(0.6152711808681488037109375e-1), SC_(0.5174601186268260520938521328073083909595e-14) }}, 
      {{ SC_(0.7e1), SC_(0.11958599090576171875e0), SC_(0.542395054389276152812978441225258183457e-12) }}, 
      {{ SC_(0.7e1), SC_(0.15262925624847412109375e0), SC_(0.299323047925904744170833613652767758086e-11) }}, 
      {{ SC_(0.7e1), SC_(0.408089816570281982421875e0), SC_(0.2937036464827401981806966262136490086826e-8) }}, 
      {{ SC_(0.7e1), SC_(0.6540834903717041015625e0), SC_(0.8046255455349868199127611214199975918109e-7) }}, 
      {{ SC_(0.7e1), SC_(0.1097540378570556640625e1), SC_(0.3087574366778968153326883525133715811508e-5) }}, 
      {{ SC_(0.7e1), SC_(0.30944411754608154296875e1), SC_(0.5653447566166178294962968673241498039082e-2) }}, 
      {{ SC_(0.7e1), SC_(0.51139926910400390625e1), SC_(0.3104877913933256744262177732064662628008e0) }}, 
      {{ SC_(0.7e1), SC_(0.95070552825927734375e1), SC_(0.1318882152673454326811262619237084813807e3) }}, 
      {{ SC_(0.7e1), SC_(0.24750102996826171875e2), SC_(0.1657171203518438763471041373689390646813e10) }}, 
      {{ SC_(0.7e1), SC_(0.637722015380859375e2), SC_(0.1687969369952926235916289436609130146855e27) }}, 
      {{ SC_(0.1e2), SC_(0.177219114266335964202880859375e-2), SC_(0.8223234174016769910080935836038629086129e-37) }}, 
      {{ SC_(0.1e2), SC_(0.22177286446094512939453125e-2), SC_(0.7744994585234402998026715482431864809177e-36) }}, 
      {{ SC_(0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(0.140699610530434722230776594136166384761e-30) }}, 
      {{ SC_(0.1e2), SC_(0.1433600485324859619140625e-1), SC_(0.9867802131594229578497672216212381206342e-28) }}, 
      {{ SC_(0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(0.7714874409767011750174102200723123371757e-27) }}, 
      {{ SC_(0.1e2), SC_(0.6152711808681488037109375e-1), SC_(0.2092377824573518684672948738047686808098e-21) }}, 
      {{ SC_(0.1e2), SC_(0.11958599090576171875e0), SC_(0.161020520917686222303614853893004305517e-18) }}, 
      {{ SC_(0.1e2), SC_(0.15262925624847412109375e0), SC_(0.1847331437121988828659943855683029847574e-17) }}, 
      {{ SC_(0.1e2), SC_(0.408089816570281982421875e0), SC_(0.3460494035292646148422797589423437304445e-13) }}, 
      {{ SC_(0.1e2), SC_(0.6540834903717041015625e0), SC_(0.3894842946330373264656841132859435813454e-11) }}, 
      {{ SC_(0.1e2), SC_(0.1097540378570556640625e1), SC_(0.7014848610606988360553920593019620983893e-9) }}, 
      {{ SC_(0.1e2), SC_(0.30944411754608154296875e1), SC_(0.2688034653083270014812653556923722759657e-4) }}, 
      {{ SC_(0.1e2), SC_(0.51139926910400390625e1), SC_(0.5883608669420951460953858890820260901642e-2) }}, 
      {{ SC_(0.1e2), SC_(0.95070552825927734375e1), SC_(0.1093507510277669423960436015414354945337e2) }}, 
      {{ SC_(0.1e2), SC_(0.24750102996826171875e2), SC_(0.5917457915288690964012606008596472223686e9) }}, 
      {{ SC_(0.1e2), SC_(0.637722015380859375e2), SC_(0.1129466336865796349694848290694042226462e27) }}, 
      {{ SC_(0.13e2), SC_(0.177219114266335964202880859375e-2), SC_(0.3334011286277694028669539285669885563166e-49) }}, 
      {{ SC_(0.13e2), SC_(0.22177286446094512939453125e-2), SC_(0.6153738758043090277122480232744400184223e-48) }}, 
      {{ SC_(0.13e2), SC_(0.7444499991834163665771484375e-2), SC_(0.4228556218314688954181791384498131827781e-41) }}, 
      {{ SC_(0.13e2), SC_(0.1433600485324859619140625e-1), SC_(0.2117859499568276103587689359158579219165e-37) }}, 
      {{ SC_(0.13e2), SC_(0.1760916970670223236083984375e-1), SC_(0.3068580854652108160425423230103324526003e-36) }}, 
      {{ SC_(0.13e2), SC_(0.6152711808681488037109375e-1), SC_(0.354996892487294926273047608799400251176e-29) }}, 
      {{ SC_(0.13e2), SC_(0.11958599090576171875e0), SC_(0.2005786158653338640126467535312809972599e-25) }}, 
      {{ SC_(0.13e2), SC_(0.15262925624847412109375e0), SC_(0.4784115376425512596092514679649054496976e-24) }}, 
      {{ SC_(0.13e2), SC_(0.408089816570281982421875e0), SC_(0.1711772323228039445264854631251211491723e-18) }}, 
      {{ SC_(0.13e2), SC_(0.6540834903717041015625e0), SC_(0.7922791477017998377388657609963942307393e-16) }}, 
      {{ SC_(0.13e2), SC_(0.1097540378570556640625e1), SC_(0.6716323224025831832505193136394393092916e-13) }}, 
      {{ SC_(0.13e2), SC_(0.30944411754608154296875e1), SC_(0.5542968221483836259279888714065628022048e-7) }}, 
      {{ SC_(0.13e2), SC_(0.51139926910400390625e1), SC_(0.5081514739534627446729224579266224585244e-4) }}, 
      {{ SC_(0.13e2), SC_(0.95070552825927734375e1), SC_(0.4725865925391415011344735823410723955919e0) }}, 
      {{ SC_(0.13e2), SC_(0.24750102996826171875e2), SC_(0.1501669323697961007131150053219059261996e9) }}, 
      {{ SC_(0.13e2), SC_(0.637722015380859375e2), SC_(0.6567322402823646295136471316076539442991e26) }}, 
      {{ SC_(0.16e2), SC_(0.177219114266335964202880859375e-2), SC_(0.6903502427645376124200283458900439421873e-62) }}, 
      {{ SC_(0.16e2), SC_(0.22177286446094512939453125e-2), SC_(0.2497094638075881780026744754511410943168e-60) }}, 
      {{ SC_(0.16e2), SC_(0.7444499991834163665771484375e-2), SC_(0.6490368720925649184380212530671130650415e-52) }}, 
      {{ SC_(0.16e2), SC_(0.1433600485324859619140625e-1), SC_(0.2321410891263873863049860997755010357737e-47) }}, 
      {{ SC_(0.16e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6233393146806615669318454471770676678158e-46) }}, 
      {{ SC_(0.16e2), SC_(0.6152711808681488037109375e-1), SC_(0.3076024754804947155076702423770846087509e-37) }}, 
      {{ SC_(0.16e2), SC_(0.11958599090576171875e0), SC_(0.1276076508818807870968154682834703381456e-32) }}, 
      {{ SC_(0.16e2), SC_(0.15262925624847412109375e0), SC_(0.6327816308187779042063522476542118283704e-31) }}, 
      {{ SC_(0.16e2), SC_(0.408089816570281982421875e0), SC_(0.4325697498499225494703474366594855227627e-24) }}, 
      {{ SC_(0.16e2), SC_(0.6540834903717041015625e0), SC_(0.8236892146966727882912257976976559721749e-21) }}, 
      {{ SC_(0.16e2), SC_(0.1097540378570556640625e1), SC_(0.3290926416109688284429353953191341282434e-17) }}, 
      {{ SC_(0.16e2), SC_(0.30944411754608154296875e1), SC_(0.5931102132514253462239519305387392076225e-10) }}, 
      {{ SC_(0.16e2), SC_(0.51139926910400390625e1), SC_(0.2335364004878958117535587002359693990812e-6) }}, 
      {{ SC_(0.16e2), SC_(0.95070552825927734375e1), SC_(0.1173133225194457116974463544330816733028e-1) }}, 
      {{ SC_(0.16e2), SC_(0.24750102996826171875e2), SC_(0.2753215704715969881848773041250943304642e8) }}, 
      {{ SC_(0.16e2), SC_(0.637722015380859375e2), SC_(0.3322209023506974925844424554221373040616e26) }}, 
      {{ SC_(0.19e2), SC_(0.177219114266335964202880859375e-2), SC_(0.8261067094087423730034263973301115684581e-75) }}, 
      {{ SC_(0.19e2), SC_(0.22177286446094512939453125e-2), SC_(0.5855920886925015157162632673778154535237e-73) }}, 
      {{ SC_(0.19e2), SC_(0.7444499991834163665771484375e-2), SC_(0.5757194525974008514948245262795334604372e-63) }}, 
      {{ SC_(0.19e2), SC_(0.1433600485324859619140625e-1), SC_(0.1470520977940377483699491133689696047926e-57) }}, 
      {{ SC_(0.19e2), SC_(0.1760916970670223236083984375e-1), SC_(0.7317720953687948002108959608625870212987e-56) }}, 
      {{ SC_(0.19e2), SC_(0.6152711808681488037109375e-1), SC_(0.1540355292754922109447449922297173905408e-45) }}, 
      {{ SC_(0.19e2), SC_(0.11958599090576171875e0), SC_(0.4691793820588578982561969754887040800778e-40) }}, 
      {{ SC_(0.19e2), SC_(0.15262925624847412109375e0), SC_(0.4837042419325611244448782705711809839607e-38) }}, 
      {{ SC_(0.19e2), SC_(0.408089816570281982421875e0), SC_(0.6318280290179167224369069743316603013159e-30) }}, 
      {{ SC_(0.19e2), SC_(0.6540834903717041015625e0), SC_(0.4950946700479993216127819599385331607622e-26) }}, 
      {{ SC_(0.19e2), SC_(0.1097540378570556640625e1), SC_(0.9329580403370556328699496223117906495753e-22) }}, 
      {{ SC_(0.19e2), SC_(0.30944411754608154296875e1), SC_(0.3700270472942945791439257341299072941617e-13) }}, 
      {{ SC_(0.19e2), SC_(0.51139926910400390625e1), SC_(0.6348476619313232628895742730906837256601e-9) }}, 
      {{ SC_(0.19e2), SC_(0.95070552825927734375e1), SC_(0.1805116332675287586594293794465309848752e-3) }}, 
      {{ SC_(0.19e2), SC_(0.24750102996826171875e2), SC_(0.3711929598597669984804253906197792841378e7) }}, 
      {{ SC_(0.19e2), SC_(0.637722015380859375e2), SC_(0.1464275015800479716846297120573863475382e26) }}, 
      {{ SC_(0.22e2), SC_(0.177219114266335964202880859375e-2), SC_(0.6220221841381686345463747703974457948264e-88) }}, 
      {{ SC_(0.22e2), SC_(0.22177286446094512939453125e-2), SC_(0.8640889610254804338796688442629163492749e-86) }}, 
      {{ SC_(0.22e2), SC_(0.7444499991834163665771484375e-2), SC_(0.3213331324358774094325533898046632109449e-74) }}, 
      {{ SC_(0.22e2), SC_(0.1433600485324859619140625e-1), SC_(0.5861294441529658310051672533774294341365e-68) }}, 
      {{ SC_(0.22e2), SC_(0.1760916970670223236083984375e-1), SC_(0.5405430696633071789361672467258939698443e-66) }}, 
      {{ SC_(0.22e2), SC_(0.6152711808681488037109375e-1), SC_(0.4853510644495870330522539016072351182167e-54) }}, 
      {{ SC_(0.22e2), SC_(0.11958599090576171875e0), SC_(0.1085444829164009254414251462765173076655e-47) }}, 
      {{ SC_(0.22e2), SC_(0.15262925624847412109375e0), SC_(0.232656294329765330942559881117341522294e-45) }}, 
      {{ SC_(0.22e2), SC_(0.408089816570281982421875e0), SC_(0.5807460900437154044099671936908947080489e-36) }}, 
      {{ SC_(0.22e2), SC_(0.6540834903717041015625e0), SC_(0.1872936340884406560723582461622465615788e-31) }}, 
      {{ SC_(0.22e2), SC_(0.1097540378570556640625e1), SC_(0.1665365281344345408053410521428205724532e-26) }}, 
      {{ SC_(0.22e2), SC_(0.30944411754608154296875e1), SC_(0.1460452573305232893475147990189032216074e-16) }}, 
      {{ SC_(0.22e2), SC_(0.51139926910400390625e1), SC_(0.110162238891447155055650375984211287254e-11) }}, 
      {{ SC_(0.22e2), SC_(0.95070552825927734375e1), SC_(0.182787721514439346096490105048682573838e-5) }}, 
      {{ SC_(0.22e2), SC_(0.24750102996826171875e2), SC_(0.3746253298470363618744415470120906650113e6) }}, 
      {{ SC_(0.22e2), SC_(0.637722015380859375e2), SC_(0.5632662484294745602939078591361038707213e25) }}, 
      {{ SC_(0.25e2), SC_(0.177219114266335964202880859375e-2), SC_(0.3135945335960727893592699884132940922271e-101) }}, 
      {{ SC_(0.25e2), SC_(0.22177286446094512939453125e-2), SC_(0.8537183153244993100786485237255246993327e-99) }}, 
      {{ SC_(0.25e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1200861732220382730023275257555184414901e-85) }}, 
      {{ SC_(0.25e2), SC_(0.1433600485324859619140625e-1), SC_(0.1564259392522354667305534790602444834818e-78) }}, 
      {{ SC_(0.25e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2673484669989116998164825655979889586695e-76) }}, 
      {{ SC_(0.25e2), SC_(0.6152711808681488037109375e-1), SC_(0.1023963723875913940543782106825105562595e-62) }}, 
      {{ SC_(0.25e2), SC_(0.11958599090576171875e0), SC_(0.1681402972499189157506694463680089409952e-55) }}, 
      {{ SC_(0.25e2), SC_(0.15262925624847412109375e0), SC_(0.7492839127770565255129726672130867658204e-53) }}, 
      {{ SC_(0.25e2), SC_(0.408089816570281982421875e0), SC_(0.3574322975225735467692728527590428448863e-42) }}, 
      {{ SC_(0.25e2), SC_(0.6540834903717041015625e0), SC_(0.4744828668382638092936552938776145589611e-37) }}, 
      {{ SC_(0.25e2), SC_(0.1097540378570556640625e1), SC_(0.1991344057173244990078283873078078723997e-31) }}, 
      {{ SC_(0.25e2), SC_(0.30944411754608154296875e1), SC_(0.3873281106566788487579113427178813795979e-20) }}, 
      {{ SC_(0.25e2), SC_(0.51139926910400390625e1), SC_(0.1292160962597325779256280725821274270157e-14) }}, 
      {{ SC_(0.25e2), SC_(0.95070552825927734375e1), SC_(0.1277480310920568694024638558844125852046e-7) }}, 
      {{ SC_(0.25e2), SC_(0.24750102996826171875e2), SC_(0.2879797259274591258177294682787289679677e5) }}, 
      {{ SC_(0.25e2), SC_(0.637722015380859375e2), SC_(0.1894657556839703532754378542183363508864e25) }}, 
      {{ SC_(0.28e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1109979701510657324409936064780530816436e-114) }}, 
      {{ SC_(0.28e2), SC_(0.22177286446094512939453125e-2), SC_(0.5921812930388885221901501790031275724875e-112) }}, 
      {{ SC_(0.28e2), SC_(0.7444499991834163665771484375e-2), SC_(0.3150753681177232602195191694326830735903e-97) }}, 
      {{ SC_(0.28e2), SC_(0.1433600485324859619140625e-1), SC_(0.2930947033264324636241925247309918315621e-89) }}, 
      {{ SC_(0.28e2), SC_(0.1760916970670223236083984375e-1), SC_(0.928344290130601916111191342129716233572e-87) }}, 
      {{ SC_(0.28e2), SC_(0.6152711808681488037109375e-1), SC_(0.1516692451422192280031325885356319403396e-71) }}, 
      {{ SC_(0.28e2), SC_(0.11958599090576171875e0), SC_(0.1828611396607332850526050100536554426156e-63) }}, 
      {{ SC_(0.28e2), SC_(0.15262925624847412109375e0), SC_(0.1694199613349620948688358748400128595992e-60) }}, 
      {{ SC_(0.28e2), SC_(0.408089816570281982421875e0), SC_(0.1544557206594990195590747820842381228636e-48) }}, 
      {{ SC_(0.28e2), SC_(0.6540834903717041015625e0), SC_(0.8440150439835583222917158485081145254802e-43) }}, 
      {{ SC_(0.28e2), SC_(0.1097540378570556640625e1), SC_(0.167225543922741375797615313493339729248e-36) }}, 
      {{ SC_(0.28e2), SC_(0.30944411754608154296875e1), SC_(0.7229741356347695815271417352613489011386e-24) }}, 
      {{ SC_(0.28e2), SC_(0.51139926910400390625e1), SC_(0.1071154635862208253018553734939741687232e-17) }}, 
      {{ SC_(0.28e2), SC_(0.95070552825927734375e1), SC_(0.6403905624258943728927767408796427923806e-10) }}, 
      {{ SC_(0.28e2), SC_(0.24750102996826171875e2), SC_(0.1714093029633072106704730462439541786694e4) }}, 
      {{ SC_(0.28e2), SC_(0.637722015380859375e2), SC_(0.5584488054748810510523872279701284113872e24) }}, 
      {{ SC_(0.31e2), SC_(0.177219114266335964202880859375e-2), SC_(0.2863358901803292925306306945061963869388e-128) }}, 
      {{ SC_(0.31e2), SC_(0.22177286446094512939453125e-2), SC_(0.2993704751214452165393173467229226989817e-125) }}, 
      {{ SC_(0.31e2), SC_(0.7444499991834163665771484375e-2), SC_(0.6024903576282872782013491962307115105296e-109) }}, 
      {{ SC_(0.31e2), SC_(0.1433600485324859619140625e-1), SC_(0.4002408227087383286146279911225738698901e-100) }}, 
      {{ SC_(0.31e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2349387561715709924891542659732908290704e-97) }}, 
      {{ SC_(0.31e2), SC_(0.6152711808681488037109375e-1), SC_(0.1637287639286449704309407433798147518595e-80) }}, 
      {{ SC_(0.31e2), SC_(0.11958599090576171875e0), SC_(0.1449393765029909620233823815723216878733e-71) }}, 
      {{ SC_(0.31e2), SC_(0.15262925624847412109375e0), SC_(0.2791893400549024586300562047044427723662e-68) }}, 
      {{ SC_(0.31e2), SC_(0.408089816570281982421875e0), SC_(0.4864541221147515577402253306801741241212e-55) }}, 
      {{ SC_(0.31e2), SC_(0.6540834903717041015625e0), SC_(0.1094280544222704547184559884703922698029e-48) }}, 
      {{ SC_(0.31e2), SC_(0.1097540378570556640625e1), SC_(0.1023695039072156662184036868355322523886e-41) }}, 
      {{ SC_(0.31e2), SC_(0.30944411754608154296875e1), SC_(0.9852580714919682750791412525269523041103e-28) }}, 
      {{ SC_(0.31e2), SC_(0.51139926910400390625e1), SC_(0.6502404032231234525897694922239945174238e-21) }}, 
      {{ SC_(0.31e2), SC_(0.95070552825927734375e1), SC_(0.2376555996134722482517673913552026409674e-12) }}, 
      {{ SC_(0.31e2), SC_(0.24750102996826171875e2), SC_(0.8021910179370802808093108588936020297325e2) }}, 
      {{ SC_(0.31e2), SC_(0.637722015380859375e2), SC_(0.144559757502471000356773666766249439466e24) }}, 
      {{ SC_(0.34e2), SC_(0.177219114266335964202880859375e-2), SC_(0.554848797257781034477910770666738393437e-142) }}, 
      {{ SC_(0.34e2), SC_(0.22177286446094512939453125e-2), SC_(0.1136845274152627033376025226298304218956e-138) }}, 
      {{ SC_(0.34e2), SC_(0.7444499991834163665771484375e-2), SC_(0.8654138946859088878293887011745214993209e-121) }}, 
      {{ SC_(0.34e2), SC_(0.1433600485324859619140625e-1), SC_(0.410556487014915840216809384796759450665e-111) }}, 
      {{ SC_(0.34e2), SC_(0.1760916970670223236083984375e-1), SC_(0.4466202286730993255330187442167251739945e-108) }}, 
      {{ SC_(0.34e2), SC_(0.6152711808681488037109375e-1), SC_(0.1327671950103163073519226507877580260439e-89) }}, 
      {{ SC_(0.34e2), SC_(0.11958599090576171875e0), SC_(0.86295932704287933357857246832402054593e-80) }}, 
      {{ SC_(0.34e2), SC_(0.15262925624847412109375e0), SC_(0.3455990968477486779164741360883518309538e-76) }}, 
      {{ SC_(0.34e2), SC_(0.408089816570281982421875e0), SC_(0.1150874342931716017287294604949997878891e-61) }}, 
      {{ SC_(0.34e2), SC_(0.6540834903717041015625e0), SC_(0.1065788460010113098181503088093171140974e-54) }}, 
      {{ SC_(0.34e2), SC_(0.1097540378570556640625e1), SC_(0.4708137202898137691876298170399356746151e-47) }}, 
      {{ SC_(0.34e2), SC_(0.30944411754608154296875e1), SC_(0.1009921586705894229463842919739328565867e-31) }}, 
      {{ SC_(0.34e2), SC_(0.51139926910400390625e1), SC_(0.2975630653433816790749983787198736104047e-24) }}, 
      {{ SC_(0.34e2), SC_(0.95070552825927734375e1), SC_(0.6703531083479191738129933338411606672808e-15) }}, 
      {{ SC_(0.34e2), SC_(0.24750102996826171875e2), SC_(0.299397039157890670910784206640756450785e1) }}, 
      {{ SC_(0.34e2), SC_(0.637722015380859375e2), SC_(0.3294214489878754746998468591882500221478e23) }}, 
      {{ SC_(0.37e2), SC_(0.177219114266335964202880859375e-2), SC_(0.828026196559747866852471375648158776984e-156) }}, 
      {{ SC_(0.37e2), SC_(0.22177286446094512939453125e-2), SC_(0.3324790777601664254426532880563918902327e-152) }}, 
      {{ SC_(0.37e2), SC_(0.7444499991834163665771484375e-2), SC_(0.9573443870243893719540856527993316924774e-133) }}, 
      {{ SC_(0.37e2), SC_(0.1433600485324859619140625e-1), SC_(0.324335905771151418363167696952253012629e-122) }}, 
      {{ SC_(0.37e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6538719305050459748524952741536544241271e-119) }}, 
      {{ SC_(0.37e2), SC_(0.6152711808681488037109375e-1), SC_(0.8291389489281667073640088741137813836748e-99) }}, 
      {{ SC_(0.37e2), SC_(0.11958599090576171875e0), SC_(0.3956994877808749184390880157839542596607e-88) }}, 
      {{ SC_(0.37e2), SC_(0.15262925624847412109375e0), SC_(0.3294716124513790394110234837959967322394e-84) }}, 
      {{ SC_(0.37e2), SC_(0.408089816570281982421875e0), SC_(0.2096969632013223981693082123484952922989e-68) }}, 
      {{ SC_(0.37e2), SC_(0.6540834903717041015625e0), SC_(0.7994725483079514493600080319267216543682e-61) }}, 
      {{ SC_(0.37e2), SC_(0.1097540378570556640625e1), SC_(0.1667836458023600048037827216363539361428e-52) }}, 
      {{ SC_(0.37e2), SC_(0.30944411754608154296875e1), SC_(0.7980555217598790316673309477891295418541e-36) }}, 
      {{ SC_(0.37e2), SC_(0.51139926910400390625e1), SC_(0.1051567957305034458555054192290336871139e-27) }}, 
      {{ SC_(0.37e2), SC_(0.95070552825927734375e1), SC_(0.1469503949790717100538026315514505362737e-17) }}, 
      {{ SC_(0.37e2), SC_(0.24750102996826171875e2), SC_(0.9028078838424508873820387824156803526994e-1) }}, 
      {{ SC_(0.37e2), SC_(0.637722015380859375e2), SC_(0.6624710227786465723665406844092603419808e22) }}, 
      {{ SC_(0.4e2), SC_(0.177219114266335964202880859375e-2), SC_(0.9718015316899897222991156478421723178211e-170) }}, 
      {{ SC_(0.4e2), SC_(0.22177286446094512939453125e-2), SC_(0.7647004681430521445000193582848602001013e-166) }}, 
      {{ SC_(0.4e2), SC_(0.7444499991834163665771484375e-2), SC_(0.8328688187483865411440918435294595300438e-145) }}, 
      {{ SC_(0.4e2), SC_(0.1433600485324859619140625e-1), SC_(0.2015028639944073105137969713222741554632e-133) }}, 
      {{ SC_(0.4e2), SC_(0.1760916970670223236083984375e-1), SC_(0.7528545584869245581219369999622839047295e-130) }}, 
      {{ SC_(0.4e2), SC_(0.6152711808681488037109375e-1), SC_(0.4072190283066936123541628438950294644046e-108) }}, 
      {{ SC_(0.4e2), SC_(0.11958599090576171875e0), SC_(0.1426938434685287976193639876529707406679e-96) }}, 
      {{ SC_(0.4e2), SC_(0.15262925624847412109375e0), SC_(0.2470178361216737927254580766310265925757e-92) }}, 
      {{ SC_(0.4e2), SC_(0.408089816570281982421875e0), SC_(0.3004875040784737651802258750750770567386e-75) }}, 
      {{ SC_(0.4e2), SC_(0.6540834903717041015625e0), SC_(0.4716452903523047367590099016132882234692e-67) }}, 
      {{ SC_(0.4e2), SC_(0.1097540378570556640625e1), SC_(0.4646918287704963886177475667694632919708e-58) }}, 
      {{ SC_(0.4e2), SC_(0.30944411754608154296875e1), SC_(0.4963455979870243017181524846243289457927e-40) }}, 
      {{ SC_(0.4e2), SC_(0.51139926910400390625e1), SC_(0.2928767603579078980226642224030836807816e-31) }}, 
      {{ SC_(0.4e2), SC_(0.95070552825927734375e1), SC_(0.2551533159075245563126487234918392198585e-20) }}, 
      {{ SC_(0.4e2), SC_(0.24750102996826171875e2), SC_(0.2225839075061771588535698246714714443425e-2) }}, 
      {{ SC_(0.4e2), SC_(0.637722015380859375e2), SC_(0.1178670663121533017236202220352711569291e22) }}, 
      {{ SC_(0.43e2), SC_(0.177219114266335964202880859375e-2), SC_(0.9130985936863463046546928953779730917377e-184) }}, 
      {{ SC_(0.43e2), SC_(0.22177286446094512939453125e-2), SC_(0.1408072391774102692929369293535359288371e-179) }}, 
      {{ SC_(0.43e2), SC_(0.7444499991834163665771484375e-2), SC_(0.5800849589151800346459897273792621658819e-157) }}, 
      {{ SC_(0.43e2), SC_(0.1433600485324859619140625e-1), SC_(0.1002245268004915958866825941402152815883e-144) }}, 
      {{ SC_(0.43e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6939626160739405567413386511279574703658e-141) }}, 
      {{ SC_(0.43e2), SC_(0.6152711808681488037109375e-1), SC_(0.1601162868348926363724149071999208219269e-117) }}, 
      {{ SC_(0.43e2), SC_(0.11958599090576171875e0), SC_(0.411957091818736604416055444734691767854e-105) }}, 
      {{ SC_(0.43e2), SC_(0.15262925624847412109375e0), SC_(0.1482674713827075151052028716968653639318e-100) }}, 
      {{ SC_(0.43e2), SC_(0.408089816570281982421875e0), SC_(0.3447244054889731161807594240462186574805e-82) }}, 
      {{ SC_(0.43e2), SC_(0.6540834903717041015625e0), SC_(0.2227646296476468683363124051704462003365e-73) }}, 
      {{ SC_(0.43e2), SC_(0.1097540378570556640625e1), SC_(0.1036615084804202732881289594829753840317e-63) }}, 
      {{ SC_(0.43e2), SC_(0.30944411754608154296875e1), SC_(0.2472940668271158777166795791968979108208e-44) }}, 
      {{ SC_(0.43e2), SC_(0.51139926910400390625e1), SC_(0.6541484773312980997922339761025247990602e-35) }}, 
      {{ SC_(0.43e2), SC_(0.95070552825927734375e1), SC_(0.3567126305847535292621986818143391582414e-23) }}, 
      {{ SC_(0.43e2), SC_(0.24750102996826171875e2), SC_(0.4535966725472100733636605024987920402377e-4) }}, 
      {{ SC_(0.43e2), SC_(0.637722015380859375e2), SC_(0.1860151703327425260186251584987331618812e21) }}, 
      {{ SC_(0.46e2), SC_(0.177219114266335964202880859375e-2), SC_(0.6974873724372059592930761837399120333106e-198) }}, 
      {{ SC_(0.46e2), SC_(0.22177286446094512939453125e-2), SC_(0.2107837814355866769403485866165808969005e-193) }}, 
      {{ SC_(0.46e2), SC_(0.7444499991834163665771484375e-2), SC_(0.3284620419327957441948066479751725605749e-169) }}, 
      {{ SC_(0.46e2), SC_(0.1433600485324859619140625e-1), SC_(0.4052708722996356969318056893316822025292e-156) }}, 
      {{ SC_(0.46e2), SC_(0.1760916970670223236083984375e-1), SC_(0.5200434785576270732987275645545463116496e-152) }}, 
      {{ SC_(0.46e2), SC_(0.6152711808681488037109375e-1), SC_(0.5118251529472963283938044760365471618008e-127) }}, 
      {{ SC_(0.46e2), SC_(0.11958599090576171875e0), SC_(0.9668912760296019239868775094892305863e-114) }}, 
      {{ SC_(0.46e2), SC_(0.15262925624847412109375e0), SC_(0.7235067157390354503265134994764081996292e-109) }}, 
      {{ SC_(0.46e2), SC_(0.408089816570281982421875e0), SC_(0.3215141308513781839332579253698819620894e-89) }}, 
      {{ SC_(0.46e2), SC_(0.6540834903717041015625e0), SC_(0.8553924416611084411392664332953550662675e-80) }}, 
      {{ SC_(0.46e2), SC_(0.1097540378570556640625e1), SC_(0.1880080073747634557570248431362280832048e-69) }}, 
      {{ SC_(0.46e2), SC_(0.30944411754608154296875e1), SC_(0.1002170745653581381543207309249480407833e-48) }}, 
      {{ SC_(0.46e2), SC_(0.51139926910400390625e1), SC_(0.1189442056793568082999926596751649195134e-38) }}, 
      {{ SC_(0.46e2), SC_(0.95070552825927734375e1), SC_(0.407314083263769347886637462837801107032e-26) }}, 
      {{ SC_(0.46e2), SC_(0.24750102996826171875e2), SC_(0.7716907058748037857050749829725239421774e-6) }}, 
      {{ SC_(0.46e2), SC_(0.637722015380859375e2), SC_(0.2610747871384482066580499361911905438827e20) }}, 
      {{ SC_(0.49e2), SC_(0.177219114266335964202880859375e-2), SC_(0.4389781172911308808815577157269368864389e-212) }}, 
      {{ SC_(0.49e2), SC_(0.22177286446094512939453125e-2), SC_(0.2599783878067930431219495087775225652146e-207) }}, 
      {{ SC_(0.49e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1532380510263907001575821410116222341594e-181) }}, 
      {{ SC_(0.49e2), SC_(0.1433600485324859619140625e-1), SC_(0.1350220254120915730693084808074002561553e-167) }}, 
      {{ SC_(0.49e2), SC_(0.1760916970670223236083984375e-1), SC_(0.3210931836020126014385900607920124735381e-163) }}, 
      {{ SC_(0.49e2), SC_(0.6152711808681488037109375e-1), SC_(0.1348017896021742606349975060443415586932e-136) }}, 
      {{ SC_(0.49e2), SC_(0.11958599090576171875e0), SC_(0.18697839036512037857308426784665430863e-122) }}, 
      {{ SC_(0.49e2), SC_(0.15262925624847412109375e0), SC_(0.2908891611748361074664875341061049836806e-117) }}, 
      {{ SC_(0.49e2), SC_(0.408089816570281982421875e0), SC_(0.2470694756126763784322536696126913805842e-96) }}, 
      {{ SC_(0.49e2), SC_(0.6540834903717041015625e0), SC_(0.2706328514816814662599134806037929561628e-86) }}, 
      {{ SC_(0.49e2), SC_(0.1097540378570556640625e1), SC_(0.2809608278103321561471733562784717228981e-75) }}, 
      {{ SC_(0.49e2), SC_(0.30944411754608154296875e1), SC_(0.3347634282264346680708924196132233927821e-53) }}, 
      {{ SC_(0.49e2), SC_(0.51139926910400390625e1), SC_(0.1783972581821037133190101569680872836095e-42) }}, 
      {{ SC_(0.49e2), SC_(0.95070552825927734375e1), SC_(0.3846690190107807695787373874628655622738e-29) }}, 
      {{ SC_(0.49e2), SC_(0.24750102996826171875e2), SC_(0.1106023327591450517690020973888073917934e-7) }}, 
      {{ SC_(0.49e2), SC_(0.637722015380859375e2), SC_(0.3267196777655734800789149604345611112574e19) }}, 
      {{ SC_(0.52e2), SC_(0.177219114266335964202880859375e-2), SC_(0.2303249815383634412855968687640340608717e-226) }}, 
      {{ SC_(0.52e2), SC_(0.22177286446094512939453125e-2), SC_(0.2673184611673846548599437220617809024879e-221) }}, 
      {{ SC_(0.52e2), SC_(0.7444499991834163665771484375e-2), SC_(0.595991002240545806910967260032753150706e-194) }}, 
      {{ SC_(0.52e2), SC_(0.1433600485324859619140625e-1), SC_(0.3750209244842119299118224108095384884535e-179) }}, 
      {{ SC_(0.52e2), SC_(0.1760916970670223236083984375e-1), SC_(0.1652776669790150330561340539746081774673e-174) }}, 
      {{ SC_(0.52e2), SC_(0.6152711808681488037109375e-1), SC_(0.2959793427663782135045312208347209503631e-146) }}, 
      {{ SC_(0.52e2), SC_(0.11958599090576171875e0), SC_(0.3014373529833589353306526172424915916571e-131) }}, 
      {{ SC_(0.52e2), SC_(0.15262925624847412109375e0), SC_(0.9749998047082604735078310612636901479602e-126) }}, 
      {{ SC_(0.52e2), SC_(0.408089816570281982421875e0), SC_(0.1582823122214012619499236499242366330843e-103) }}, 
      {{ SC_(0.52e2), SC_(0.6540834903717041015625e0), SC_(0.7138286618658376348114479100682439242919e-93) }}, 
      {{ SC_(0.52e2), SC_(0.1097540378570556640625e1), SC_(0.350046506043463784991137871177415470362e-81) }}, 
      {{ SC_(0.52e2), SC_(0.30944411754608154296875e1), SC_(0.9325578367853379452460418857475890341489e-58) }}, 
      {{ SC_(0.52e2), SC_(0.51139926910400390625e1), SC_(0.2232708230274459700606757413151961565263e-46) }}, 
      {{ SC_(0.52e2), SC_(0.95070552825927734375e1), SC_(0.3038215047045795583103231039540070449898e-32) }}, 
      {{ SC_(0.52e2), SC_(0.24750102996826171875e2), SC_(0.1346636232458805792435862254498088945776e-9) }}, 
      {{ SC_(0.52e2), SC_(0.637722015380859375e2), SC_(0.3655177757144173521181223750805400851081e18) }}, 
      {{ SC_(0.55e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1018006201602452906655354903811548381167e-240) }}, 
      {{ SC_(0.55e2), SC_(0.22177286446094512939453125e-2), SC_(0.2315431108142814819247954796685586778109e-235) }}, 
      {{ SC_(0.55e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1952648142025852610182556700189629588985e-206) }}, 
      {{ SC_(0.55e2), SC_(0.1433600485324859619140625e-1), SC_(0.8774403250287790806080348894635684082545e-191) }}, 
      {{ SC_(0.55e2), SC_(0.1760916970670223236083984375e-1), SC_(0.716652253310640352860349232619717567446e-186) }}, 
      {{ SC_(0.55e2), SC_(0.6152711808681488037109375e-1), SC_(0.5474423611339555255078088754703018574174e-156) }}, 
      {{ SC_(0.55e2), SC_(0.11958599090576171875e0), SC_(0.4093682078016060762342589273538134574926e-140) }}, 
      {{ SC_(0.55e2), SC_(0.15262925624847412109375e0), SC_(0.2752916444579352513354305312923153109258e-134) }}, 
      {{ SC_(0.55e2), SC_(0.408089816570281982421875e0), SC_(0.8541990352219993146878387175620874300916e-111) }}, 
      {{ SC_(0.55e2), SC_(0.6540834903717041015625e0), SC_(0.158607707905854303487414564050288615317e-99) }}, 
      {{ SC_(0.55e2), SC_(0.1097540378570556640625e1), SC_(0.3673946132076884229805538775186106732424e-87) }}, 
      {{ SC_(0.55e2), SC_(0.30944411754608154296875e1), SC_(0.2189024089902699086841898845933915976698e-62) }}, 
      {{ SC_(0.55e2), SC_(0.51139926910400390625e1), SC_(0.2355749280211012739763356422162726826943e-50) }}, 
      {{ SC_(0.55e2), SC_(0.95070552825927734375e1), SC_(0.2026861324159946447258206491024438702174e-35) }}, 
      {{ SC_(0.55e2), SC_(0.24750102996826171875e2), SC_(0.1403522940552612452403976593875550756503e-11) }}, 
      {{ SC_(0.55e2), SC_(0.637722015380859375e2), SC_(0.3665083221494400948950976597954993776716e17) }}, 
      {{ SC_(0.58e2), SC_(0.177219114266335964202880859375e-2), SC_(0.3825614854251193014643148182442112314422e-255) }}, 
      {{ SC_(0.58e2), SC_(0.22177286446094512939453125e-2), SC_(0.1705203509939234696277159749563672565672e-249) }}, 
      {{ SC_(0.58e2), SC_(0.7444499991834163665771484375e-2), SC_(0.5439384071460261246604890034143549092382e-219) }}, 
      {{ SC_(0.58e2), SC_(0.1433600485324859619140625e-1), SC_(0.1745505108484575279377648347854510213424e-202) }}, 
      {{ SC_(0.58e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2642069354990837019592459762587245355314e-197) }}, 
      {{ SC_(0.58e2), SC_(0.6152711808681488037109375e-1), SC_(0.8609082778299358326554204561754269587854e-166) }}, 
      {{ SC_(0.58e2), SC_(0.11958599090576171875e0), SC_(0.472686020135453860719433000549657722504e-149) }}, 
      {{ SC_(0.58e2), SC_(0.15262925624847412109375e0), SC_(0.6608809509650562213406358665129864437131e-143) }}, 
      {{ SC_(0.58e2), SC_(0.408089816570281982421875e0), SC_(0.3919485557299515146422086935702232352484e-118) }}, 
      {{ SC_(0.58e2), SC_(0.6540834903717041015625e0), SC_(0.2996407069786035814282993151068654804437e-106) }}, 
      {{ SC_(0.58e2), SC_(0.1097540378570556640625e1), SC_(0.3278647331691108241950605165181408237355e-93) }}, 
      {{ SC_(0.58e2), SC_(0.30944411754608154296875e1), SC_(0.43699189078229521520626760453212752386e-67) }}, 
      {{ SC_(0.58e2), SC_(0.51139926910400390625e1), SC_(0.2114743569497515441487851296959306271934e-54) }}, 
      {{ SC_(0.58e2), SC_(0.95070552825927734375e1), SC_(0.115228244838142813047281874480449127547e-38) }}, 
      {{ SC_(0.58e2), SC_(0.24750102996826171875e2), SC_(0.1261019181054019830219112686580088955875e-13) }}, 
      {{ SC_(0.58e2), SC_(0.637722015380859375e2), SC_(0.3302220383111896270864858001851557409682e16) }}, 
      {{ SC_(0.61e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1232565040787181306716880234355575159688e-269) }}, 
      {{ SC_(0.61e2), SC_(0.22177286446094512939453125e-2), SC_(0.1076659436763981915175390828995986822434e-263) }}, 
      {{ SC_(0.61e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1299072045965767599011230964683207236757e-231) }}, 
      {{ SC_(0.61e2), SC_(0.1433600485324859619140625e-1), SC_(0.2977024713229769823554142462666492545543e-214) }}, 
      {{ SC_(0.61e2), SC_(0.1760916970670223236083984375e-1), SC_(0.8350985680074320512382864475853870571052e-209) }}, 
      {{ SC_(0.61e2), SC_(0.6152711808681488037109375e-1), SC_(0.1160735273973088870681548746063213229074e-175) }}, 
      {{ SC_(0.61e2), SC_(0.11958599090576171875e0), SC_(0.4679390835427500595982169037089408013153e-158) }}, 
      {{ SC_(0.61e2), SC_(0.15262925624847412109375e0), SC_(0.1360227151484704343606225139366640450974e-151) }}, 
      {{ SC_(0.61e2), SC_(0.408089816570281982421875e0), SC_(0.1541907881518304382028330079213762969566e-125) }}, 
      {{ SC_(0.61e2), SC_(0.6540834903717041015625e0), SC_(0.4853323022258957491856078733397637957488e-113) }}, 
      {{ SC_(0.61e2), SC_(0.1097540378570556640625e1), SC_(0.2508568084833358319857564156287903222335e-99) }}, 
      {{ SC_(0.61e2), SC_(0.30944411754608154296875e1), SC_(0.748075040682448072563688302916057106236e-72) }}, 
      {{ SC_(0.61e2), SC_(0.51139926910400390625e1), SC_(0.1628516947362121576297154167081137581681e-58) }}, 
      {{ SC_(0.61e2), SC_(0.95070552825927734375e1), SC_(0.5627271604271077200487733611431219863609e-42) }}, 
      {{ SC_(0.61e2), SC_(0.24750102996826171875e2), SC_(0.9830275153111534414683337549340620199722e-16) }}, 
      {{ SC_(0.61e2), SC_(0.637722015380859375e2), SC_(0.2680164800522684112302023590484676688526e15) }}, 
      {{ SC_(0.64e2), SC_(0.177219114266335964202880859375e-2), SC_(0.3430357084175735278555854255147470817249e-284) }}, 
      {{ SC_(0.64e2), SC_(0.22177286446094512939453125e-2), SC_(0.5872207167386025213208526154375803763796e-278) }}, 
      {{ SC_(0.64e2), SC_(0.7444499991834163665771484375e-2), SC_(0.268001752806320143243799671821308474476e-244) }}, 
      {{ SC_(0.64e2), SC_(0.1433600485324859619140625e-1), SC_(0.438595974527149040242523230840645299492e-226) }}, 
      {{ SC_(0.64e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2280090845086226890824090050294482285799e-220) }}, 
      {{ SC_(0.64e2), SC_(0.6152711808681488037109375e-1), SC_(0.13518558871192707219559554892043526652e-185) }}, 
      {{ SC_(0.64e2), SC_(0.11958599090576171875e0), SC_(0.4001537432733981854270522579460299551195e-167) }}, 
      {{ SC_(0.64e2), SC_(0.15262925624847412109375e0), SC_(0.2418358717309696982129974343687543076697e-160) }}, 
      {{ SC_(0.64e2), SC_(0.408089816570281982421875e0), SC_(0.5239743663416479097363838023466875937012e-133) }}, 
      {{ SC_(0.64e2), SC_(0.6540834903717041015625e0), SC_(0.6790503577584169527731717114683795828784e-120) }}, 
      {{ SC_(0.64e2), SC_(0.1097540378570556640625e1), SC_(0.1658012742661589928281409681622254785962e-105) }}, 
      {{ SC_(0.64e2), SC_(0.30944411754608154296875e1), SC_(0.11064107783749177287523543835604870967e-76) }}, 
      {{ SC_(0.64e2), SC_(0.51139926910400390625e1), SC_(0.1083831156071722097307453857622259500324e-62) }}, 
      {{ SC_(0.64e2), SC_(0.95070552825927734375e1), SC_(0.2377869577116586340246748039246972489746e-45) }}, 
      {{ SC_(0.64e2), SC_(0.24750102996826171875e2), SC_(0.6688735376176144378801375956705003179075e-18) }}, 
      {{ SC_(0.64e2), SC_(0.637722015380859375e2), SC_(0.196433282094407750436026386061406870489e14) }}, 
      {{ SC_(0.67e2), SC_(0.177219114266335964202880859375e-2), SC_(0.8303265659968393923976721769339237467243e-299) }}, 
      {{ SC_(0.67e2), SC_(0.22177286446094512939453125e-2), SC_(0.2785508604717382969707899955984153109995e-292) }}, 
      {{ SC_(0.67e2), SC_(0.7444499991834163665771484375e-2), SC_(0.480863872762121076920266217690470663122e-257) }}, 
      {{ SC_(0.67e2), SC_(0.1433600485324859619140625e-1), SC_(0.5619878965970541271629312269439113669091e-238) }}, 
      {{ SC_(0.67e2), SC_(0.1760916970670223236083984375e-1), SC_(0.5414354444420529082761372605957493468984e-232) }}, 
      {{ SC_(0.67e2), SC_(0.6152711808681488037109375e-1), SC_(0.1369328842205035435791819270137405216132e-195) }}, 
      {{ SC_(0.67e2), SC_(0.11958599090576171875e0), SC_(0.2976080454780070131652687845254578786778e-176) }}, 
      {{ SC_(0.67e2), SC_(0.15262925624847412109375e0), SC_(0.3739472000953063909501613448588687457119e-169) }}, 
      {{ SC_(0.67e2), SC_(0.408089816570281982421875e0), SC_(0.1548613210047140776105471826780937390242e-140) }}, 
      {{ SC_(0.67e2), SC_(0.6540834903717041015625e0), SC_(0.8263193751493687283195945930118436171448e-127) }}, 
      {{ SC_(0.67e2), SC_(0.1097540378570556640625e1), SC_(0.9531001594119617180115060699004781472022e-112) }}, 
      {{ SC_(0.67e2), SC_(0.30944411754608154296875e1), SC_(0.1423429375392353585102712760378566415253e-81) }}, 
      {{ SC_(0.67e2), SC_(0.51139926910400390625e1), SC_(0.6276199872704888189953779431744609272855e-67) }}, 
      {{ SC_(0.67e2), SC_(0.95070552825927734375e1), SC_(0.8751710351217371349774248758780557808399e-49) }}, 
      {{ SC_(0.67e2), SC_(0.24750102996826171875e2), SC_(0.399443014585480721312551749526965287716e-20) }}, 
      {{ SC_(0.67e2), SC_(0.637722015380859375e2), SC_(0.1303190285326414512188004605064925401042e13) }}, 
      {{ SC_(0.7e2), SC_(0.177219114266335964202880859375e-2), SC_(0.175887342640394106189151976112543057962e-313) }}, 
      {{ SC_(0.7e2), SC_(0.7444499991834163665771484375e-2), SC_(0.7550621788530834428425404682332589500832e-270) }}, 
      {{ SC_(0.7e2), SC_(0.1433600485324859619140625e-1), SC_(0.6301810450616594782432087551850756373668e-250) }}, 
      {{ SC_(0.7e2), SC_(0.1760916970670223236083984375e-1), SC_(0.1125167731015917733561916583817457784138e-243) }}, 
      {{ SC_(0.7e2), SC_(0.6152711808681488037109375e-1), SC_(0.1213839287680701613177842094136722210551e-205) }}, 
      {{ SC_(0.7e2), SC_(0.11958599090576171875e0), SC_(0.1937040012939367633269395257833394549994e-185) }}, 
      {{ SC_(0.7e2), SC_(0.15262925624847412109375e0), SC_(0.5060297469126818749198761907151271684388e-178) }}, 
      {{ SC_(0.7e2), SC_(0.408089816570281982421875e0), SC_(0.4005465233840990833504194622177985321517e-148) }}, 
      {{ SC_(0.7e2), SC_(0.6540834903717041015625e0), SC_(0.8799796018332889235436642767544430577921e-134) }}, 
      {{ SC_(0.7e2), SC_(0.1097540378570556640625e1), SC_(0.4794825121102189651189070515356607000206e-118) }}, 
      {{ SC_(0.7e2), SC_(0.30944411754608154296875e1), SC_(0.1602843216269687242254187608050533636733e-86) }}, 
      {{ SC_(0.7e2), SC_(0.51139926910400390625e1), SC_(0.3181779993739836562974728016162666336895e-71) }}, 
      {{ SC_(0.7e2), SC_(0.95070552825927734375e1), SC_(0.2822466596594199323749265377605991268801e-52) }}, 
      {{ SC_(0.7e2), SC_(0.24750102996826171875e2), SC_(0.2104365489296975788813919994670728216215e-22) }}, 
      {{ SC_(0.7e2), SC_(0.637722015380859375e2), SC_(0.7844318561221098998292957969567564923615e11) }}, 
      {{ SC_(0.73e2), SC_(0.177219114266335964202880859375e-2), SC_(0.3279159790515129976232600411030994939645e-328) }}, 
      {{ SC_(0.73e2), SC_(0.22177286446094512939453125e-2), SC_(0.4224790877225924823386404075215067890494e-321) }}, 
      {{ SC_(0.73e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1043483587404467322105724165693680432988e-282) }}, 
      {{ SC_(0.73e2), SC_(0.1433600485324859619140625e-1), SC_(0.6219365054628790184510838867649950741467e-262) }}, 
      {{ SC_(0.73e2), SC_(0.1760916970670223236083984375e-1), SC_(0.2057928083398578974258661409116904762983e-255) }}, 
      {{ SC_(0.73e2), SC_(0.6152711808681488037109375e-1), SC_(0.9470152726761824765032042182394011675392e-216) }}, 
      {{ SC_(0.73e2), SC_(0.11958599090576171875e0), SC_(0.1109621677740774224342517916855017900658e-194) }}, 
      {{ SC_(0.73e2), SC_(0.15262925624847412109375e0), SC_(0.6026765241850857913163429093708050618843e-187) }}, 
      {{ SC_(0.73e2), SC_(0.408089816570281982421875e0), SC_(0.9118139298541229295297403648253683737698e-156) }}, 
      {{ SC_(0.73e2), SC_(0.6540834903717041015625e0), SC_(0.8247872764458903831476787586065099347135e-141) }}, 
      {{ SC_(0.73e2), SC_(0.1097540378570556640625e1), SC_(0.2123029007982407474621311100276015417167e-124) }}, 
      {{ SC_(0.73e2), SC_(0.30944411754608154296875e1), SC_(0.1588696020280731697227952432556978774771e-91) }}, 
      {{ SC_(0.73e2), SC_(0.51139926910400390625e1), SC_(0.1420130918879929727408563849006120293294e-75) }}, 
      {{ SC_(0.73e2), SC_(0.95070552825927734375e1), SC_(0.8020381326448500037051674847470025971321e-56) }}, 
      {{ SC_(0.73e2), SC_(0.24750102996826171875e2), SC_(0.9826710538792853844402410449812254638335e-25) }}, 
      {{ SC_(0.73e2), SC_(0.637722015380859375e2), SC_(0.4293839369539487481259198718773671804064e10) }}, 
      {{ SC_(0.76e2), SC_(0.177219114266335964202880859375e-2), SC_(0.5408759889893148190520203529735474973187e-343) }}, 
      {{ SC_(0.76e2), SC_(0.22177286446094512939453125e-2), SC_(0.1365632588234360977374366339815548997377e-335) }}, 
      {{ SC_(0.76e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1275838367710964746430025849813881543957e-295) }}, 
      {{ SC_(0.76e2), SC_(0.1433600485324859619140625e-1), SC_(0.5430425912637421039353201453109713889038e-274) }}, 
      {{ SC_(0.76e2), SC_(0.1760916970670223236083984375e-1), SC_(0.3330046136342914006909942281157109406199e-267) }}, 
      {{ SC_(0.76e2), SC_(0.6152711808681488037109375e-1), SC_(0.6536720629329230577091818914690091163553e-226) }}, 
      {{ SC_(0.76e2), SC_(0.11958599090576171875e0), SC_(0.5623652442375975181466641168529807893221e-204) }}, 
      {{ SC_(0.76e2), SC_(0.15262925624847412109375e0), SC_(0.6350380451255890749856575267278817991626e-196) }}, 
      {{ SC_(0.76e2), SC_(0.408089816570281982421875e0), SC_(0.183640054565323298205707300952041465441e-163) }}, 
      {{ SC_(0.76e2), SC_(0.6540834903717041015625e0), SC_(0.6839439254682699613485852891479608181366e-148) }}, 
      {{ SC_(0.76e2), SC_(0.1097540378570556640625e1), SC_(0.8316719082770017371804750065668802553579e-131) }}, 
      {{ SC_(0.76e2), SC_(0.30944411754608154296875e1), SC_(0.1393297633857098951754512416010366098401e-96) }}, 
      {{ SC_(0.76e2), SC_(0.51139926910400390625e1), SC_(0.5609441790373577387000154824729897241791e-80) }}, 
      {{ SC_(0.76e2), SC_(0.95070552825927734375e1), SC_(0.2018365197172710168614503238313291896062e-59) }}, 
      {{ SC_(0.76e2), SC_(0.24750102996826171875e2), SC_(0.4085433998985207824201599332796010854695e-27) }}, 
      {{ SC_(0.76e2), SC_(0.637722015380859375e2), SC_(0.2142103160400899021062036922016113667452e9) }}, 
      {{ SC_(0.79e2), SC_(0.177219114266335964202880859375e-2), SC_(0.7930982305179989580158425245351456663586e-358) }}, 
      {{ SC_(0.79e2), SC_(0.22177286446094512939453125e-2), SC_(0.3924250147523408219992167518859050391414e-350) }}, 
      {{ SC_(0.79e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1386755351840733324704199171711908798229e-308) }}, 
      {{ SC_(0.79e2), SC_(0.1433600485324859619140625e-1), SC_(0.4215177758474358774763535279898355939459e-286) }}, 
      {{ SC_(0.79e2), SC_(0.1760916970670223236083984375e-1), SC_(0.4790319326701827605381983744427272324794e-279) }}, 
      {{ SC_(0.79e2), SC_(0.6152711808681488037109375e-1), SC_(0.4011040414527164043809376106988478947351e-236) }}, 
      {{ SC_(0.79e2), SC_(0.11958599090576171875e0), SC_(0.253370605560492432574321731615139964047e-213) }}, 
      {{ SC_(0.79e2), SC_(0.15262925624847412109375e0), SC_(0.5948527457011269418607542342494814436562e-205) }}, 
      {{ SC_(0.79e2), SC_(0.408089816570281982421875e0), SC_(0.3287936896920888923522197582153467750847e-171) }}, 
      {{ SC_(0.79e2), SC_(0.6540834903717041015625e0), SC_(0.5041909325640412505781517484471102307831e-155) }}, 
      {{ SC_(0.79e2), SC_(0.1097540378570556640625e1), SC_(0.2896326090972206182393839086729167150143e-137) }}, 
      {{ SC_(0.79e2), SC_(0.30944411754608154296875e1), SC_(0.1086380977296709087208790251658448356189e-101) }}, 
      {{ SC_(0.79e2), SC_(0.51139926910400390625e1), SC_(0.1970229546359244151730974118220967814952e-84) }}, 
      {{ SC_(0.79e2), SC_(0.95070552825927734375e1), SC_(0.4519411101705219203865562848704682354613e-63) }}, 
      {{ SC_(0.79e2), SC_(0.24750102996826171875e2), SC_(0.1518463586382666158992394326311743396678e-29) }}, 
      {{ SC_(0.79e2), SC_(0.637722015380859375e2), SC_(0.9760490072697396207873117894195488769342e7) }}, 
      {{ SC_(0.82e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1038436202803785426388133600179459730169e-372) }}, 
      {{ SC_(0.82e2), SC_(0.22177286446094512939453125e-2), SC_(0.1006938753460328462474122574448053771171e-364) }}, 
      {{ SC_(0.82e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1345945900323246361787623818357538331624e-321) }}, 
      {{ SC_(0.82e2), SC_(0.1433600485324859619140625e-1), SC_(0.292160471475819054556258294299816966923e-298) }}, 
      {{ SC_(0.82e2), SC_(0.1760916970670223236083984375e-1), SC_(0.6153217141248195324459719214887728749464e-291) }}, 
      {{ SC_(0.82e2), SC_(0.6152711808681488037109375e-1), SC_(0.2197747157001515487720136860444751064868e-246) }}, 
      {{ SC_(0.82e2), SC_(0.11958599090576171875e0), SC_(0.1019336562451156029299163377789061540366e-222) }}, 
      {{ SC_(0.82e2), SC_(0.15262925624847412109375e0), SC_(0.4975570065935101711688291197874212937039e-214) }}, 
      {{ SC_(0.82e2), SC_(0.408089816570281982421875e0), SC_(0.5256585491004637978784987888275707136183e-179) }}, 
      {{ SC_(0.82e2), SC_(0.6540834903717041015625e0), SC_(0.3318904542226912390049207214862611260169e-162) }}, 
      {{ SC_(0.82e2), SC_(0.1097540378570556640625e1), SC_(0.9006810914088316982393635835954853735918e-144) }}, 
      {{ SC_(0.82e2), SC_(0.30944411754608154296875e1), SC_(0.7564505234377340524197089618341840082876e-107) }}, 
      {{ SC_(0.82e2), SC_(0.51139926910400390625e1), SC_(0.6180693935663269590148206442946860331756e-89) }}, 
      {{ SC_(0.82e2), SC_(0.95070552825927734375e1), SC_(0.9043352144198374855605316967339611243444e-67) }}, 
      {{ SC_(0.82e2), SC_(0.24750102996826171875e2), SC_(0.5065035140645080960031365557479815802671e-32) }}, 
      {{ SC_(0.82e2), SC_(0.637722015380859375e2), SC_(0.4070462729680846577801828424629699736782e6) }}, 
      {{ SC_(0.85e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1219116513647314073579445140073826698962e-387) }}, 
      {{ SC_(0.85e2), SC_(0.22177286446094512939453125e-2), SC_(0.2316658303570511364023325655883461576972e-379) }}, 
      {{ SC_(0.85e2), SC_(0.7444499991834163665771484375e-2), SC_(0.1171299375215890527495299558278169129332e-334) }}, 
      {{ SC_(0.85e2), SC_(0.1433600485324859619140625e-1), SC_(0.1815681105495951303009870770747843010446e-310) }}, 
      {{ SC_(0.85e2), SC_(0.1760916970670223236083984375e-1), SC_(0.708683910208375847232135348016178171053e-303) }}, 
      {{ SC_(0.85e2), SC_(0.6152711808681488037109375e-1), SC_(0.1079719594775910837503589945246873551394e-256) }}, 
      {{ SC_(0.85e2), SC_(0.11958599090576171875e0), SC_(0.3676982627128526557346333692497334159336e-232) }}, 
      {{ SC_(0.85e2), SC_(0.15262925624847412109375e0), SC_(0.3731546483902763830031124428268564725393e-223) }}, 
      {{ SC_(0.85e2), SC_(0.408089816570281982421875e0), SC_(0.7535240432188811873875509550682990477762e-187) }}, 
      {{ SC_(0.85e2), SC_(0.6540834903717041015625e0), SC_(0.1958883058289393975902194279609190904406e-169) }}, 
      {{ SC_(0.85e2), SC_(0.1097540378570556640625e1), SC_(0.2511373518429964095251580585112467258299e-150) }}, 
      {{ SC_(0.85e2), SC_(0.30944411754608154296875e1), SC_(0.4723067963574572650298919057601100049465e-112) }}, 
      {{ SC_(0.85e2), SC_(0.51139926910400390625e1), SC_(0.1738839346363387627371195241710367004536e-93) }}, 
      {{ SC_(0.85e2), SC_(0.95070552825927734375e1), SC_(0.1623663257276872998800059443147901760439e-70) }}, 
      {{ SC_(0.85e2), SC_(0.24750102996826171875e2), SC_(0.1521743437932867300705177236196212703582e-34) }}, 
      {{ SC_(0.85e2), SC_(0.637722015380859375e2), SC_(0.1556799959129105832955966318088587426661e5) }}, 
      {{ SC_(0.88e2), SC_(0.177219114266335964202880859375e-2), SC_(0.1288209613593357571142720689583005763762e-402) }}, 
      {{ SC_(0.88e2), SC_(0.22177286446094512939453125e-2), SC_(0.4797299543775689080036441106208914106219e-394) }}, 
      {{ SC_(0.88e2), SC_(0.7444499991834163665771484375e-2), SC_(0.9174536812416633326341915508185869175459e-348) }}, 
      {{ SC_(0.88e2), SC_(0.1433600485324859619140625e-1), SC_(0.1015625556161420986205394396723116662882e-322) }}, 
      {{ SC_(0.88e2), SC_(0.1760916970670223236083984375e-1), SC_(0.7346472096657986490100705296779319049912e-315) }}, 
      {{ SC_(0.88e2), SC_(0.6152711808681488037109375e-1), SC_(0.4774415143129565154141226398131338281536e-267) }}, 
      {{ SC_(0.88e2), SC_(0.11958599090576171875e0), SC_(0.119382735471855848143552750474098416176e-241) }}, 
      {{ SC_(0.88e2), SC_(0.15262925624847412109375e0), SC_(0.2518899646481384301970914279883481939291e-232) }}, 
      {{ SC_(0.88e2), SC_(0.408089816570281982421875e0), SC_(0.9722253412784373652536121925492657625805e-195) }}, 
      {{ SC_(0.88e2), SC_(0.6540834903717041015625e0), SC_(0.1040637574745703228070355356117916659304e-176) }}, 
      {{ SC_(0.88e2), SC_(0.1097540378570556640625e1), SC_(0.6302766367711271660992485559308335862541e-157) }}, 
      {{ SC_(0.88e2), SC_(0.30944411754608154296875e1), SC_(0.2654441873858763831864401113742713122992e-117) }}, 
      {{ SC_(0.88e2), SC_(0.51139926910400390625e1), SC_(0.4403904099603861384280491749834790369519e-98) }}, 
      {{ SC_(0.88e2), SC_(0.95070552825927734375e1), SC_(0.262551184129831686961964273106436690334e-74) }}, 
      {{ SC_(0.88e2), SC_(0.24750102996826171875e2), SC_(0.4131930234604820436302932418803598894853e-37) }}, 
      {{ SC_(0.88e2), SC_(0.637722015380859375e2), SC_(0.5471250742874498784335752261273680101442e3) }}
   }};


