find_package(PkgConfig)
pkg_search_module(PC_QAT libqat qatlib QUIET)

find_path(QAT_INCLUDE_DIR
  NAMES qat/cpa.h
  HINTS ${PC_QAT_INCLUDE_DIRS})

find_library(QAT_LIBRARY
  NAMES qat
  HINTS ${PC_QAT_LIBRARY_DIRS})

find_library(QAT_USDM_LIBRARY
  NAMES usdm
  HINTS ${PC_QAT_LIBRARY_DIRS})

set(QAT_VERSION ${PC_QAT_VERSION})
set(QAT_LIBRARIES ${QAT_LIBRARY} ${QAT_USDM_LIBRARY})

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(QAT
  REQUIRED_VARS QAT_LIBRARY QAT_USDM_LIBRARY QAT_INCLUDE_DIR
  VERSION_VAR QAT_VERSION)

mark_as_advanced(QAT_LIBRARY QAT_USDM_LIBRARY QAT_LIBRARIES QAT_INCLUDE_DIR QAT_VERSION)

if(QAT_FOUND AND NOT (TARGET QAT::qat))
  add_library(QAT::qat UNKNOWN IMPORTED)
  set_target_properties(QAT::qat PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${QAT_INCLUDE_DIR}"
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${QAT_LIBRARY}")
endif()

if(QAT_FOUND AND NOT (TARGET QAT::usdm))
  add_library(QAT::usdm UNKNOWN IMPORTED)
  set_target_properties(QAT::usdm PROPERTIES
    INTERFACE_INCLUDE_DIRECTORIES "${QAT_INCLUDE_DIR}"
    IMPORTED_LINK_INTERFACE_LANGUAGES "C"
    IMPORTED_LOCATION "${QAT_USDM_LIBRARY}")
endif()
