/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.jdbc.NotificationRegistration;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFAQRegistration;
import oracle.jdbc.driver.NTFDCNRegistration;
import oracle.jdbc.driver.NTFEventListener;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.Namespace;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C7Ocommoncall;
import oracle.jdbc.driver.T4C7Oversion;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4C8Oclose;
import oracle.jdbc.driver.T4C8Odscrarr;
import oracle.jdbc.driver.T4C8TTIBfile;
import oracle.jdbc.driver.T4C8TTIBlob;
import oracle.jdbc.driver.T4C8TTIClob;
import oracle.jdbc.driver.T4C8TTIdty;
import oracle.jdbc.driver.T4C8TTIpro;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CStatement;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.driver.T4CTTIoauthenticate;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.driver.T4CTTIokeyval;
import oracle.jdbc.driver.T4CTTIokpn;
import oracle.jdbc.driver.T4CTTIoping;
import oracle.jdbc.driver.T4CTTIoscid;
import oracle.jdbc.driver.T4CTTIoses;
import oracle.jdbc.driver.T4CTTIoxsscs;
import oracle.jdbc.driver.T4CTTIoxsspo;
import oracle.jdbc.driver.T4CTTIoxssro;
import oracle.jdbc.driver.T4CTTIrxd;
import oracle.jdbc.driver.T4CTTIspfp;
import oracle.jdbc.driver.T4CTTIsto;
import oracle.jdbc.driver.T4CTTIxsnsop;
import oracle.jdbc.driver.T4CXAResource;
import oracle.jdbc.driver.T4Caqdq;
import oracle.jdbc.driver.T4Caqe;
import oracle.jdbc.internal.KeywordValue;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSEventListener;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.ns.Communication;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.TIMESTAMPTZ;

class T4CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final short MIN_TTCVER_SUPPORTED = 4;
    static final short V8_TTCVER_SUPPORTED = 5;
    static final short MAX_TTCVER_SUPPORTED = 6;
    static final int DEFAULT_LONG_PREFETCH_SIZE = 4080;
    static final String DEFAULT_CONNECT_STRING = "localhost:1521:orcl";
    static final int STREAM_CHUNK_SIZE = 255;
    static final int REFCURSOR_SIZE = 5;
    long LOGON_MODE = 0L;
    static final long SYSDBA = 8L;
    static final long SYSOPER = 16L;
    static final long SYSASM = 128L;
    boolean isLoggedOn;
    private boolean useZeroCopyIO;
    boolean useLobPrefetch;
    private String password;
    Communication net;
    private NTFEventListener[] xsListeners = new NTFEventListener[0];
    boolean readAsNonStream;
    T4CTTIoer oer;
    T4CMAREngine mare;
    T4C8TTIpro pro;
    T4CTTIrxd rxd;
    T4CTTIsto sto;
    T4CTTIspfp spfp;
    T4CTTIoauthenticate auth;
    T4C8Odscrarr describe;
    T4C8Oall all8;
    T4C8Oclose close8;
    T4C7Ocommoncall commoncall;
    T4Caqe aqe;
    T4Caqdq aqdq;
    T4C8TTIBfile bfileMsg;
    T4C8TTIBlob blobMsg;
    T4C8TTIClob clobMsg;
    T4CTTIoses oses;
    T4CTTIoping oping;
    T4CTTIokpn okpn;
    byte[] EMPTY_BYTE = new byte[0];
    T4CTTIOtxen otxen;
    T4CTTIOtxse otxse;
    T4CTTIk2rpc k2rpc;
    T4CTTIoscid oscid;
    T4CTTIokeyval okeyval;
    T4CTTIoxsscs oxsscs;
    T4CTTIoxssro oxssro;
    T4CTTIoxsspo oxsspo;
    T4CTTIxsnsop xsnsop;
    int[] cursorToClose = new int[4];
    int cursorToCloseOffset = 0;
    int[] queryToClose = new int[10];
    int queryToCloseOffset = 0;
    int[] lusFunctionId2 = new int[10];
    byte[][] lusSessionId2 = new byte[10][];
    KeywordValueLong[][] lusInKeyVal2 = new KeywordValueLong[10][];
    int[] lusInFlags2 = new int[10];
    int lusOffset2 = 0;
    int sessionId;
    int serialNumber;
    byte negotiatedTTCversion;
    byte[] serverRuntimeCapabilities;
    Hashtable namespaces;
    byte[] internalName;
    byte[] externalName;
    static final int FREE = -1;
    static final int SEND = 1;
    static final int RECEIVE = 2;
    int pipeState = -1;
    boolean sentCancel = false;
    static final int MAX_SIZE_VSESSION_OSUSER = 30;
    static final int MAX_SIZE_VSESSION_PROCESS = 24;
    static final int MAX_SIZE_VSESSION_MACHINE = 64;
    static final int MAX_SIZE_VSESSION_TERMINAL = 30;
    static final int MAX_SIZE_VSESSION_PROGRAM = 48;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:18:34_PDT_2010";
    public static final boolean TRACE = false;

    T4CConnection(String string, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, properties, oracleDriverExtension);
        this.minVcsBindSize = 0;
        this.streamChunkSize = 255;
        this.namespaces = new Hashtable(5);
    }

    @Override
    final void initializePassword(String string) throws SQLException {
        this.password = string;
    }

    @Override
    void logon() throws SQLException {
        try {
            if (this.isLoggedOn) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 428);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.database == null) {
                this.database = DEFAULT_CONNECT_STRING;
            }
            this.connect(this.database);
            this.all8 = new T4C8Oall(this);
            this.okpn = new T4CTTIokpn(this);
            this.close8 = new T4C8Oclose(this);
            this.sto = new T4CTTIsto(this);
            this.spfp = new T4CTTIspfp(this);
            this.commoncall = new T4C7Ocommoncall(this);
            this.describe = new T4C8Odscrarr(this);
            this.bfileMsg = new T4C8TTIBfile(this);
            this.blobMsg = new T4C8TTIBlob(this);
            this.clobMsg = new T4C8TTIClob(this);
            this.otxen = new T4CTTIOtxen(this);
            this.otxse = new T4CTTIOtxse(this);
            this.oping = new T4CTTIoping(this);
            this.k2rpc = new T4CTTIk2rpc(this);
            this.oses = new T4CTTIoses(this);
            this.okeyval = new T4CTTIokeyval(this);
            this.oxssro = new T4CTTIoxssro(this);
            this.oxsspo = new T4CTTIoxsspo(this);
            this.oxsscs = new T4CTTIoxsscs(this);
            this.xsnsop = new T4CTTIxsnsop(this);
            this.aqe = new T4Caqe(this);
            this.aqdq = new T4Caqdq(this);
            this.oscid = new T4CTTIoscid(this);
            this.LOGON_MODE = 0L;
            if (this.internalLogon != null) {
                if (this.internalLogon.equalsIgnoreCase("sysoper")) {
                    this.LOGON_MODE = 64L;
                } else if (this.internalLogon.equalsIgnoreCase("sysdba")) {
                    this.LOGON_MODE = 32L;
                } else if (this.internalLogon.equalsIgnoreCase("sysasm")) {
                    this.LOGON_MODE = 0x400000L;
                }
            }
            if (this.prelimAuth) {
                this.LOGON_MODE |= 0x80L;
            }
            this.auth = new T4CTTIoauthenticate(this, this.resourceManagerId);
            if (this.userName != null && this.userName.length() != 0) {
                this.auth.doOSESSKEY(this.userName, this.LOGON_MODE);
            }
            this.auth.doOAUTH(this.userName, this.password, this.LOGON_MODE);
            this.sessionId = this.getSessionId();
            this.serialNumber = this.getSerialNumber();
            this.internalName = this.auth.internalName;
            this.externalName = this.auth.externalName;
            this.instanceName = this.sessionProperties.getProperty("AUTH_INSTANCENAME");
            if (!this.prelimAuth) {
                T4C7Oversion t4C7Oversion = new T4C7Oversion(this);
                t4C7Oversion.doOVERSION();
                byte[] byArray = t4C7Oversion.getVersion();
                try {
                    this.databaseProductVersion = new String(byArray, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), unsupportedEncodingException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.versionNumber = t4C7Oversion.getVersionNumber();
            } else {
                this.versionNumber = 0;
            }
            this.isLoggedOn = true;
        }
        catch (NetException netException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (SQLException sQLException) {
            try {
                this.net.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isLoggedOn = false;
            throw sQLException;
        }
    }

    void handleIOException(IOException iOException) throws SQLException {
        try {
            this.pipeState = -1;
            this.net.disconnect();
            this.net = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isLoggedOn = false;
        this.lifecycle = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void logoff() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.logoff");
            if (this.lifecycle == 8) {
                return;
            }
            this.sendPiggyBackedMessages();
            this.commoncall.doOLOGOFF();
            this.net.disconnect();
            this.net = null;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            if (this.lifecycle != 8) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        finally {
            try {
                if (this.net != null) {
                    this.net.disconnect();
                }
            }
            catch (Exception exception) {}
            this.isLoggedOn = false;
        }
    }

    T4CMAREngine getMarshalEngine() {
        return this.mare;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    synchronized void doCommit(int n2) throws SQLException {
        this.assertLoggedOn("T4CConnection.do_commit");
        try {
            this.sendPiggyBackedMessages();
            if (n2 == 0) {
                this.commoncall.doOCOMMIT();
                return;
            }
            int n3 = 0;
            if ((n2 & OracleConnection.CommitOption.WRITEBATCH.getCode()) != 0) {
                n3 = n3 | 2 | 1;
            } else if ((n2 & OracleConnection.CommitOption.WRITEIMMED.getCode()) != 0) {
                n3 |= 2;
            }
            if ((n2 & OracleConnection.CommitOption.NOWAIT.getCode()) != 0) {
                n3 = n3 | 8 | 4;
            } else if ((n2 & OracleConnection.CommitOption.WAIT.getCode()) != 0) {
                n3 |= 8;
            }
            this.otxen.doOTXEN(1, null, null, 0, 0, 0, 0, 4, n3);
            int n4 = this.otxen.getOutStateFromServer();
            if (n4 != 2 && n4 == 4) return;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    synchronized void doRollback() throws SQLException {
        try {
            this.assertLoggedOn("T4CConnection.do_rollback");
            this.sendPiggyBackedMessages();
            this.commoncall.doOROLLBACK();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    synchronized void doSetAutoCommit(boolean bl) throws SQLException {
    }

    @Override
    public synchronized void open(OracleStatement oracleStatement) throws SQLException {
        this.assertLoggedOn("T4CConnection.open");
        oracleStatement.setCursorId(0);
    }

    @Override
    synchronized String doGetDatabaseProductVersion() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getDatabaseProductVersion");
        T4C7Oversion t4C7Oversion = new T4C7Oversion(this);
        try {
            t4C7Oversion.doOVERSION();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string = null;
        byte[] byArray = t4C7Oversion.getVersion();
        try {
            string = new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), unsupportedEncodingException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return string;
    }

    @Override
    synchronized short doGetVersionNumber() throws SQLException {
        this.assertLoggedOn("T4CConnection.do_getVersionNumber");
        T4C7Oversion t4C7Oversion = new T4C7Oversion(this);
        try {
            t4C7Oversion.doOVERSION();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return t4C7Oversion.getVersionNumber();
    }

    @Override
    OracleStatement RefCursorBytesToStatement(byte[] byArray, OracleStatement oracleStatement) throws SQLException {
        T4CStatement t4CStatement = new T4CStatement(this, -1, -1);
        try {
            int n2 = this.mare.unmarshalRefCursor(byArray);
            t4CStatement.setCursorId(n2);
            t4CStatement.isOpen = true;
            t4CStatement.sqlObject = oracleStatement.sqlObject;
            t4CStatement.serverCursor = true;
            oracleStatement.addChild(t4CStatement);
            t4CStatement.prepareForNewResults(true, false);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        t4CStatement.sqlStringChanged = false;
        t4CStatement.needToParse = false;
        return t4CStatement;
    }

    @Override
    void cancelOperationOnServer() throws SQLException {
        try {
            switch (this.pipeState) {
                case -1: {
                    return;
                }
                case 1: {
                    this.net.sendBreak();
                    break;
                }
                case 2: {
                    this.net.sendInterrupt();
                }
            }
            this.sentCancel = true;
        }
        catch (NetException netException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void connect(String string) throws IOException, SQLException {
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Properties properties = new Properties();
        if (this.thinNetProfile != null) {
            properties.setProperty("oracle.net.profile", this.thinNetProfile);
        }
        if (this.thinNetAuthenticationServices != null) {
            properties.setProperty("oracle.net.authentication_services", this.thinNetAuthenticationServices);
        }
        if (this.thinNetAuthenticationKrb5Mutual != null) {
            properties.setProperty("oracle.net.kerberos5_mutual_authentication", this.thinNetAuthenticationKrb5Mutual);
        }
        if (this.thinNetAuthenticationKrb5CcName != null) {
            properties.setProperty("oracle.net.kerberos5_cc_name", this.thinNetAuthenticationKrb5CcName);
        }
        if (this.thinNetEncryptionLevel != null) {
            properties.setProperty("oracle.net.encryption_client", this.thinNetEncryptionLevel);
        }
        if (this.thinNetEncryptionTypes != null) {
            properties.setProperty("oracle.net.encryption_types_client", this.thinNetEncryptionTypes);
        }
        if (this.thinNetChecksumLevel != null) {
            properties.setProperty("oracle.net.crypto_checksum_client", this.thinNetChecksumLevel);
        }
        if (this.thinNetChecksumTypes != null) {
            properties.setProperty("oracle.net.crypto_checksum_types_client", this.thinNetChecksumTypes);
        }
        if (this.thinNetCryptoSeed != null) {
            properties.setProperty("oracle.net.crypto_seed", this.thinNetCryptoSeed);
        }
        if (this.thinTcpNoDelay) {
            properties.setProperty("TCP.NODELAY", "YES");
        }
        if (this.thinReadTimeout != null) {
            properties.setProperty("oracle.net.READ_TIMEOUT", this.thinReadTimeout);
        }
        if (this.thinNetConnectTimeout != null) {
            properties.setProperty("oracle.net.CONNECT_TIMEOUT", this.thinNetConnectTimeout);
        }
        if (this.thinSslServerDnMatch != null) {
            properties.setProperty("oracle.net.ssl_server_dn_match", this.thinSslServerDnMatch);
        }
        if (this.walletLocation != null) {
            properties.setProperty("oracle.net.wallet_location", this.walletLocation);
        }
        if (this.walletPassword != null) {
            properties.setProperty("oracle.net.wallet_password", this.walletPassword);
        }
        if (this.thinSslVersion != null) {
            properties.setProperty("oracle.net.ssl_version", this.thinSslVersion);
        }
        if (this.thinSslCipherSuites != null) {
            properties.setProperty("oracle.net.ssl_cipher_suites", this.thinSslCipherSuites);
        }
        if (this.thinJavaxNetSslKeystore != null) {
            properties.setProperty("javax.net.ssl.keyStore", this.thinJavaxNetSslKeystore);
        }
        if (this.thinJavaxNetSslKeystoretype != null) {
            properties.setProperty("javax.net.ssl.keyStoreType", this.thinJavaxNetSslKeystoretype);
        }
        if (this.thinJavaxNetSslKeystorepassword != null) {
            properties.setProperty("javax.net.ssl.keyStorePassword", this.thinJavaxNetSslKeystorepassword);
        }
        if (this.thinJavaxNetSslTruststore != null) {
            properties.setProperty("javax.net.ssl.trustStore", this.thinJavaxNetSslTruststore);
        }
        if (this.thinJavaxNetSslTruststoretype != null) {
            properties.setProperty("javax.net.ssl.trustStoreType", this.thinJavaxNetSslTruststoretype);
        }
        if (this.thinJavaxNetSslTruststorepassword != null) {
            properties.setProperty("javax.net.ssl.trustStorePassword", this.thinJavaxNetSslTruststorepassword);
        }
        if (this.thinSslKeymanagerfactoryAlgorithm != null) {
            properties.setProperty("ssl.keyManagerFactory.algorithm", this.thinSslKeymanagerfactoryAlgorithm);
        }
        if (this.thinSslTrustmanagerfactoryAlgorithm != null) {
            properties.setProperty("ssl.trustManagerFactory.algorithm", this.thinSslTrustmanagerfactoryAlgorithm);
        }
        if (this.thinNetOldsyntax != null) {
            properties.setProperty("oracle.net.oldSyntax", this.thinNetOldsyntax);
        }
        if (this.thinNamingContextInitial != null) {
            properties.setProperty("java.naming.factory.initial", this.thinNamingContextInitial);
        }
        if (this.thinNamingProviderUrl != null) {
            properties.setProperty("java.naming.provider.url", this.thinNamingProviderUrl);
        }
        if (this.thinNamingSecurityAuthentication != null) {
            properties.setProperty("java.naming.security.authentication", this.thinNamingSecurityAuthentication);
        }
        if (this.thinNamingSecurityPrincipal != null) {
            properties.setProperty("java.naming.security.principal", this.thinNamingSecurityPrincipal);
        }
        if (this.thinNamingSecurityCredentials != null) {
            properties.setProperty("java.naming.security.credentials", this.thinNamingSecurityCredentials);
        }
        if (this.thinNetDisableOutOfBandBreak) {
            properties.setProperty("DISABLE_OOB", "" + this.thinNetDisableOutOfBandBreak);
        }
        if (this.thinNetEnableSDP) {
            properties.setProperty("oracle.net.SDP", "" + this.thinNetEnableSDP);
        }
        properties.setProperty("USE_ZERO_COPY_IO", "" + this.thinNetUseZeroCopyIO);
        properties.setProperty("FORCE_DNS_LOAD_BALANCING", "" + this.thinForceDnsLoadBalancing);
        properties.setProperty("oracle.jdbc.v$session.osuser", this.thinVsessionOsuser);
        properties.setProperty("oracle.jdbc.v$session.program", this.thinVsessionProgram);
        properties.setProperty("T4CConnection.hashCode", Integer.toHexString(this.hashCode()).toUpperCase());
        this.net = new NSProtocol();
        this.net.connect(string, properties);
        this.mare = new T4CMAREngine(this.net);
        this.oer = new T4CTTIoer(this);
        this.mare.setConnectionDuringExceptionHandling(this);
        this.pro = new T4C8TTIpro(this);
        this.pro.marshal();
        byte[] byArray = this.pro.receive();
        this.serverRuntimeCapabilities = this.pro.getServerRuntimeCapabilities();
        short s2 = this.pro.getOracleVersion();
        short s3 = this.pro.getCharacterSet();
        short s4 = DBConversion.findDriverCharSet(s3, s2);
        this.conversion = new DBConversion(s3, s4, this.pro.getncharCHARSET(), this.isStrictAsciiConversion);
        this.mare.types.setServerConversion(s4 != s3);
        if (DBConversion.isCharSetMultibyte(s4)) {
            if (DBConversion.isCharSetMultibyte(this.pro.getCharacterSet())) {
                this.mare.types.setFlags((byte)1);
            } else {
                this.mare.types.setFlags((byte)2);
            }
        } else {
            this.mare.types.setFlags(this.pro.getFlags());
        }
        this.mare.conv = this.conversion;
        T4C8TTIdty t4C8TTIdty = new T4C8TTIdty(this, byArray, this.serverRuntimeCapabilities, this.logonCap != null && this.logonCap.trim().equals("o3"), this.thinNetUseZeroCopyIO);
        t4C8TTIdty.doRPC();
        this.negotiatedTTCversion = byArray[7];
        if (t4C8TTIdty.jdbcThinCompileTimeCapabilities[7] < byArray[7]) {
            this.negotiatedTTCversion = t4C8TTIdty.jdbcThinCompileTimeCapabilities[7];
        }
        this.useZeroCopyIO = this.serverRuntimeCapabilities != null && this.serverRuntimeCapabilities.length > 6 && (this.serverRuntimeCapabilities[6] & T4C8TTIdty.KPCCAP_RTB_TTC_ZCPY) != 0 && this.thinNetUseZeroCopyIO && (this.net.getSessionAttributes().getNegotiatedOptions() & 0x40) != 0 && this.getDataIntegrityAlgorithmName().equals("") && this.getEncryptionAlgorithmName().equals("");
        this.useLobPrefetch = byArray.length > 23 && (byArray[23] & 0x40) != 0 && (t4C8TTIdty.jdbcThinCompileTimeCapabilities[23] & 0x40) != 0;
    }

    boolean isZeroCopyIOEnabled() {
        return this.useZeroCopyIO;
    }

    final T4CTTIoer getT4CTTIoer() {
        return this.oer;
    }

    final byte getTTCVersion() {
        return this.negotiatedTTCversion;
    }

    @Override
    void doStartup(int n2) throws SQLException {
        try {
            int n3 = 0;
            if (n2 == OracleConnection.DatabaseStartupMode.FORCE.getMode()) {
                n3 = 16;
            } else if (n2 == OracleConnection.DatabaseStartupMode.RESTRICT.getMode()) {
                n3 = 1;
            }
            this.spfp.doOSPFPPUT();
            this.sto.doOV6STRT(n3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    void doShutdown(int n2) throws SQLException {
        try {
            int n3 = 4;
            if (n2 == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL.getMode()) {
                n3 = 128;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.TRANSACTIONAL_LOCAL.getMode()) {
                n3 = 256;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.IMMEDIATE.getMode()) {
                n3 = 2;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.FINAL.getMode()) {
                n3 = 8;
            } else if (n2 == OracleConnection.DatabaseShutdownMode.ABORT.getMode()) {
                n3 = 64;
            }
            this.sendPiggyBackedMessages();
            this.sto.doOV6STOP(n3);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void sendPiggyBackedMessages() throws SQLException, IOException {
        int n2;
        this.sendPiggyBackedClose();
        if (this.endToEndAnyChanged && this.getTTCVersion() >= 3) {
            this.oscid.doOSCID(this.endToEndHasChanged, this.endToEndValues, this.endToEndECIDSequenceNumber);
            for (n2 = 0; n2 < 4; ++n2) {
                if (!this.endToEndHasChanged[n2]) continue;
                this.endToEndHasChanged[n2] = false;
            }
        }
        this.endToEndAnyChanged = false;
        if (!this.namespaces.isEmpty()) {
            if (this.getTTCVersion() >= 4) {
                Object[] objectArray = this.namespaces.values().toArray();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    this.okeyval.doOKEYVAL((Namespace)objectArray[i2]);
                }
            }
            this.namespaces.clear();
        }
        if (this.lusOffset2 > 0) {
            for (n2 = 0; n2 < this.lusOffset2; ++n2) {
                this.oxsspo.doOXSSPO(this.lusFunctionId2[n2], this.lusSessionId2[n2], this.lusInKeyVal2[n2], this.lusInFlags2[n2]);
            }
            this.lusOffset2 = 0;
        }
    }

    private void sendPiggyBackedClose() throws SQLException, IOException {
        if (this.queryToCloseOffset > 0) {
            this.close8.doOCANA(this.queryToClose, this.queryToCloseOffset);
            this.queryToCloseOffset = 0;
        }
        if (this.cursorToCloseOffset > 0) {
            this.close8.doOCCA(this.cursorToClose, this.cursorToCloseOffset);
            this.cursorToCloseOffset = 0;
        }
    }

    @Override
    void doProxySession(int n2, Properties properties) throws SQLException {
        try {
            this.sendPiggyBackedMessages();
            this.auth.doOAUTH(n2, properties, this.sessionId, this.serialNumber);
            int n3 = this.getSessionId();
            int n4 = this.getSerialNumber();
            this.oses.doO80SES(n3, n4, 1);
            this.savedUser = this.userName;
            this.userName = n2 == 1 ? properties.getProperty("PROXY_USER_NAME") : null;
            this.isProxy = true;
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    void closeProxySession() throws SQLException {
        try {
            this.sendPiggyBackedMessages();
            this.commoncall.doOLOGOFF();
            this.oses.doO80SES(this.sessionId, this.serialNumber, 1);
            this.userName = this.savedUser;
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void updateSessionProperties(KeywordValue[] keywordValueArray) throws SQLException {
        for (int i2 = 0; i2 < keywordValueArray.length; ++i2) {
            int n2 = keywordValueArray[i2].getKeyword();
            byte[] byArray = keywordValueArray[i2].getBinaryValue();
            if (n2 < T4C8Oall.NLS_KEYS.length) {
                String string = T4C8Oall.NLS_KEYS[n2];
                if (string == null) continue;
                if (byArray != null) {
                    this.sessionProperties.setProperty(string, this.mare.conv.CharBytesToString(byArray, byArray.length));
                    continue;
                }
                if (keywordValueArray[i2].getTextValue() == null) continue;
                this.sessionProperties.setProperty(string, keywordValueArray[i2].getTextValue().trim());
                continue;
            }
            if (n2 == 163) {
                if (byArray == null) continue;
                int n3 = byArray[4];
                int n4 = byArray[5];
                if ((byArray[4] & 0xFF) > 120) {
                    n3 = (byArray[4] & 0xFF) - 181;
                    n4 = (byArray[5] & 0xFF) - 60;
                } else {
                    n3 = (byArray[4] & 0xFF) - 60;
                    n4 = (byArray[5] & 0xFF) - 60;
                }
                String string = (n3 > 0 ? "+" : "") + n3 + (n4 <= 9 ? ":0" : ":") + n4;
                this.sessionProperties.setProperty("SESSION_TIME_ZONE", string);
                continue;
            }
            if (n2 != 165 && n2 != 166 && n2 != 167 && n2 != 168 && n2 != 169 && n2 != 170 && n2 != 171) continue;
        }
    }

    @Override
    public Properties getServerSessionInfo() throws SQLException {
        if (this.getVersionNumber() >= 10000 && this.getVersionNumber() < 10200) {
            this.queryFCFProperties(this.sessionProperties);
        }
        return this.sessionProperties;
    }

    @Override
    public String getSessionTimeZoneOffset() throws SQLException {
        String string = this.getServerSessionInfo().getProperty("SESSION_TIME_ZONE");
        string = string == null ? super.getSessionTimeZoneOffset() : this.tzToOffset(string);
        return string;
    }

    int getSessionId() {
        int n2 = -1;
        String string = this.sessionProperties.getProperty("AUTH_SESSION_ID");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    int getSerialNumber() {
        int n2 = -1;
        String string = this.sessionProperties.getProperty("AUTH_SERIAL_NUM");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty instanceProperty) throws SQLException {
        byte by = 0;
        if (instanceProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
            if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 6) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            by = this.serverRuntimeCapabilities[5];
        } else if (instanceProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
            if (this.serverRuntimeCapabilities == null || this.serverRuntimeCapabilities.length < 4) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 256);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            by = this.serverRuntimeCapabilities[3];
        }
        return by;
    }

    @Override
    public synchronized BlobDBAccess createBlobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized ClobDBAccess createClobDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized BfileDBAccess createBfileDBAccess() throws SQLException {
        return this;
    }

    @Override
    public synchronized long length(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(bFILE.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.bfileMsg.getLength(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return l2;
    }

    @Override
    public synchronized long position(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "position");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.hasPattern(bFILE, byArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "position");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.isSubLob(bFILE, bFILE2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getBytes(BFILE bFILE, long l2, int n2, byte[] byArray) throws SQLException {
        this.assertLoggedOn("getBytes");
        this.assertNotNull(bFILE.shareBytes(), "getBytes");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        if (this.pipeState != -1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.needLine();
        long l3 = 0L;
        if (n2 != 0) {
            try {
                l3 = this.bfileMsg.read(bFILE.shareBytes(), l2, n2, byArray, 0);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return (int)l3;
    }

    @Override
    public String getName(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("getName");
        this.assertNotNull(bFILE.shareBytes(), "getName");
        String string = LobPlsqlUtil.fileGetName(bFILE);
        return string;
    }

    @Override
    public String getDirAlias(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("getDirAlias");
        this.assertNotNull(bFILE.shareBytes(), "getDirAlias");
        String string = LobPlsqlUtil.fileGetDirAlias(bFILE);
        return string;
    }

    @Override
    public synchronized void openFile(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(bFILE.shareBytes(), "openFile");
        this.needLine();
        try {
            this.bfileMsg.open(bFILE.shareBytes(), 11);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean isFileOpen(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("openFile");
        this.assertNotNull(bFILE.shareBytes(), "openFile");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.isOpen(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl;
    }

    @Override
    public synchronized boolean fileExists(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("fileExists");
        this.assertNotNull(bFILE.shareBytes(), "fileExists");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.doesExist(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl;
    }

    @Override
    public synchronized void closeFile(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("closeFile");
        this.assertNotNull(bFILE.shareBytes(), "closeFile");
        this.needLine();
        try {
            this.bfileMsg.close(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized void open(BFILE bFILE, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(bFILE.shareBytes(), "open");
        this.needLine();
        try {
            this.bfileMsg.open(bFILE.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized void close(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(bFILE.shareBytes(), "close");
        this.needLine();
        try {
            this.bfileMsg.close(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean isOpen(BFILE bFILE) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(bFILE.shareBytes(), "isOpen");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.bfileMsg.isOpen(bFILE.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(BFILE bFILE, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bFILE, n2);
        }
        return new OracleBlobInputStream(bFILE, n2, l2);
    }

    @Override
    public InputStream newConversionInputStream(BFILE bFILE, int n2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    @Override
    public Reader newConversionReader(BFILE bFILE, int n2) throws SQLException {
        this.assertNotNull(bFILE.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bFILE.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    @Override
    public synchronized long length(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(bLOB.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getLength(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return l2;
    }

    @Override
    public long position(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        this.assertLoggedOn("position");
        this.assertNotNull(bLOB.shareBytes(), "position");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.hasPattern(bLOB, byArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        this.assertLoggedOn("position");
        this.assertNotNull(bLOB.shareBytes(), "position");
        this.assertNotNull(bLOB2.shareBytes(), "position");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.isSubLob(bLOB, bLOB2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getBytes(BLOB bLOB, long l2, int n2, byte[] byArray) throws SQLException {
        this.assertLoggedOn("getBytes");
        this.assertNotNull(bLOB.shareBytes(), "getBytes");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.pipeState != -1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getBytes()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 <= 0 || byArray == null) {
            return 0;
        }
        long l3 = 0L;
        long l4 = -1L;
        if (bLOB.isActivePrefetch()) {
            byte[] byArray2 = bLOB.getPrefetchedData();
            int n3 = bLOB.getPrefetchedDataSize();
            l4 = bLOB.length();
            int n4 = 0;
            if (byArray2 != null) {
                n4 = Math.min(n3, byArray2.length);
            }
            if (n4 > 0 && l2 <= (long)n4) {
                int n5 = Math.min(n4 - (int)l2 + 1, n2);
                System.arraycopy(byArray2, (int)l2 - 1, byArray, 0, n5);
                l3 += (long)n5;
            }
        }
        if (l3 < (long)n2 && (l4 == -1L || l2 - 1L + l3 < l4)) {
            this.needLine();
            try {
                l3 += this.blobMsg.read(bLOB.shareBytes(), l2 + l3, (long)n2 - l3, byArray, (int)l3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int putBytes(BLOB bLOB, long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.assertLoggedOn("putBytes");
        this.assertNotNull(bLOB.shareBytes(), "putBytes");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putBytes()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (byArray == null || n3 <= 0) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n3 != 0) {
            try {
                bLOB.setActivePrefetch(false);
                bLOB.clearCachedData();
                l3 = this.blobMsg.write(bLOB.shareBytes(), l2, byArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int getChunkSize(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(bLOB.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.blobMsg.getChunkSize(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (int)l2;
    }

    @Override
    public synchronized void trim(BLOB bLOB, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(bLOB.shareBytes(), "trim");
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.needLine();
        try {
            bLOB.setActivePrefetch(false);
            bLOB.clearCachedData();
            this.blobMsg.trim(bLOB.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized BLOB createTemporaryBlob(Connection connection, boolean bl, int n2) throws SQLException {
        this.assertLoggedOn("createTemporaryBlob");
        this.needLine();
        BLOB bLOB = null;
        try {
            bLOB = (BLOB)this.blobMsg.createTemporaryLob(this, bl, n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bLOB;
    }

    @Override
    public synchronized void freeTemporary(BLOB bLOB, boolean bl) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(bLOB.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.blobMsg.freeTemporaryLob(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public boolean isTemporary(BLOB bLOB) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "isTemporary");
        boolean bl = false;
        byte[] byArray = bLOB.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized void open(BLOB bLOB, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(bLOB.shareBytes(), "open");
        this.needLine();
        try {
            this.blobMsg.open(bLOB.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized void close(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(bLOB.shareBytes(), "close");
        this.needLine();
        try {
            this.blobMsg.close(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean isOpen(BLOB bLOB) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(bLOB.shareBytes(), "isOpen");
        this.needLine();
        boolean bl = false;
        try {
            bl = this.blobMsg.isOpen(bLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleBlobInputStream(bLOB, n2);
        }
        return new OracleBlobInputStream(bLOB, n2, l2);
    }

    @Override
    public InputStream newInputStream(BLOB bLOB, int n2, long l2, long l3) throws SQLException {
        return new OracleBlobInputStream(bLOB, n2, l2, l3);
    }

    @Override
    public OutputStream newOutputStream(BLOB bLOB, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleBlobOutputStream(bLOB, n2);
        }
        return new OracleBlobOutputStream(bLOB, n2, l2);
    }

    @Override
    public InputStream newConversionInputStream(BLOB bLOB, int n2) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "newConversionInputStream");
        OracleConversionInputStream oracleConversionInputStream = new OracleConversionInputStream(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionInputStream;
    }

    @Override
    public Reader newConversionReader(BLOB bLOB, int n2) throws SQLException {
        this.assertNotNull(bLOB.shareBytes(), "newConversionReader");
        OracleConversionReader oracleConversionReader = new OracleConversionReader(this.conversion, bLOB.getBinaryStream(), n2);
        return oracleConversionReader;
    }

    @Override
    public synchronized long length(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("length");
        this.assertNotNull(cLOB.shareBytes(), "length");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getLength(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return l2;
    }

    @Override
    public long position(CLOB cLOB, String string, long l2) throws SQLException {
        if (string == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.assertLoggedOn("position");
        this.assertNotNull(cLOB.shareBytes(), "position");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        long l3 = LobPlsqlUtil.hasPattern(cLOB, cArray, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public long position(CLOB cLOB, CLOB cLOB2, long l2) throws SQLException {
        if (cLOB2 == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.assertLoggedOn("position");
        this.assertNotNull(cLOB.shareBytes(), "position");
        this.assertNotNull(cLOB2.shareBytes(), "position");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l3 = LobPlsqlUtil.isSubLob(cLOB, cLOB2, l2);
        l3 = l3 == 0L ? -1L : l3;
        return l3;
    }

    @Override
    public synchronized int getChars(CLOB cLOB, long l2, int n2, char[] cArray) throws SQLException {
        this.assertLoggedOn("getChars");
        this.assertNotNull(cLOB.shareBytes(), "getChars");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getChars()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.pipeState != -1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 453, "getChars()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 <= 0 || cArray == null) {
            return 0;
        }
        long l3 = 0L;
        long l4 = -1L;
        if (cLOB.isActivePrefetch()) {
            l4 = cLOB.length();
            char[] cArray2 = cLOB.getPrefetchedData();
            int n3 = cLOB.getPrefetchedDataSize();
            int n4 = 0;
            if (cArray2 != null) {
                n4 = Math.min(n3, cArray2.length);
            }
            if (n4 > 0 && l2 <= (long)n4) {
                int n5 = Math.min(n4 - (int)l2 + 1, n2);
                System.arraycopy(cArray2, (int)l2 - 1, cArray, 0, n5);
                l3 += (long)n5;
            }
        }
        if (l3 < (long)n2 && (l4 == -1L || l2 - 1L + l3 < l4)) {
            this.needLine();
            try {
                boolean bl = cLOB.isNCLOB();
                l3 += this.clobMsg.read(cLOB.shareBytes(), (long)((int)l2) + l3, (long)n2 - l3, bl, cArray, (int)l3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int putChars(CLOB cLOB, long l2, char[] cArray, int n2, int n3) throws SQLException {
        this.assertLoggedOn("putChars");
        this.assertNotNull(cLOB.shareBytes(), "putChars");
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "putChars()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (cArray == null || n3 <= 0) {
            return 0;
        }
        this.needLine();
        long l3 = 0L;
        if (n3 != 0) {
            try {
                boolean bl = cLOB.isNCLOB();
                cLOB.setActivePrefetch(false);
                cLOB.clearCachedData();
                l3 = this.clobMsg.write(cLOB.shareBytes(), l2, bl, cArray, n2, n3);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return (int)l3;
    }

    @Override
    public synchronized int getChunkSize(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("getChunkSize");
        this.assertNotNull(cLOB.shareBytes(), "getChunkSize");
        this.needLine();
        long l2 = 0L;
        try {
            l2 = this.clobMsg.getChunkSize(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (int)l2;
    }

    @Override
    public synchronized void trim(CLOB cLOB, long l2) throws SQLException {
        this.assertLoggedOn("trim");
        this.assertNotNull(cLOB.shareBytes(), "trim");
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "trim()");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.needLine();
        try {
            cLOB.setActivePrefetch(false);
            cLOB.clearCachedData();
            this.clobMsg.trim(cLOB.shareBytes(), l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized CLOB createTemporaryClob(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        this.assertLoggedOn("createTemporaryClob");
        this.needLine();
        CLOB cLOB = null;
        try {
            cLOB = (CLOB)this.clobMsg.createTemporaryLob(this, bl, n2, s2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return cLOB;
    }

    @Override
    public synchronized void freeTemporary(CLOB cLOB, boolean bl) throws SQLException {
        this.assertLoggedOn("freeTemporary");
        this.assertNotNull(cLOB.shareBytes(), "freeTemporary");
        this.needLine();
        try {
            this.clobMsg.freeTemporaryLob(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public boolean isTemporary(CLOB cLOB) throws SQLException {
        boolean bl = false;
        byte[] byArray = cLOB.shareBytes();
        if ((byArray[7] & 1) > 0 || (byArray[4] & 0x40) > 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized void open(CLOB cLOB, int n2) throws SQLException {
        this.assertLoggedOn("open");
        this.assertNotNull(cLOB.shareBytes(), "open");
        this.needLine();
        try {
            this.clobMsg.open(cLOB.shareBytes(), n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized void close(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("close");
        this.assertNotNull(cLOB.shareBytes(), "close");
        this.needLine();
        try {
            this.clobMsg.close(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean isOpen(CLOB cLOB) throws SQLException {
        this.assertLoggedOn("isOpen");
        this.assertNotNull(cLOB.shareBytes(), "isOpen");
        boolean bl = false;
        this.needLine();
        try {
            bl = this.clobMsg.isOpen(cLOB.shareBytes());
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl;
    }

    @Override
    public InputStream newInputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobInputStream(cLOB, n2);
        }
        return new OracleClobInputStream(cLOB, n2, l2);
    }

    @Override
    public OutputStream newOutputStream(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleClobOutputStream(cLOB, n2);
        }
        return new OracleClobOutputStream(cLOB, n2, l2);
    }

    @Override
    public Reader newReader(CLOB cLOB, int n2, long l2) throws SQLException {
        if (l2 == 0L) {
            return new OracleClobReader(cLOB, n2);
        }
        return new OracleClobReader(cLOB, n2, l2);
    }

    @Override
    public Reader newReader(CLOB cLOB, int n2, long l2, long l3) throws SQLException {
        return new OracleClobReader(cLOB, n2, l2, l3);
    }

    @Override
    public Writer newWriter(CLOB cLOB, int n2, long l2, boolean bl) throws SQLException {
        if (l2 == 0L) {
            if (bl & this.lobStreamPosStandardCompliant) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            return new OracleClobWriter(cLOB, n2);
        }
        return new OracleClobWriter(cLOB, n2, l2);
    }

    void assertLoggedOn(String string) throws SQLException {
        if (!this.isLoggedOn) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 430);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    void assertNotNull(byte[] byArray, String string) throws NullPointerException {
        if (byArray == null) {
            throw new NullPointerException("bytes are null");
        }
    }

    @Override
    void internalClose() throws SQLException {
        super.internalClose();
        this.isLoggedOn = false;
        try {
            if (this.net != null) {
                this.net.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    void doAbort() throws SQLException {
        try {
            this.net.abort();
        }
        catch (NetException netException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), netException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        T4CStatement t4CStatement = new T4CStatement(this, -1, -1);
        t4CStatement.open();
        String string = autoKeyInfo.getTableName();
        String string2 = "SELECT * FROM " + string;
        t4CStatement.sqlObject.initialize(string2);
        Accessor[] accessorArray = null;
        try {
            this.describe.doODNY(t4CStatement, 0, accessorArray, t4CStatement.sqlObject.getSqlBytes(false, false));
            accessorArray = this.describe.getAccessors();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.describe.numuds;
        autoKeyInfo.allocateSpaceForDescribedData(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Accessor accessor = accessorArray[i2];
            String string3 = accessor.columnName;
            int n3 = accessor.describeType;
            int n4 = accessor.describeMaxLength;
            boolean bl = accessor.nullable;
            short s2 = accessor.formOfUse;
            int n5 = accessor.precision;
            int n6 = accessor.scale;
            String string4 = accessor.describeTypeName;
            autoKeyInfo.fillDescribedData(i2, string3, n3, n4, bl, s2, n5, n6, string4);
        }
        t4CStatement.close();
    }

    @Override
    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        Namespace namespace = (Namespace)this.namespaces.get(string);
        if (namespace == null) {
            namespace = new Namespace(string);
            this.namespaces.put(string, namespace);
        }
        namespace.setAttribute(string2, string3);
    }

    @Override
    void doClearAllApplicationContext(String string) throws SQLException {
        Namespace namespace = new Namespace(string);
        namespace.clear();
        this.namespaces.put(string, namespace);
    }

    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection) throws SQLException {
        super.getPropertyForPooledConnection(oraclePooledConnection, this.password);
    }

    final void getPasswordInternal(T4CXAResource t4CXAResource) throws SQLException {
        t4CXAResource.setPasswordInternal(this.password);
    }

    @Override
    synchronized void doEnqueue(String string, AQEnqueueOptions aQEnqueueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, byte[] byArray2, byte[][] byArray3, boolean bl) throws SQLException {
        try {
            this.needLine();
            this.sendPiggyBackedMessages();
            this.aqe.doOAQEQ(string, aQEnqueueOptions, aQMessagePropertiesI, byArray2, byArray, bl);
            if (aQEnqueueOptions.getRetrieveMessageId()) {
                byArray3[0] = this.aqe.getMessageId();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    synchronized boolean doDequeue(String string, AQDequeueOptions aQDequeueOptions, AQMessagePropertiesI aQMessagePropertiesI, byte[] byArray, byte[][] byArray2, byte[][] byArray3, boolean bl) throws SQLException {
        boolean bl2 = false;
        try {
            this.needLine();
            this.sendPiggyBackedMessages();
            this.aqdq.doOAQDQ(string, aQDequeueOptions, byArray, bl, aQMessagePropertiesI);
            byArray2[0] = this.aqdq.getPayload();
            byArray3[0] = this.aqdq.getDequeuedMessageId();
            bl2 = this.aqdq.hasAMessageBeenDequeued();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return bl2;
    }

    @Override
    synchronized int doPingDatabase() throws SQLException {
        if (this.versionNumber >= 10102) {
            try {
                this.needLine();
                this.sendPiggyBackedMessages();
                this.oping.doOPING();
            }
            catch (IOException iOException) {
                return -1;
            }
            catch (SQLException sQLException) {
                return -1;
            }
            return 0;
        }
        return super.doPingDatabase();
    }

    @Override
    synchronized NTFAQRegistration[] doRegisterAQNotification(String[] stringArray, String string, int n2, Properties[] propertiesArray) throws SQLException {
        int n3;
        int n4 = stringArray.length;
        int[] nArray = new int[n4];
        byte[][] byArrayArray = new byte[n4][];
        int[] nArray2 = new int[n4];
        int[] nArray3 = new int[n4];
        int[] nArray4 = new int[n4];
        int[] nArray5 = new int[n4];
        int[] nArray6 = new int[n4];
        int[] nArray7 = new int[n4];
        long[] lArray = new long[n4];
        byte[] byArray = new byte[n4];
        int[] nArray8 = new int[n4];
        byte[] byArray2 = new byte[n4];
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[n4];
        int[] nArray9 = new int[n4];
        boolean bl = false;
        if (n2 == 0) {
            bl = true;
            n2 = 47632;
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray[i2] = PhysicalConnection.ntfManager.getNextJdbcRegId();
            byArrayArray[i2] = new byte[4];
            byArrayArray[i2][0] = (byte)((nArray[i2] & 0xFF000000) >> 24);
            byArrayArray[i2][1] = (byte)((nArray[i2] & 0xFF0000) >> 16);
            byArrayArray[i2][2] = (byte)((nArray[i2] & 0xFF00) >> 8);
            byArrayArray[i2][3] = (byte)(nArray[i2] & 0xFF);
            nArray2[i2] = 1;
            nArray3[i2] = 23;
            if (propertiesArray.length <= i2 || propertiesArray[i2] == null) continue;
            if (propertiesArray[i2].getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
                int n5 = i2;
                nArray4[n5] = nArray4[n5] | 1;
            }
            if (propertiesArray[i2].getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
                int n6 = i2;
                nArray4[n6] = nArray4[n6] | 0x10;
            }
            if (propertiesArray[i2].getProperty("NTF_AQ_PAYLOAD", "false").compareToIgnoreCase("true") == 0) {
                int n7 = i2;
                nArray4[n7] = nArray4[n7] | 2;
            }
            nArray5[i2] = this.readNTFtimeout(propertiesArray[i2]);
        }
        this.setNtfGroupingOptions(byArray, nArray8, byArray2, tIMESTAMPTZArray, nArray9, propertiesArray);
        int[] nArray10 = new int[]{n2};
        boolean bl2 = PhysicalConnection.ntfManager.listenOnPortT4C(nArray10, bl);
        n2 = nArray10[0];
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        try {
            try {
                int n8 = bl2 ? 1 : 0;
                this.sendPiggyBackedMessages();
                this.okpn.doOKPN(1, n8, this.userName, string2, n4, nArray2, stringArray, byArrayArray, nArray3, nArray4, nArray5, nArray6, nArray7, lArray, byArray, nArray8, byArray2, tIMESTAMPTZArray, nArray9);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            if (bl2) {
                PhysicalConnection.ntfManager.cleanListenersT4C(n2);
            }
            throw sQLException;
        }
        NTFAQRegistration[] nTFAQRegistrationArray = new NTFAQRegistration[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nTFAQRegistrationArray[n3] = new NTFAQRegistration(nArray[n3], true, this.instanceName, this.userName, string, n2, propertiesArray[n3], stringArray[n3], this.versionNumber);
        }
        for (n3 = 0; n3 < nTFAQRegistrationArray.length; ++n3) {
            PhysicalConnection.ntfManager.addRegistration(nTFAQRegistrationArray[n3]);
        }
        return nTFAQRegistrationArray;
    }

    private void setNtfGroupingOptions(byte[] byArray, int[] nArray, byte[] byArray2, TIMESTAMPTZ[] tIMESTAMPTZArray, int[] nArray2, Properties[] propertiesArray) throws SQLException {
        for (int i2 = 0; i2 < propertiesArray.length; ++i2) {
            String string = propertiesArray[i2].getProperty("NTF_GROUPING_CLASS", "NTF_GROUPING_CLASS_NONE");
            String string2 = propertiesArray[i2].getProperty("NTF_GROUPING_VALUE");
            String string3 = propertiesArray[i2].getProperty("NTF_GROUPING_TYPE");
            TIMESTAMPTZ tIMESTAMPTZ = null;
            if (propertiesArray[i2].get("NTF_GROUPING_START_TIME") != null) {
                tIMESTAMPTZ = (TIMESTAMPTZ)propertiesArray[i2].get("NTF_GROUPING_START_TIME");
            }
            String string4 = propertiesArray[i2].getProperty("NTF_GROUPING_REPEAT_TIME", "NTF_GROUPING_REPEAT_FOREVER");
            if (string.compareTo("NTF_GROUPING_CLASS_TIME") != 0 && string.compareTo("NTF_GROUPING_CLASS_NONE") != 0) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string.compareTo("NTF_GROUPING_CLASS_NONE") != 0 && this.getTTCVersion() < 5) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (string.compareTo("NTF_GROUPING_CLASS_TIME") != 0) continue;
            byArray[i2] = 1;
            nArray[i2] = 600;
            if (string2 != null) {
                nArray[i2] = Integer.parseInt(string2);
            }
            byArray2[i2] = 1;
            if (string3 != null) {
                if (string3.compareTo("NTF_GROUPING_TYPE_SUMMARY") == 0) {
                    byArray2[i2] = 1;
                } else if (string3.compareTo("NTF_GROUPING_TYPE_LAST") == 0) {
                    byArray2[i2] = 2;
                } else {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            tIMESTAMPTZArray[i2] = tIMESTAMPTZ;
            nArray2[i2] = string4.compareTo("NTF_GROUPING_REPEAT_FOREVER") == 0 ? 0 : Integer.parseInt(string4);
        }
    }

    @Override
    synchronized void doUnregisterAQNotification(NTFAQRegistration nTFAQRegistration) throws SQLException {
        String string = nTFAQRegistration.getClientHost();
        int n2 = nTFAQRegistration.getClientTCPPort();
        if (string == null) {
            return;
        }
        PhysicalConnection.ntfManager.removeRegistration(nTFAQRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFAQRegistration.getJdbcRegId());
        PhysicalConnection.ntfManager.cleanListenersT4C(nTFAQRegistration.getClientTCPPort());
        nTFAQRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        int[] nArray = new int[]{1};
        String[] stringArray = new String[]{nTFAQRegistration.getQueueName()};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        long[] lArray = new long[]{0L};
        byte[] byArray = new byte[]{0};
        int[] nArray7 = new int[]{0};
        byte[] byArray2 = new byte[]{0};
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[]{null};
        int[] nArray8 = new int[]{0};
        byte[][] byArrayArray = new byte[1][];
        int n3 = nTFAQRegistration.getJdbcRegId();
        byArrayArray[0] = new byte[4];
        byArrayArray[0][0] = (byte)((n3 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n3 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n3 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n3 & 0xFF);
        try {
            this.sendPiggyBackedMessages();
            this.okpn.doOKPN(2, 0, this.userName, string2, 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, lArray, byArray, nArray7, byArray2, tIMESTAMPTZArray, nArray8);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    synchronized NTFDCNRegistration doRegisterDatabaseChangeNotification(String string, int n2, Properties properties, int n3, int n4) throws SQLException {
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Object var11_11 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n2 == 0) {
            bl5 = true;
            n2 = 47632;
        }
        if (properties.getProperty("NTF_QOS_RELIABLE", "false").compareToIgnoreCase("true") == 0) {
            n6 |= 1;
        }
        if (properties.getProperty("NTF_QOS_PURGE_ON_NTFN", "false").compareToIgnoreCase("true") == 0) {
            n6 |= 0x10;
        }
        if (properties.getProperty("DCN_NOTIFY_ROWIDS", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x10;
        }
        if (properties.getProperty("DCN_QUERY_CHANGE_NOTIFICATION", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x20;
        }
        if (properties.getProperty("DCN_BEST_EFFORT", "false").compareToIgnoreCase("true") == 0) {
            n5 |= 0x40;
        }
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (properties.getProperty("DCN_IGNORE_INSERTOP", "false").compareToIgnoreCase("true") == 0) {
            bl6 = true;
        }
        if (properties.getProperty("DCN_IGNORE_UPDATEOP", "false").compareToIgnoreCase("true") == 0) {
            bl7 = true;
        }
        if (properties.getProperty("DCN_IGNORE_DELETEOP", "false").compareToIgnoreCase("true") == 0) {
            bl8 = true;
        }
        if (bl6 || bl7 || bl8) {
            n5 |= 0xF;
            if (bl6) {
                n5 -= 2;
            }
            if (bl7) {
                n5 -= 4;
            }
            if (bl8) {
                n5 -= 8;
            }
        }
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        byte[] byArray2 = new byte[1];
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[1];
        int[] nArray2 = new int[1];
        Properties[] propertiesArray = new Properties[]{properties};
        this.setNtfGroupingOptions(byArray, nArray, byArray2, tIMESTAMPTZArray, nArray2, propertiesArray);
        int[] nArray3 = new int[]{n2};
        boolean bl9 = PhysicalConnection.ntfManager.listenOnPortT4C(nArray3, bl5);
        n2 = nArray3[0];
        String string2 = "(ADDRESS=(PROTOCOL=tcp)(HOST=" + string + ")(PORT=" + n2 + "))?PR=0";
        int[] nArray4 = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray5 = new int[]{23};
        int[] nArray6 = new int[]{n6};
        int[] nArray7 = new int[]{n3};
        int[] nArray8 = new int[]{n5};
        int[] nArray9 = new int[]{n4};
        long[] lArray = new long[]{0L};
        int n7 = PhysicalConnection.ntfManager.getNextJdbcRegId();
        byte[][] byArrayArray = new byte[][]{new byte[4]};
        byArrayArray[0][0] = (byte)((n7 & 0xFF000000) >> 24);
        byArrayArray[0][1] = (byte)((n7 & 0xFF0000) >> 16);
        byArrayArray[0][2] = (byte)((n7 & 0xFF00) >> 8);
        byArrayArray[0][3] = (byte)(n7 & 0xFF);
        long l2 = 0L;
        try {
            try {
                int n8 = bl9 ? 1 : 0;
                this.sendPiggyBackedMessages();
                this.okpn.doOKPN(1, n8, this.userName, string2, 1, nArray4, stringArray, byArrayArray, nArray5, nArray6, nArray7, nArray8, nArray9, lArray, byArray, nArray, byArray2, tIMESTAMPTZArray, nArray2);
                l2 = this.okpn.getRegistrationId();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            if (bl9) {
                PhysicalConnection.ntfManager.cleanListenersT4C(n2);
            }
            throw sQLException;
        }
        NTFDCNRegistration nTFDCNRegistration = new NTFDCNRegistration(n7, true, this.instanceName, l2, this.userName, string, n2, properties, this.versionNumber);
        return nTFDCNRegistration;
    }

    @Override
    synchronized void doUnregisterDatabaseChangeNotification(long l2, String string) throws SQLException {
        int[] nArray = new int[]{2};
        String[] stringArray = new String[1];
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int[] nArray5 = new int[]{0};
        int[] nArray6 = new int[]{0};
        byte[] byArray = new byte[]{0};
        int[] nArray7 = new int[]{0};
        byte[] byArray2 = new byte[]{0};
        TIMESTAMPTZ[] tIMESTAMPTZArray = new TIMESTAMPTZ[]{null};
        int[] nArray8 = new int[]{0};
        long[] lArray = new long[]{l2};
        byte[][] byArrayArray = new byte[1][];
        try {
            this.sendPiggyBackedMessages();
            this.okpn.doOKPN(2, 0, null, string, 1, nArray, stringArray, byArrayArray, nArray2, nArray3, nArray4, nArray5, nArray6, lArray, byArray, nArray7, byArray2, tIMESTAMPTZArray, nArray8);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    synchronized void doUnregisterDatabaseChangeNotification(NTFDCNRegistration nTFDCNRegistration) throws SQLException {
        PhysicalConnection.ntfManager.removeRegistration(nTFDCNRegistration);
        PhysicalConnection.ntfManager.freeJdbcRegId(nTFDCNRegistration.getJdbcRegId());
        PhysicalConnection.ntfManager.cleanListenersT4C(nTFDCNRegistration.getClientTCPPort());
        nTFDCNRegistration.setState(NotificationRegistration.RegistrationState.CLOSED);
        this.doUnregisterDatabaseChangeNotification(nTFDCNRegistration.getRegId(), "(ADDRESS=(PROTOCOL=tcp)(HOST=" + nTFDCNRegistration.getClientHost() + ")(PORT=" + nTFDCNRegistration.getClientTCPPort() + "))?PR=0");
    }

    @Override
    public String getDataIntegrityAlgorithmName() throws SQLException {
        return this.net.getDataIntegrityName();
    }

    @Override
    public String getEncryptionAlgorithmName() throws SQLException {
        return this.net.getEncryptionName();
    }

    @Override
    public String getAuthenticationAdaptorName() throws SQLException {
        return this.net.getAuthenticationAdaptorName();
    }

    @Override
    void validateConnectionProperties() throws SQLException {
        super.validateConnectionProperties();
        String string = ".*[\\00\\(\\)].*";
        if (this.thinVsessionOsuser != null && (this.thinVsessionOsuser.matches(string) || this.thinVsessionOsuser.length() > 30)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.osuser' and value is '" + this.thinVsessionOsuser + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.thinVsessionTerminal != null && (this.thinVsessionTerminal.matches(string) || this.thinVsessionTerminal.length() > 30)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.terminal' and value is '" + this.thinVsessionTerminal + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.thinVsessionMachine != null && (this.thinVsessionMachine.matches(string) || this.thinVsessionMachine.length() > 64)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.machine' and value is '" + this.thinVsessionMachine + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.thinVsessionProgram != null && (this.thinVsessionProgram.matches(string) || this.thinVsessionProgram.length() > 48)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.program' and value is '" + this.thinVsessionProgram + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.thinVsessionProcess != null && (this.thinVsessionProcess.matches(string) || this.thinVsessionProcess.length() > 24)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.process' and value is '" + this.thinVsessionProcess + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.thinVsessionIname != null && this.thinVsessionIname.matches(string)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.iname' and value is '" + this.thinVsessionIname + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.thinVsessionEname != null && this.thinVsessionEname.matches(string)) {
            SQLException sQLException = DatabaseError.createSqlException(null, 190, "Property is 'v$session.ename' and value is '" + this.thinVsessionEname + "'");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized byte[] createLightweightSession(String string, KeywordValueLong[] keywordValueLongArray, int n2, KeywordValueLong[][] keywordValueLongArray2, int[] nArray) throws SQLException {
        if (keywordValueLongArray2.length != 1 || nArray.length != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = null;
        try {
            this.sendPiggyBackedMessages();
            this.oxsscs.doOXSSCS(string, keywordValueLongArray, n2);
            byArray = this.oxsscs.getSessionId();
            keywordValueLongArray2[0] = this.oxsscs.getOutKV();
            nArray[0] = this.oxsscs.getOutFlags();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return byArray;
    }

    private synchronized void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSNamespace[][] xSNamespaceArray2, boolean bl) throws SQLException {
        XSNamespace[] xSNamespaceArray3 = null;
        try {
            if (bl) {
                this.sendPiggyBackedMessages();
            }
            this.xsnsop.doOXSNS(xSOperationCode, byArray, xSNamespaceArray, bl);
            if (bl) {
                xSNamespaceArray3 = this.xsnsop.getNamespaces();
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (xSNamespaceArray2 != null && xSNamespaceArray2.length > 0) {
            xSNamespaceArray2[0] = xSNamespaceArray3;
        }
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray, XSNamespace[][] xSNamespaceArray2) throws SQLException {
        this.doXSNamespaceOp(xSOperationCode, byArray, xSNamespaceArray, xSNamespaceArray2, true);
    }

    @Override
    public void doXSNamespaceOp(OracleConnection.XSOperationCode xSOperationCode, byte[] byArray, XSNamespace[] xSNamespaceArray) throws SQLException {
        this.doXSNamespaceOp(xSOperationCode, byArray, xSNamespaceArray, null, false);
    }

    @Override
    public synchronized void executeLightweightSessionRoundtrip(int n2, byte[] byArray, KeywordValueLong[] keywordValueLongArray, int n3, KeywordValueLong[][] keywordValueLongArray2, int[] nArray) throws SQLException {
        if (keywordValueLongArray2.length != 1 || nArray.length != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        try {
            this.sendPiggyBackedMessages();
            this.oxssro.doOXSSRO(n2, byArray, keywordValueLongArray, n3);
            keywordValueLongArray2[0] = this.oxssro.getOutKV();
            nArray[0] = this.oxssro.getOutFlags();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    @Override
    public synchronized void executeLightweightSessionPiggyback(int n2, byte[] byArray, KeywordValueLong[] keywordValueLongArray, int n3) throws SQLException {
        if (this.lusOffset2 == this.lusFunctionId2.length) {
            int n4 = this.lusFunctionId2.length;
            int[] nArray = new int[n4 * 2];
            System.arraycopy(this.lusFunctionId2, 0, nArray, 0, n4);
            byte[][] byArrayArray = new byte[n4 * 2][];
            System.arraycopy(this.lusSessionId2, 0, byArrayArray, 0, n4);
            KeywordValueLong[][] keywordValueLongArrayArray = new KeywordValueLong[n4 * 2][];
            System.arraycopy(this.lusInKeyVal2, 0, keywordValueLongArrayArray, 0, n4);
            int[] nArray2 = new int[n4 * 2];
            System.arraycopy(this.lusInFlags2, 0, nArray2, 0, n4);
            this.lusFunctionId2 = nArray;
            this.lusSessionId2 = byArrayArray;
            this.lusInKeyVal2 = keywordValueLongArrayArray;
            this.lusInFlags2 = nArray2;
        }
        this.lusFunctionId2[this.lusOffset2] = n2;
        this.lusSessionId2[this.lusOffset2] = byArray;
        this.lusInKeyVal2[this.lusOffset2] = keywordValueLongArray;
        this.lusInFlags2[this.lusOffset2] = n3;
        ++this.lusOffset2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addXSEventListener(XSEventListener xSEventListener, Executor executor) throws SQLException {
        if (this.lifecycle != 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        NTFEventListener nTFEventListener = new NTFEventListener(xSEventListener);
        nTFEventListener.setExecutor(executor);
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        synchronized (this.xsListeners) {
            int n2 = this.xsListeners.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.xsListeners[i2].getXSEventListener() != xSEventListener) continue;
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 248);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[n2 + 1];
            System.arraycopy(this.xsListeners, 0, nTFEventListenerArray2, 0, n2);
            nTFEventListenerArray2[n2] = nTFEventListener;
            this.xsListeners = nTFEventListenerArray2;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void addXSEventListener(XSEventListener xSEventListener) throws SQLException {
        this.addXSEventListener(xSEventListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeXSEventListener(XSEventListener xSEventListener) throws SQLException {
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        synchronized (this.xsListeners) {
            int n2 = 0;
            int n3 = this.xsListeners.length;
            for (n2 = 0; n2 < n3 && this.xsListeners[n2].getXSEventListener() != xSEventListener; ++n2) {
            }
            if (n2 == n3) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 249);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            NTFEventListener[] nTFEventListenerArray2 = new NTFEventListener[n3 - 1];
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.xsListeners[n2].getXSEventListener() == xSEventListener) continue;
                nTFEventListenerArray2[n4++] = this.xsListeners[n2];
            }
            this.xsListeners = nTFEventListenerArray2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void notify(final NTFXSEvent nTFXSEvent) {
        NTFEventListener[] nTFEventListenerArray = this.xsListeners;
        int n2 = nTFEventListenerArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Executor executor = nTFEventListenerArray[i2].getExecutor();
            if (executor != null) {
                final XSEventListener xSEventListener = nTFEventListenerArray[i2].getXSEventListener();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        xSEventListener.onXSEvent(nTFXSEvent);
                    }
                });
                continue;
            }
            nTFEventListenerArray[i2].getXSEventListener().onXSEvent(nTFXSEvent);
        }
    }
}

