/* PAM to authenticate to AFS */

/* 
 * Albrecht Gebhardt <agebhard@uni-klu.ac.at>
 * Copyright: GPL, See COPYING.LIB-2.0
 *
 * Created Sun Jun 16 21:12:20 CEST 2002
 * 
 * Version:
 * $Id: pam_linux_uniklu_get_password.c,v 1.5 2009-01-09 10:17:09 agebhard Exp $
 * 
 * Last Revised on
 * $Date: 2009-01-09 10:17:09 $
 * 
 * Changelog:
 *
 * $Log: pam_linux_uniklu_get_password.c,v $
 * Revision 1.5  2009-01-09 10:17:09  agebhard
 * ...
 *
 * Revision 1.4  2004/10/28 18:31:43  agebhard
 * rename mount-home program to uniklu_helper
 *
 * Revision 1.3  2002/06/18 13:25:08  agebhard
 * new debugging. still not working on madrake.
 * pam_sm_authenticate fails because it is called before entering a password!
 *
 * Revision 1.2  2002/06/17 09:57:28  agebhard
 * more cvs keywords ...
 *
 * 
 */

#include <stdio.h>
#include <syslog.h>
#include <security/pam_modules.h>
#include "pam_linux_uniklu.h"

int pam_linux_uniklu_get_password(pam_handle_t *pamh, char **password,
				  char *prompt, int ask_user)
{
    const char *procname="pam_linux_uniklu_get_password";

    int		retval;

#   ifdef DEBUG
    syslog(LOG_DEBUG, "%s:", procname);
#   endif
    /* get password */
    retval = pam_get_item(pamh, PAM_AUTHTOK, (void *) password);
    if ((retval == PAM_SUCCESS) && (*password != NULL)){
#       ifdef DEBUG
	syslog(LOG_DEBUG, "%s: password: '%s'", procname, STAR_PASSWD); 
#       endif
	retval = pam_set_item(pamh, PAM_AUTHTOK, *password);
	if (retval != PAM_SUCCESS)
	    syslog(LOG_CRIT, "%s: pam_set_item failed: %s", procname,
		   pam_strerror(pamh,retval));
#       ifdef DEBUG
	else
	    syslog(LOG_DEBUG, "%s: pam_set_item succeeded", procname);
#       endif
	return retval;
    };
    /* should this be implemented here? see pam_linux_afs_get_password */
    /*    if ((ask_user == 1) && ((retval == PAM_BAD_ITEM) || 
              (*password == NULL)))
	{
	    retval = pam_linux_afs_ask_password(pamh, password, prompt);
	    if (retval != PAM_SUCCESS) return(PAM_AUTH_ERR);
	    return(pam_set_item(pamh, PAM_AUTHTOK, *password));
	    } */
    syslog(LOG_CRIT, "%s: password: failed, %s",procname, pam_strerror(pamh,retval));
    return(PAM_AUTH_ERR);
}
