/* PAM to automate Uni-Klu login tasks */

/* 
 * Albrecht Gebhardt <agebhard@uni-klu.ac.at>
 * Copyright: GPL, See COPYING.LIB-2.0
 *
 * Created Sun Jun 16 21:12:20 CEST 2002
 * 
 * Version:
 * $Id: pam_linux_uniklu.h,v 1.11 2009-01-09 10:17:09 agebhard Exp $
 * 
 * Last Revised on
 * $Date: 2009-01-09 10:17:09 $
 * 
 * PAM module to execute login task as user with passwd during PAM session,
 * see README
 *
 * Inspired by pam_linux_afs from 
 *   Tobias Schaefer <T.Schaefer@science-computing.de>
 * found at http://www.uni-hohenheim.de/~schaefer/linux/pam/
 * 
 * Changelog:
 *
 * $Log: pam_linux_uniklu.h,v $
 * Revision 1.11  2009-01-09 10:17:09  agebhard
 * ...
 *
 * Revision 1.10  2005/02/19 16:02:50  agebhard
 * debianzed
 *
 * Revision 1.9  2004/10/30 18:07:25  agebhard
 * docu reorganized
 * ignore_root works now
 *
 * Revision 1.8  2004/10/30 16:32:50  agebhard
 * fixed kdm crash in close_session
 * fixed wrong password length in kdm session
 * added more expect scripts, untested
 *
 * Revision 1.7  2004/10/29 22:49:59  agebhard
 * sort of works now also for kdm
 * short passwords are read back with extra characters, leads to wrong degarble
 *
 * Revision 1.6  2004/10/29 07:12:39  agebhard
 * makefile cleanup, disable debug passwords
 *
 * Revision 1.5  2004/10/28 21:40:47  agebhard
 * working again (debian sarge)
 *
 * Revision 1.4  2004/10/28 18:31:43  agebhard
 * rename mount-home program to uniklu_helper
 *
 * Revision 1.3  2002/06/18 13:25:08  agebhard
 * new debugging. still not working on madrake.
 * pam_sm_authenticate fails because it is called before entereing a password!
 *
 * Revision 1.2  2002/06/17 09:53:38  agebhard
 * cvs keywords added
 *
 * 
 */


#ifndef PAM_LINUX_UNIKLU_H
#define PAM_LINUX_UNIKLU_H

#include <syslog.h>

#include <security/pam_modules.h>

#define UNIKLU_HELPER_PROGRAM      "/usr/local/bin/uniklu_helper"

#define UNIQUE_DATA_NAME	"PAM_LINUX_UNIKLU_GARBLED_PASSWORD"

//#define DEBUG
#undef DEBUG
#ifdef DEBUG
  /* use password debugging carefully, it logs clear text passwords into
   * /var/log/auth !!!
   */

//#  define DEBUG_PASSWD
#  undef DEBUG_PASSWD
#  ifdef DEBUG_PASSWD
#    define PASSWD       password
#    define LOCAL_PASSWD local_password
#    define PASSWD_PTR   password_ptr
#    define STAR_PASSWD  *password
#  else
#    define PASSWD       "********"
#    define LOCAL_PASSWD "********"
#    define PASSWD_PTR   "********"
#    define STAR_PASSWD  "********"
#  endif
#endif

extern int pam_linux_uniklu_helper(char *username, char *password,
					    const char *uniklu_helper_program);

extern int pam_linux_uniklu_get_password(pam_handle_t *pamh,
					 char **password,
					 char *prompt,
					 int ask_user);
extern int pam_linux_uniklu_garble_string(pam_handle_t *pamh,
					  char string[],
					  int len);
extern void pam_linux_uniklu_cleanup_password(pam_handle_t *pamh,
					      void *data,
					      int error_status);
extern void pam_linux_uniklu_cleanup_garble_key(pam_handle_t *pamh,
						int *pam_linux_uniklu_garble_key, 
						int error_status);


#ifdef PAM_STATIC

/* static module data */

struct pam_module _pam_env_modstruct = {
     "pam_linux_uniklu",
     pam_sm_authenticate,
     pam_sm_setcred,
     pam_sm_acct_mgmt,
     pam_sm_open_session,
     pam_sm_close_session,
     pam_sm_chauthtok,
};

#endif


#endif /* PAM_LINUX_UNIKLU_H */
