/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MopacReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacGraphfReader
extends MopacReader {
    private int atomCount;
    private float[][] invMatrix;

    protected boolean checkLine() throws Exception {
        this.readAtoms();
        this.readSlaterBasis();
        this.readMOs(false);
        if (this.readKeywords()) {
            this.readMOs(true);
        }
        this.continuing = false;
        return false;
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomCount = this.parseInt(this.line);
        this.atomicNumbers = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomicNumbers[i] = this.parseInt(this.line.substring(0, 4));
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.x = this.parseFloat(this.line.substring(4, 17));
            atom.y = this.parseFloat(this.line.substring(17, 29));
            atom.z = this.parseFloat(this.line.substring(29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloat(this.line.substring(41));
            }
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(this.atomicNumbers[i]);
        }
    }

    private void readSlaterBasis() throws Exception {
        this.nOrbitals = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.atomCount; ++i) {
            MopacGraphfReader.getTokensFloat(this.readLine(), fArray, 3);
            int n = this.atomicNumbers[i];
            float f = fArray[0];
            if (f != 0.0f) {
                this.createSphericalSlaterByType(i, n, "S", f, 1.0f);
            }
            if ((f = fArray[1]) != 0.0f) {
                this.createSphericalSlaterByType(i, n, "Px", f, 1.0f);
                this.createSphericalSlaterByType(i, n, "Py", f, 1.0f);
                this.createSphericalSlaterByType(i, n, "Pz", f, 1.0f);
            }
            if ((f = fArray[2]) == 0.0f) continue;
            this.createSphericalSlaterByType(i, n, "Dx2-y2", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dxz", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dz2", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dyz", f, 1.0f);
            this.createSphericalSlaterByType(i, n, "Dxy", f, 1.0f);
        }
        this.nOrbitals = this.slaters.size();
        this.setSlaters(true, false);
    }

    private void readMOs(boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        float[][] fArray = new float[this.nOrbitals][this.nOrbitals];
        for (n3 = 0; n3 < this.nOrbitals; ++n3) {
            n2 = -1;
            for (n = 0; n < this.nOrbitals; ++n) {
                if ((n2 = (n2 + 1) % 5) == 0) {
                    this.readLine();
                }
                fArray[n3][n] = this.parseFloat(this.line.substring(n2 * 15, (n2 + 1) * 15));
            }
        }
        if (!bl) {
            this.invMatrix = new float[this.nOrbitals][this.nOrbitals];
            for (n3 = 0; n3 < this.nOrbitals; ++n3) {
                n2 = -1;
                for (n = 0; n < n3 + 1; ++n) {
                    if ((n2 = (n2 + 1) % 5) == 0) {
                        this.readLine();
                    }
                    float f = this.parseFloat(this.line.substring(n2 * 15, (n2 + 1) * 15));
                    this.invMatrix[n][n3] = f;
                    this.invMatrix[n3][n] = f;
                }
            }
        }
        float[][] fArray2 = new float[this.nOrbitals][this.nOrbitals];
        for (n2 = 0; n2 < this.nOrbitals; ++n2) {
            for (n = 0; n < this.nOrbitals; ++n) {
                for (int i = 0; i < this.nOrbitals; ++i) {
                    float[] fArray3 = fArray2[n2];
                    int n4 = n;
                    fArray3[n4] = fArray3[n4] + fArray[n2][i] * this.invMatrix[i][n];
                }
                if (!(Math.abs(fArray2[n2][n]) < 1.0E-4f)) continue;
                fArray2[n2][n] = 0.0f;
            }
        }
        float[] fArray4 = new float[2];
        for (n = 0; n < this.nOrbitals; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            if (this.readLine() != null) {
                MopacGraphfReader.getTokensFloat(this.line, fArray4, 2);
                hashtable.put("energy", new Float(fArray4[0]));
                hashtable.put("occupancy", new Float(fArray4[1]));
            }
            hashtable.put("coefficients", fArray2[n]);
            if (bl) {
                hashtable.put("type", "beta");
            }
            this.orbitals.addElement(hashtable);
        }
        this.setMOs("eV");
    }

    private boolean readKeywords() throws Exception {
        boolean bl;
        if (this.readLine() == null || this.line.indexOf(" Keywords:") < 0) {
            return false;
        }
        this.calculationType = this.line.substring(11).trim();
        this.moData.put("calculationType", this.calculationType);
        boolean bl2 = bl = this.line.indexOf("UHF") >= 0;
        if (bl) {
            int n = this.orbitals.size();
            while (--n >= 0) {
                ((Hashtable)this.orbitals.get(n)).put("type", "alpha");
            }
        }
        return bl;
    }
}

