/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem;

import WIMSchem.CatalogLoader;
import WIMSchem.EditorPane;
import WIMSchem.MainWindow;
import WIMSchem.MolSelectListener;
import WIMSchem.Molecule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class CatalogWindow
extends JFrame
implements MolSelectListener,
ActionListener,
ComponentListener,
AdjustmentListener,
WindowListener {
    String catFN;
    FileInputStream istr = null;
    final int COL_SIZE = 5;
    int basepos = 0;
    int selnum = -1;
    int highestUpdated = 0;
    Color bckgr;
    Color highl;
    JScrollBar scroll;
    JButton bopen;
    JButton bclose;
    EditorPane[] entries;
    CatalogLoader loader = null;

    public CatalogWindow(String CatFN) {
        this.catFN = CatFN;
        this.setDefaultCloseOperation(2);
        JFrame.setDefaultLookAndFeelDecorated(false);
        this.setTitle("WIMSchem Catalog - " + this.catFN);
        this.bckgr = this.getBackground();
        this.highl = new Color(Math.max(this.bckgr.getRed() - 32, 0), Math.max(this.bckgr.getGreen() - 32, 0), this.bckgr.getBlue());
        ImageIcon mainIcon = new ImageIcon(this.getClass().getResource("/images/MainIcon.png"));
        this.setIconImage(mainIcon.getImage());
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 0));
        this.entries = new EditorPane[5];
        for (int n = 0; n < 5; ++n) {
            this.entries[n] = new EditorPane(100, 100);
            this.entries[n].setEditable(false);
            this.entries[n].setMolSelectListener(this);
            this.entries[n].setToolCursor();
            this.entries[n].setBorder(true);
            this.entries[n].setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            content.add(this.entries[n]);
        }
        gc.fill = 1;
        gc.gridwidth = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gb.setConstraints(content, gc);
        this.add(content);
        gc.fill = 2;
        gc.weighty = 0.0;
        this.scroll = new JScrollBar(0, 0, 0, 0, 0);
        this.scroll.addAdjustmentListener(this);
        gc.gridwidth = 5;
        gc.weightx = 1.0;
        gb.setConstraints(this.scroll, gc);
        this.add(this.scroll);
        this.bopen = new JButton("Open");
        this.bopen.addActionListener(this);
        this.bopen.setMnemonic(79);
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gb.setConstraints(this.bopen, gc);
        this.add(this.bopen);
        this.bclose = new JButton("Close");
        this.bclose.setMnemonic(67);
        this.bclose.addActionListener(this);
        gc.gridwidth = 1;
        gc.weightx = 0.0;
        gb.setConstraints(this.bclose, gc);
        this.add(this.bclose);
        this.setLayout(gb);
        this.pack();
        this.addComponentListener(this);
        this.addWindowListener(this);
        try {
            this.istr = new FileInputStream(this.catFN);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Catalog Read Failed", 0);
            this.dispose();
            return;
        }
        this.loader = new CatalogLoader(this, this.istr);
        this.loader.start();
    }

    public void synch(int Sz) {
        this.scroll.setMaximum(Sz);
        this.scroll.setVisibleAmount(5);
        this.scroll.setUnitIncrement(1);
        this.scroll.setBlockIncrement(5);
        if (this.basepos + 5 >= Sz || this.highestUpdated <= 5) {
            this.updatePosition(this.basepos);
        }
        this.highestUpdated = Sz;
    }

    private void updatePosition(int NewPos) {
        this.basepos = NewPos;
        try {
            for (int n = 0; n < 5; ++n) {
                if (this.basepos + n >= this.loader.count()) {
                    this.entries[n].setBackground(this.bckgr);
                    this.entries[n].clear();
                    continue;
                }
                Molecule mol = this.loader.get(this.basepos + n);
                this.entries[n].setBackground(this.basepos + n == this.selnum ? this.highl : this.bckgr);
                this.entries[n].replace(mol, true, false);
                this.entries[n].scaleToFit();
                this.entries[n].repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized void openMolecule(int N) {
        try {
            Molecule mol = this.loader.get(N);
            MainWindow mw = new MainWindow(null, false);
            mw.mainPanel().setMolecule(mol);
            mw.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void molSelected(EditorPane source, int idx, boolean dblclick) {
        int n;
        int entnum = -1;
        for (n = 0; n < 5; ++n) {
            if (source != this.entries[n]) continue;
            entnum = n;
            break;
        }
        if (entnum >= 0) {
            this.selnum = this.basepos + entnum;
            for (n = 0; n < 5; ++n) {
                this.entries[n].setBackground(n == entnum ? this.highl : this.bckgr);
                this.entries[n].repaint();
            }
            if (idx != 0) {
                this.openMolecule(this.selnum);
            }
        }
    }

    public void dirtyChanged(boolean isdirty) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bopen && this.selnum >= 0) {
            this.openMolecule(this.selnum);
        }
        if (e.getSource() == this.bclose) {
            if (this.loader != null) {
                this.loader.zap();
            }
            this.dispose();
            return;
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        for (int n = 0; n < 5; ++n) {
            this.entries[n].scaleToFit();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        int pos;
        if (e.getSource() == this.scroll && (pos = e.getValue()) != this.basepos) {
            this.updatePosition(pos);
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.loader.zap();
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

