/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.StringTokenizer;

class Line
extends DiagramItem {
    Line() {
    }

    Line(StringTokenizer stringTokenizer) throws Exception {
        super(stringTokenizer);
    }

    @Override
    void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!KansBoom.original) {
            int n = KansBoom.ysize / KansBoom.ygrid;
            int n2 = KansBoom.xsize / KansBoom.ygrid;
            if (this.state != 2) {
                this.y = n * Math.round(this.y / n);
                this.h = n * Math.round(this.h / n);
            }
            if (this.state == 1 || this.state == 2) {
                graphics2D.setColor(KansBoom.textcolor);
                graphics2D.setStroke(new BasicStroke(1.0f));
                if (KansBoom.textalign) {
                    for (int i = 0; i < KansBoom.ysize; i += n) {
                        graphics2D.drawLine(0, i, KansBoom.xsize, i);
                    }
                } else {
                    for (int i = 0; i < KansBoom.xsize; i += n2) {
                        graphics2D.drawLine(i, 0, i, KansBoom.ysize);
                    }
                }
            }
        }
        graphics2D.setColor(KansBoom.drawcolor);
        graphics2D.setStroke(new BasicStroke(KansBoom.thickness));
        graphics2D.drawLine(this.x, this.y, this.x + this.w, this.y + this.h);
        ++KansBoom.linecounter;
    }

    @Override
    String describe() {
        return "line," + this.x + "," + this.y + "," + (this.x + this.w) + "," + (this.y + this.h);
    }

    @Override
    String specify_text() {
        return null;
    }

    @Override
    int specify_text_x() {
        return -1;
    }

    @Override
    int specify_text_y() {
        return -1;
    }

    @Override
    int specify_line_x1() {
        return this.x;
    }

    @Override
    int specify_line_y1() {
        return this.y;
    }

    @Override
    int specify_line_x2() {
        return this.x + this.w;
    }

    @Override
    int specify_line_y2() {
        return this.y + this.h;
    }

    @Override
    double distance(int n, int n2) {
        double d;
        if (this.w == 0 && this.h == 0) {
            return Misc.distance(this.x, this.y, n, n2);
        }
        n -= this.x;
        n2 -= this.y;
        double d2 = Math.sqrt(this.w * this.w + this.h * this.h);
        double d3 = (double)this.w / d2;
        double d4 = (double)n * d3 + (double)n2 * (d = (double)this.h / d2);
        if (d4 < 0.0) {
            return Misc.distance(0.0, 0.0, n, n2);
        }
        if (d4 > d2) {
            return Misc.distance(this.w, this.h, n, n2);
        }
        return Misc.distance(d4 * d3, d4 * d, n, n2);
    }
}

