/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import rene.util.xml.XmlWriter;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.Count;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.MyGraphics13;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveCircleObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.TwoPointLineObject;
import rene.zirkel.structures.Coordinates;

public class RayObject
extends TwoPointLineObject {
    static Count N = new Count();

    public RayObject(Construction construction, PointObject pointObject, PointObject pointObject2) {
        super(construction, pointObject, pointObject2);
        this.validate();
        this.updateText();
    }

    public String getTag() {
        return "Ray";
    }

    public int getN() {
        return N.next();
    }

    public void updateText() {
        this.setText(RayObject.text2(Zirkel.name("text.ray"), this.P1.getName(), this.P2.getName()));
    }

    public void validate() {
        if (!this.P1.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X1 = this.P1.getX();
        this.Y1 = this.P1.getY();
        this.X2 = this.P2.getX();
        this.Y2 = this.P2.getY();
        this.DX = this.X2 - this.X1;
        this.DY = this.Y2 - this.Y1;
        this.R = Math.sqrt(this.DX * this.DX + this.DY * this.DY);
        if (this.R < 1.0E-10) {
            this.Valid = false;
            return;
        }
        this.DX /= this.R;
        this.DY /= this.R;
    }

    public void paint(MyGraphics myGraphics, ZirkelCanvas zirkelCanvas) {
        String string;
        double d2;
        double d3;
        double d4;
        if (!this.Valid || this.mustHide(zirkelCanvas)) {
            return;
        }
        double d5 = (zirkelCanvas.minX() + zirkelCanvas.maxX()) / 2.0;
        double d6 = (zirkelCanvas.minY() + zirkelCanvas.maxY()) / 2.0;
        double d7 = (d5 - this.X1) * this.DY - (d6 - this.Y1) * this.DX;
        double d8 = d5 - d7 * this.DY;
        double d9 = d6 + d7 * this.DX;
        double d10 = Math.max(zirkelCanvas.maxX() - zirkelCanvas.minX(), zirkelCanvas.maxY() - zirkelCanvas.minY());
        if (Math.abs(d7) > d10) {
            return;
        }
        double d11 = (d8 - this.X1) * this.DX + (d9 - this.Y1) * this.DY;
        this.k1 = d11 - d10;
        this.k2 = d11 + d10;
        this.k12valid = true;
        if (this.k1 < 0.0) {
            this.k1 = 0.0;
        }
        if (this.k1 >= this.k2) {
            return;
        }
        if (this.Partial && !zirkelCanvas.showHidden() && this.Dep != null) {
            d4 = (zirkelCanvas.maxX() - zirkelCanvas.minX()) / 20.0;
            d3 = -d4;
            d2 = this.R + d4;
            for (int i = 0; i < this.NDep; ++i) {
                if (!this.Dep[i].valid() || this.Dep[i].mustHide(zirkelCanvas)) continue;
                double d12 = this.project(this.Dep[i].getX(), this.Dep[i].getY());
                if (d12 - d4 < d3) {
                    d3 = d12 - d4;
                    continue;
                }
                if (!(d12 + d4 > d2)) continue;
                d2 = d12 + d4;
            }
            if (this.k1 < d3) {
                this.k1 = d3;
            }
            if (this.k2 > d2) {
                this.k2 = d2;
            }
        }
        d4 = zirkelCanvas.col(this.X1 + this.k1 * this.DX);
        d3 = zirkelCanvas.col(this.X1 + this.k2 * this.DX);
        d2 = zirkelCanvas.row(this.Y1 + this.k1 * this.DY);
        double d13 = zirkelCanvas.row(this.Y1 + this.k2 * this.DY);
        if (this.isStrongSelected() && myGraphics instanceof MyGraphics13) {
            ((MyGraphics13)myGraphics).drawMarkerLine(d4, d2, d3, d13);
        }
        myGraphics.setColor(this);
        if (this.visible(zirkelCanvas)) {
            myGraphics.drawLine(d4, d2, d3, d13, this);
        }
        if (!(string = this.getDisplayText()).equals("")) {
            myGraphics.setLabelColor(this);
            this.DisplaysText = true;
            double d14 = -d11 + d10 / 5.0;
            if (d14 < -d10 / 5.0) {
                d14 = -d10 / 5.0;
            } else if (d14 > d10 / 5.0) {
                d14 = d10 / 5.0;
            }
            if (d14 < -d11 + d10 / 10.0) {
                d14 = -d11 + d10 / 10.0;
            }
            if (this.KeepClose) {
                double d15 = this.YcOffset < 0.0 ? 1.0 : -1.0;
                this.drawLabel(myGraphics, string, zirkelCanvas, this.X1 + this.XcOffset * (this.X2 - this.X1), this.Y1 + this.XcOffset * (this.Y2 - this.Y1), d15 * this.DX, d15 * this.DY, 0.0, 0.0);
            } else {
                this.drawLabel(myGraphics, string, zirkelCanvas, d8 + d14 * this.DX, d9 + d14 * this.DY, this.DX, this.DY, this.XcOffset, this.YcOffset);
            }
        }
    }

    public boolean canKeepClose() {
        return true;
    }

    public void setKeepClose(double d2, double d3) {
        this.KeepClose = true;
        this.XcOffset = (d2 - this.X1) / this.R * this.DX + (d3 - this.Y1) / this.R * this.DY;
        this.YcOffset = (d2 - this.X1) / this.R * this.DY - (d3 - this.Y1) / this.R * this.DX;
    }

    public String getDisplayValue() {
        return "" + this.round(this.R, ZirkelCanvas.LengthsFactor);
    }

    public boolean nearto(int n, int n2, ZirkelCanvas zirkelCanvas) {
        double d2;
        if (!this.displays(zirkelCanvas)) {
            return false;
        }
        double d3 = zirkelCanvas.x(n);
        double d4 = zirkelCanvas.y(n2);
        double d5 = (d3 - this.X1) * this.DY - (d4 - this.Y1) * this.DX;
        double d6 = (d3 - this.X1) * this.DX + (d4 - this.Y1) * this.DY;
        double d7 = (this.X2 - this.X1) * this.DX + (this.Y2 - this.Y1) * this.DY;
        if (d7 > 0.0) {
            if (d6 < 0.0) {
                d5 = Math.sqrt((d3 - this.X1) * (d3 - this.X1) + (d4 - this.Y1) * (d4 - this.Y1));
            }
        } else if (d6 > 0.0) {
            d5 = Math.sqrt((d3 - this.X1) * (d3 - this.X1) + (d4 - this.Y1) * (d4 - this.Y1));
        }
        if ((d2 = this.project(d3, d4)) < this.k1 || d2 > this.k2) {
            return false;
        }
        this.Value = Math.abs(zirkelCanvas.col(zirkelCanvas.minX() + d5) - zirkelCanvas.col(zirkelCanvas.minX()));
        return this.Value < zirkelCanvas.selectionSize() * 2.0;
    }

    public void printArgs(XmlWriter xmlWriter) {
        xmlWriter.printArg("from", this.P1.getName());
        xmlWriter.printArg("to", this.P2.getName());
        super.printArgs(xmlWriter);
    }

    public boolean contains(double d2, double d3) {
        double d4 = (d2 - this.X1) * this.DX + (d3 - this.Y1) * this.DY;
        return !(d4 < 1.0E-9);
    }

    public double project(double d2, double d3) {
        double d4 = super.project(d2, d3);
        if (d4 < 0.0) {
            return 0.0;
        }
        return d4;
    }

    public boolean equals(ConstructionObject constructionObject) {
        if (!(constructionObject instanceof RayObject) || !constructionObject.valid()) {
            return false;
        }
        RayObject rayObject = (RayObject)constructionObject;
        return this.equals(this.X1, rayObject.X1) && this.equals(this.Y1, rayObject.Y1) && this.equals(this.DX, rayObject.DX) && this.equals(this.DY, rayObject.DY);
    }

    public static Coordinates intersect(PrimitiveLineObject primitiveLineObject, PrimitiveLineObject primitiveLineObject2) {
        double d2 = -primitiveLineObject.DX * primitiveLineObject2.DY + primitiveLineObject.DY * primitiveLineObject2.DX;
        if (Math.abs(d2) < 1.0E-10) {
            return null;
        }
        double d3 = (-(primitiveLineObject2.X1 - primitiveLineObject.X1) * primitiveLineObject2.DY + (primitiveLineObject2.Y1 - primitiveLineObject.Y1) * primitiveLineObject2.DX) / d2;
        return new Coordinates(primitiveLineObject.X1 + d3 * primitiveLineObject.DX, primitiveLineObject.Y1 + d3 * primitiveLineObject.DY);
    }

    public static Coordinates intersect(PrimitiveLineObject primitiveLineObject, PrimitiveCircleObject primitiveCircleObject) {
        double d2 = primitiveCircleObject.getX();
        double d3 = primitiveCircleObject.getY();
        double d4 = primitiveCircleObject.getR();
        double d5 = (d2 - primitiveLineObject.X1) * primitiveLineObject.DY - (d3 - primitiveLineObject.Y1) * primitiveLineObject.DX;
        if (Math.abs(d5) > d4 + 1.0E-10) {
            return null;
        }
        double d6 = d4 * d4 - d5 * d5;
        d6 = d6 > 0.0 ? Math.sqrt(d6) : 0.0;
        return new Coordinates((d2 -= d5 * primitiveLineObject.DY) + d6 * primitiveLineObject.DX, (d3 += d5 * primitiveLineObject.DX) + d6 * primitiveLineObject.DY, d2 - d6 * primitiveLineObject.DX, d3 - d6 * primitiveLineObject.DY);
    }
}

