/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MPRIS_CONTROLLER_ADAPTOR_H
#define MPRIS_CONTROLLER_ADAPTOR_H

#include <QtCore/QObject>
#include <QtDBus/QtDBus>
QT_BEGIN_NAMESPACE
class QByteArray;
template<class T> class QList;
template<class Key, class Value> class QMap;
class QString;
class QVariant;
QT_END_NAMESPACE

/*
 * Adaptor class for interface org.ukui.mpris.controller
 */
class MprisControllerAdaptor: public QDBusAbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.mpris.controller")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.ukui.mpris.controller\">\n"
"    <property access=\"read\" type=\"as\" name=\"supportOperations\"/>\n"
"    <method name=\"operation\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"operation\"/>\n"
"    </method>\n"
"  </interface>\n"
        "")
public:
    MprisControllerAdaptor(QObject *parent);
    virtual ~MprisControllerAdaptor();

public: // PROPERTIES
    Q_PROPERTY(QStringList supportOperations READ supportOperations)
    QStringList supportOperations() const;

public Q_SLOTS: // METHODS
    void operation(const QString &operation);
Q_SIGNALS: // SIGNALS
};

#endif
