/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GLOBALSETTINGS_H
#define GLOBALSETTINGS_H

#include <QDBusVariant>
#include <QSettings>
#include <QObject>
#include <QDebug>
#include <QFile>
#include <QDir>

#include "clib-syslog.h"
#include "usd_base_class.h"

class GlobalConfig : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface","com.settings.daemon.interface")
public:
    explicit GlobalConfig(QObject *parent = nullptr);
    ~GlobalConfig();
public Q_SLOTS:
    /**
     * @brief getGlobalConf 获取全局配置
     * @param schema 主题
     * @param key 键值
     * @return
     */
    QDBusVariant getGlobalConf(QString schema, QString key);
    /**
     * @brief setGlobalConf 设置全局配置
     * @param schema 主题
     * @param key 键值
     * @param value 值
     * @return
     */
    bool setGlobalConf(QString schema, QString key, QDBusVariant value);

    bool setGlobalConf1(QString schema, QString key, QString value);

Q_SIGNALS:
    /**
     * @brief globalConfChanged
     * @param schema
     * @param key
     * @param value
     * 是否需要此信号？？或许多用户时需要。。
     */
    void globalConfChanged(QString schema, QString key, QDBusVariant value);
};

#endif // GLOBALSETTINGS_H
