/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_DIRENTRY_H
#define _SVN_DIRENTRY_H

// sc
#include "svn.h"
#include "DirEntryTypes.h"
#include "util/String.h"

// svn
struct svn_dirent_t;


namespace svn
{

/**
 * This class represents subversions svn_dirent_t.
 */
class DirEntry
{
public:
  DirEntry( const sc::String& );
  DirEntry( const sc::String&, svn_dirent_t* );

  const sc::String& getName() const;

  NodeKind getKind() const;
  bool isDir() const;
  bool isFile() const;

  Filesize getSize() const;
  bool hasProperties() const;

  Revnumber getLastRevision() const;
  Date getLastDate() const;

  const sc::String& getLastAuthor() const;

  bool isNop() const;

private:
  sc::String _name;
  bool       _nop;

  // svn_dirent_t
  NodeKind   _kind;
  Filesize   _size;
  bool       _props;
  Revnumber  _rev;
  Date       _date;
  sc::String _author;
};

} // namespace

#endif // _SVN_DIRENTRY_H

