/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _ASSERTIONTRAIT_QSTRING_H
#define _ASSERTIONTRAIT_QSTRING_H

// sc
#include "util/uuid.h"
#include "util/String.h"

// qt
#include <QtCore/QString>


/** This adds QString support to CPPUNIT_ASSERT_EQUALS. */
template<> struct CPPUNIT_NS::assertion_traits<QString>
{
  static bool equal( const QString& x, const QString& y )
  {
    return x == y;
  }

  static std::string toString( const QString& x )
  {
    OStringStream ost;
    ost << "\"";
    ost << (const char*)x.toAscii();
    ost << "\"";
    return ost.str();
  }
};


#endif // _ASSERTIONTRAIT_QSTRING_H
