/*
  sqclient -- gets a page from squid cache or purge it
  Copyright (C) 2003  Pedro Zorzenon Neto <pzn@autsens.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "htmlchk.h"
#include "sqclient.h"
#include "url.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/wait.h>

/* debug purposes */
//#define SQCLIENT_VERBOSE

int sqclient_retrieve_if_in_cache (char * url, char * outfile) {
  int i;
  char * s;
  char * urlf;

  urlf = malloc ((strlen(url)*3)+1);
  assert (urlf != NULL);

  url_filter (url, urlf);
  
  s = malloc (strlen(urlf)+200);
  assert (s != NULL);

  sprintf(s, SQUIDCLIENT " "
	  SQUIDCLIENTARGS " "
	  " -m GET "
	  "-H \"Cache-control: Only-if-cached\\n\" "
	  "'%s' "
	  "> %s 2>/dev/null", urlf, outfile);

#ifdef SQCLIENT_VERBOSE
  fprintf(stderr,"sqclient: checking cache: %s\n",urlf);
#endif

  i=system(s);
  if (i!=0)
    {
      fprintf(stderr,"sqclient: system call failed. ERR:%d CMD:%s\n",i,s);
    }
  
  free(urlf);
  free(s);
  
  if (i == 0)
    {
      return 1;
    }

  return 0;

}

void sqclient_purge_from_cache(char * url) {
  int i;
  char * s;
  char * urlf;

#ifdef SQCLIENT_VERBOSE
  fprintf(stderr,"sqclient: PURGING from cache: %s\n",url);
#endif

  urlf = malloc ((strlen(url)*3)+1);
  assert (urlf != NULL);

  url_filter (url, urlf);
  
  s = malloc (strlen(urlf)+200);
  assert (s != NULL);

  sprintf(s, SQUIDCLIENT " "
	  SQUIDCLIENTARGS " "
	  "-m PURGE "
	  "'%s' "
	  "> /dev/null 2>&1", urlf);

  i=system(s);
  if (i!=0)
    {
      fprintf(stderr,"sqclient: system call failed. ERR:%d CMD:%s\n",i,s);
    }

  free(urlf);
  free(s);

}
