//! Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline 25519_scalar 64 '2^252 + 27742317777372353535851937790883648493' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//! curve description: 25519_scalar
//! machine_wordsize = 64 (from "64")
//! requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//! m = 0x1000000000000000000000000000000014def9dea2f79cd65812631a5cf5d3ed (from "2^252 + 27742317777372353535851937790883648493")
//!
//! NOTE: In addition to the bounds specified above each function, all
//!   functions synthesized for this Montgomery arithmetic require the
//!   input to be strictly less than the prime modulus (m), and also
//!   require the input to be in the unique saturated representation.
//!   All functions also ensure that these two properties are true of
//!   return values.
//!
//! Computed values:
//!   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//!   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//!   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//!                            if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256

#![allow(unused_parens)]
#![allow(non_camel_case_types)]

/** fiat_25519_scalar_u1 represents values of 1 bits, stored in one byte. */
pub type fiat_25519_scalar_u1 = u8;
/** fiat_25519_scalar_i1 represents values of 1 bits, stored in one byte. */
pub type fiat_25519_scalar_i1 = i8;
/** fiat_25519_scalar_u2 represents values of 2 bits, stored in one byte. */
pub type fiat_25519_scalar_u2 = u8;
/** fiat_25519_scalar_i2 represents values of 2 bits, stored in one byte. */
pub type fiat_25519_scalar_i2 = i8;

/** The type fiat_25519_scalar_montgomery_domain_field_element is a field element in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_25519_scalar_montgomery_domain_field_element(pub [u64; 4]);

impl core::ops::Index<usize> for fiat_25519_scalar_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_25519_scalar_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}

/** The type fiat_25519_scalar_non_montgomery_domain_field_element is a field element NOT in the Montgomery domain. */
/** Bounds: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]] */
#[derive(Clone, Copy)]
pub struct fiat_25519_scalar_non_montgomery_domain_field_element(pub [u64; 4]);

impl core::ops::Index<usize> for fiat_25519_scalar_non_montgomery_domain_field_element {
    type Output = u64;
    #[inline]
    fn index(&self, index: usize) -> &Self::Output {
        &self.0[index]
    }
}

impl core::ops::IndexMut<usize> for fiat_25519_scalar_non_montgomery_domain_field_element {
    #[inline]
    fn index_mut(&mut self, index: usize) -> &mut Self::Output {
        &mut self.0[index]
    }
}


/// The function fiat_25519_scalar_addcarryx_u64 is an addition with carry.
///
/// Postconditions:
///   out1 = (arg1 + arg2 + arg3) mod 2^64
///   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_scalar_addcarryx_u64(out1: &mut u64, out2: &mut fiat_25519_scalar_u1, arg1: fiat_25519_scalar_u1, arg2: u64, arg3: u64) {
  let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: fiat_25519_scalar_u1 = ((x1 >> 64) as fiat_25519_scalar_u1);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_scalar_subborrowx_u64 is a subtraction with borrow.
///
/// Postconditions:
///   out1 = (-arg1 + arg2 + -arg3) mod 2^64
///   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0x1]
#[inline]
pub fn fiat_25519_scalar_subborrowx_u64(out1: &mut u64, out2: &mut fiat_25519_scalar_u1, arg1: fiat_25519_scalar_u1, arg2: u64, arg3: u64) {
  let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
  let x2: fiat_25519_scalar_i1 = ((x1 >> 64) as fiat_25519_scalar_i1);
  let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
  *out1 = x3;
  *out2 = (((0x0 as fiat_25519_scalar_i2) - (x2 as fiat_25519_scalar_i2)) as fiat_25519_scalar_u1);
}

/// The function fiat_25519_scalar_mulx_u64 is a multiplication, returning the full double-width result.
///
/// Postconditions:
///   out1 = (arg1 * arg2) mod 2^64
///   out2 = ⌊arg1 * arg2 / 2^64⌋
///
/// Input Bounds:
///   arg1: [0x0 ~> 0xffffffffffffffff]
///   arg2: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
///   out2: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_25519_scalar_mulx_u64(out1: &mut u64, out2: &mut u64, arg1: u64, arg2: u64) {
  let x1: u128 = ((arg1 as u128) * (arg2 as u128));
  let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
  let x3: u64 = ((x1 >> 64) as u64);
  *out1 = x2;
  *out2 = x3;
}

/// The function fiat_25519_scalar_cmovznz_u64 is a single-word conditional move.
///
/// Postconditions:
///   out1 = (if arg1 = 0 then arg2 else arg3)
///
/// Input Bounds:
///   arg1: [0x0 ~> 0x1]
///   arg2: [0x0 ~> 0xffffffffffffffff]
///   arg3: [0x0 ~> 0xffffffffffffffff]
/// Output Bounds:
///   out1: [0x0 ~> 0xffffffffffffffff]
#[inline]
pub fn fiat_25519_scalar_cmovznz_u64(out1: &mut u64, arg1: fiat_25519_scalar_u1, arg2: u64, arg3: u64) {
  let x1: fiat_25519_scalar_u1 = (!(!arg1));
  let x2: u64 = ((((((0x0 as fiat_25519_scalar_i2) - (x1 as fiat_25519_scalar_i2)) as fiat_25519_scalar_i1) as i128) & (0xffffffffffffffff as i128)) as u64);
  let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
  *out1 = x3;
}

/// The function fiat_25519_scalar_mul multiplies two field elements in the Montgomery domain.
///
/// Preconditions:
///   0 ≤ eval arg1 < m
///   0 ≤ eval arg2 < m
/// Postconditions:
///   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
///   0 ≤ eval out1 < m
///
#[inline]
pub fn fiat_25519_scalar_mul(out1: &mut fiat_25519_scalar_montgomery_domain_field_element, arg1: &fiat_25519_scalar_montgomery_domain_field_element, arg2: &fiat_25519_scalar_montgomery_domain_field_element) {
  let x1: u64 = (arg1[1]);
  let x2: u64 = (arg1[2]);
  let x3: u64 = (arg1[3]);
  let x4: u64 = (arg1[0]);
  let mut x5: u64 = 0;
  let mut x6: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x5, &mut x6, x4, (arg2[3]));
  let mut x7: u64 = 0;
  let mut x8: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x7, &mut x8, x4, (arg2[2]));
  let mut x9: u64 = 0;
  let mut x10: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x9, &mut x10, x4, (arg2[1]));
  let mut x11: u64 = 0;
  let mut x12: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x11, &mut x12, x4, (arg2[0]));
  let mut x13: u64 = 0;
  let mut x14: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x13, &mut x14, 0x0, x12, x9);
  let mut x15: u64 = 0;
  let mut x16: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x15, &mut x16, x14, x10, x7);
  let mut x17: u64 = 0;
  let mut x18: fiat_25519_scalar_u1 = 0;
  fiat_25519_scalar_addcarryx_u64(&mut x17, &mut x18, x16, x8, x5);
  let x19: u64 = ((x18 as u64) + x6);
  let mut x20: u64 = 0;
  let mut x21: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x20, &mut x21, x11, 0xd2b51da312547e1b);
  let mut x22: u64 = 0;
  let mut x23: u64 = 0;
  fiat_25519_scalar_mulx_u64(&mut x2