% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.r
\name{mutate}
\alias{mutate}
\title{Mutate a data frame by adding new or replacing existing columns.}
\usage{
mutate(.data, ...)
}
\arguments{
\item{.data}{the data frame to transform}

\item{...}{named parameters giving definitions of new columns.}
}
\description{
This function is very similar to \code{\link{transform}} but it executes
the transformations iteratively so that later transformations can use the
columns created by earlier transformations.  Like transform, unnamed
components are silently dropped.
}
\details{
Mutate seems to be considerably faster than transform for large data
frames.
}
\examples{
# Examples from transform
mutate(airquality, Ozone = -Ozone)
mutate(airquality, new = -Ozone, Temp = (Temp - 32) / 1.8)

# Things transform can't do
mutate(airquality, Temp = (Temp - 32) / 1.8, OzT = Ozone / Temp)

# mutate is rather faster than transform
system.time(transform(baseball, avg_ab = ab / g))
system.time(mutate(baseball, avg_ab = ab / g))
}
\seealso{
\code{\link{subset}}, \code{\link{summarise}},
  \code{\link{arrange}}.  For another somewhat different approach to
  solving the same problem, see \code{\link{within}}.
}

