% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde_tidiers.R
\name{kde_tidiers}
\alias{kde_tidiers}
\alias{tidy.kde}
\title{Tidy a kernel density estimate object from the ks package}
\usage{
\method{tidy}{kde}(x, ...)
}
\arguments{
\item{x}{A "ks" object from the kde package}

\item{...}{Extra arguments, not used}
}
\value{
A data frame with one row for each point in the
estimated grid. The result contains one column (named \code{x1},
\code{x2}, etc) for each dimension, and an \code{estimate} column
containing the estimated density.
}
\description{
Tidy a kernel density estimate object, into a table with
one row for each point in the estimated grid, and one column
for each dimension (along with an \code{estimate} column with
the estimated density).
}
\examples{

if (require("ks", quietly = TRUE)) {
  dat <- replicate(2, rnorm(100))
  k <- kde(dat)
  
  td <- tidy(k)
  head(td)
  
  library(ggplot2)
  ggplot(td, aes(x1, x2, fill = estimate)) +
    geom_tile() +
    theme_void()
  
  # also works with 3 dimensions
  dat3 <- replicate(3, rnorm(100))
  k3 <- kde(dat3)
  
  td3 <- tidy(k3)
  head(td3)
}

}
