# Community Applications

Welcome to the communty page of trame applications. This page aims to showcase what people are doing with trame and maybe spark some collaboration.
If you would like to see your application listed below, please submit a MR adding your project to that [markdown](https://github.com/Kitware/trame/blob/master/docs/vitepress/examples/apps/community.md).

<!-- [[toc]] -->

## [Parsli](https://github.com/brendanjmeade/parsli)

Parsli is a VTK based viewer for fault system kinematics that enables fast exploration and export of time animation.
This software available on PyPI is the result of a collaboration between [Kitware](https://www.kitware.com/trame/) and Brendan Meade, a Professor of Earth & Planetary Sciences at Harvard University. 

![Parsli](/assets/images/apps/parsli.png)

## [Drill Down](https://github.com/cardinalgeo/drilldown)

DrillDown is a visualization and analysis toolkit for "drilling down" into ore deposits datasets.

![poster](https://raw.githubusercontent.com/cardinalgeo/drilldown/refs/heads/main/media/poster.jpg)

## [ImpactX Dashboard](https://impactx.readthedocs.io/en/latest/usage/dashboard.html)

[ImpactX Dashboard](https://impactx.readthedocs.io/en/latest/usage/dashboard.html) is a browser-based interface to the beam dynamics code [ImpactX](https://github.com/ECP-WarpX/impactx).
The purpose of the application is to interactively design particle accelerator beamlines, run simulations and analyze them.

![ImpactX Dashboard](https://gist.githubusercontent.com/ax3l/b56aa3c3261f9612e276f3198b34f771/raw/11bfe461a24e1daa7fd2d663c686b0fcc2b6e305/dashboard.png)

## [MRI Viewer](https://github.com/karelvrabeckv/mri-viewer)

MRI Viewer is a web application **for analyzing and visualizing VTI files**. The purpose of the application is to simplify scientific work **with 4D flow MRI medical data**. The tool is oriented especially **towards researchers**. It was created for **the Institute for Clinical and Experimental Medicine** in Prague, Czech Republic.

<table>
  <tr>
    <td><img src="https://raw.githubusercontent.com/karelvrabeckv/mri-viewer/main/assets/aorta.png" alt="Aorta"></td>
    <td><img src="https://raw.githubusercontent.com/karelvrabeckv/mri-viewer/main/assets/brain.png" alt="Brain"></td>
  </tr>
</table>

## AI/Medical application

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7093253518769201153" height="997" width="504" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## [SpinView](https://mxjk851.github.io/SpinView/)

SpinView is a general interactive visual analysis tool developed for multiscale computational magnetism that allow users with interdisciplinary backgrounds to simplified their own workflow, speeds up analysis of complex datasets and trajectories, and enables new types of analysis.

![landing](https://raw.githubusercontent.com/MXJK851/SpinView/main/docs/assets/readme.png)

The key features are:

- User friendly: Enjoy the combination of Command-line-interface, WebUI and DesktopUI
- Post-processing: Denoising, Clip, Rescaling, try the visual exploration and data mining with SpinView!
- Feature-rich 3D visualization: Visualize your simulation result with glyphs, e.g., sphere, cone, arrow, plane, box, and any 3D models generated by yourself. Overlap everything including reconstructed mesh and isosurface.
- Extendable: Currently support .out (UppASD), Non-binary .ovf (Mumax3, OOMMF, Spirit), and .data (Vampire) output files and can easily extend to other magnetic simulation code.
- Shareable: Take snapshoot, rendering a trajectory video, make a portable interactive HTML file with only one click!
- Community support: Open-source (GPL V3) and free to use, based on Python, Pandas, Numpy, Scipy, Trame, and Pyvista.
