/*
 *	Copyright (C) 2007-2009 Gabest
 *	http://www.gabest.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

#pragma once

#include "GSDeviceDX.h"
#include "GSTexture9.h"

struct Direct3DSamplerState9
{
    D3DTEXTUREFILTERTYPE FilterMin[2];
    D3DTEXTUREFILTERTYPE FilterMag[2];
	D3DTEXTUREFILTERTYPE FilterMip[2];
	D3DTEXTUREFILTERTYPE Anisotropic[2];
    D3DTEXTUREADDRESS AddressU;
    D3DTEXTUREADDRESS AddressV;
	D3DTEXTUREADDRESS AddressW;
	DWORD MaxAnisotropy;
	DWORD MaxLOD;
};

struct Direct3DDepthStencilState9
{
    BOOL DepthEnable;
    BOOL DepthWriteMask;
    D3DCMPFUNC DepthFunc;
    BOOL StencilEnable;
    UINT8 StencilReadMask;
    UINT8 StencilWriteMask;
    D3DSTENCILOP StencilFailOp;
    D3DSTENCILOP StencilDepthFailOp;
    D3DSTENCILOP StencilPassOp;
    D3DCMPFUNC StencilFunc;
	uint32 StencilRef;
};

struct Direct3DBlendState9
{
    BOOL BlendEnable;
    D3DBLEND SrcBlend;
    D3DBLEND DestBlend;
    D3DBLENDOP BlendOp;
    D3DBLEND SrcBlendAlpha;
    D3DBLEND DestBlendAlpha;
    D3DBLENDOP BlendOpAlpha;
    UINT8 RenderTargetWriteMask;
};

struct GSVertexShader9
{
	CComPtr<IDirect3DVertexShader9> vs;
	CComPtr<IDirect3DVertexDeclaration9> il;
};

class GSDevice9 : public GSDeviceDX
{
	GSTexture* CreateSurface(int type, int w, int h, bool msaa, int format);

	void DoMerge(GSTexture* sTex[3], GSVector4* sRect, GSTexture* dTex, GSVector4* dRect, const GSRegPMODE& PMODE, const GSRegEXTBUF& EXTBUF, const GSVector4& c);
	void DoInterlace(GSTexture* sTex, GSTexture* dTex, int shader, bool linear, float yoffset = 0);
	void DoFXAA(GSTexture* sTex, GSTexture* dTex);
	void DoShadeBoost(GSTexture* sTex, GSTexture* dTex);
	void DoExternalFX(GSTexture* sTex, GSTexture* dTex);

	void InitExternalFX();
	void InitFXAA();

	//

	D3DCAPS9 m_d3dcaps;
	D3DPRESENT_PARAMETERS m_pp;
	CComPtr<IDirect3D9> m_d3d;
	CComPtr<IDirect3DDevice9> m_dev;
	CComPtr<IDirect3DSwapChain9> m_swapchain;
	CComPtr<IDirect3DVertexBuffer9> m_vb;
	CComPtr<IDirect3DVertexBuffer9> m_vb_old;
	CComPtr<IDirect3DIndexBuffer9> m_ib;
	CComPtr<IDirect3DIndexBuffer9> m_ib_old;
	bool m_lost;
	D3DFORMAT m_depth_format;

	int m_mipmap;

	struct
	{
		IDirect3DVertexBuffer9* vb;
		size_t vb_stride;
		IDirect3DIndexBuffer9* ib;
		IDirect3DVertexDeclaration9* layout;
		D3DPRIMITIVETYPE topology;
		IDirect3DVertexShader9* vs;
		float* vs_cb;
		int vs_cb_len;
		IDirect3DTexture9* ps_srvs[3];
		IDirect3DPixelShader9* ps;
		float* ps_cb;
		int ps_cb_len;
		Direct3DSamplerState9* ps_ss;
		GSVector4i scissor;
		Direct3DDepthStencilState9* dss;
		Direct3DBlendState9* bs;
		uint32 bf;
		IDirect3DSurface9* rtv;
		IDirect3DSurface9* dsv;
	} m_state;

public: // TODO

	bool FXAA_Compiled;
	bool ExShader_Compiled;

	struct
	{
		CComPtr<IDirect3DVertexDeclaration9> il;
		CComPtr<IDirect3DVertexShader9> vs;
		CComPtr<IDirect3DPixelShader9> ps[10];
		Direct3DSamplerState9 ln;
		Direct3DSamplerState9 pt;
		Direct3DDepthStencilState9 dss;
		Direct3DBlendState9 bs;
	} m_convert;

	struct
	{
		CComPtr<IDirect3DPixelShader9> ps[2];
		Direct3DBlendState9 bs;
	} m_merge;

	struct
	{
		CComPtr<IDirect3DPixelShader9> ps[4];
	} m_interlace;

	struct
	{
		CComPtr<IDirect3DPixelShader9> ps;
	} m_shaderfx;

	struct
	{
		CComPtr<IDirect3DPixelShader9> ps;
	} m_fxaa;

	struct
	{
		CComPtr<IDirect3DPixelShader9> ps;
	} m_shadeboost;

	struct
	{
		Direct3DDepthStencilState9 dss;
		Direct3DBlendState9 bs;
	} m_date;

	void SetupDATE(GSTexture* rt, GSTexture* ds, const GSVertexPT1* vertices, bool datm);

	// Shaders...

	std::unordered_map<uint32, GSVertexShader9> m_vs;
	std::unordered_map<uint64, CComPtr<IDirect3DPixelShader9>> m_ps;
	std::unordered_map<uint32, Direct3DSamplerState9*> m_ps_ss;
	std::unordered_map<uint32, Direct3DDepthStencilState9*> m_om_dss;
	std::unordered_map<uint32, Direct3DBlendState9*> m_om_bs;
	std::unordered_map<uint32, GSTexture*> m_mskfix;

	GSTexture* CreateMskFix(uint32 size, uint32 msk, uint32 fix);

public:
	GSDevice9();
	virtual ~GSDevice9();

	bool Create(const std::shared_ptr<GSWnd> &wnd);
	bool Reset(int w, int h);
	bool IsLost(bool update);
	void Flip();

	void SetVSync(int vsync);

	void BeginScene();
	void DrawPrimitive();
	void DrawIndexedPrimitive();
	void EndScene();

	void ClearRenderTarget(GSTexture* t, const GSVector4& c);
	void ClearRenderTarget(GSTexture* t, uint32 c);
	void ClearDepth(GSTexture* t);
	void ClearStencil(GSTexture* t, uint8 c);

	GSTexture* CreateRenderTarget(int w, int h, bool msaa, int format = 0);
	GSTexture* CreateDepthStencil(int w, int h, bool msaa, int format = 0);
	GSTexture* CreateTexture(int w, int h, int format = 0);
	GSTexture* CreateOffscreen(int w, int h, int format = 0);

	GSTexture* Resolve(GSTexture* t);

	GSTexture* CopyOffscreen(GSTexture* src, const GSVector4& sRect, int w, int h, int format = 0, int ps_shader = 0);

	void CopyRect(GSTexture* sTex, GSTexture* dTex, const GSVector4i& r);

	void StretchRect(GSTexture* sTex, const GSVector4& sRect, GSTexture* dTex, const GSVector4& dRect, int shader = 0, bool linear = true);
	void StretchRect(GSTexture* sTex, const GSVector4& sRect, GSTexture* dTex, const GSVector4& dRect, IDirect3DPixelShader9* ps, const float* ps_cb, int ps_cb_len, bool linear = true);
	void StretchRect(GSTexture* sTex, const GSVector4& sRect, GSTexture* dTex, const GSVector4& dRect, IDirect3DPixelShader9* ps, const float* ps_cb, int ps_cb_len, Direct3DBlendState9* bs, bool linear = true);

	void IASetVertexBuffer(const void* vertex, size_t stride, size_t count);
	bool IAMapVertexBuffer(void** vertex, size_t stride, size_t count);
	void IAUnmapVertexBuffer();
	void IASetVertexBuffer(IDirect3DVertexBuffer9* vb, size_t stride);
	void IASetIndexBuffer(const void* index, size_t count);
	void IASetIndexBuffer(IDirect3DIndexBuffer9* ib);
	void IASetInputLayout(IDirect3DVertexDeclaration9* layout);
	void IASetPrimitiveTopology(D3DPRIMITIVETYPE topology);
	void VSSetShader(IDirect3DVertexShader9* vs, const float* vs_cb, int vs_cb_len);
	void PSSetShaderResources(GSTexture* sr0, GSTexture* sr1);
	void PSSetShaderResource(int i, GSTexture* sr);
	void PSSetShader(IDirect3DPixelShader9* ps, const float* ps_cb, int ps_cb_len);
	void PSSetSamplerState(Direct3DSamplerState9* ss);
	void OMSetDepthStencilState(Direct3DDepthStencilState9* dss);
	void OMSetBlendState(Direct3DBlendState9* bs, uint32 bf);
	void OMSetRenderTargets(GSTexture* rt, GSTexture* ds, const GSVector4i* scissor = NULL);

	IDirect3DDevice9* operator->() {return m_dev;}
	operator IDirect3DDevice9*() {return m_dev;}

	void CompileShader(const char *source, size_t size, const char *filename, const std::string& entry, const D3D_SHADER_MACRO* macro, IDirect3DVertexShader9** vs, const D3DVERTEXELEMENT9* layout, int count, IDirect3DVertexDeclaration9** il);
	void CompileShader(const char *source, size_t size, const char *filename, const std::string& entry, const D3D_SHADER_MACRO* macro, IDirect3DPixelShader9** ps);

	void SetupVS(VSSelector sel, const VSConstantBuffer* cb);
	void SetupGS(GSSelector sel, const GSConstantBuffer* cb) {}
	void SetupPS(PSSelector sel, const PSConstantBuffer* cb, PSSamplerSelector ssel);
	void SetupOM(OMDepthStencilSelector dssel, OMBlendSelector bsel, uint8 afix);

	bool HasStencil() { return m_depth_format == D3DFMT_D24S8; }
	bool HasDepth32() { return m_depth_format != D3DFMT_D24S8; }

	static uint32 GetMaxDepth(uint32 msaaCount = 0, std::string adapter_id = "");
	static void ForceValidMsaaConfig();

};

