# Scene as Transition plugin for OBS Studio

A plugin for OBS Studio that will allow you to use a Scene as a Transition.

This can be used to create all kinds of transitions. It is recommended to get the most out of this plugin that you use other powerful plugins such as [Exeldro's Move Transition plugin](https://obsproject.com/forum/resources/move-transition.913/) to create advanced movements.
You can even make the transitions dynamic by passing information from a program like [SAMMI](https://sammi.solutions) or [Streamer.Bot](https://streamer.bot).

An example would be putting a text source on the transition scene and having it update with the name of the scene or game you are transitioning to.

Some examples of this plugin will be uploaded for you to get your hands on at [StreamUP](https://streamup.tips).

# How To Use
1. Under the '**Scene Transitions**' dock press '**+**' and select '**Scene**' and give the transition a name.

1. You can configure the following '**Scene as Transition Properties**':
    - **Scene** • Select the scene you wish to use as the transition.
    - **Duration** • Set how long you wish the transition to last in milliseconds (ms).
    - **Transition Point Settings** • Set at which point you want the current scene to switch to the new scene. This is either a **Percentage** or **Time in milliseconds** (ms).
    - **Audio Fade Style** • Select how the audio from scene A and scene B react during the transition.
    - **Audio Volume** • Select how loud the audio on the transition scene is.
    - **Filter To Trigger** • Select a filter that is on your selected scene to be enabled when the transition is started.

# Build
1. In-tree build
    - Build OBS Studio: https://obsproject.com/wiki/Install-Instructions
    - Check out this repository to plugins/scene-as-transition
    - Add `add_subdirectory(scene-as-transition)` to plugins/CMakeLists.txt
    - Rebuild OBS Studio

1. Stand-alone build (Linux only)
    - Verify that you have package with development files for OBS
    - Check out this repository and run `cmake -S . -B build -DBUILD_OUT_OF_TREE=On && cmake --build build`

# Support
- [**Patreon**](https://www.patreon.com/Andilippi) - Get access to all my products and more exclusive perks
- [**Ko-Fi**](https://ko-fi.com/andilippi) - Get access to all my products and more exclusive perks
- [**PayPal**](https://www.paypal.me/andilippi) - Send me a beer to say thanks!
- [**Twitch**](https://www.twitch.tv/andilippi) - Come say hi and feel free to ask questions!
- [**YouTube**](https://www.youtube.com/andilippi) - Learn more about OBS and upgrading your streams

