------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-string_bounded.ads,v 1.10 2007/04/25 10:08:47 vagul Exp $

with OCI.Thick.Statements;

package OCI.Thick.String_Bounded is

   use Statements;

   subtype String_Size is C.size_t;

   type Variable (Length : String_Size) is new Limited_Variable with private;

   procedure Bind (Stmt : Statement; Value : in out Variable; Name : String);

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive);

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive);

   procedure Set_Value (Var : in out Variable; Value : String);
   function Get_Value (Var : Variable) return String;

   function Value (Var : Variable) return String renames Get_Value;

   function String_Value (Var : Variable) return String
     renames Get_Value;

   function Get_Value
     (Var     : in Variable;
      Default : in String;
      Mode    : in Default_Mode := Instead_Any)
      return  String;

private

   type Variable (Length : String_Size) is new Limited_Variable with
   record
      Value : C.char_array (0 .. Length);
   end record;

end OCI.Thick.String_Bounded;
