-- ------------------------------------------------------------------------- --
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/objects/string_table.adb,v $
--  Description     : String Table                                           --
--  Author          : Michael Erdmann <Michael.Erdmann@snafu.de>             --
--  Created On      : 30-April-2005                                          --
--  Last Modified By: $Author: merdmann $                                    --
--  Last Modified On: $Date: 2007/01/05 07:26:44 $                           --
--  Status          : $State: Exp $                                          --
--                                                                           --
--  Copyright (C) 2006 Michael Erdmann                                       --
--                                                                           --
--  GNADE is copyrighted by the persons and institutions enumerated in the   --
--  AUTHORS file. This file is located in the root directory of the          --
--  SDB distribution.                                                        --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNADE;  see file COPYING. If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from      --
--  GNADE Ada units, or you link GNADE Ada units or libraries with other     --
--  files  to produce an executable, these  units or libraries do not by     --
--  itself cause the resulting  executable  to  be covered  by the  GNU      --
--  General  Public  License.  This exception does not however invalidate    --
--  any other reasons why  the executable file  might be covered by the      --
--  GNU Public License.                                                      --
--                                                                           --
-- ------------------------------------------------------------------------- --
with Objects;				use Objects;

package body String_Table is

   Version : constant String :=
      "$Id: string_table.adb,v 1.3 2007/01/05 07:26:44 merdmann Exp $";

   ---------
   -- Add --
   ---------
   procedure Add(
      This  : in out Object;
      Value : in Unbounded_String ) is
      Done  : Boolean := False;
   begin
      Get_Object(This);

      for i in This.Strings'Range loop
         if This.Strings(i) = Null_Unbounded_String then
            This.Strings(i) := Value;
            Done := True;
            exit;
         end if;

      end loop;

      if not Done then
         raise Table_Full;
      end if;

      Put_Object(This);
   end Add;

   ---------
   -- Add --
   ---------
   procedure Add(
      This  : in out Object;
      Value : in String ) is
   begin
      Add( This, To_Unbounded_String(Value));
   end Add;

   ---------
   -- Get --
   ---------
   procedure Get(
      This   : in out Object;
      Pos    : Natural;
      Result : out Unbounded_String ) is
   begin
      if Pos in This.Strings'Range then
         Get_Object( This );
         Result := This.Strings(Pos);
      else
         raise Out_Of_Range;
      end if;
   end Get;

   --------------
   -- Contains --
   --------------
   function Contains(
      This   : in Object;
      Value  : in Unbounded_String ) return Boolean is
      Result : Boolean := False;
   begin
      for i in This.Strings'Range loop
         if This.Strings(i) /= Null_Unbounded_String and then
            This.Strings(i) = Value
         then
            Result := True;
            exit;
         end if;

      end loop;

      return Result;
   end Contains;

   ------------
   -- Delete --
   ------------
   procedure Delete(
      This : in out Object;
      Pos  : in Natural ) is
   begin
      if Pos in This.Strings'Range then
         Get_Object(This);
         This.Strings(Pos) := Null_Unbounded_String;
         Put_Object(This);
      else
         raise Out_Of_Range;
      end if;
   end Delete;

end String_Table;
