-------------------------------------------------------------------------------
--                                                                           --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/lista4/pgrecordset.ads,v $
--  Description     : binding package
--  Author          : Julio Cano                                             --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: jukano $
--  Last Modified On: $Date: 2002/01/13 16:07:45 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Julio Cano                                            --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Julio Cano  <julius_bip@yahoo.com>                               --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;
use Ada.Strings.Unbounded;

with Data_Bind;
use Data_Bind;

package PGRecordset is

   type Pgrecordset_ptr is private;

   NO_DATA : exception;
   DATABASE_ERROR : exception;

   procedure Registerdata (Recordset: Pgrecordset_Ptr;
                           Str: String_Access;
                           Field : String);

   procedure MoveFirst (Recordset : Pgrecordset_Ptr);
   procedure MoveNext (Recordset : Pgrecordset_Ptr);

   function Recordset_New(Conninfo : String;
                          Username : String := "";
                          Passwd : String := "") return Pgrecordset_ptr;

   procedure Recordset_Close(recordset : in out Pgrecordset_Ptr);

   function Error (Recordset : Pgrecordset_Ptr) return Boolean;
   -- Returns true if there was an error.

   function Error_Msg (Recordset : Pgrecordset_ptr) return String;
   -- Returns a string explaining the error.

   procedure Error_Msg (Recordset : Pgrecordset_Ptr;
                        Msg : out String);
   -- Sets Msg with the error string;

   procedure Query (Recordset : in out Pgrecordset_Ptr;
                    Query : String);
   -- Sends the query to the database and returns the resulting table
   -- to the recordset

   procedure Exec (Recordset : in out Pgrecordset_Ptr;
                   Cmd : String);
   -- Sends the command to the database but returns no result.

   function GetColNums (Rs: Pgrecordset_Ptr) return Integer;
   -- Returns number of columns in query table.

   function GetColName (Rs: Pgrecordset_Ptr;
                        Num: integer) return String;
   -- Returns the column name.

   function GetData (Rs: Pgrecordset_Ptr;
                     Column : String) return String;
   -- Returns data in the named column in actual register.

private

   type Pgrecordset;
   type Pgrecordset_Ptr is access all pgRecordset;

end PGRecordset;
