/* VideoSupport.c generated by valac 0.34.7, the Vala compiler
 * generated from VideoSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gst/pbutils/pbutils.h>
#include <gst/gst.h>
#include <signal.h>
#include <sys/types.h>
#include <gio/gunixinputstream.h>
#include <sys/wait.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_VIDEO_IMPORT_PARAMS (video_import_params_get_type ())
#define VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams))
#define VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))
#define IS_VIDEO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_IMPORT_PARAMS))
#define IS_VIDEO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_IMPORT_PARAMS))
#define VIDEO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_IMPORT_PARAMS, VideoImportParamsClass))

typedef struct _VideoImportParams VideoImportParams;
typedef struct _VideoImportParamsClass VideoImportParamsClass;
typedef struct _VideoImportParamsPrivate VideoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_VIDEO_ROW (video_row_get_type ())
#define VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_ROW, VideoRow))
#define VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_ROW, VideoRowClass))
#define IS_VIDEO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_ROW))
#define IS_VIDEO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_ROW))
#define VIDEO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_ROW, VideoRowClass))

typedef struct _VideoRow VideoRow;
typedef struct _VideoRowClass VideoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _video_row_unref0(var) ((var == NULL) ? NULL : (var = (video_row_unref (var), NULL)))
typedef struct _ParamSpecVideoImportParams ParamSpecVideoImportParams;

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;
typedef struct _VideoReaderPrivate VideoReaderPrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_IMPORT_RESULT (import_result_get_type ())
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
typedef struct _VideoRowPrivate VideoRowPrivate;

#define TYPE_VIDEO_ID (video_id_get_type ())
typedef struct _VideoID VideoID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_RATING (rating_get_type ())
typedef struct _ParamSpecVideoReader ParamSpecVideoReader;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())
typedef struct _Scaling Scaling;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;
typedef struct _VideoSourcePrivate VideoSourcePrivate;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
typedef struct _VideoPrivate VideoPrivate;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_VIDEO_TABLE (video_table_get_type ())
#define VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_TABLE, VideoTable))
#define VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_TABLE, VideoTableClass))
#define IS_VIDEO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_TABLE))
#define IS_VIDEO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_TABLE))
#define VIDEO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_TABLE, VideoTableClass))

typedef struct _VideoTable VideoTable;
typedef struct _VideoTableClass VideoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_EXPORTER (exporter_get_type ())
#define EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER, Exporter))
#define EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER, ExporterClass))
#define IS_EXPORTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER))
#define IS_EXPORTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER))
#define EXPORTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER, ExporterClass))

typedef struct _Exporter Exporter;
typedef struct _ExporterClass ExporterClass;

#define TYPE_EXPORTER_UI (exporter_ui_get_type ())
#define EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPORTER_UI, ExporterUI))
#define EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPORTER_UI, ExporterUIClass))
#define IS_EXPORTER_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPORTER_UI))
#define IS_EXPORTER_UI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPORTER_UI))
#define EXPORTER_UI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPORTER_UI, ExporterUIClass))

typedef struct _ExporterUI ExporterUI;
typedef struct _ExporterUIClass ExporterUIClass;

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
#define _exporter_ui_unref0(var) ((var == NULL) ? NULL : (var = (exporter_ui_unref (var), NULL)))

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;
#define _backing_file_state_unref0(var) ((var == NULL) ? NULL : (var = (backing_file_state_unref (var), NULL)))

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define VIDEO_TYPE_INTERPRETABLE_RESULTS (video_interpretable_results_get_type ())
#define VIDEO_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults))
#define VIDEO_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))
#define VIDEO_IS_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_IS_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_INTERPRETABLE_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))

typedef struct _VideoInterpretableResults VideoInterpretableResults;
typedef struct _VideoInterpretableResultsClass VideoInterpretableResultsClass;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
typedef struct _VideoInterpretableResultsPrivate VideoInterpretableResultsPrivate;
typedef struct _VideoParamSpecInterpretableResults VideoParamSpecInterpretableResults;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;
typedef struct _VideoSourceCollectionPrivate VideoSourceCollectionPrivate;

#define VIDEO_SOURCE_COLLECTION_TYPE_STATE (video_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	VIDEO_ERROR_FILE,
	VIDEO_ERROR_CONTENTS
} VideoError;
#define VIDEO_ERROR video_error_quark ()
struct _ImportID {
	gint64 id;
};

struct _VideoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoImportParamsPrivate * priv;
	GFile* file;
	ImportID import_id;
	gchar* md5;
	time_t exposure_time_override;
	Thumbnails* thumbnails;
	VideoRow* row;
};

struct _VideoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoImportParams *self);
};

struct _ParamSpecVideoImportParams {
	GParamSpec parent_instance;
};

struct _VideoReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoReaderPrivate * priv;
};

struct _VideoReaderClass {
	GTypeClass parent_class;
	void (*finalize) (VideoReader *self);
};

struct _VideoReaderPrivate {
	gdouble clip_duration;
	GdkPixbuf* preview_frame;
	GFile* file;
	GPid thumbnailer_pid;
	GDateTime* _timestamp;
};

typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

struct _VideoID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _VideoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoRowPrivate * priv;
	VideoID video_id;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	gint width;
	gint height;
	gdouble clip_duration;
	gboolean is_interpretable;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	gchar* md5;
	time_t time_created;
	Rating rating;
	gchar* title;
	gchar* backlinks;
	time_t time_reimported;
	guint64 flags;
	gchar* comment;
};

struct _VideoRowClass {
	GTypeClass parent_class;
	void (*finalize) (VideoRow *self);
};

struct _ParamSpecVideoReader {
	GParamSpec parent_instance;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	time_t (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, int* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	time_t (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _VideoSource {
	MediaSource parent_instance;
	VideoSourcePrivate * priv;
};

struct _VideoSourceClass {
	MediaSourceClass parent_class;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, time_t target_time);
	time_t (*get_exposure_time) (Dateable* self);
};

struct _Video {
	VideoSource parent_instance;
	VideoPrivate * priv;
};

struct _VideoClass {
	VideoSourceClass parent_class;
};

struct _VideoPrivate {
	VideoRow* backing_row;
	GRecMutex __lock_backing_row;
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
typedef void (*ExporterCompletionCallback) (Exporter* exporter, gboolean is_cancelled, void* user_data);
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _VideoInterpretableResults {
	GTypeInstance parent_instance;
	volatile int ref_count;
	VideoInterpretableResultsPrivate * priv;
	Video* video;
	gboolean update_interpretable;
	gboolean is_interpretable;
	GdkPixbuf* new_thumbnail;
};

struct _VideoInterpretableResultsClass {
	GTypeClass parent_class;
	void (*finalize) (VideoInterpretableResults *self);
};

struct _VideoParamSpecInterpretableResults {
	GParamSpec parent_instance;
};

typedef gint64 (*Comparator) (void* a, void* b, void* user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, void* user_data);
struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, void* comparator_target, ComparatorPredicate predicate, void* predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _VideoSourceCollection {
	MediaSourceCollection parent_instance;
	VideoSourceCollectionPrivate * priv;
};

struct _VideoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
};

struct _VideoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeMultiMap* filesize_to_video;
};

typedef enum  {
	VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN,
	VIDEO_SOURCE_COLLECTION_STATE_ONLINE,
	VIDEO_SOURCE_COLLECTION_STATE_OFFLINE,
	VIDEO_SOURCE_COLLECTION_STATE_TRASH
} VideoSourceCollectionState;

typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, void* user_data);
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, void* user_data);

static gpointer video_import_params_parent_class = NULL;
static gpointer video_reader_parent_class = NULL;
static gpointer video_parent_class = NULL;
static gboolean video_interpreter_state_changed;
static gboolean video_interpreter_state_changed = FALSE;
static gint video_current_state;
static gint video_current_state = 0;
static gboolean video_normal_regen_complete;
static gboolean video_normal_regen_complete = FALSE;
static gboolean video_offline_regen_complete;
static gboolean video_offline_regen_complete = FALSE;
extern VideoSourceCollection* video_global;
VideoSourceCollection* video_global = NULL;
static gpointer video_interpretable_results_parent_class = NULL;
static FlaggableIface* video_flaggable_parent_iface = NULL;
static MonitorableIface* video_monitorable_parent_iface = NULL;
static DateableIface* video_dateable_parent_iface = NULL;
static gpointer video_source_collection_parent_class = NULL;

GQuark video_error_quark (void);
gpointer video_import_params_ref (gpointer instance);
void video_import_params_unref (gpointer instance);
GParamSpec* param_spec_video_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_import_params (GValue* value, gpointer v_object);
void value_take_video_import_params (GValue* value, gpointer v_object);
gpointer value_get_video_import_params (const GValue* value);
GType video_import_params_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_thumbnails (GValue* value, gpointer v_object);
void value_take_thumbnails (GValue* value, gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
gpointer video_row_ref (gpointer instance);
void video_row_unref (gpointer instance);
GParamSpec* param_spec_video_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_row (GValue* value, gpointer v_object);
void value_take_video_row (GValue* value, gpointer v_object);
gpointer value_get_video_row (const GValue* value);
GType video_row_get_type (void) G_GNUC_CONST;
enum  {
	VIDEO_IMPORT_PARAMS_DUMMY_PROPERTY
};
#define IMPORT_ID_INVALID ((gint64) 0)
void import_id_init (ImportID *self, gint64 id);
VideoRow* video_row_new (void);
VideoRow* video_row_construct (GType object_type);
VideoImportParams* video_import_params_new (GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override);
VideoImportParams* video_import_params_construct (GType object_type, GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override);
static void video_import_params_finalize (VideoImportParams* obj);
gpointer video_reader_ref (gpointer instance);
void video_reader_unref (gpointer instance);
GParamSpec* param_spec_video_reader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_reader (GValue* value, gpointer v_object);
void value_take_video_reader (GValue* value, gpointer v_object);
gpointer value_get_video_reader (const GValue* value);
GType video_reader_get_type (void) G_GNUC_CONST;
#define VIDEO_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_READER, VideoReaderPrivate))
enum  {
	VIDEO_READER_DUMMY_PROPERTY
};
#define VIDEO_READER_UNKNOWN_CLIP_DURATION (-1.0)
#define VIDEO_READER_THUMBNAILER_TIMEOUT ((guint) 10000)
VideoReader* video_reader_new (GFile* file);
VideoReader* video_reader_construct (GType object_type, GFile* file);
gboolean video_reader_is_supported_video_file (GFile* file);
gboolean video_reader_is_supported_video_filename (const gchar* filename);
void disassemble_filename (const gchar* basename, gchar** name, gchar** ext);
gint utf8_ci_compare (void* a, void* b);
GType import_result_get_type (void) G_GNUC_CONST;
ImportResult video_reader_prepare_for_import (VideoImportParams* params);
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
GdkPixbuf* video_reader_read_preview_frame (VideoReader* self);
gdouble video_reader_read_clip_duration (VideoReader* self, GError** error);
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType video_metadata_get_type (void) G_GNUC_CONST;
VideoMetadata* video_reader_read_metadata (VideoReader* self, GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
gchar* media_metadata_get_title (MediaMetadata* self);
gchar* media_metadata_get_comment (MediaMetadata* self);
GDateTime* video_reader_get_timestamp (VideoReader* self);
GType video_id_get_type (void) G_GNUC_CONST;
VideoID* video_id_dup (const VideoID* self);
void video_id_free (VideoID* self);
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType rating_get_type (void) G_GNUC_CONST;
#define VIDEO_ID_INVALID ((gint64) -1)
void video_id_init (VideoID *self, gint64 id);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self, gint64 id);
Thumbnails* thumbnails_new (void);
Thumbnails* thumbnails_construct (GType object_type);
void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails, GdkPixbuf* preview_frame);
static void video_reader_read_internal (VideoReader* self, GError** error);
static gboolean video_reader_does_file_exist (VideoReader* self);
static GDate* _g_date_dup (GDate* self);
static void video_reader_set_timestamp (VideoReader* self, GDateTime* value);
static gboolean video_reader_on_thumbnailer_timer (VideoReader* self);
static GdkPixbuf* video_reader_thumbnailer (VideoReader* self, const gchar* video_file);
GFile* app_dirs_get_thumbnailer_bin (void);
static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self);
GdkPixbuf* resources_get_noninterpretable_badge_pixbuf (void);
VideoMetadata* video_metadata_new (void);
VideoMetadata* video_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
static void video_reader_finalize (VideoReader* obj);
GType data_object_get_type (void) G_GNUC_CONST;
gpointer alteration_ref (gpointer instance);
void alteration_unref (gpointer instance);
GParamSpec* param_spec_alteration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_alteration (GValue* value, gpointer v_object);
void value_take_alteration (GValue* value, gpointer v_object);
gpointer value_get_alteration (const GValue* value);
GType alteration_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
gpointer source_holding_tank_ref (gpointer instance);
void source_holding_tank_unref (gpointer instance);
GParamSpec* param_spec_source_holding_tank (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_holding_tank (GValue* value, gpointer v_object);
void value_take_source_holding_tank (GValue* value, gpointer v_object);
gpointer value_get_source_holding_tank (const GValue* value);
GType source_holding_tank_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
gpointer source_snapshot_ref (gpointer instance);
void source_snapshot_unref (gpointer instance);
GParamSpec* param_spec_source_snapshot (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_snapshot (GValue* value, gpointer v_object);
void value_take_source_snapshot (GValue* value, gpointer v_object);
gpointer value_get_source_snapshot (const GValue* value);
GType source_snapshot_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType indexable_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
gpointer backing_file_state_ref (gpointer instance);
void backing_file_state_unref (gpointer instance);
GParamSpec* param_spec_backing_file_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_file_state (GValue* value, gpointer v_object);
void value_take_backing_file_state (GValue* value, gpointer v_object);
gpointer value_get_backing_file_state (const GValue* value);
GType backing_file_state_get_type (void) G_GNUC_CONST;
GType photo_exception_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType flaggable_get_type (void) G_GNUC_CONST;
GType monitorable_get_type (void) G_GNUC_CONST;
GType dateable_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
#define VIDEO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO, VideoPrivate))
enum  {
	VIDEO_DUMMY_PROPERTY
};
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType video_source_collection_get_type (void) G_GNUC_CONST;
#define VIDEO_TYPENAME "video"
#define VIDEO_FLAG_TRASH ((guint64) 0x0000000000000001)
#define VIDEO_FLAG_OFFLINE ((guint64) 0x0000000000000002)
#define VIDEO_FLAG_FLAGGED ((guint64) 0x0000000000000004)
Video* video_new (VideoRow* row);
Video* video_construct (GType object_type, VideoRow* row);
VideoSource* video_source_construct (GType object_type);
gchar* media_source_prep_title (const gchar* title);
void data_source_rehydrate_backlinks (DataSource* self, SourceCollection* unlinked_from, const gchar* dehydrated);
void video_init (ProgressMonitor monitor, void* monitor_target);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
#define CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE -1
VideoSourceCollection* video_source_collection_new (void);
VideoSourceCollection* video_source_collection_construct (GType object_type);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType video_table_get_type (void) G_GNUC_CONST;
VideoTable* video_table_get_instance (void);
GeeArrayList* video_table_get_all (VideoTable* self);
static void video_set_is_interpretable (Video* self, gboolean is_interpretable);
gboolean media_source_is_trashed (MediaSource* self);
gboolean media_source_is_offline (MediaSource* self);
void media_source_collection_add_many_to_trash (MediaSourceCollection* self, GeeCollection* sources);
void media_source_collection_add_many_to_offline (MediaSourceCollection* self, GeeCollection* sources);
GeeCollection* data_collection_add_many (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, void* monitor_target);
gboolean video_has_interpreter_state_changed (void);
void video_notify_normal_thumbs_regenerated (void);
static void video_save_interpreter_state (void);
void video_notify_offline_thumbs_regenerated (void);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
void video_terminate (void);
GType exporter_get_type (void) G_GNUC_CONST;
gpointer exporter_ui_ref (gpointer instance);
void exporter_ui_unref (gpointer instance);
GParamSpec* param_spec_exporter_ui (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_exporter_ui (GValue* value, gpointer v_object);
void value_take_exporter_ui (GValue* value, gpointer v_object);
gpointer value_get_exporter_ui (const GValue* value);
GType exporter_ui_get_type (void) G_GNUC_CONST;
ExporterUI* video_export_many (GeeCollection* videos, ExporterCompletionCallback done, void* done_target, gboolean export_in_place);
void scaling_for_original (Scaling* result);
GType export_format_parameters_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
void export_format_parameters_free (ExportFormatParameters* self);
void export_format_parameters_unmodified (ExportFormatParameters* result);
Exporter* exporter_new_for_temp_file (GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
Exporter* exporter_construct_for_temp_file (GType object_type, GeeCollection* to_export, Scaling* scaling, ExportFormatParameters* export_params);
ExporterUI* exporter_ui_new (Exporter* exporter);
ExporterUI* exporter_ui_construct (GType object_type, Exporter* exporter);
void exporter_ui_export (ExporterUI* self, ExporterCompletionCallback completion_callback, void* completion_callback_target);
GFile* export_ui_choose_file (const gchar* current_file_basename);
gchar* media_source_get_basename (MediaSource* self);
GType page_window_get_type (void) G_GNUC_CONST;
GType app_window_get_type (void) G_GNUC_CONST;
AppWindow* app_window_get_instance (void);
void page_window_set_busy_cursor (PageWindow* self);
void video_export (Video* self, GFile* dest_file, GError** error);
void page_window_set_normal_cursor (PageWindow* self);
GtkResponseType export_error_dialog (GFile* dest, gboolean photos_remaining);
GFile* export_ui_choose_dir (const gchar* user_title);
Exporter* exporter_new (GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
Exporter* exporter_construct (GType object_type, GeeCollection* to_export, GFile* dir, Scaling* scaling, ExportFormatParameters* export_params, gboolean auto_replace_all);
static void video_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks);
GQuark database_error_quark (void);
void video_table_update_backlinks (VideoTable* self, VideoID* video_id, const gchar* backlinks, GError** error);
void video_get_video_id (Video* self, VideoID* result);
gchar* data_object_to_string (DataObject* self);
static gboolean video_real_set_event_id (MediaSource* base, EventID* event_id);
gboolean video_table_set_event (VideoTable* self, VideoID* video_id, EventID* event_id);
gboolean video_is_duplicate (GFile* file, const gchar* full_md5);
gboolean video_table_has_duplicate (VideoTable* self, GFile* file, const gchar* md5);
ImportResult video_import_create (VideoImportParams* params, Video** video);
void video_table_add (VideoTable* self, VideoRow* video_row, VideoID* result, GError** error);
gboolean video_id_is_invalid (VideoID *self);
void video_import_failed (Video* video);
void video_table_remove (VideoTable* self, VideoID* videoID, GError** error);
void app_window_database_error (GError* err);
static BackingFileState** video_real_get_backing_files_state (MediaSource* base, int* result_length1);
BackingFileState* backing_file_state_new (const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5);
BackingFileState* backing_file_state_construct (GType object_type, const gchar* filepath, gint64 filesize, time_t modification_time, const gchar* md5);
static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source, gint scale, GError** error);
static gchar* video_real_get_master_md5 (MediaSource* base);
static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error);
GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self, gint scale, GError** error);
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error);
GFile* media_source_get_file (MediaSource* self);
static gchar* video_real_get_typename (DataSource* base);
static gint64 video_real_get_instance_id (DataSource* base);
static void video_real_get_import_id (MediaSource* base, ImportID* result);
static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base);
PhotoFileFormat photo_file_format_get_system_default_format (void);
static gchar* video_real_get_title (MediaSource* base);
static void video_real_set_title (MediaSource* base, const gchar* title);
void video_table_set_title (VideoTable* self, VideoID* video_id, const gchar* new_title, GError** error);
void data_object_notify_altered (DataObject* self, Alteration* alteration);
Alteration* alteration_new (const gchar* subject, const gchar* detail);
Alteration* alteration_construct (GType object_type, const gchar* subject, const gchar* detail);
static gchar* video_real_get_comment (MediaSource* base);
static gboolean video_real_set_comment (MediaSource* base, const gchar* comment);
void video_table_set_comment (VideoTable* self, VideoID* video_id, const gchar* new_comment, GError** error);
static Rating video_real_get_rating (MediaSource* base);
static void video_real_set_rating (MediaSource* base, Rating rating);
gboolean rating_is_valid (Rating self);
void video_table_set_rating (VideoTable* self, VideoID* video_id, Rating rating, GError** error);
static void video_real_increase_rating (MediaSource* base);
void media_source_set_rating (MediaSource* self, Rating rating);
Rating rating_increase (Rating self);
static void video_real_decrease_rating (MediaSource* base);
Rating rating_decrease (Rating self);
static gboolean video_real_is_trashed (MediaSource* base);
gboolean video_is_flag_set (Video* self, guint64 flag);
static gboolean video_real_is_offline (Monitorable* base);
static void video_real_mark_offline (Monitorable* base);
guint64 video_add_flags (Video* self, guint64 flags_to_add, Alteration* additional_alteration);
static void video_real_mark_online (Monitorable* base);
guint64 video_remove_flags (Video* self, guint64 flags_to_remove, Alteration* additional_alteration);
gboolean video_get_is_interpretable (Video* self);
gpointer video_interpretable_results_ref (gpointer instance);
void video_interpretable_results_unref (gpointer instance);
GParamSpec* video_param_spec_interpretable_results (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void video_value_set_interpretable_results (GValue* value, gpointer v_object);
void video_value_take_interpretable_results (GValue* value, gpointer v_object);
gpointer video_value_get_interpretable_results (const GValue* value);
GType video_interpretable_results_get_type (void) G_GNUC_CONST;
VideoInterpretableResults* video_check_is_interpretable (Video* self);
void video_interpretable_results_foreground_finish (VideoInterpretableResults* self);
static void video_real_trash (MediaSource* base);
static void video_real_untrash (MediaSource* base);
static gboolean video_real_is_flagged (Flaggable* base);
static void video_real_mark_flagged (Flaggable* base);
static void video_real_mark_unflagged (Flaggable* base);
static void video_real_get_event_id (MediaSource* base, EventID* result);
static gchar* video_real_to_string (DataObject* base);
static time_t video_real_get_exposure_time (Dateable* base);
static void video_real_set_exposure_time (Dateable* base, time_t time);
void video_table_set_exposure_time (VideoTable* self, VideoID* video_id, time_t time, GError** error);
void video_get_frame_dimensions (Video* self, Dimensions* result);
void dimensions_init (Dimensions *self, gint width, gint height);
static void video_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result);
static guint64 video_real_get_filesize (MediaSource* base);
guint64 media_source_get_master_filesize (MediaSource* self);
static guint64 video_real_get_master_filesize (MediaSource* base);
static time_t video_real_get_timestamp (MediaSource* base);
static void video_real_set_master_timestamp (Monitorable* base, GFileInfo* info);
void video_table_set_timestamp (VideoTable* self, VideoID* video_id, time_t timestamp, GError** error);
gchar* video_get_filename (Video* self);
static GFile* video_real_get_file (MediaSource* base);
static GFile* video_real_get_master_file (MediaSource* base);
gdouble video_get_clip_duration (Video* self);
void video_table_update_is_interpretable (VideoTable* self, VideoID* video_id, gboolean is_interpretable, GError** error);
VideoInterpretableResults* video_interpretable_results_new (Video* video);
VideoInterpretableResults* video_interpretable_results_construct (GType object_type, Video* video);
static void video_real_destroy (DataSource* base);
void thumbnail_cache_remove (ThumbnailSource* source);
void data_source_destroy (DataSource* self);
static gboolean video_real_internal_delete_backing (DataSource* base, GError** error);
gboolean media_source_delete_original_file (MediaSource* self);
gboolean data_source_internal_delete_backing (DataSource* self, GError** error);
static void video_notify_flags_altered (Video* self, Alteration* additional_alteration);
Alteration* alteration_compress (Alteration* self, Alteration* other);
guint64 media_source_internal_add_flags (guint64 flags, guint64 selector);
void video_table_set_flags (VideoTable* self, VideoID* video_id, guint64 flags, GError** error);
guint64 media_source_internal_remove_flags (guint64 flags, guint64 selector);
gboolean media_source_internal_is_flag_set (guint64 flags, guint64 selector);
static void video_real_set_master_file (Monitorable* base, GFile* file);
void video_table_set_filepath (VideoTable* self, VideoID* video_id, const gchar* filepath, GError** error);
void media_source_notify_master_replaced (MediaSource* self, GFile* old_file, GFile* new_file);
Alteration* alteration_new_from_list (const gchar* list);
Alteration* alteration_construct_from_list (GType object_type, const gchar* list);
VideoMetadata* video_read_metadata (Video* self, GError** error);
enum  {
	VIDEO_INTERPRETABLE_RESULTS_DUMMY_PROPERTY
};
void thumbnail_cache_replace (ThumbnailSource* source, ThumbnailCacheSize size, GdkPixbuf* replacement, GError** error);
void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void video_interpretable_results_finalize (VideoInterpretableResults* obj);
static void video_finalize (GObject* obj);
GType marker_get_type (void) G_GNUC_CONST;
gpointer source_backlink_ref (gpointer instance);
void source_backlink_unref (gpointer instance);
GParamSpec* param_spec_source_backlink (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_source_backlink (GValue* value, gpointer v_object);
void value_take_source_backlink (GValue* value, gpointer v_object);
gpointer value_get_source_backlink (const GValue* value);
GType source_backlink_get_type (void) G_GNUC_CONST;
GType database_source_holding_tank_get_type (void) G_GNUC_CONST;
GType media_source_holding_tank_get_type (void) G_GNUC_CONST;
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
GType media_monitor_get_type (void) G_GNUC_CONST;
gpointer transaction_controller_ref (gpointer instance);
void transaction_controller_unref (gpointer instance);
GParamSpec* param_spec_transaction_controller (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_transaction_controller (GValue* value, gpointer v_object);
void value_take_transaction_controller (GValue* value, gpointer v_object);
gpointer value_get_transaction_controller (const GValue* value);
GType transaction_controller_get_type (void) G_GNUC_CONST;
#define VIDEO_SOURCE_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionPrivate))
enum  {
	VIDEO_SOURCE_COLLECTION_DUMMY_PROPERTY
};
GType video_source_collection_state_get_type (void) G_GNUC_CONST;
gint uint64_compare (guint64* a, guint64* b);
static gint _uint64_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static guint64* _uint64_dup (guint64* self);
gint64 video_source_collection_get_video_key (DataSource* source);
static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source, gpointer self);
MediaSourceCollection* media_source_collection_construct (GType object_type, const gchar* name, GetSourceDatabaseKey source_key_func, void* source_key_func_target);
MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed);
static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self);
static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base);
gboolean video_source_collection_is_video_trashed (DataSource* source);
static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type, MediaSourceCollection* sources, SourceHoldingTankCheckToKeep check_to_keep, void* check_to_keep_target, GetSourceDatabaseKey get_key, void* get_key_target);
static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base);
gboolean video_source_collection_is_video_offline (DataSource* source);
static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self);
static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base, Workers* workers, GCancellable* cancellable);
VideoMonitor* video_monitor_new (GCancellable* cancellable);
VideoMonitor* video_monitor_construct (GType object_type, GCancellable* cancellable);
GType video_monitor_get_type (void) G_GNUC_CONST;
static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source);
static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base, GFile* file);
static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base, gint64 numeric_id);
Video* video_source_collection_fetch (VideoSourceCollection* self, VideoID* video_id);
DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self, gint64 key);
static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base, EventID* event_id);
GeeArrayList* video_table_get_event_source_ids (VideoTable* self, EventID* event_id);
Video* video_source_collection_get_state_by_file (VideoSourceCollection* self, GFile* file, VideoSourceCollectionState* state);
MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self, GFile* file);
MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self, GFile* file);
static void video_source_collection_compare_backing (VideoSourceCollection* self, Video* video, GFileInfo* info, GeeCollection* matching_master);
guint64 media_source_get_filesize (MediaSource* self);
time_t media_source_get_timestamp (MediaSource* self);
void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self, GFileInfo* info, GeeCollection* matching_master);
GeeCollection* data_collection_get_all (DataCollection* self);
GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
static void video_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed);
void data_collection_notify_contents_altered (DataCollection* self, GeeIterable* added, GeeIterable* removed);
void video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize, VideoID* result);
GFile* media_source_get_master_file (MediaSource* self);
gboolean video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize);
gboolean video_id_is_valid (VideoID *self);
MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type, MediaSourceCollection* sources);
GType media_source_transaction_controller_get_type (void) G_GNUC_CONST;
static void video_source_collection_finalize (DataCollection* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS[4] = {"bdm", "bdmv", "cpi", "mpl"};

GQuark video_error_quark (void) {
	return g_quark_from_static_string ("video_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? g_object_ref (self) : NULL;
#line 1515 "VideoSupport.c"
}


static gpointer _thumbnails_ref0 (gpointer self) {
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? thumbnails_ref (self) : NULL;
#line 1522 "VideoSupport.c"
}


VideoImportParams* video_import_params_construct (GType object_type, GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override) {
	VideoImportParams* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	ImportID _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	Thumbnails* _tmp5_ = NULL;
	Thumbnails* _tmp6_ = NULL;
	time_t _tmp7_ = 0;
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (import_id != NULL, NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoImportParams*) g_type_create_instance (object_type);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->file);
#line 30 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->file = _tmp1_;
#line 31 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = *import_id;
#line 31 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->import_id = _tmp2_;
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = md5;
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (self->md5);
#line 32 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->md5 = _tmp4_;
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = thumbnails;
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _thumbnails_ref0 (_tmp5_);
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 33 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->thumbnails = _tmp6_;
#line 34 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = exposure_time_override;
#line 34 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->exposure_time_override = _tmp7_;
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 1578 "VideoSupport.c"
}


VideoImportParams* video_import_params_new (GFile* file, ImportID* import_id, const gchar* md5, Thumbnails* thumbnails, time_t exposure_time_override) {
#line 28 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_import_params_construct (TYPE_VIDEO_IMPORT_PARAMS, file, import_id, md5, thumbnails, exposure_time_override);
#line 1585 "VideoSupport.c"
}


static void value_video_import_params_init (GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 1592 "VideoSupport.c"
}


static void value_video_import_params_free_value (GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (value->data[0].v_pointer);
#line 1601 "VideoSupport.c"
	}
}


static void value_video_import_params_copy_value (const GValue* src_value, GValue* dest_value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_import_params_ref (src_value->data[0].v_pointer);
#line 1611 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1615 "VideoSupport.c"
	}
}


static gpointer value_video_import_params_peek_pointer (const GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 1623 "VideoSupport.c"
}


static gchar* value_video_import_params_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 1630 "VideoSupport.c"
		VideoImportParams* object;
		object = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1637 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1641 "VideoSupport.c"
		}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_import_params_ref (object);
#line 1645 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1649 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 1653 "VideoSupport.c"
}


static gchar* value_video_import_params_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoImportParams** object_p;
	object_p = collect_values[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1664 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 1670 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 1674 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_import_params_ref (value->data[0].v_pointer);
#line 1678 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 1682 "VideoSupport.c"
}


GParamSpec* param_spec_video_import_params (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecVideoImportParams* spec;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_IMPORT_PARAMS), NULL);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 1696 "VideoSupport.c"
}


gpointer value_get_video_import_params (const GValue* value) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS), NULL);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 1705 "VideoSupport.c"
}


void value_set_video_import_params (GValue* value, gpointer v_object) {
	VideoImportParams* old;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_ref (value->data[0].v_pointer);
#line 1725 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1729 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (old);
#line 1735 "VideoSupport.c"
	}
}


void value_take_video_import_params (GValue* value, gpointer v_object) {
	VideoImportParams* old;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_IMPORT_PARAMS));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 1754 "VideoSupport.c"
	} else {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 1758 "VideoSupport.c"
	}
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_import_params_unref (old);
#line 1764 "VideoSupport.c"
	}
}


static void video_import_params_class_init (VideoImportParamsClass * klass) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_import_params_parent_class = g_type_class_peek_parent (klass);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoImportParamsClass *) klass)->finalize = video_import_params_finalize;
#line 1774 "VideoSupport.c"
}


static void video_import_params_instance_init (VideoImportParams * self) {
	VideoRow* _tmp0_ = NULL;
#line 18 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	import_id_init (&self->import_id, IMPORT_ID_INVALID);
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_row_new ();
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->row = _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 1788 "VideoSupport.c"
}


static void video_import_params_finalize (VideoImportParams* obj) {
	VideoImportParams * self;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_IMPORT_PARAMS, VideoImportParams);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 17 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->file);
#line 19 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (self->md5);
#line 23 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_thumbnails_unref0 (self->thumbnails);
#line 26 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->row);
#line 1806 "VideoSupport.c"
}


GType video_import_params_get_type (void) {
	static volatile gsize video_import_params_type_id__volatile = 0;
	if (g_once_init_enter (&video_import_params_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_import_params_init, value_video_import_params_free_value, value_video_import_params_copy_value, value_video_import_params_peek_pointer, "p", value_video_import_params_collect_value, "p", value_video_import_params_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoImportParams), 0, (GInstanceInitFunc) video_import_params_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_import_params_type_id;
		video_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_import_params_type_id__volatile, video_import_params_type_id);
	}
	return video_import_params_type_id__volatile;
}


gpointer video_import_params_ref (gpointer instance) {
	VideoImportParams* self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 1831 "VideoSupport.c"
}


void video_import_params_unref (gpointer instance) {
	VideoImportParams* self;
	self = instance;
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
#line 15 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1844 "VideoSupport.c"
	}
}


VideoReader* video_reader_construct (GType object_type, GFile* file) {
	VideoReader* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoReader*) g_type_create_instance (object_type);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->file);
#line 52 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->file = _tmp1_;
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 1867 "VideoSupport.c"
}


VideoReader* video_reader_new (GFile* file) {
#line 51 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_reader_construct (TYPE_VIDEO_READER, file);
#line 1874 "VideoSupport.c"
}


gboolean video_reader_is_supported_video_file (GFile* file) {
	gboolean result = FALSE;
	gchar* mime_type = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	guchar* _tmp3_ = NULL;
	guchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	GFile* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
#line 55 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_basename (_tmp0_);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_new0 (guchar, 0);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4__length1 = 0;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = g_content_type_guess (_tmp2_, _tmp4_, (gsize) 0, NULL);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = (g_free (_tmp4_), NULL);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_);
#line 56 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	mime_type = _tmp6_;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = mime_type;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_strcmp0 (_tmp8_, "audio/ogg") == 0) {
#line 1925 "VideoSupport.c"
		GFile* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = file;
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = g_file_has_uri_scheme (_tmp9_, "file");
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = _tmp10_;
#line 1934 "VideoSupport.c"
	} else {
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = FALSE;
#line 1938 "VideoSupport.c"
	}
#line 58 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_) {
#line 1942 "VideoSupport.c"
		{
			GFileInfo* info = NULL;
			GFile* _tmp11_ = NULL;
			GFileInfo* _tmp12_ = NULL;
			gchar* content_type = NULL;
			GFileInfo* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			const gchar* _tmp17_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = file;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = g_file_query_info (_tmp11_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			info = _tmp12_;
#line 60 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1961 "VideoSupport.c"
				goto __catch493_g_error;
			}
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = info;
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = g_file_info_get_content_type (_tmp13_);
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = g_strdup (_tmp14_);
#line 62 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			content_type = _tmp15_;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp17_ != NULL) {
#line 1976 "VideoSupport.c"
				const gchar* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = content_type;
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = g_str_has_prefix (_tmp18_, "video/");
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _tmp19_;
#line 1985 "VideoSupport.c"
			} else {
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = FALSE;
#line 1989 "VideoSupport.c"
			}
#line 63 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp16_) {
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = TRUE;
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (content_type);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (info);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (mime_type);
#line 64 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 2003 "VideoSupport.c"
			}
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (content_type);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 2009 "VideoSupport.c"
		}
		goto __finally493;
		__catch493_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_error_ = _inner_error_;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = _error_;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = _tmp20_->message;
#line 67 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_debug ("VideoSupport.vala:67: Failed to query content type: %s", _tmp21_);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (_error_);
#line 2029 "VideoSupport.c"
		}
		__finally493:
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2034 "VideoSupport.c"
			gboolean _tmp22_ = FALSE;
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (mime_type);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 59 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp22_;
#line 2044 "VideoSupport.c"
		}
	}
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = file;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = g_file_get_basename (_tmp23_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = _tmp24_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = video_reader_is_supported_video_filename (_tmp25_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = _tmp26_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp25_);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp27_;
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 71 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 2065 "VideoSupport.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2098 "VideoSupport.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2107 "VideoSupport.c"
	}
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2113 "VideoSupport.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2122 "VideoSupport.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2128 "VideoSupport.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2137 "VideoSupport.c"
	} else {
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2141 "VideoSupport.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2149 "VideoSupport.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2158 "VideoSupport.c"
	} else {
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2162 "VideoSupport.c"
	}
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 2184 "VideoSupport.c"
}


gboolean video_reader_is_supported_video_filename (const gchar* filename) {
	gboolean result = FALSE;
	gchar* mime_type = NULL;
	const gchar* _tmp0_ = NULL;
	guchar* _tmp1_ = NULL;
	guchar* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 74 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = filename;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_new0 (guchar, 0);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2__length1 = 0;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_content_type_guess (_tmp0_, _tmp2_, (gsize) 0, NULL);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	mime_type = _tmp3_;
#line 76 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = (g_free (_tmp2_), NULL);
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = mime_type;
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = strlen (_tmp5_);
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = _tmp6_;
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_ >= 6) {
#line 2226 "VideoSupport.c"
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = mime_type;
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = string_slice (_tmp8_, (glong) 0, (glong) 6);
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_;
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = g_strcmp0 (_tmp10_, "video/") == 0;
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp10_);
#line 2240 "VideoSupport.c"
	} else {
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = FALSE;
#line 2244 "VideoSupport.c"
	}
#line 77 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp4_) {
#line 2248 "VideoSupport.c"
		gchar* extension = NULL;
		gchar* name = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 78 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		extension = NULL;
#line 79 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		name = NULL;
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = filename;
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		disassemble_filename (_tmp11_, &_tmp12_, &_tmp13_);
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (name);
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		name = _tmp12_;
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (extension);
#line 80 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		extension = _tmp13_;
#line 82 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = extension;
#line 82 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp14_ == NULL) {
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = TRUE;
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (name);
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (extension);
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (mime_type);
#line 83 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 2285 "VideoSupport.c"
		}
		{
			const gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
#line 85 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			s_collection = VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS;
#line 85 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			s_collection_length1 = G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS);
#line 85 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			for (s_it = 0; s_it < G_N_ELEMENTS (VIDEO_READER_METADATA_ONLY_FILE_EXTENSIONS); s_it = s_it + 1) {
#line 2298 "VideoSupport.c"
				gchar* _tmp15_ = NULL;
				gchar* s = NULL;
#line 85 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = g_strdup (s_collection[s_it]);
#line 85 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				s = _tmp15_;
#line 2305 "VideoSupport.c"
				{
					const gchar* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					gint _tmp18_ = 0;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp16_ = s;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp17_ = extension;
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp18_ = utf8_ci_compare (_tmp16_, _tmp17_);
#line 86 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_tmp18_ == 0) {
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						result = FALSE;
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (s);
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (name);
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (extension);
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_g_free0 (mime_type);
#line 87 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						return result;
#line 2330 "VideoSupport.c"
					}
#line 85 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (s);
#line 2334 "VideoSupport.c"
				}
			}
		}
#line 90 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = TRUE;
#line 90 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (name);
#line 90 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (extension);
#line 90 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (mime_type);
#line 90 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2348 "VideoSupport.c"
	} else {
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = filename;
#line 92 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = mime_type;
#line 92 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:92: Skipping %s, unsupported mime type %s", _tmp19_, _tmp20_);
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = FALSE;
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (mime_type);
#line 93 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2364 "VideoSupport.c"
	}
#line 74 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (mime_type);
#line 2368 "VideoSupport.c"
}


ImportResult video_reader_prepare_for_import (VideoImportParams* params) {
	ImportResult result = 0;
	GFile* file = NULL;
	VideoImportParams* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFileInfo* info = NULL;
	GFileInfo* _tmp7_ = NULL;
	GFileType _tmp8_ = 0;
	GFile* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GTimeVal timestamp = {0};
	GFileInfo* _tmp14_ = NULL;
	GTimeVal _tmp15_ = {0};
	VideoImportParams* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	time_t exposure_time = 0;
	VideoImportParams* _tmp18_ = NULL;
	time_t _tmp19_ = 0;
	gchar* title = NULL;
	gchar* _tmp20_ = NULL;
	gchar* comment = NULL;
	gchar* _tmp21_ = NULL;
	VideoReader* reader = NULL;
	GFile* _tmp22_ = NULL;
	VideoReader* _tmp23_ = NULL;
	gboolean is_interpretable = FALSE;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* _tmp24_ = NULL;
	GdkPixbuf* _tmp25_ = NULL;
	time_t _tmp53_ = 0;
	VideoImportParams* _tmp60_ = NULL;
	VideoRow* _tmp61_ = NULL;
	VideoImportParams* _tmp62_ = NULL;
	VideoRow* _tmp63_ = NULL;
	GFile* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	VideoImportParams* _tmp66_ = NULL;
	VideoRow* _tmp67_ = NULL;
	GFileInfo* _tmp68_ = NULL;
	gint64 _tmp69_ = 0LL;
	VideoImportParams* _tmp70_ = NULL;
	VideoRow* _tmp71_ = NULL;
	GTimeVal _tmp72_ = {0};
	glong _tmp73_ = 0L;
	VideoImportParams* _tmp74_ = NULL;
	VideoRow* _tmp75_ = NULL;
	GdkPixbuf* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	VideoImportParams* _tmp79_ = NULL;
	VideoRow* _tmp80_ = NULL;
	GdkPixbuf* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	gint _tmp83_ = 0;
	VideoImportParams* _tmp84_ = NULL;
	VideoRow* _tmp85_ = NULL;
	gdouble _tmp86_ = 0.0;
	VideoImportParams* _tmp87_ = NULL;
	VideoRow* _tmp88_ = NULL;
	gboolean _tmp89_ = FALSE;
	VideoImportParams* _tmp90_ = NULL;
	VideoRow* _tmp91_ = NULL;
	time_t _tmp92_ = 0;
	VideoImportParams* _tmp93_ = NULL;
	VideoRow* _tmp94_ = NULL;
	VideoImportParams* _tmp95_ = NULL;
	ImportID _tmp96_ = {0};
	VideoImportParams* _tmp97_ = NULL;
	VideoRow* _tmp98_ = NULL;
	VideoImportParams* _tmp99_ = NULL;
	VideoRow* _tmp100_ = NULL;
	VideoImportParams* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	gchar* _tmp103_ = NULL;
	VideoImportParams* _tmp104_ = NULL;
	VideoRow* _tmp105_ = NULL;
	VideoImportParams* _tmp106_ = NULL;
	VideoRow* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	VideoImportParams* _tmp110_ = NULL;
	VideoRow* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	gchar* _tmp113_ = NULL;
	VideoImportParams* _tmp114_ = NULL;
	VideoRow* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	VideoImportParams* _tmp117_ = NULL;
	VideoRow* _tmp118_ = NULL;
	VideoImportParams* _tmp119_ = NULL;
	VideoRow* _tmp120_ = NULL;
	VideoImportParams* _tmp121_ = NULL;
	Thumbnails* _tmp122_ = NULL;
	GError * _inner_error_ = NULL;
#line 97 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
#line 101 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = params;
#line 101 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_->file;
#line 101 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 101 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	file = _tmp2_;
#line 103 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	info = NULL;
#line 2480 "VideoSupport.c"
	{
		GFileInfo* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFileInfo* _tmp5_ = NULL;
		GFileInfo* _tmp6_ = NULL;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = file;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = g_file_query_info (_tmp4_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error_);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp5_;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2494 "VideoSupport.c"
			goto __catch494_g_error;
		}
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp3_;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = NULL;
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		info = _tmp6_;
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp3_);
#line 2507 "VideoSupport.c"
	}
	goto __finally494;
	__catch494_g_error:
	{
		GError* err = NULL;
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_FILE_ERROR;
#line 108 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 108 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 108 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 108 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2527 "VideoSupport.c"
	}
	__finally494:
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 104 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2542 "VideoSupport.c"
	}
#line 111 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = info;
#line 111 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
#line 111 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp8_ != G_FILE_TYPE_REGULAR) {
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_NOT_A_FILE;
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 112 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2558 "VideoSupport.c"
	}
#line 114 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = file;
#line 114 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = video_reader_is_supported_video_file (_tmp9_);
#line 114 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp10_) {
#line 2566 "VideoSupport.c"
		GFile* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = file;
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = g_file_get_path (_tmp11_);
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = _tmp12_;
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("Not importing %s: file is marked as a video file but doesn't have a" "supported extension", _tmp13_);
#line 115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp13_);
#line 118 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
#line 118 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 118 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 118 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 2588 "VideoSupport.c"
	}
#line 121 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = info;
#line 121 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp14_, &_tmp15_);
#line 121 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	timestamp = _tmp15_;
#line 124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = params;
#line 124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp17_ = _tmp16_->md5;
#line 124 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp17_ != NULL, "params.md5 != null");
#line 126 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = params;
#line 126 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = _tmp18_->exposure_time_override;
#line 126 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exposure_time = _tmp19_;
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = g_strdup ("");
#line 127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	title = _tmp20_;
#line 128 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = g_strdup ("");
#line 128 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	comment = _tmp21_;
#line 130 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = file;
#line 130 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = video_reader_new (_tmp22_);
#line 130 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	reader = _tmp23_;
#line 131 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	is_interpretable = TRUE;
#line 132 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	clip_duration = 0.0;
#line 133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = reader;
#line 133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = video_reader_read_preview_frame (_tmp24_);
#line 133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	preview_frame = _tmp25_;
#line 2632 "VideoSupport.c"
	{
		gdouble _tmp26_ = 0.0;
		VideoReader* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp27_ = reader;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp28_ = video_reader_read_clip_duration (_tmp27_, &_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = _tmp28_;
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 2647 "VideoSupport.c"
				goto __catch495_video_error;
			}
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (reader);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (file);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return 0;
#line 2668 "VideoSupport.c"
		}
#line 135 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		clip_duration = _tmp26_;
#line 2672 "VideoSupport.c"
	}
	goto __finally495;
	__catch495_video_error:
	{
		GError* err = NULL;
		GError* _tmp29_ = NULL;
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 137 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp29_ = err;
#line 137 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (g_error_matches (_tmp29_, VIDEO_ERROR, VIDEO_ERROR_FILE)) {
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = IMPORT_RESULT_FILE_ERROR;
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (reader);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (info);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (file);
#line 138 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 2705 "VideoSupport.c"
		} else {
			GError* _tmp30_ = NULL;
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp30_ = err;
#line 139 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_error_matches (_tmp30_, VIDEO_ERROR, VIDEO_ERROR_CONTENTS)) {
#line 140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				is_interpretable = FALSE;
#line 141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				clip_duration = 0.0;
#line 2716 "VideoSupport.c"
			} else {
#line 143 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_error ("VideoSupport.vala:143: can't prepare video for import: an unknown kind" \
" of video error occurred");
#line 2720 "VideoSupport.c"
			}
		}
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 2725 "VideoSupport.c"
	}
	__finally495:
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (reader);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (comment);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (title);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 134 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2748 "VideoSupport.c"
	}
	{
		VideoMetadata* metadata = NULL;
		VideoReader* _tmp31_ = NULL;
		VideoMetadata* _tmp32_ = NULL;
		MetadataDateTime* creation_date_time = NULL;
		VideoMetadata* _tmp33_ = NULL;
		MetadataDateTime* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		MetadataDateTime* _tmp36_ = NULL;
		gchar* video_title = NULL;
		VideoMetadata* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* video_comment = NULL;
		VideoMetadata* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		const gchar* _tmp48_ = NULL;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp31_ = reader;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp32_ = video_reader_read_metadata (_tmp31_, &_inner_error_);
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		metadata = _tmp32_;
#line 148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2775 "VideoSupport.c"
			goto __catch496_g_error;
		}
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp33_ = metadata;
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp34_ = media_metadata_get_creation_date_time (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		creation_date_time = _tmp34_;
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp36_ = creation_date_time;
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp36_ != NULL) {
#line 2788 "VideoSupport.c"
			MetadataDateTime* _tmp37_ = NULL;
			time_t _tmp38_ = 0;
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp37_ = creation_date_time;
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp38_ = metadata_date_time_get_timestamp (_tmp37_);
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = _tmp38_ != ((time_t) 0);
#line 2797 "VideoSupport.c"
		} else {
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = FALSE;
#line 2801 "VideoSupport.c"
		}
#line 151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp35_) {
#line 2805 "VideoSupport.c"
			MetadataDateTime* _tmp39_ = NULL;
			time_t _tmp40_ = 0;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp39_ = creation_date_time;
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp40_ = metadata_date_time_get_timestamp (_tmp39_);
#line 152 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			exposure_time = _tmp40_;
#line 2814 "VideoSupport.c"
		}
#line 154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp41_ = metadata;
#line 154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp42_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 154 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_title = _tmp42_;
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp43_ = metadata;
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp44_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, TYPE_MEDIA_METADATA, MediaMetadata));
#line 155 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_comment = _tmp44_;
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp45_ = video_title;
#line 156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp45_ != NULL) {
#line 2832 "VideoSupport.c"
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp46_ = video_title;
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp47_ = g_strdup (_tmp46_);
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (title);
#line 157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			title = _tmp47_;
#line 2843 "VideoSupport.c"
		}
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp48_ = video_comment;
#line 158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp48_ != NULL) {
#line 2849 "VideoSupport.c"
			const gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp49_ = video_comment;
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp50_ = g_strdup (_tmp49_);
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (comment);
#line 159 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			comment = _tmp50_;
#line 2860 "VideoSupport.c"
		}
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_comment);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_title);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_metadata_date_time_unref0 (creation_date_time);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_metadata_unref0 (metadata);
#line 2870 "VideoSupport.c"
	}
	goto __finally496;
	__catch496_g_error:
	{
		GError* err = NULL;
		GError* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp51_ = err;
#line 161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp52_ = _tmp51_->message;
#line 161 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_warning ("VideoSupport.vala:161: Unable to read video metadata: %s", _tmp52_);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 2890 "VideoSupport.c"
	}
	__finally496:
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (reader);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (comment);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (title);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (file);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 147 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 2913 "VideoSupport.c"
	}
#line 164 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp53_ = exposure_time;
#line 164 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp53_ == ((time_t) 0)) {
#line 2919 "VideoSupport.c"
		gint64 _tmp54_ = 0LL;
		VideoReader* _tmp55_ = NULL;
		GDateTime* _tmp56_ = NULL;
#line 166 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp55_ = reader;
#line 166 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp56_ = _tmp55_->priv->_timestamp;
#line 166 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp56_ != NULL) {
#line 2929 "VideoSupport.c"
			VideoReader* _tmp57_ = NULL;
			GDateTime* _tmp58_ = NULL;
			gint64 _tmp59_ = 0LL;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp57_ = reader;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp58_ = _tmp57_->priv->_timestamp;
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp59_ = g_date_time_to_unix (_tmp58_);
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp54_ = _tmp59_;
#line 2941 "VideoSupport.c"
		} else {
#line 167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp54_ = (gint64) 0;
#line 2945 "VideoSupport.c"
		}
#line 166 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		exposure_time = (time_t) _tmp54_;
#line 2949 "VideoSupport.c"
	}
#line 170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp60_ = params;
#line 170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp61_ = _tmp60_->row;
#line 170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp61_->video_id, VIDEO_ID_INVALID);
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp62_ = params;
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_ = _tmp62_->row;
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp64_ = file;
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp65_ = g_file_get_path (_tmp64_);
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp63_->filepath);
#line 171 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_->filepath = _tmp65_;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp66_ = params;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp67_ = _tmp66_->row;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp68_ = info;
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp69_ = g_file_info_get_size (_tmp68_);
#line 172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp67_->filesize = _tmp69_;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp70_ = params;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp71_ = _tmp70_->row;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp72_ = timestamp;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp73_ = _tmp72_.tv_sec;
#line 173 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp71_->timestamp = (time_t) _tmp73_;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp74_ = params;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp75_ = _tmp74_->row;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp76_ = preview_frame;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp77_ = gdk_pixbuf_get_width (_tmp76_);
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp78_ = _tmp77_;
#line 174 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp75_->width = _tmp78_;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp79_ = params;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp80_ = _tmp79_->row;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp81_ = preview_frame;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp82_ = gdk_pixbuf_get_height (_tmp81_);
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp83_ = _tmp82_;
#line 175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp80_->height = _tmp83_;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp84_ = params;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp85_ = _tmp84_->row;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp86_ = clip_duration;
#line 176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp85_->clip_duration = _tmp86_;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp87_ = params;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp88_ = _tmp87_->row;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp89_ = is_interpretable;
#line 177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp88_->is_interpretable = _tmp89_;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp90_ = params;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp91_ = _tmp90_->row;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp92_ = exposure_time;
#line 178 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp91_->exposure_time = _tmp92_;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp93_ = params;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp94_ = _tmp93_->row;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp95_ = params;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp96_ = _tmp95_->import_id;
#line 179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp94_->import_id = _tmp96_;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp97_ = params;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp98_ = _tmp97_->row;
#line 180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	event_id_init (&_tmp98_->event_id, EVENT_ID_INVALID);
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp99_ = params;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp100_ = _tmp99_->row;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp101_ = params;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp102_ = _tmp101_->md5;
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp103_ = g_strdup (_tmp102_);
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp100_->md5);
#line 181 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp100_->md5 = _tmp103_;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp104_ = params;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp105_ = _tmp104_->row;
#line 182 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp105_->time_created = (time_t) 0;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp106_ = params;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp107_ = _tmp106_->row;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp108_ = title;
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp109_ = g_strdup (_tmp108_);
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp107_->title);
#line 183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp107_->title = _tmp109_;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp110_ = params;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp111_ = _tmp110_->row;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp112_ = comment;
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp113_ = g_strdup (_tmp112_);
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp111_->comment);
#line 184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp111_->comment = _tmp113_;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp114_ = params;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp115_ = _tmp114_->row;
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp116_ = g_strdup ("");
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp115_->backlinks);
#line 185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp115_->backlinks = _tmp116_;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp117_ = params;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp118_ = _tmp117_->row;
#line 186 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp118_->time_reimported = (time_t) 0;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp119_ = params;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp120_ = _tmp119_->row;
#line 187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp120_->flags = (guint64) 0;
#line 189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp121_ = params;
#line 189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp122_ = _tmp121_->thumbnails;
#line 189 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp122_ != NULL) {
#line 3125 "VideoSupport.c"
		VideoImportParams* _tmp123_ = NULL;
		Thumbnails* _tmp124_ = NULL;
		VideoImportParams* _tmp125_ = NULL;
		Thumbnails* _tmp126_ = NULL;
		GdkPixbuf* _tmp127_ = NULL;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp123_ = params;
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp124_ = thumbnails_new ();
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_thumbnails_unref0 (_tmp123_->thumbnails);
#line 190 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp123_->thumbnails = _tmp124_;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp125_ = params;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp126_ = _tmp125_->thumbnails;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp127_ = preview_frame;
#line 191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		thumbnail_cache_generate_for_video_frame (_tmp126_, _tmp127_);
#line 3147 "VideoSupport.c"
	}
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (preview_frame);
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (reader);
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (comment);
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (title);
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (info);
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (file);
#line 197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3165 "VideoSupport.c"
}


static GDate* _g_date_dup (GDate* self) {
	GDate* dup;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	dup = g_new0 (GDate, 1);
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	memcpy (dup, self, sizeof (GDate));
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return dup;
#line 3177 "VideoSupport.c"
}


static gpointer __g_date_dup0 (gpointer self) {
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? _g_date_dup (self) : NULL;
#line 3184 "VideoSupport.c"
}


static void video_reader_read_internal (VideoReader* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 200 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_READER (self));
#line 201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_reader_does_file_exist (self);
#line 201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp0_) {
#line 3197 "VideoSupport.c"
		GFile* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->file;
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = g_file_get_path (_tmp1_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = g_strdup_printf ("video file '%s' does not exist or is inaccessible", _tmp3_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_FILE, _tmp5_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = _tmp6_;
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp5_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp3_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = _tmp7_;
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_inner_error_->domain == VIDEO_ERROR) {
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3231 "VideoSupport.c"
		} else {
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3239 "VideoSupport.c"
		}
	}
	{
		GstDiscoverer* d = NULL;
		GstDiscoverer* _tmp8_ = NULL;
		GstDiscovererInfo* info = NULL;
		GstDiscoverer* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GstDiscovererInfo* _tmp13_ = NULL;
		GstDiscovererInfo* _tmp14_ = NULL;
		GstDiscovererInfo* _tmp15_ = NULL;
		GstClockTime _tmp16_ = 0ULL;
		GDate* video_date = NULL;
		gboolean _tmp17_ = FALSE;
		GstDiscovererInfo* _tmp18_ = NULL;
		GstTagList* _tmp19_ = NULL;
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = gst_discoverer_new ((GstClockTime) (GST_SECOND * 5), &_inner_error_);
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		d = _tmp8_;
#line 206 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3264 "VideoSupport.c"
			goto __catch497_g_error;
		}
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = d;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = self->priv->file;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = g_file_get_uri (_tmp10_);
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = _tmp11_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = gst_discoverer_discover_uri (_tmp9_, _tmp12_, &_inner_error_);
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = _tmp13_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp12_);
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		info = _tmp14_;
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (d);
#line 3287 "VideoSupport.c"
			goto __catch497_g_error;
		}
#line 209 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = info;
#line 209 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp16_ = gst_discoverer_info_get_duration (_tmp15_);
#line 209 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->clip_duration = ((gdouble) _tmp16_) / 1000000000.0;
#line 214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_date = NULL;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = info;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = gst_discoverer_info_get_tags (_tmp18_);
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp19_ != NULL) {
#line 3304 "VideoSupport.c"
			GstDiscovererInfo* _tmp20_ = NULL;
			GstTagList* _tmp21_ = NULL;
			GDate _tmp22_ = {0};
			gboolean _tmp23_ = FALSE;
			GDate _tmp24_ = {0};
			GDate* _tmp25_ = NULL;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = info;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = gst_discoverer_info_get_tags (_tmp20_);
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = gst_tag_list_get_date (_tmp21_, GST_TAG_DATE, &_tmp22_);
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (video_date);
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = _tmp22_;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = __g_date_dup0 (&_tmp24_);
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_date = _tmp25_;
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = _tmp23_;
#line 3327 "VideoSupport.c"
		} else {
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = FALSE;
#line 3331 "VideoSupport.c"
		}
#line 215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp17_) {
#line 3335 "VideoSupport.c"
			GDate* _tmp26_ = NULL;
#line 217 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp26_ = video_date;
#line 217 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp26_ != NULL) {
#line 3341 "VideoSupport.c"
				GDate* _tmp27_ = NULL;
				GDateYear _tmp28_ = 0U;
				GDate* _tmp29_ = NULL;
				GDateMonth _tmp30_ = 0;
				GDate* _tmp31_ = NULL;
				GDateDay _tmp32_ = '\0';
				GDateTime* _tmp33_ = NULL;
				GDateTime* _tmp34_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp27_ = video_date;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp28_ = g_date_get_year (_tmp27_);
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp29_ = video_date;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp30_ = g_date_get_month (_tmp29_);
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp31_ = video_date;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp32_ = g_date_get_day (_tmp31_);
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp33_ = g_date_time_new_local ((gint) _tmp28_, (gint) _tmp30_, (gint) _tmp32_, 0, 0, (gdouble) 0);
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp34_ = _tmp33_;
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_reader_set_timestamp (self, _tmp34_);
#line 218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_date_time_unref0 (_tmp34_);
#line 3370 "VideoSupport.c"
			}
		}
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (video_date);
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (info);
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (d);
#line 3379 "VideoSupport.c"
	}
	goto __finally497;
	__catch497_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		GError* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		GError* _tmp41_ = NULL;
		GError* _tmp42_ = NULL;
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp35_ = e;
#line 223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp36_ = _tmp35_->message;
#line 223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:223: Video read error: %s", _tmp36_);
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp37_ = e;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp38_ = _tmp37_->message;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp39_ = g_strdup_printf ("GStreamer couldn't extract clip information: %s", _tmp38_);
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp40_ = _tmp39_;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp41_ = g_error_new_literal (VIDEO_ERROR, VIDEO_ERROR_CONTENTS, _tmp40_);
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp42_ = _tmp41_;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp40_);
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = _tmp42_;
#line 224 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 3421 "VideoSupport.c"
		goto __finally497;
	}
	__finally497:
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_inner_error_->domain == VIDEO_ERROR) {
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3433 "VideoSupport.c"
		} else {
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 3441 "VideoSupport.c"
		}
	}
}


static gboolean video_reader_on_thumbnailer_timer (VideoReader* self) {
	gboolean result = FALSE;
	GPid _tmp0_ = 0;
#line 230 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
#line 231 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:231: Thumbnailer timer called");
#line 232 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->thumbnailer_pid;
#line 232 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != ((GPid) 0)) {
#line 3458 "VideoSupport.c"
		GPid _tmp1_ = 0;
		GPid _tmp2_ = 0;
#line 233 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->thumbnailer_pid;
#line 233 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:233: Killing thumbnailer process: %d", (gint) _tmp1_);
#line 234 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->thumbnailer_pid;
#line 234 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		kill ((pid_t) _tmp2_, SIGKILL);
#line 3469 "VideoSupport.c"
	}
#line 236 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = FALSE;
#line 236 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3475 "VideoSupport.c"
}


static gboolean _video_reader_on_thumbnailer_timer_gsource_func (gpointer self) {
	gboolean result;
	result = video_reader_on_thumbnailer_timer ((VideoReader*) self);
#line 259 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3484 "VideoSupport.c"
}


static GdkPixbuf* video_reader_thumbnailer (VideoReader* self, const gchar* video_file) {
	GdkPixbuf* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** argv = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gint child_stdout = 0;
	GdkPixbuf* buf = NULL;
	gint child_status = 0;
	gint ret_waitpid = 0;
	GPid _tmp27_ = 0;
	gint _tmp28_ = 0;
	pid_t _tmp29_ = 0;
	gint _tmp30_ = 0;
	GPid _tmp36_ = 0;
	GError * _inner_error_ = NULL;
#line 241 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 241 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (video_file != NULL, NULL);
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = app_dirs_get_thumbnailer_bin ();
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:243: Launching thumbnailer process: %s", _tmp3_);
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp3_);
#line 243 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp1_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = app_dirs_get_thumbnailer_bin ();
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_file;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = g_new0 (gchar*, 2 + 1);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_[0] = _tmp6_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_[1] = _tmp8_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = _tmp9_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10__length1 = 2;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp5_);
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv = _tmp10_;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv_length1 = _tmp10__length1;
#line 244 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_argv_size_ = argv_length1;
#line 3561 "VideoSupport.c"
	{
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		GPid _tmp12_ = 0;
		gint _tmp13_ = 0;
		GPid _tmp14_ = 0;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = argv;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11__length1 = argv_length1;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_spawn_async_with_pipes (NULL, _tmp11_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp12_, NULL, &_tmp13_, NULL, &_inner_error_);
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->thumbnailer_pid = _tmp12_;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		child_stdout = _tmp13_;
#line 247 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3580 "VideoSupport.c"
			goto __catch498_g_error;
		}
#line 250 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = self->priv->thumbnailer_pid;
#line 250 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:250: Spawned thumbnailer, child pid: %d", (gint) _tmp14_);
#line 3587 "VideoSupport.c"
	}
	goto __finally498;
	__catch498_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GPid _tmp17_ = 0;
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 252 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = e;
#line 252 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp16_ = _tmp15_->message;
#line 252 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:252: Error spawning process: %s", _tmp16_);
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp17_ = self->priv->thumbnailer_pid;
#line 253 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp17_ != ((GPid) 0)) {
#line 3610 "VideoSupport.c"
			GPid _tmp18_ = 0;
#line 254 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->thumbnailer_pid;
#line 254 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_spawn_close_pid (_tmp18_);
#line 3616 "VideoSupport.c"
		}
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 255 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3626 "VideoSupport.c"
	}
	__finally498:
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 246 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3639 "VideoSupport.c"
	}
#line 259 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_timeout_add_full (G_PRIORITY_DEFAULT, VIDEO_READER_THUMBNAILER_TIMEOUT, _video_reader_on_thumbnailer_timer_gsource_func, video_reader_ref (self), video_reader_unref);
#line 262 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	buf = NULL;
#line 3645 "VideoSupport.c"
	{
		GUnixInputStream* unix_input = NULL;
		gint _tmp19_ = 0;
		GUnixInputStream* _tmp20_ = NULL;
		GdkPixbuf* _tmp21_ = NULL;
		GUnixInputStream* _tmp22_ = NULL;
		GdkPixbuf* _tmp23_ = NULL;
		GdkPixbuf* _tmp24_ = NULL;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = child_stdout;
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = (GUnixInputStream*) g_unix_input_stream_new (_tmp19_, TRUE);
#line 264 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		unix_input = _tmp20_;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp22_ = unix_input;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp23_ = gdk_pixbuf_new_from_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = _tmp23_;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (unix_input);
#line 3670 "VideoSupport.c"
			goto __catch499_g_error;
		}
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp24_ = _tmp21_;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp21_ = NULL;
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 265 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = _tmp24_;
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp21_);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (unix_input);
#line 3685 "VideoSupport.c"
	}
	goto __finally499;
	__catch499_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 267 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp25_ = e;
#line 267 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = _tmp25_->message;
#line 267 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:267: Error creating pixbuf: %s", _tmp26_);
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 268 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = NULL;
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 3709 "VideoSupport.c"
	}
	__finally499:
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 263 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3724 "VideoSupport.c"
	}
#line 272 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	child_status = 0;
#line 273 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = self->priv->thumbnailer_pid;
#line 273 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp29_ = waitpid ((pid_t) _tmp27_, &_tmp28_, 0);
#line 273 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	child_status = _tmp28_;
#line 273 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	ret_waitpid = (gint) _tmp29_;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp30_ = ret_waitpid;
#line 274 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp30_ < 0) {
#line 3740 "VideoSupport.c"
		gint _tmp31_ = 0;
#line 275 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp31_ = ret_waitpid;
#line 275 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_debug ("VideoSupport.vala:275: waitpid returned error code: %d", _tmp31_);
#line 276 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (buf);
#line 276 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		buf = NULL;
#line 3750 "VideoSupport.c"
	} else {
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp32_ = child_status;
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp33_ = WEXITSTATUS (_tmp32_);
#line 277 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (0 != _tmp33_) {
#line 3760 "VideoSupport.c"
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp34_ = child_status;
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = WEXITSTATUS (_tmp34_);
#line 278 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_debug ("VideoSupport.vala:278: Thumbnailer exited with error code: %d", _tmp35_);
#line 280 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (buf);
#line 280 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			buf = NULL;
#line 3773 "VideoSupport.c"
		}
	}
#line 283 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp36_ = self->priv->thumbnailer_pid;
#line 283 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_spawn_close_pid (_tmp36_);
#line 284 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->thumbnailer_pid = (GPid) 0;
#line 285 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = buf;
#line 285 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
#line 285 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3788 "VideoSupport.c"
}


static gboolean video_reader_does_file_exist (VideoReader* self) {
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 288 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), FALSE);
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->file;
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS | G_FILE_TEST_IS_REGULAR);
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_);
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 289 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3817 "VideoSupport.c"
}


GdkPixbuf* video_reader_read_preview_frame (VideoReader* self) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gboolean _tmp3_ = FALSE;
	GFile* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
	GdkPixbuf* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_ = NULL;
#line 292 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 293 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->preview_frame;
#line 293 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != NULL) {
#line 3838 "VideoSupport.c"
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->preview_frame;
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = _tmp2_;
#line 294 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3849 "VideoSupport.c"
	}
#line 296 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_does_file_exist (self);
#line 296 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp3_) {
#line 297 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 297 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 3859 "VideoSupport.c"
	}
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = self->priv->file;
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = g_file_get_path (_tmp4_);
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_reader_thumbnailer (self, _tmp6_);
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->preview_frame);
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->preview_frame = _tmp7_;
#line 300 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp6_);
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = self->priv->preview_frame;
#line 301 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (NULL == _tmp8_) {
#line 3879 "VideoSupport.c"
		GdkPixbuf* _tmp9_ = NULL;
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = resources_get_noninterpretable_badge_pixbuf ();
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (self->priv->preview_frame);
#line 302 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->preview_frame = _tmp9_;
#line 3887 "VideoSupport.c"
	}
#line 304 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = self->priv->preview_frame;
#line 304 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 304 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp11_;
#line 304 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3897 "VideoSupport.c"
}


gdouble video_reader_read_clip_duration (VideoReader* self, GError** error) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GError * _inner_error_ = NULL;
#line 307 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), 0.0);
#line 308 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->clip_duration;
#line 308 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ == VIDEO_READER_UNKNOWN_CLIP_DURATION) {
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_read_internal (self, &_inner_error_);
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 3918 "VideoSupport.c"
				gdouble _tmp1_ = 0.0;
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_propagate_error (error, _inner_error_);
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp1_;
#line 3924 "VideoSupport.c"
			} else {
				gdouble _tmp2_ = 0.0;
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 309 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp2_;
#line 3933 "VideoSupport.c"
			}
		}
	}
#line 311 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->priv->clip_duration;
#line 311 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 311 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3943 "VideoSupport.c"
}


VideoMetadata* video_reader_read_metadata (VideoReader* self, GError** error) {
	VideoMetadata* result = NULL;
	VideoMetadata* metadata = NULL;
	VideoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 314 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 315 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_metadata_new ();
#line 315 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	metadata = _tmp0_;
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = self->priv->file;
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = g_file_new_for_path (_tmp3_);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp5_, &_inner_error_);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp5_);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp3_);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_metadata_unref0 (metadata);
#line 316 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 3987 "VideoSupport.c"
	}
#line 318 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = metadata;
#line 318 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 3993 "VideoSupport.c"
}


GDateTime* video_reader_get_timestamp (VideoReader* self) {
	GDateTime* result;
	GDateTime* _tmp0_ = NULL;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_READER (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->_timestamp;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4008 "VideoSupport.c"
}


static gpointer _g_date_time_ref0 (gpointer self) {
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? g_date_time_ref (self) : NULL;
#line 4015 "VideoSupport.c"
}


static void video_reader_set_timestamp (VideoReader* self, GDateTime* value) {
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp1_ = NULL;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_READER (self));
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = value;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_date_time_unref0 (self->priv->_timestamp);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_timestamp = _tmp1_;
#line 4032 "VideoSupport.c"
}


static void value_video_reader_init (GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 4039 "VideoSupport.c"
}


static void value_video_reader_free_value (GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (value->data[0].v_pointer);
#line 4048 "VideoSupport.c"
	}
}


static void value_video_reader_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_reader_ref (src_value->data[0].v_pointer);
#line 4058 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4062 "VideoSupport.c"
	}
}


static gpointer value_video_reader_peek_pointer (const GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 4070 "VideoSupport.c"
}


static gchar* value_video_reader_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 4077 "VideoSupport.c"
		VideoReader* object;
		object = collect_values[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4084 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4088 "VideoSupport.c"
		}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_reader_ref (object);
#line 4092 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4096 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 4100 "VideoSupport.c"
}


static gchar* value_video_reader_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoReader** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4111 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 4117 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 4121 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_reader_ref (value->data[0].v_pointer);
#line 4125 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 4129 "VideoSupport.c"
}


GParamSpec* param_spec_video_reader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecVideoReader* spec;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_VIDEO_READER), NULL);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 4143 "VideoSupport.c"
}


gpointer value_get_video_reader (const GValue* value) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER), NULL);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 4152 "VideoSupport.c"
}


void value_set_video_reader (GValue* value, gpointer v_object) {
	VideoReader* old;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_ref (value->data[0].v_pointer);
#line 4172 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4176 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (old);
#line 4182 "VideoSupport.c"
	}
}


void value_take_video_reader (GValue* value, gpointer v_object) {
	VideoReader* old;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_VIDEO_READER));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 4201 "VideoSupport.c"
	} else {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 4205 "VideoSupport.c"
	}
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_reader_unref (old);
#line 4211 "VideoSupport.c"
	}
}


static void video_reader_class_init (VideoReaderClass * klass) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_reader_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoReaderClass *) klass)->finalize = video_reader_finalize;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoReaderPrivate));
#line 4223 "VideoSupport.c"
}


static void video_reader_instance_init (VideoReader * self) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_READER_GET_PRIVATE (self);
#line 45 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->clip_duration = VIDEO_READER_UNKNOWN_CLIP_DURATION;
#line 46 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->preview_frame = NULL;
#line 47 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->file = NULL;
#line 48 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->thumbnailer_pid = (GPid) 0;
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_timestamp = NULL;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 4242 "VideoSupport.c"
}


static void video_reader_finalize (VideoReader* obj) {
	VideoReader * self;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_READER, VideoReader);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 46 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->preview_frame);
#line 47 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->file);
#line 49 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_date_time_unref0 (self->priv->_timestamp);
#line 4258 "VideoSupport.c"
}


GType video_reader_get_type (void) {
	static volatile gsize video_reader_type_id__volatile = 0;
	if (g_once_init_enter (&video_reader_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_video_reader_init, value_video_reader_free_value, value_video_reader_copy_value, value_video_reader_peek_pointer, "p", value_video_reader_collect_value, "p", value_video_reader_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoReader), 0, (GInstanceInitFunc) video_reader_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_reader_type_id;
		video_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_reader_type_id__volatile, video_reader_type_id);
	}
	return video_reader_type_id__volatile;
}


gpointer video_reader_ref (gpointer instance) {
	VideoReader* self;
	self = instance;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 4283 "VideoSupport.c"
}


void video_reader_unref (gpointer instance) {
	VideoReader* self;
	self = instance;
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_READER_GET_CLASS (self)->finalize (self);
#line 38 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4296 "VideoSupport.c"
	}
}


static gpointer _video_row_ref0 (gpointer self) {
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self ? video_row_ref (self) : NULL;
#line 4304 "VideoSupport.c"
}


Video* video_construct (GType object_type, VideoRow* row) {
	Video * self = NULL;
	VideoRow* _tmp0_ = NULL;
	VideoRow* _tmp1_ = NULL;
	VideoRow* _tmp2_ = NULL;
	VideoRow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	VideoRow* _tmp7_ = NULL;
	guint64 _tmp8_ = 0ULL;
#line 365 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_ROW (row), NULL);
#line 365 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (Video*) video_source_construct (object_type);
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = row;
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _video_row_ref0 (_tmp0_);
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->priv->backing_row);
#line 366 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->backing_row = _tmp1_;
#line 369 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = self->priv->backing_row;
#line 369 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->priv->backing_row;
#line 369 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_->title;
#line 369 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = media_source_prep_title (_tmp4_);
#line 369 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp2_->title);
#line 369 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_->title = _tmp5_;
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = row;
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = _tmp7_->flags;
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if ((_tmp8_ & VIDEO_FLAG_TRASH) != ((guint64) 0)) {
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = TRUE;
#line 4351 "VideoSupport.c"
	} else {
		VideoRow* _tmp9_ = NULL;
		guint64 _tmp10_ = 0ULL;
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = row;
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_->flags;
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = (_tmp10_ & VIDEO_FLAG_OFFLINE) != ((guint64) 0);
#line 4361 "VideoSupport.c"
	}
#line 371 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp6_) {
#line 4365 "VideoSupport.c"
		VideoSourceCollection* _tmp11_ = NULL;
		VideoRow* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = video_global;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = row;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = _tmp12_->backlinks;
#line 372 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp13_);
#line 4377 "VideoSupport.c"
	}
#line 365 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 4381 "VideoSupport.c"
}


Video* video_new (VideoRow* row) {
#line 365 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_construct (TYPE_VIDEO, row);
#line 4388 "VideoSupport.c"
}


void video_init (ProgressMonitor monitor, void* monitor_target) {
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	GstRegistry* registry = NULL;
	GstRegistry* _tmp0_ = NULL;
	GstRegistry* _tmp1_ = NULL;
	gint saved_state = 0;
	ConfigFacade* _tmp2_ = NULL;
	ConfigFacade* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GstRegistry* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	gint _tmp8_ = 0;
	GstPluginFeature* feature = NULL;
	GstRegistry* _tmp11_ = NULL;
	GstPluginFeature* _tmp12_ = NULL;
	GstPluginFeature* _tmp13_ = NULL;
	GstRegistry* _tmp16_ = NULL;
	GstPluginFeature* _tmp17_ = NULL;
	GstPluginFeature* _tmp18_ = NULL;
	VideoSourceCollection* _tmp21_ = NULL;
	GeeArrayList* all = NULL;
	VideoTable* _tmp22_ = NULL;
	VideoTable* _tmp23_ = NULL;
	GeeArrayList* _tmp24_ = NULL;
	GeeArrayList* _tmp25_ = NULL;
	GeeArrayList* all_videos = NULL;
	GeeArrayList* _tmp26_ = NULL;
	GeeArrayList* trashed_videos = NULL;
	GeeArrayList* _tmp27_ = NULL;
	GeeArrayList* offline_videos = NULL;
	GeeArrayList* _tmp28_ = NULL;
	gint count = 0;
	GeeArrayList* _tmp29_ = NULL;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	VideoSourceCollection* _tmp58_ = NULL;
	GeeArrayList* _tmp59_ = NULL;
	VideoSourceCollection* _tmp60_ = NULL;
	GeeArrayList* _tmp61_ = NULL;
	VideoSourceCollection* _tmp62_ = NULL;
	GeeArrayList* _tmp63_ = NULL;
	GeeCollection* _tmp64_ = NULL;
	GeeCollection* _tmp65_ = NULL;
#line 379 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_interpreter_state_changed = FALSE;
#line 380 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_current_state = -1;
#line 381 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_normal_regen_complete = FALSE;
#line 382 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_offline_regen_complete = FALSE;
#line 386 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	args = NULL;
#line 386 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	args_length1 = 0;
#line 386 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_args_size_ = args_length1;
#line 387 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	gst_init (&args_length1, &args);
#line 389 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gst_registry_get ();
#line 389 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 389 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	registry = _tmp1_;
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = config_facade_get_instance ();
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = configuration_facade_get_video_interpreter_state_cookie (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = _tmp4_;
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp3_);
#line 390 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	saved_state = _tmp5_;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = registry;
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = gst_registry_get_feature_list_cookie (_tmp6_);
#line 391 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_current_state = (gint) _tmp7_;
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = saved_state;
#line 392 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp8_ == CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE) {
#line 393 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("VideoSupport.vala:393: interpreter state cookie not found; assuming al" \
"l video thumbnails are out of date");
#line 394 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpreter_state_changed = TRUE;
#line 4486 "VideoSupport.c"
	} else {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 395 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = saved_state;
#line 395 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = video_current_state;
#line 395 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp9_ != _tmp10_) {
#line 396 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_message ("VideoSupport.vala:396: interpreter state has changed; video thumbnails" \
" may be out of date");
#line 397 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_interpreter_state_changed = TRUE;
#line 4500 "VideoSupport.c"
		}
	}
#line 406 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = registry;
#line 406 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp12_ = gst_registry_find_feature (_tmp11_, "vaapidecodebin", gst_element_factory_get_type ());
#line 406 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	feature = _tmp12_;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = feature;
#line 408 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp13_ != NULL) {
#line 4513 "VideoSupport.c"
		GstRegistry* _tmp14_ = NULL;
		GstPluginFeature* _tmp15_ = NULL;
#line 409 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = registry;
#line 409 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = feature;
#line 409 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		gst_registry_remove_feature (_tmp14_, _tmp15_);
#line 4522 "VideoSupport.c"
	}
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = registry;
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp17_ = gst_registry_find_feature (_tmp16_, "vaapidecode", gst_element_factory_get_type ());
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (feature);
#line 412 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	feature = _tmp17_;
#line 414 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = feature;
#line 414 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp18_ != NULL) {
#line 4536 "VideoSupport.c"
		GstRegistry* _tmp19_ = NULL;
		GstPluginFeature* _tmp20_ = NULL;
#line 415 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = registry;
#line 415 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = feature;
#line 415 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		gst_registry_remove_feature (_tmp19_, _tmp20_);
#line 4545 "VideoSupport.c"
	}
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = video_source_collection_new ();
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_data_collection_unref0 (video_global);
#line 418 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_global = _tmp21_;
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = video_table_get_instance ();
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = _tmp22_;
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = video_table_get_all (_tmp23_);
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = _tmp24_;
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp23_);
#line 420 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	all = _tmp25_;
#line 421 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 421 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	all_videos = _tmp26_;
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 422 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	trashed_videos = _tmp27_;
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp28_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 423 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	offline_videos = _tmp28_;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp29_ = all;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp30_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp31_ = _tmp30_;
#line 424 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	count = _tmp31_;
#line 4585 "VideoSupport.c"
	{
		gint ctr = 0;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		ctr = 0;
#line 4590 "VideoSupport.c"
		{
			gboolean _tmp32_ = FALSE;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp32_ = TRUE;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 4597 "VideoSupport.c"
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				Video* video = NULL;
				GeeArrayList* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gpointer _tmp38_ = NULL;
				VideoRow* _tmp39_ = NULL;
				Video* _tmp40_ = NULL;
				Video* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
				Video* _tmp44_ = NULL;
				gboolean _tmp45_ = FALSE;
				ProgressMonitor _tmp54_ = NULL;
				void* _tmp54__target = NULL;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp32_) {
#line 4614 "VideoSupport.c"
					gint _tmp33_ = 0;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp33_ = ctr;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					ctr = _tmp33_ + 1;
#line 4620 "VideoSupport.c"
				}
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp32_ = FALSE;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp34_ = ctr;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp35_ = count;
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!(_tmp34_ < _tmp35_)) {
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 4632 "VideoSupport.c"
				}
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp36_ = all;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp37_ = ctr;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp38_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp37_);
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp39_ = (VideoRow*) _tmp38_;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp40_ = video_new (_tmp39_);
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp41_ = _tmp40_;
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_video_row_unref0 (_tmp39_);
#line 426 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp41_;
#line 428 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp42_ = video_interpreter_state_changed;
#line 428 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp42_) {
#line 4654 "VideoSupport.c"
					Video* _tmp43_ = NULL;
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp43_ = video;
#line 429 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					video_set_is_interpretable (_tmp43_, FALSE);
#line 4660 "VideoSupport.c"
				}
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp44_ = video;
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp45_ = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, TYPE_MEDIA_SOURCE, MediaSource));
#line 431 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp45_) {
#line 4668 "VideoSupport.c"
					GeeArrayList* _tmp46_ = NULL;
					Video* _tmp47_ = NULL;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp46_ = trashed_videos;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp47_ = video;
#line 432 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp47_);
#line 4677 "VideoSupport.c"
				} else {
					Video* _tmp48_ = NULL;
					gboolean _tmp49_ = FALSE;
#line 433 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp48_ = video;
#line 433 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp49_ = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_MEDIA_SOURCE, MediaSource));
#line 433 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_tmp49_) {
#line 4687 "VideoSupport.c"
						GeeArrayList* _tmp50_ = NULL;
						Video* _tmp51_ = NULL;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp50_ = offline_videos;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp51_ = video;
#line 434 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp51_);
#line 4696 "VideoSupport.c"
					} else {
						GeeArrayList* _tmp52_ = NULL;
						Video* _tmp53_ = NULL;
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp52_ = all_videos;
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp53_ = video;
#line 436 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp53_);
#line 4706 "VideoSupport.c"
					}
				}
#line 438 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp54_ = monitor;
#line 438 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp54__target = monitor_target;
#line 438 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp54_ != NULL) {
#line 4715 "VideoSupport.c"
					ProgressMonitor _tmp55_ = NULL;
					void* _tmp55__target = NULL;
					gint _tmp56_ = 0;
					gint _tmp57_ = 0;
#line 439 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp55_ = monitor;
#line 439 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp55__target = monitor_target;
#line 439 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp56_ = ctr;
#line 439 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp57_ = count;
#line 439 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp55_ ((guint64) _tmp56_, (guint64) _tmp57_, TRUE, _tmp55__target);
#line 4730 "VideoSupport.c"
				}
#line 425 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 4734 "VideoSupport.c"
			}
		}
	}
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp58_ = video_global;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp59_ = trashed_videos;
#line 442 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_collection_add_many_to_trash (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, GEE_TYPE_COLLECTION, GeeCollection));
#line 443 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp60_ = video_global;
#line 443 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp61_ = offline_videos;
#line 443 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_collection_add_many_to_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COLLECTION, GeeCollection));
#line 444 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp62_ = video_global;
#line 444 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp63_ = all_videos;
#line 444 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp64_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
#line 444 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp65_ = _tmp64_;
#line 444 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp65_);
#line 375 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (offline_videos);
#line 375 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (trashed_videos);
#line 375 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (all_videos);
#line 375 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (all);
#line 375 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (feature);
#line 375 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (registry);
#line 4772 "VideoSupport.c"
}


gboolean video_has_interpreter_state_changed (void) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 448 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpreter_state_changed;
#line 448 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 448 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 4785 "VideoSupport.c"
}


void video_notify_normal_thumbs_regenerated (void) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 452 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_normal_regen_complete;
#line 452 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 453 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 4799 "VideoSupport.c"
	}
#line 455 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_message ("VideoSupport.vala:455: normal video thumbnail regeneration completed");
#line 457 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_normal_regen_complete = TRUE;
#line 458 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_normal_regen_complete;
#line 458 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 4809 "VideoSupport.c"
		gboolean _tmp3_ = FALSE;
#line 458 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_offline_regen_complete;
#line 458 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp3_;
#line 4815 "VideoSupport.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 4819 "VideoSupport.c"
	}
#line 458 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 459 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_save_interpreter_state ();
#line 4825 "VideoSupport.c"
	}
}


void video_notify_offline_thumbs_regenerated (void) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 463 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_offline_regen_complete;
#line 463 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 464 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 4840 "VideoSupport.c"
	}
#line 466 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_message ("VideoSupport.vala:466: offline video thumbnail regeneration completed");
#line 468 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_offline_regen_complete = TRUE;
#line 469 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_normal_regen_complete;
#line 469 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 4850 "VideoSupport.c"
		gboolean _tmp3_ = FALSE;
#line 469 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_offline_regen_complete;
#line 469 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp3_;
#line 4856 "VideoSupport.c"
	} else {
#line 469 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 4860 "VideoSupport.c"
	}
#line 469 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_) {
#line 470 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_save_interpreter_state ();
#line 4866 "VideoSupport.c"
	}
}


static void video_save_interpreter_state (void) {
	gboolean _tmp0_ = FALSE;
#line 474 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpreter_state_changed;
#line 474 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 4877 "VideoSupport.c"
		ConfigFacade* _tmp1_ = NULL;
		ConfigFacade* _tmp2_ = NULL;
		gint _tmp3_ = 0;
#line 475 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_message ("VideoSupport.vala:475: saving video interpreter state to configuration" \
" system");
#line 477 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = config_facade_get_instance ();
#line 477 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 477 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_current_state;
#line 477 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		configuration_facade_set_video_interpreter_state_cookie (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_);
#line 477 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp2_);
#line 478 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpreter_state_changed = FALSE;
#line 4895 "VideoSupport.c"
	}
}


void video_terminate (void) {
}


ExporterUI* video_export_many (GeeCollection* videos, ExporterCompletionCallback done, void* done_target, gboolean export_in_place) {
	ExporterUI* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GeeCollection* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GFile* export_dir = NULL;
	const gchar* _tmp39_ = NULL;
	GFile* _tmp40_ = NULL;
	GFile* _tmp41_ = NULL;
	ExporterUI* exporter = NULL;
	GeeCollection* _tmp42_ = NULL;
	GFile* _tmp43_ = NULL;
	Scaling _tmp44_ = {0};
	ExportFormatParameters _tmp45_ = {0};
	Exporter* _tmp46_ = NULL;
	Exporter* _tmp47_ = NULL;
	ExporterUI* _tmp48_ = NULL;
	ExporterUI* _tmp49_ = NULL;
	ExporterUI* _tmp50_ = NULL;
	ExporterCompletionCallback _tmp51_ = NULL;
	void* _tmp51__target = NULL;
	GError * _inner_error_ = NULL;
#line 485 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (GEE_IS_COLLECTION (videos), NULL);
#line 487 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = videos;
#line 487 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 487 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 487 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_ == 0) {
#line 488 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 488 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 4944 "VideoSupport.c"
	}
#line 491 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = export_in_place;
#line 491 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp3_) {
#line 4950 "VideoSupport.c"
		ExporterUI* temp_exporter = NULL;
		GeeCollection* _tmp4_ = NULL;
		Scaling _tmp5_ = {0};
		ExportFormatParameters _tmp6_ = {0};
		Exporter* _tmp7_ = NULL;
		Exporter* _tmp8_ = NULL;
		ExporterUI* _tmp9_ = NULL;
		ExporterUI* _tmp10_ = NULL;
		ExporterUI* _tmp11_ = NULL;
		ExporterCompletionCallback _tmp12_ = NULL;
		void* _tmp12__target = NULL;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = videos;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		scaling_for_original (&_tmp5_);
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		export_format_parameters_unmodified (&_tmp6_);
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = exporter_new_for_temp_file (_tmp4_, &_tmp5_, &_tmp6_);
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = _tmp7_;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = exporter_ui_new (_tmp8_);
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_;
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp8_);
#line 492 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		temp_exporter = _tmp10_;
#line 494 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = temp_exporter;
#line 494 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = done;
#line 494 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12__target = done_target;
#line 494 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		exporter_ui_export (_tmp11_, _tmp12_, _tmp12__target);
#line 495 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = temp_exporter;
#line 495 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 4992 "VideoSupport.c"
	}
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = videos;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp14_ = gee_collection_get_size (_tmp13_);
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp15_ = _tmp14_;
#line 499 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp15_ == 1) {
#line 5002 "VideoSupport.c"
		Video* video = NULL;
		GFile* save_as = NULL;
		Video* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		GFile* _tmp27_ = NULL;
		GFile* _tmp28_ = NULL;
		GFile* _tmp29_ = NULL;
#line 500 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video = NULL;
#line 5013 "VideoSupport.c"
		{
			GeeIterator* _v_it = NULL;
			GeeCollection* _tmp16_ = NULL;
			GeeIterator* _tmp17_ = NULL;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = videos;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_v_it = _tmp17_;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 5026 "VideoSupport.c"
				GeeIterator* _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				Video* v = NULL;
				GeeIterator* _tmp20_ = NULL;
				gpointer _tmp21_ = NULL;
				Video* _tmp22_ = NULL;
				Video* _tmp23_ = NULL;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = _v_it;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = gee_iterator_next (_tmp18_);
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp19_) {
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 5042 "VideoSupport.c"
				}
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp20_ = _v_it;
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp21_ = gee_iterator_get (_tmp20_);
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				v = (Video*) _tmp21_;
#line 502 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp22_ = v;
#line 502 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp23_ = _g_object_ref0 (_tmp22_);
#line 502 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 502 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp23_;
#line 503 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (v);
#line 503 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 5062 "VideoSupport.c"
			}
#line 501 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_v_it);
#line 5066 "VideoSupport.c"
		}
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp24_ = video;
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp25_ = media_source_get_basename (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MEDIA_SOURCE, MediaSource));
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp26_ = _tmp25_;
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp27_ = export_ui_choose_file (_tmp26_);
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp28_ = _tmp27_;
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp26_);
#line 506 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		save_as = _tmp28_;
#line 507 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp29_ = save_as;
#line 507 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp29_ == NULL) {
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = NULL;
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (save_as);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 508 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5094 "VideoSupport.c"
		}
		{
			AppWindow* _tmp30_ = NULL;
			AppWindow* _tmp31_ = NULL;
			Video* _tmp32_ = NULL;
			GFile* _tmp33_ = NULL;
			AppWindow* _tmp34_ = NULL;
			AppWindow* _tmp35_ = NULL;
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp30_ = app_window_get_instance ();
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp31_ = _tmp30_;
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_busy_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_PAGE_WINDOW, PageWindow));
#line 511 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp31_);
#line 512 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp32_ = video;
#line 512 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp33_ = save_as;
#line 512 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_export (_tmp32_, _tmp33_, &_inner_error_);
#line 512 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5119 "VideoSupport.c"
				goto __catch500_g_error;
			}
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp34_ = app_window_get_instance ();
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp35_ = _tmp34_;
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_PAGE_WINDOW, PageWindow));
#line 513 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp35_);
#line 5130 "VideoSupport.c"
		}
		goto __finally500;
		__catch500_g_error:
		{
			GError* err = NULL;
			AppWindow* _tmp36_ = NULL;
			AppWindow* _tmp37_ = NULL;
			GFile* _tmp38_ = NULL;
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			err = _inner_error_;
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp36_ = app_window_get_instance ();
#line 515 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp37_ = _tmp36_;
#line 515 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			page_window_set_normal_cursor (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, TYPE_PAGE_WINDOW, PageWindow));
#line 515 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp37_);
#line 516 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp38_ = save_as;
#line 516 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			export_error_dialog (_tmp38_, FALSE);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 5157 "VideoSupport.c"
		}
		__finally500:
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (save_as);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 510 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 5172 "VideoSupport.c"
		}
#line 519 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 519 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (save_as);
#line 519 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (video);
#line 519 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5182 "VideoSupport.c"
	}
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp39_ = _ ("Export Videos");
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp40_ = export_ui_choose_dir (_tmp39_);
#line 523 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	export_dir = _tmp40_;
#line 524 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp41_ = export_dir;
#line 524 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp41_ == NULL) {
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = NULL;
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (export_dir);
#line 525 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5200 "VideoSupport.c"
	}
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp42_ = videos;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp43_ = export_dir;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	scaling_for_original (&_tmp44_);
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	export_format_parameters_unmodified (&_tmp45_);
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp46_ = exporter_new (_tmp42_, _tmp43_, &_tmp44_, &_tmp45_, FALSE);
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp47_ = _tmp46_;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp48_ = exporter_ui_new (_tmp47_);
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp49_ = _tmp48_;
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp47_);
#line 527 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exporter = _tmp49_;
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp50_ = exporter;
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp51_ = done;
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp51__target = done_target;
#line 529 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	exporter_ui_export (_tmp50_, _tmp51_, _tmp51__target);
#line 531 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = exporter;
#line 531 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (export_dir);
#line 531 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5236 "VideoSupport.c"
}


static void video_real_commit_backlinks (DataSource* base, SourceCollection* sources, const gchar* backlinks) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 534 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
#line 5247 "VideoSupport.c"
	{
		VideoTable* _tmp0_ = NULL;
		VideoTable* _tmp1_ = NULL;
		VideoID _tmp2_ = {0};
		const gchar* _tmp3_ = NULL;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_table_get_instance ();
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (self, &_tmp2_);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = backlinks;
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_update_backlinks (_tmp1_, &_tmp2_, _tmp3_, &_inner_error_);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp1_);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5269 "VideoSupport.c"
				goto __catch501_database_error;
			}
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 536 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 5278 "VideoSupport.c"
		}
		{
			VideoRow* _tmp4_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5286 "VideoSupport.c"
			{
				VideoRow* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
#line 538 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = self->priv->backing_row;
#line 538 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = backlinks;
#line 538 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = g_strdup (_tmp6_);
#line 538 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp5_->backlinks);
#line 538 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_->backlinks = _tmp7_;
#line 5301 "VideoSupport.c"
			}
			__finally502:
			{
				VideoRow* _tmp8_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5310 "VideoSupport.c"
			}
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 5316 "VideoSupport.c"
					goto __catch501_database_error;
				}
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 537 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 5325 "VideoSupport.c"
			}
		}
	}
	goto __finally501;
	__catch501_database_error:
	{
		GError* err = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 541 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = _tmp9_;
#line 541 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = err;
#line 541 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = _tmp11_->message;
#line 541 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_warning ("VideoSupport.vala:541: Unable to update link state for %s: %s", _tmp10_, _tmp12_);
#line 541 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp10_);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 5355 "VideoSupport.c"
	}
	__finally501:
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 535 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5366 "VideoSupport.c"
	}
}


static gboolean video_real_set_event_id (MediaSource* base, EventID* event_id) {
	Video * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 545 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 5379 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		gboolean _tmp13_ = FALSE;
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5387 "VideoSupport.c"
		{
			gboolean committed = FALSE;
			VideoTable* _tmp1_ = NULL;
			VideoTable* _tmp2_ = NULL;
			VideoRow* _tmp3_ = NULL;
			VideoID _tmp4_ = {0};
			EventID _tmp5_ = {0};
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = video_table_get_instance ();
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->video_id;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = *event_id;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = video_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_;
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_database_table_unref0 (_tmp2_);
#line 547 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			committed = _tmp7_;
#line 549 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = committed;
#line 549 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp8_) {
#line 5420 "VideoSupport.c"
				VideoRow* _tmp9_ = NULL;
				EventID _tmp10_ = {0};
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = *event_id;
#line 550 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_->event_id = _tmp10_;
#line 5429 "VideoSupport.c"
			}
#line 552 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = committed;
#line 5433 "VideoSupport.c"
			{
				VideoRow* _tmp11_ = NULL;
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = self->priv->backing_row;
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5440 "VideoSupport.c"
			}
#line 552 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5444 "VideoSupport.c"
		}
		__finally503:
		{
			VideoRow* _tmp12_ = NULL;
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = self->priv->backing_row;
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5453 "VideoSupport.c"
		}
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 546 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp13_;
#line 5461 "VideoSupport.c"
	}
}


gboolean video_is_duplicate (GFile* file, const gchar* full_md5) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_ = NULL;
	VideoTable* _tmp3_ = NULL;
	VideoTable* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
#line 556 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = file;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != NULL) {
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = TRUE;
#line 5484 "VideoSupport.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = full_md5;
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 5491 "VideoSupport.c"
	}
#line 557 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp0_, "file != null || full_md5 != null");
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_table_get_instance ();
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = file;
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = full_md5;
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video_table_has_duplicate (_tmp4_, _tmp5_, _tmp6_);
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = _tmp7_;
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp4_);
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp8_;
#line 559 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5513 "VideoSupport.c"
}


ImportResult video_import_create (VideoImportParams* params, Video** video) {
	Video* _vala_video = NULL;
	ImportResult result = 0;
	VideoImportParams* _tmp8_ = NULL;
	VideoRow* _tmp9_ = NULL;
	Video* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 565 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_IMPORT_PARAMS (params), 0);
#line 566 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_vala_video);
#line 566 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_video = NULL;
#line 5530 "VideoSupport.c"
	{
		VideoID _tmp0_ = {0};
		VideoTable* _tmp1_ = NULL;
		VideoTable* _tmp2_ = NULL;
		VideoImportParams* _tmp3_ = NULL;
		VideoRow* _tmp4_ = NULL;
		VideoID _tmp5_ = {0};
		VideoID _tmp6_ = {0};
		gboolean _tmp7_ = FALSE;
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_table_get_instance ();
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = params;
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp3_->row;
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_add (_tmp2_, _tmp4_, &_tmp5_, &_inner_error_);
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp5_;
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp2_);
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp6_;
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5560 "VideoSupport.c"
				goto __catch504_database_error;
			}
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return 0;
#line 5569 "VideoSupport.c"
		}
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = video_id_is_invalid (&_tmp0_);
#line 570 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (_tmp7_) {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = IMPORT_RESULT_DATABASE_ERROR;
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (video) {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				*video = _vala_video;
#line 5581 "VideoSupport.c"
			} else {
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (_vala_video);
#line 5585 "VideoSupport.c"
			}
#line 571 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5589 "VideoSupport.c"
		}
	}
	goto __finally504;
	__catch504_database_error:
	{
		GError* err = NULL;
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 573 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = IMPORT_RESULT_DATABASE_ERROR;
#line 573 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 573 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (video) {
#line 573 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*video = _vala_video;
#line 5608 "VideoSupport.c"
		} else {
#line 573 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_vala_video);
#line 5612 "VideoSupport.c"
		}
#line 573 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 5616 "VideoSupport.c"
	}
	__finally504:
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 569 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 5627 "VideoSupport.c"
	}
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = params;
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = _tmp8_->row;
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = video_new (_tmp9_);
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_vala_video);
#line 577 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_video = _tmp10_;
#line 579 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = IMPORT_RESULT_SUCCESS;
#line 579 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (video) {
#line 579 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*video = _vala_video;
#line 5645 "VideoSupport.c"
	} else {
#line 579 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_vala_video);
#line 5649 "VideoSupport.c"
	}
#line 579 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5653 "VideoSupport.c"
}


void video_import_failed (Video* video) {
	GError * _inner_error_ = NULL;
#line 582 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 5661 "VideoSupport.c"
	{
		VideoTable* _tmp0_ = NULL;
		VideoTable* _tmp1_ = NULL;
		Video* _tmp2_ = NULL;
		VideoID _tmp3_ = {0};
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = video_table_get_instance ();
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = video;
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (_tmp2_, &_tmp3_);
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_remove (_tmp1_, &_tmp3_, &_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp1_);
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 5683 "VideoSupport.c"
				goto __catch505_database_error;
			}
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 5692 "VideoSupport.c"
		}
	}
	goto __finally505;
	__catch505_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 586 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = err;
#line 586 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp4_);
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 5710 "VideoSupport.c"
	}
	__finally505:
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 583 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 5721 "VideoSupport.c"
	}
}


static BackingFileState** video_real_get_backing_files_state (MediaSource* base, int* result_length1) {
	Video * self;
	BackingFileState** result = NULL;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_ = NULL;
	gint backing_length1 = 0;
	gint _backing_size_ = 0;
	BackingFileState** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	GError * _inner_error_ = NULL;
#line 590 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_new0 (BackingFileState*, 1 + 1);
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing = _tmp0_;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing_length1 = 1;
#line 591 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_backing_size_ = backing_length1;
#line 5746 "VideoSupport.c"
	{
		VideoRow* _tmp1_ = NULL;
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->priv->backing_row;
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5753 "VideoSupport.c"
		{
			VideoRow* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			VideoRow* _tmp4_ = NULL;
			gint64 _tmp5_ = 0LL;
			VideoRow* _tmp6_ = NULL;
			time_t _tmp7_ = 0;
			VideoRow* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			BackingFileState* _tmp10_ = NULL;
			BackingFileState* _tmp11_ = NULL;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_->filepath;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _tmp4_->filesize;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_->timestamp;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->priv->backing_row;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = _tmp8_->md5;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = backing_file_state_new (_tmp3_, _tmp5_, _tmp7_, _tmp9_);
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_backing_file_state_unref0 (backing[0]);
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			backing[0] = _tmp10_;
#line 593 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = backing[0];
#line 5789 "VideoSupport.c"
		}
		__finally506:
		{
			VideoRow* _tmp12_ = NULL;
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = self->priv->backing_row;
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5798 "VideoSupport.c"
		}
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 592 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 5810 "VideoSupport.c"
		}
	}
#line 597 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = backing;
#line 597 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13__length1 = backing_length1;
#line 597 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (result_length1) {
#line 597 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*result_length1 = _tmp13__length1;
#line 5821 "VideoSupport.c"
	}
#line 597 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp13_;
#line 597 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5827 "VideoSupport.c"
}


static GdkPixbuf* video_real_get_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	Video * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 600 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = scale;
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = thumbnail_cache_fetch (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp1_, &_inner_error_);
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _tmp2_;
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 5853 "VideoSupport.c"
	}
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp0_;
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = NULL;
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 601 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5865 "VideoSupport.c"
}


static gchar* video_real_get_master_md5 (MediaSource* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 604 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 5875 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 5882 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 606 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 606 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->md5;
#line 606 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 606 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 5895 "VideoSupport.c"
			{
				VideoRow* _tmp4_ = NULL;
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5902 "VideoSupport.c"
			}
#line 606 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 5906 "VideoSupport.c"
		}
		__finally507:
		{
			VideoRow* _tmp5_ = NULL;
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 5915 "VideoSupport.c"
		}
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 605 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 5923 "VideoSupport.c"
	}
}


static GdkPixbuf* video_real_get_preview_pixbuf (MediaSource* base, Scaling* scaling, GError** error) {
	Video * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 610 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 610 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (scaling != NULL, NULL);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error_);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	pixbuf = _tmp0_;
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 611 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 5949 "VideoSupport.c"
	}
#line 613 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_NEAREST, TRUE);
#line 613 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 613 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (pixbuf);
#line 613 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 5959 "VideoSupport.c"
}


static GdkPixbuf* video_real_create_thumbnail (ThumbnailSource* base, gint scale, GError** error) {
	Video * self;
	GdkPixbuf* result = NULL;
	VideoReader* reader = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	VideoReader* _tmp2_ = NULL;
	VideoReader* _tmp3_ = NULL;
	GdkPixbuf* frame = NULL;
	VideoReader* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 616 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 617 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 617 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 617 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_reader_new (_tmp1_);
#line 617 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 617 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp1_);
#line 617 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	reader = _tmp3_;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = reader;
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video_reader_read_preview_frame (_tmp4_);
#line 618 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	frame = _tmp5_;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = frame;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_ != NULL) {
#line 6000 "VideoSupport.c"
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = frame;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp6_);
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp9_;
#line 6011 "VideoSupport.c"
	} else {
		GdkPixbuf* _tmp10_ = NULL;
		GdkPixbuf* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = resources_get_noninterpretable_badge_pixbuf ();
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = _tmp10_;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = gdk_pixbuf_copy (_tmp11_);
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp6_);
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = _tmp12_;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp11_);
#line 6028 "VideoSupport.c"
	}
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp6_;
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (frame);
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (reader);
#line 620 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6038 "VideoSupport.c"
}


static gchar* video_real_get_typename (DataSource* base) {
	Video * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 624 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
#line 624 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 624 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6054 "VideoSupport.c"
}


static gint64 video_real_get_instance_id (DataSource* base) {
	Video * self;
	gint64 result = 0LL;
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
#line 627 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 628 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (self, &_tmp0_);
#line 628 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.id;
#line 628 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 628 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6073 "VideoSupport.c"
}


static void video_real_get_import_id (MediaSource* base, ImportID* result) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 631 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6082 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6089 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			ImportID _tmp2_ = {0};
#line 633 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 633 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->import_id;
#line 633 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 6099 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6106 "VideoSupport.c"
			}
#line 633 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6110 "VideoSupport.c"
		}
		__finally508:
		{
			VideoRow* _tmp4_ = NULL;
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6119 "VideoSupport.c"
		}
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 632 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 6127 "VideoSupport.c"
	}
}


static PhotoFileFormat video_real_get_preferred_thumbnail_format (ThumbnailSource* base) {
	Video * self;
	PhotoFileFormat result = 0;
	PhotoFileFormat _tmp0_ = 0;
#line 637 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 638 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = photo_file_format_get_system_default_format ();
#line 638 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 638 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6144 "VideoSupport.c"
}


static gchar* video_real_get_title (MediaSource* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 641 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6154 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6161 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 643 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 643 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->title;
#line 643 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 643 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6174 "VideoSupport.c"
			{
				VideoRow* _tmp4_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6181 "VideoSupport.c"
			}
#line 643 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6185 "VideoSupport.c"
		}
		__finally509:
		{
			VideoRow* _tmp5_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6194 "VideoSupport.c"
		}
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6202 "VideoSupport.c"
	}
}


static void video_real_set_title (MediaSource* base, const gchar* title) {
	Video * self;
	gchar* new_title = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Alteration* _tmp20_ = NULL;
	Alteration* _tmp21_ = NULL;
	GError * _inner_error_ = NULL;
#line 647 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = title;
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_prep_title (_tmp0_);
#line 648 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_title = _tmp1_;
#line 6223 "VideoSupport.c"
	{
		VideoRow* _tmp2_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->backing_row;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6230 "VideoSupport.c"
		{
			VideoRow* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			VideoRow* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 651 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 651 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->title;
#line 651 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = new_title;
#line 651 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 6246 "VideoSupport.c"
				{
					VideoRow* _tmp6_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp6_ = self->priv->backing_row;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6253 "VideoSupport.c"
				}
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 652 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6259 "VideoSupport.c"
			}
			{
				VideoTable* _tmp7_ = NULL;
				VideoTable* _tmp8_ = NULL;
				VideoRow* _tmp9_ = NULL;
				VideoID _tmp10_ = {0};
				const gchar* _tmp11_ = NULL;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = video_table_get_instance ();
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_->video_id;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = new_title;
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_title (_tmp8_, &_tmp10_, _tmp11_, &_inner_error_);
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp8_);
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6285 "VideoSupport.c"
						goto __catch511_database_error;
					}
					{
						VideoRow* _tmp12_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp12_ = self->priv->backing_row;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6294 "VideoSupport.c"
					}
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_title);
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 655 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 6304 "VideoSupport.c"
				}
			}
			goto __finally511;
			__catch511_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_ = NULL;
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 657 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = e;
#line 657 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp13_);
#line 658 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6322 "VideoSupport.c"
				{
					VideoRow* _tmp14_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = self->priv->backing_row;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6329 "VideoSupport.c"
				}
#line 658 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 658 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6335 "VideoSupport.c"
			}
			__finally511:
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6340 "VideoSupport.c"
				{
					VideoRow* _tmp15_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6347 "VideoSupport.c"
				}
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_title);
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 654 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6357 "VideoSupport.c"
			}
#line 662 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = self->priv->backing_row;
#line 662 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = new_title;
#line 662 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 662 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp16_->title);
#line 662 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_->title = _tmp18_;
#line 6369 "VideoSupport.c"
		}
		__finally510:
		{
			VideoRow* _tmp19_ = NULL;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = self->priv->backing_row;
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6378 "VideoSupport.c"
		}
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (new_title);
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 650 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6390 "VideoSupport.c"
		}
	}
#line 665 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = alteration_new ("metadata", "name");
#line 665 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = _tmp20_;
#line 665 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp21_);
#line 665 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp21_);
#line 647 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_title);
#line 6403 "VideoSupport.c"
}


static gchar* video_real_get_comment (MediaSource* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 668 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6413 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6420 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 670 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 670 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->comment;
#line 670 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 670 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 6433 "VideoSupport.c"
			{
				VideoRow* _tmp4_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6440 "VideoSupport.c"
			}
#line 670 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6444 "VideoSupport.c"
		}
		__finally512:
		{
			VideoRow* _tmp5_ = NULL;
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6453 "VideoSupport.c"
		}
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 669 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 6461 "VideoSupport.c"
	}
}


static gboolean video_real_set_comment (MediaSource* base, const gchar* comment) {
	Video * self;
	gboolean result = FALSE;
	gchar* new_comment = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Alteration* _tmp23_ = NULL;
	Alteration* _tmp24_ = NULL;
	GError * _inner_error_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = comment;
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_prep_title (_tmp0_);
#line 675 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_comment = _tmp1_;
#line 6483 "VideoSupport.c"
	{
		VideoRow* _tmp2_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->priv->backing_row;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6490 "VideoSupport.c"
		{
			VideoRow* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			VideoRow* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 678 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->comment;
#line 678 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = new_comment;
#line 678 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = TRUE;
#line 6508 "VideoSupport.c"
				{
					VideoRow* _tmp6_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp6_ = self->priv->backing_row;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6515 "VideoSupport.c"
				}
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 679 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 6521 "VideoSupport.c"
			}
			{
				VideoTable* _tmp7_ = NULL;
				VideoTable* _tmp8_ = NULL;
				VideoRow* _tmp9_ = NULL;
				VideoID _tmp10_ = {0};
				const gchar* _tmp11_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = video_table_get_instance ();
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->backing_row;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = _tmp9_->video_id;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = new_comment;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_comment (_tmp8_, &_tmp10_, _tmp11_, &_inner_error_);
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp8_);
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6545 "VideoSupport.c"
					gboolean _tmp13_ = FALSE;
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6549 "VideoSupport.c"
						goto __catch514_database_error;
					}
					{
						VideoRow* _tmp12_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp12_ = self->priv->backing_row;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6558 "VideoSupport.c"
					}
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_comment);
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 682 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp13_;
#line 6568 "VideoSupport.c"
				}
			}
			goto __finally514;
			__catch514_database_error:
			{
				GError* e = NULL;
				GError* _tmp14_ = NULL;
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 684 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = e;
#line 684 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp14_);
#line 685 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = FALSE;
#line 685 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6588 "VideoSupport.c"
				{
					VideoRow* _tmp15_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6595 "VideoSupport.c"
				}
#line 685 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 685 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 6601 "VideoSupport.c"
			}
			__finally514:
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6606 "VideoSupport.c"
				gboolean _tmp17_ = FALSE;
				{
					VideoRow* _tmp16_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp16_ = self->priv->backing_row;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6614 "VideoSupport.c"
				}
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_comment);
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 681 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp17_;
#line 6624 "VideoSupport.c"
			}
#line 689 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->backing_row;
#line 689 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = new_comment;
#line 689 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = g_strdup (_tmp19_);
#line 689 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp18_->comment);
#line 689 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_->comment = _tmp20_;
#line 6636 "VideoSupport.c"
		}
		__finally513:
		{
			VideoRow* _tmp21_ = NULL;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = self->priv->backing_row;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6645 "VideoSupport.c"
		}
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6649 "VideoSupport.c"
			gboolean _tmp22_ = FALSE;
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (new_comment);
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 677 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp22_;
#line 6659 "VideoSupport.c"
		}
	}
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = alteration_new ("metadata", "comment");
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = _tmp23_;
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp24_);
#line 692 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp24_);
#line 694 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = TRUE;
#line 694 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_comment);
#line 694 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 6676 "VideoSupport.c"
}


static Rating video_real_get_rating (MediaSource* base) {
	Video * self;
	Rating result = 0;
	GError * _inner_error_ = NULL;
#line 698 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6686 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6693 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
#line 700 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 700 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 700 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 6703 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6710 "VideoSupport.c"
			}
#line 700 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 6714 "VideoSupport.c"
		}
		__finally515:
		{
			VideoRow* _tmp4_ = NULL;
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6723 "VideoSupport.c"
		}
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 699 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return 0;
#line 6731 "VideoSupport.c"
	}
}


static void video_real_set_rating (MediaSource* base, Rating rating) {
	Video * self;
	Alteration* _tmp19_ = NULL;
	Alteration* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 704 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6743 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6750 "VideoSupport.c"
		{
			gboolean _tmp1_ = FALSE;
			Rating _tmp2_ = 0;
			gboolean _tmp3_ = FALSE;
			VideoRow* _tmp16_ = NULL;
			Rating _tmp17_ = 0;
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = rating;
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = rating_is_valid (_tmp2_);
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp3_) {
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = TRUE;
#line 6765 "VideoSupport.c"
			} else {
				Rating _tmp4_ = 0;
				VideoRow* _tmp5_ = NULL;
				Rating _tmp6_ = 0;
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = rating;
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = self->priv->backing_row;
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = _tmp5_->rating;
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = _tmp4_ == _tmp6_;
#line 6778 "VideoSupport.c"
			}
#line 706 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp1_) {
#line 6782 "VideoSupport.c"
				{
					VideoRow* _tmp7_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp7_ = self->priv->backing_row;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6789 "VideoSupport.c"
				}
#line 707 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6793 "VideoSupport.c"
			}
			{
				VideoTable* _tmp8_ = NULL;
				VideoTable* _tmp9_ = NULL;
				VideoID _tmp10_ = {0};
				Rating _tmp11_ = 0;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = video_table_get_instance ();
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp10_);
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = rating;
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_rating (_tmp9_, &_tmp10_, _tmp11_, &_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp9_);
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 6816 "VideoSupport.c"
						goto __catch517_database_error;
					}
					{
						VideoRow* _tmp12_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp12_ = self->priv->backing_row;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6825 "VideoSupport.c"
					}
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 710 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 6833 "VideoSupport.c"
				}
			}
			goto __finally517;
			__catch517_database_error:
			{
				GError* e = NULL;
				GError* _tmp13_ = NULL;
#line 709 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 709 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 712 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = e;
#line 712 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp13_);
#line 713 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 6851 "VideoSupport.c"
				{
					VideoRow* _tmp14_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp14_ = self->priv->backing_row;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6858 "VideoSupport.c"
				}
#line 713 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6862 "VideoSupport.c"
			}
			__finally517:
#line 709 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6867 "VideoSupport.c"
				{
					VideoRow* _tmp15_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp15_ = self->priv->backing_row;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6874 "VideoSupport.c"
				}
#line 709 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 709 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 709 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 6882 "VideoSupport.c"
			}
#line 717 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = self->priv->backing_row;
#line 717 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = rating;
#line 717 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_->rating = _tmp17_;
#line 6890 "VideoSupport.c"
		}
		__finally516:
		{
			VideoRow* _tmp18_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = self->priv->backing_row;
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6899 "VideoSupport.c"
		}
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 705 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6909 "VideoSupport.c"
		}
	}
#line 720 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = alteration_new ("metadata", "rating");
#line 720 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = _tmp19_;
#line 720 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 720 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp20_);
#line 6920 "VideoSupport.c"
}


static void video_real_increase_rating (MediaSource* base) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 723 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6929 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6936 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
			Rating _tmp3_ = 0;
#line 725 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 725 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 725 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = rating_increase (_tmp2_);
#line 725 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 6949 "VideoSupport.c"
		}
		__finally518:
		{
			VideoRow* _tmp4_ = NULL;
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 6958 "VideoSupport.c"
		}
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 724 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 6968 "VideoSupport.c"
		}
	}
}


static void video_real_decrease_rating (MediaSource* base) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 729 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 6979 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 6986 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			Rating _tmp2_ = 0;
			Rating _tmp3_ = 0;
#line 731 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 731 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->rating;
#line 731 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = rating_decrease (_tmp2_);
#line 731 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp3_);
#line 6999 "VideoSupport.c"
		}
		__finally519:
		{
			VideoRow* _tmp4_ = NULL;
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7008 "VideoSupport.c"
		}
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 730 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7018 "VideoSupport.c"
		}
	}
}


static gboolean video_real_is_trashed (MediaSource* base) {
	Video * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 735 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 736 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_is_flag_set (self, VIDEO_FLAG_TRASH);
#line 736 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 736 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7036 "VideoSupport.c"
}


static gboolean video_real_is_offline (Monitorable* base) {
	Video * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 739 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 740 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_is_flag_set (self, VIDEO_FLAG_OFFLINE);
#line 740 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 740 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7052 "VideoSupport.c"
}


static void video_real_mark_offline (Monitorable* base) {
	Video * self;
#line 743 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 744 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_OFFLINE, NULL);
#line 7062 "VideoSupport.c"
}


static void video_real_mark_online (Monitorable* base) {
	Video * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 747 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 748 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_OFFLINE, NULL);
#line 750 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_get_is_interpretable (self);
#line 750 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!_tmp1_) {
#line 7078 "VideoSupport.c"
		gboolean _tmp2_ = FALSE;
#line 750 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = video_has_interpreter_state_changed ();
#line 750 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = _tmp2_;
#line 7084 "VideoSupport.c"
	} else {
#line 750 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = FALSE;
#line 7088 "VideoSupport.c"
	}
#line 750 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 7092 "VideoSupport.c"
		VideoInterpretableResults* _tmp3_ = NULL;
		VideoInterpretableResults* _tmp4_ = NULL;
#line 751 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_check_is_interpretable (self);
#line 751 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = _tmp3_;
#line 751 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_foreground_finish (_tmp4_);
#line 751 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_interpretable_results_unref0 (_tmp4_);
#line 7103 "VideoSupport.c"
	}
}


static void video_real_trash (MediaSource* base) {
	Video * self;
#line 754 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 755 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_TRASH, NULL);
#line 7114 "VideoSupport.c"
}


static void video_real_untrash (MediaSource* base) {
	Video * self;
#line 758 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 759 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_TRASH, NULL);
#line 7124 "VideoSupport.c"
}


static gboolean video_real_is_flagged (Flaggable* base) {
	Video * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 762 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 763 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_is_flag_set (self, VIDEO_FLAG_FLAGGED);
#line 763 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 763 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7140 "VideoSupport.c"
}


static void video_real_mark_flagged (Flaggable* base) {
	Video * self;
	Alteration* _tmp0_ = NULL;
	Alteration* _tmp1_ = NULL;
#line 766 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 767 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flagged");
#line 767 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 767 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_add_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
#line 767 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp1_);
#line 7158 "VideoSupport.c"
}


static void video_real_mark_unflagged (Flaggable* base) {
	Video * self;
	Alteration* _tmp0_ = NULL;
	Alteration* _tmp1_ = NULL;
#line 770 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 771 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flagged");
#line 771 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 771 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_remove_flags (self, VIDEO_FLAG_FLAGGED, _tmp1_);
#line 771 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp1_);
#line 7176 "VideoSupport.c"
}


static void video_real_get_event_id (MediaSource* base, EventID* result) {
	Video * self;
	GError * _inner_error_ = NULL;
#line 774 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7185 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7192 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			EventID _tmp2_ = {0};
#line 776 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 776 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->event_id;
#line 776 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 7202 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7209 "VideoSupport.c"
			}
#line 776 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7213 "VideoSupport.c"
		}
		__finally520:
		{
			VideoRow* _tmp4_ = NULL;
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7222 "VideoSupport.c"
		}
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 775 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7230 "VideoSupport.c"
	}
}


static gchar* video_real_to_string (DataObject* base) {
	Video * self;
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 780 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7241 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7248 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			VideoID _tmp2_ = {0};
			gint64 _tmp3_ = 0LL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			VideoRow* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->video_id;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = _tmp2_.id;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = _tmp4_;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = _tmp6_->filepath;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = g_strdup_printf ("[%s] %s", _tmp5_, _tmp7_);
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = _tmp8_;
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp5_);
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp9_;
#line 7281 "VideoSupport.c"
			{
				VideoRow* _tmp10_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = self->priv->backing_row;
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7288 "VideoSupport.c"
			}
#line 782 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7292 "VideoSupport.c"
		}
		__finally521:
		{
			VideoRow* _tmp11_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = self->priv->backing_row;
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7301 "VideoSupport.c"
		}
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 781 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 7309 "VideoSupport.c"
	}
}


void video_get_video_id (Video* self, VideoID* result) {
	GError * _inner_error_ = NULL;
#line 786 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 7318 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7325 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			VideoID _tmp2_ = {0};
#line 788 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 788 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->video_id;
#line 788 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp2_;
#line 7335 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7342 "VideoSupport.c"
			}
#line 788 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7346 "VideoSupport.c"
		}
		__finally522:
		{
			VideoRow* _tmp4_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7355 "VideoSupport.c"
		}
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 787 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7363 "VideoSupport.c"
	}
}


static time_t video_real_get_exposure_time (Dateable* base) {
	Video * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 792 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7374 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		time_t _tmp5_ = 0;
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7382 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			time_t _tmp2_ = 0;
#line 794 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 794 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->exposure_time;
#line 794 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 7392 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7399 "VideoSupport.c"
			}
#line 794 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7403 "VideoSupport.c"
		}
		__finally523:
		{
			VideoRow* _tmp4_ = NULL;
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7412 "VideoSupport.c"
		}
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 793 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7420 "VideoSupport.c"
	}
}


static void video_real_set_exposure_time (Dateable* base, time_t time) {
	Video * self;
	Alteration* _tmp12_ = NULL;
	Alteration* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 798 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7432 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7439 "VideoSupport.c"
		{
			VideoRow* _tmp9_ = NULL;
			time_t _tmp10_ = 0;
			{
				VideoTable* _tmp1_ = NULL;
				VideoTable* _tmp2_ = NULL;
				VideoRow* _tmp3_ = NULL;
				VideoID _tmp4_ = {0};
				time_t _tmp5_ = 0;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp1_ = video_table_get_instance ();
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp2_ = _tmp1_;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->video_id;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = time;
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_exposure_time (_tmp2_, &_tmp4_, _tmp5_, &_inner_error_);
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp2_);
#line 801 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7465 "VideoSupport.c"
					goto __catch525_g_error;
				}
			}
			goto __finally525;
			__catch525_g_error:
			{
				GError* e = NULL;
				GError* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = e;
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = _tmp6_->message;
#line 803 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_debug ("VideoSupport.vala:803: Warning - %s", _tmp7_);
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 7487 "VideoSupport.c"
			}
			__finally525:
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7492 "VideoSupport.c"
				{
					VideoRow* _tmp8_ = NULL;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp8_ = self->priv->backing_row;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7499 "VideoSupport.c"
				}
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 800 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7507 "VideoSupport.c"
			}
#line 805 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = self->priv->backing_row;
#line 805 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = time;
#line 805 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_->exposure_time = _tmp10_;
#line 7515 "VideoSupport.c"
		}
		__finally524:
		{
			VideoRow* _tmp11_ = NULL;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = self->priv->backing_row;
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7524 "VideoSupport.c"
		}
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 799 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7534 "VideoSupport.c"
		}
	}
#line 808 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp12_ = alteration_new ("metadata", "exposure-time");
#line 808 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = _tmp12_;
#line 808 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp13_);
#line 808 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp13_);
#line 7545 "VideoSupport.c"
}


void video_get_frame_dimensions (Video* self, Dimensions* result) {
	GError * _inner_error_ = NULL;
#line 811 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 7553 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7560 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			gint _tmp2_ = 0;
			VideoRow* _tmp3_ = NULL;
			gint _tmp4_ = 0;
			Dimensions _tmp5_ = {0};
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->width;
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = self->priv->backing_row;
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _tmp3_->height;
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			dimensions_init (&_tmp5_, _tmp2_, _tmp4_);
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*result = _tmp5_;
#line 7579 "VideoSupport.c"
			{
				VideoRow* _tmp6_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = self->priv->backing_row;
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7586 "VideoSupport.c"
			}
#line 813 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 7590 "VideoSupport.c"
		}
		__finally526:
		{
			VideoRow* _tmp7_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->priv->backing_row;
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7599 "VideoSupport.c"
		}
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 812 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7607 "VideoSupport.c"
	}
}


static void video_real_get_dimensions (MediaSource* base, PhotoException disallowed_steps, Dimensions* result) {
	Video * self;
	Dimensions _tmp0_ = {0};
#line 817 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 818 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_frame_dimensions (self, &_tmp0_);
#line 818 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	*result = _tmp0_;
#line 818 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return;
#line 7623 "VideoSupport.c"
}


static guint64 video_real_get_filesize (MediaSource* base) {
	Video * self;
	guint64 result = 0ULL;
	guint64 _tmp0_ = 0ULL;
#line 821 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 822 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 822 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 822 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 7639 "VideoSupport.c"
}


static guint64 video_real_get_master_filesize (MediaSource* base) {
	Video * self;
	guint64 result = 0ULL;
	GError * _inner_error_ = NULL;
#line 825 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7649 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		guint64 _tmp5_ = 0ULL;
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7657 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			gint64 _tmp2_ = 0LL;
#line 827 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 827 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->filesize;
#line 827 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = (guint64) _tmp2_;
#line 7667 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7674 "VideoSupport.c"
			}
#line 827 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7678 "VideoSupport.c"
		}
		__finally527:
		{
			VideoRow* _tmp4_ = NULL;
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7687 "VideoSupport.c"
		}
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 826 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7695 "VideoSupport.c"
	}
}


static time_t video_real_get_timestamp (MediaSource* base) {
	Video * self;
	time_t result = 0;
	GError * _inner_error_ = NULL;
#line 831 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 7706 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		time_t _tmp5_ = 0;
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7714 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			time_t _tmp2_ = 0;
#line 833 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 833 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->timestamp;
#line 833 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 7724 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7731 "VideoSupport.c"
			}
#line 833 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7735 "VideoSupport.c"
		}
		__finally528:
		{
			VideoRow* _tmp4_ = NULL;
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7744 "VideoSupport.c"
		}
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 832 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 7752 "VideoSupport.c"
	}
}


static void video_real_set_master_timestamp (Monitorable* base, GFileInfo* info) {
	Video * self;
	GTimeVal time_val = {0};
	GFileInfo* _tmp0_ = NULL;
	GTimeVal _tmp1_ = {0};
	Alteration* _tmp19_ = NULL;
	Alteration* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 837 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 837 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = info;
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
#line 838 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	time_val = _tmp1_;
#line 7775 "VideoSupport.c"
	{
		{
			VideoRow* _tmp2_ = NULL;
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7783 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
				time_t _tmp4_ = 0;
				GTimeVal _tmp5_ = {0};
				glong _tmp6_ = 0L;
				VideoTable* _tmp8_ = NULL;
				VideoTable* _tmp9_ = NULL;
				VideoRow* _tmp10_ = NULL;
				VideoID _tmp11_ = {0};
				GTimeVal _tmp12_ = {0};
				glong _tmp13_ = 0L;
				VideoRow* _tmp14_ = NULL;
				GTimeVal _tmp15_ = {0};
				glong _tmp16_ = 0L;
#line 842 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 842 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->timestamp;
#line 842 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = time_val;
#line 842 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = _tmp5_.tv_sec;
#line 842 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_tmp4_ == ((time_t) _tmp6_)) {
#line 7808 "VideoSupport.c"
					{
						VideoRow* _tmp7_ = NULL;
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp7_ = self->priv->backing_row;
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7815 "VideoSupport.c"
					}
#line 843 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 7819 "VideoSupport.c"
				}
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = video_table_get_instance ();
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_;
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = self->priv->backing_row;
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = _tmp10_->video_id;
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = time_val;
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = _tmp12_.tv_sec;
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_timestamp (_tmp9_, &_tmp11_, (time_t) _tmp13_, &_inner_error_);
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp9_);
#line 845 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 7839 "VideoSupport.c"
					goto __finally530;
				}
#line 846 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = self->priv->backing_row;
#line 846 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = time_val;
#line 846 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _tmp15_.tv_sec;
#line 846 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_->timestamp = (time_t) _tmp16_;
#line 7850 "VideoSupport.c"
			}
			__finally530:
			{
				VideoRow* _tmp17_ = NULL;
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = self->priv->backing_row;
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7859 "VideoSupport.c"
			}
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 7865 "VideoSupport.c"
					goto __catch529_database_error;
				}
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 841 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 7874 "VideoSupport.c"
			}
		}
	}
	goto __finally529;
	__catch529_database_error:
	{
		GError* err = NULL;
		GError* _tmp18_ = NULL;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 849 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp18_ = err;
#line 849 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp18_);
#line 851 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 851 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7895 "VideoSupport.c"
	}
	__finally529:
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 840 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 7906 "VideoSupport.c"
	}
#line 854 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = alteration_new ("metadata", "master-timestamp");
#line 854 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = _tmp19_;
#line 854 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp20_);
#line 854 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp20_);
#line 7916 "VideoSupport.c"
}


gchar* video_get_filename (Video* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 857 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 7925 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 7932 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 859 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 859 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->filepath;
#line 859 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 859 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp3_;
#line 7945 "VideoSupport.c"
			{
				VideoRow* _tmp4_ = NULL;
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = self->priv->backing_row;
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7952 "VideoSupport.c"
			}
#line 859 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 7956 "VideoSupport.c"
		}
		__finally531:
		{
			VideoRow* _tmp5_ = NULL;
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 7965 "VideoSupport.c"
		}
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 858 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 7973 "VideoSupport.c"
	}
}


static GFile* video_real_get_file (MediaSource* base) {
	Video * self;
	GFile* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_get_filename (self);
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 864 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8001 "VideoSupport.c"
}


static GFile* video_real_get_master_file (MediaSource* base) {
	Video * self;
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
#line 867 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 868 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 868 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 868 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8017 "VideoSupport.c"
}


void video_export (Video* self, GFile* dest_file, GError** error) {
	GFile* source_file = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE (dest_file));
#line 872 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_get_filename (self);
#line 872 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 872 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = g_file_new_for_path (_tmp1_);
#line 872 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 872 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp1_);
#line 872 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	source_file = _tmp3_;
#line 873 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = dest_file;
#line 873 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_copy (source_file, _tmp4_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error_);
#line 873 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 873 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 873 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (source_file);
#line 873 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8057 "VideoSupport.c"
	}
#line 871 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (source_file);
#line 8061 "VideoSupport.c"
}


gdouble video_get_clip_duration (Video* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
#line 877 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0.0);
#line 8070 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		gdouble _tmp5_ = 0.0;
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8078 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			gdouble _tmp2_ = 0.0;
#line 879 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 879 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->clip_duration;
#line 879 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 8088 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8095 "VideoSupport.c"
			}
#line 879 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8099 "VideoSupport.c"
		}
		__finally532:
		{
			VideoRow* _tmp4_ = NULL;
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8108 "VideoSupport.c"
		}
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 878 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 8116 "VideoSupport.c"
	}
}


gboolean video_get_is_interpretable (Video* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 883 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
#line 8126 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8134 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
#line 885 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 885 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->is_interpretable;
#line 885 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp2_;
#line 8144 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8151 "VideoSupport.c"
			}
#line 885 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 8155 "VideoSupport.c"
		}
		__finally533:
		{
			VideoRow* _tmp4_ = NULL;
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->priv->backing_row;
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8164 "VideoSupport.c"
		}
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 884 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp5_;
#line 8172 "VideoSupport.c"
	}
}


static void video_set_is_interpretable (Video* self, gboolean is_interpretable) {
	GError * _inner_error_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 8181 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8188 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			VideoRow* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 891 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 891 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->is_interpretable;
#line 891 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = is_interpretable;
#line 891 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp2_ == _tmp3_) {
#line 8203 "VideoSupport.c"
				{
					VideoRow* _tmp4_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp4_ = self->priv->backing_row;
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8210 "VideoSupport.c"
				}
#line 892 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 8214 "VideoSupport.c"
			}
#line 894 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 894 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = is_interpretable;
#line 894 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_->is_interpretable = _tmp6_;
#line 8222 "VideoSupport.c"
		}
		__finally534:
		{
			VideoRow* _tmp7_ = NULL;
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->priv->backing_row;
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8231 "VideoSupport.c"
		}
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 890 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8241 "VideoSupport.c"
		}
	}
	{
		VideoTable* _tmp8_ = NULL;
		VideoTable* _tmp9_ = NULL;
		VideoID _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = video_table_get_instance ();
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = _tmp8_;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_get_video_id (self, &_tmp10_);
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = is_interpretable;
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_update_is_interpretable (_tmp9_, &_tmp10_, _tmp11_, &_inner_error_);
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp9_);
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8265 "VideoSupport.c"
				goto __catch535_database_error;
			}
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 898 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8274 "VideoSupport.c"
		}
	}
	goto __finally535;
	__catch535_database_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 900 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = e;
#line 900 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp12_);
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 8292 "VideoSupport.c"
	}
	__finally535:
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 897 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8303 "VideoSupport.c"
	}
}


VideoInterpretableResults* video_check_is_interpretable (Video* self) {
	VideoInterpretableResults* result = NULL;
	VideoInterpretableResults* results = NULL;
	VideoInterpretableResults* _tmp0_ = NULL;
	gdouble clip_duration = 0.0;
	GdkPixbuf* preview_frame = NULL;
	VideoReader* backing_file_reader = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	VideoReader* _tmp3_ = NULL;
	VideoReader* _tmp4_ = NULL;
	gboolean _tmp13_ = FALSE;
	GFile* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	VideoInterpretableResults* _tmp24_ = NULL;
	VideoInterpretableResults* _tmp25_ = NULL;
	VideoInterpretableResults* _tmp26_ = NULL;
	GdkPixbuf* _tmp27_ = NULL;
	GdkPixbuf* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 908 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_interpretable_results_new (self);
#line 908 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	results = _tmp0_;
#line 910 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	clip_duration = -1.0;
#line 911 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	preview_frame = NULL;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_new (_tmp2_);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 913 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	backing_file_reader = _tmp4_;
#line 8352 "VideoSupport.c"
	{
		gdouble _tmp5_ = 0.0;
		VideoReader* _tmp6_ = NULL;
		gdouble _tmp7_ = 0.0;
		VideoReader* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp6_ = backing_file_reader;
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp7_ = video_reader_read_clip_duration (_tmp6_, &_inner_error_);
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp7_;
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == VIDEO_ERROR) {
#line 8369 "VideoSupport.c"
				goto __catch536_video_error;
			}
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (backing_file_reader);
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_interpretable_results_unref0 (results);
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 8384 "VideoSupport.c"
		}
#line 915 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		clip_duration = _tmp5_;
#line 916 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp8_ = backing_file_reader;
#line 916 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = video_reader_read_preview_frame (_tmp8_);
#line 916 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 916 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		preview_frame = _tmp9_;
#line 8396 "VideoSupport.c"
	}
	goto __finally536;
	__catch536_video_error:
	{
		GError* e = NULL;
		VideoInterpretableResults* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		VideoInterpretableResults* _tmp12_ = NULL;
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		e = _inner_error_;
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 920 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = results;
#line 920 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = video_get_is_interpretable (self);
#line 920 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_->update_interpretable = _tmp11_;
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = results;
#line 921 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_->is_interpretable = FALSE;
#line 923 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = results;
#line 923 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (e);
#line 923 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 923 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 923 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 8429 "VideoSupport.c"
	}
	__finally536:
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_interpretable_results_unref0 (results);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 914 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 8446 "VideoSupport.c"
	}
#line 927 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = video_get_is_interpretable (self);
#line 927 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp13_) {
#line 8452 "VideoSupport.c"
		VideoInterpretableResults* _tmp14_ = NULL;
		VideoInterpretableResults* _tmp15_ = NULL;
#line 928 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = results;
#line 928 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_->update_interpretable = FALSE;
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_ = results;
#line 929 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp15_->is_interpretable = TRUE;
#line 931 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = results;
#line 931 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_reader_unref0 (backing_file_reader);
#line 931 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (preview_frame);
#line 931 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 8471 "VideoSupport.c"
	}
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp16_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp17_ = _tmp16_;
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp18_ = g_file_get_basename (_tmp17_);
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp19_ = _tmp18_;
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_debug ("VideoSupport.vala:934: video %s has become interpretable", _tmp19_);
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (_tmp19_);
#line 934 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp17_);
#line 8487 "VideoSupport.c"
	{
		VideoRow* _tmp20_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp20_ = self->priv->backing_row;
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8494 "VideoSupport.c"
		{
			VideoRow* _tmp21_ = NULL;
			gdouble _tmp22_ = 0.0;
#line 938 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = self->priv->backing_row;
#line 938 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp22_ = clip_duration;
#line 938 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_->clip_duration = _tmp22_;
#line 8504 "VideoSupport.c"
		}
		__finally537:
		{
			VideoRow* _tmp23_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8513 "VideoSupport.c"
		}
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_reader_unref0 (backing_file_reader);
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (preview_frame);
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_video_interpretable_results_unref0 (results);
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 937 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return NULL;
#line 8529 "VideoSupport.c"
		}
	}
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = results;
#line 941 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_->update_interpretable = TRUE;
#line 942 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = results;
#line 942 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_->is_interpretable = TRUE;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = results;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = preview_frame;
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp28_ = _g_object_ref0 (_tmp27_);
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp26_->new_thumbnail);
#line 943 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_->new_thumbnail = _tmp28_;
#line 945 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = results;
#line 945 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (backing_file_reader);
#line 945 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (preview_frame);
#line 945 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8558 "VideoSupport.c"
}


static void video_real_destroy (DataSource* base) {
	Video * self;
	VideoID video_id = {0};
	VideoID _tmp0_ = {0};
	GError * _inner_error_ = NULL;
#line 948 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 949 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (self, &_tmp0_);
#line 949 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id = _tmp0_;
#line 951 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 8575 "VideoSupport.c"
	{
		VideoTable* _tmp1_ = NULL;
		VideoTable* _tmp2_ = NULL;
		VideoID _tmp3_ = {0};
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = video_table_get_instance ();
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = _tmp1_;
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = video_id;
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_table_remove (_tmp2_, &_tmp3_, &_inner_error_);
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_database_table_unref0 (_tmp2_);
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 8594 "VideoSupport.c"
				goto __catch538_database_error;
			}
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 954 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 8603 "VideoSupport.c"
		}
	}
	goto __finally538;
	__catch538_database_error:
	{
		GError* err = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 956 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
#line 956 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 956 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_error ("VideoSupport.vala:956: failed to remove video %s from video table", _tmp5_);
#line 956 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (_tmp5_);
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 8626 "VideoSupport.c"
	}
	__finally538:
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 953 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 8637 "VideoSupport.c"
	}
#line 959 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_SOURCE_CLASS (video_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource));
#line 8641 "VideoSupport.c"
}


static gboolean video_real_internal_delete_backing (DataSource* base, GError** error) {
	Video * self;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GError * _inner_error_ = NULL;
#line 962 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 963 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_delete_original_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 963 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	ret = _tmp0_;
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = DATA_SOURCE_CLASS (video_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_VIDEO_SOURCE, VideoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error_);
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp3_;
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8666 "VideoSupport.c"
		gboolean _tmp4_ = FALSE;
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp4_;
#line 8672 "VideoSupport.c"
	}
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_) {
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = ret;
#line 8678 "VideoSupport.c"
	} else {
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = FALSE;
#line 8682 "VideoSupport.c"
	}
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 966 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8688 "VideoSupport.c"
}


static void video_notify_flags_altered (Video* self, Alteration* additional_alteration) {
	Alteration* alteration = NULL;
	Alteration* _tmp0_ = NULL;
	Alteration* _tmp1_ = NULL;
	Alteration* _tmp5_ = NULL;
#line 969 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (self));
#line 969 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = alteration_new ("metadata", "flags");
#line 970 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	alteration = _tmp0_;
#line 971 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = additional_alteration;
#line 971 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != NULL) {
#line 8709 "VideoSupport.c"
		Alteration* _tmp2_ = NULL;
		Alteration* _tmp3_ = NULL;
		Alteration* _tmp4_ = NULL;
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = alteration;
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = additional_alteration;
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = alteration_compress (_tmp2_, _tmp3_);
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_alteration_unref0 (alteration);
#line 972 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		alteration = _tmp4_;
#line 8723 "VideoSupport.c"
	}
#line 974 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = alteration;
#line 974 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp5_);
#line 969 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (alteration);
#line 8731 "VideoSupport.c"
}


guint64 video_add_flags (Video* self, guint64 flags_to_add, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 new_flags = 0ULL;
	Alteration* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
#line 977 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 8744 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8751 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			VideoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
			VideoRow* _tmp23_ = NULL;
			guint64 _tmp24_ = 0ULL;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = flags_to_add;
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = media_source_internal_add_flags (_tmp2_, _tmp3_);
#line 980 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			new_flags = _tmp4_;
#line 981 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 981 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _tmp5_->flags;
#line 981 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = new_flags;
#line 981 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp6_ == _tmp7_) {
#line 8780 "VideoSupport.c"
				VideoRow* _tmp8_ = NULL;
				guint64 _tmp9_ = 0ULL;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_->flags;
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp9_;
#line 8789 "VideoSupport.c"
				{
					VideoRow* _tmp10_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp10_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8796 "VideoSupport.c"
				}
#line 982 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 8800 "VideoSupport.c"
			}
			{
				VideoTable* _tmp11_ = NULL;
				VideoTable* _tmp12_ = NULL;
				VideoID _tmp13_ = {0};
				guint64 _tmp14_ = 0ULL;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = video_table_get_instance ();
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _tmp11_;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp13_);
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = new_flags;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_flags (_tmp12_, &_tmp13_, _tmp14_, &_inner_error_);
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp12_);
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8821 "VideoSupport.c"
					guint64 _tmp16_ = 0ULL;
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 8825 "VideoSupport.c"
						goto __catch540_database_error;
					}
					{
						VideoRow* _tmp15_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp15_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8834 "VideoSupport.c"
					}
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 985 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp16_;
#line 8842 "VideoSupport.c"
				}
			}
			goto __finally540;
			__catch540_database_error:
			{
				GError* e = NULL;
				GError* _tmp17_ = NULL;
				VideoRow* _tmp18_ = NULL;
				guint64 _tmp19_ = 0ULL;
#line 984 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 984 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 987 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = e;
#line 987 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp17_);
#line 988 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = self->priv->backing_row;
#line 988 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = _tmp18_->flags;
#line 988 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp19_;
#line 988 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 8868 "VideoSupport.c"
				{
					VideoRow* _tmp20_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp20_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8875 "VideoSupport.c"
				}
#line 988 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 8879 "VideoSupport.c"
			}
			__finally540:
#line 984 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8884 "VideoSupport.c"
				guint64 _tmp22_ = 0ULL;
				{
					VideoRow* _tmp21_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp21_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8892 "VideoSupport.c"
				}
#line 984 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 984 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 984 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp22_;
#line 8900 "VideoSupport.c"
			}
#line 991 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 991 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = new_flags;
#line 991 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_->flags = _tmp24_;
#line 8908 "VideoSupport.c"
		}
		__finally539:
		{
			VideoRow* _tmp25_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = self->priv->backing_row;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 8917 "VideoSupport.c"
		}
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 8921 "VideoSupport.c"
			guint64 _tmp26_ = 0ULL;
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 979 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp26_;
#line 8929 "VideoSupport.c"
		}
	}
#line 994 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = additional_alteration;
#line 994 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_notify_flags_altered (self, _tmp27_);
#line 996 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = new_flags;
#line 996 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 8940 "VideoSupport.c"
}


guint64 video_remove_flags (Video* self, guint64 flags_to_remove, Alteration* additional_alteration) {
	guint64 result = 0ULL;
	guint64 new_flags = 0ULL;
	Alteration* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), 0ULL);
#line 999 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
#line 8953 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 8960 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			guint64 _tmp4_ = 0ULL;
			VideoRow* _tmp5_ = NULL;
			guint64 _tmp6_ = 0ULL;
			guint64 _tmp7_ = 0ULL;
			VideoRow* _tmp23_ = NULL;
			guint64 _tmp24_ = 0ULL;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = flags_to_remove;
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = media_source_internal_remove_flags (_tmp2_, _tmp3_);
#line 1002 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			new_flags = _tmp4_;
#line 1003 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->priv->backing_row;
#line 1003 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _tmp5_->flags;
#line 1003 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = new_flags;
#line 1003 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp6_ == _tmp7_) {
#line 8989 "VideoSupport.c"
				VideoRow* _tmp8_ = NULL;
				guint64 _tmp9_ = 0ULL;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = self->priv->backing_row;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = _tmp8_->flags;
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp9_;
#line 8998 "VideoSupport.c"
				{
					VideoRow* _tmp10_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp10_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9005 "VideoSupport.c"
				}
#line 1004 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 9009 "VideoSupport.c"
			}
			{
				VideoTable* _tmp11_ = NULL;
				VideoTable* _tmp12_ = NULL;
				VideoID _tmp13_ = {0};
				guint64 _tmp14_ = 0ULL;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = video_table_get_instance ();
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = _tmp11_;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (self, &_tmp13_);
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = new_flags;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_flags (_tmp12_, &_tmp13_, _tmp14_, &_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp12_);
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9030 "VideoSupport.c"
					guint64 _tmp16_ = 0ULL;
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 9034 "VideoSupport.c"
						goto __catch542_database_error;
					}
					{
						VideoRow* _tmp15_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp15_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9043 "VideoSupport.c"
					}
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_clear_error (&_inner_error_);
#line 1007 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return _tmp16_;
#line 9051 "VideoSupport.c"
				}
			}
			goto __finally542;
			__catch542_database_error:
			{
				GError* e = NULL;
				GError* _tmp17_ = NULL;
				VideoRow* _tmp18_ = NULL;
				guint64 _tmp19_ = 0ULL;
#line 1006 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				e = _inner_error_;
#line 1006 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_inner_error_ = NULL;
#line 1009 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = e;
#line 1009 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				app_window_database_error (_tmp17_);
#line 1010 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = self->priv->backing_row;
#line 1010 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = _tmp18_->flags;
#line 1010 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				result = _tmp19_;
#line 1010 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_error_free0 (e);
#line 9077 "VideoSupport.c"
				{
					VideoRow* _tmp20_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp20_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9084 "VideoSupport.c"
				}
#line 1010 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return result;
#line 9088 "VideoSupport.c"
			}
			__finally542:
#line 1006 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9093 "VideoSupport.c"
				guint64 _tmp22_ = 0ULL;
				{
					VideoRow* _tmp21_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_tmp21_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9101 "VideoSupport.c"
				}
#line 1006 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1006 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 1006 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return _tmp22_;
#line 9109 "VideoSupport.c"
			}
#line 1013 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_ = self->priv->backing_row;
#line 1013 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp24_ = new_flags;
#line 1013 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp23_->flags = _tmp24_;
#line 9117 "VideoSupport.c"
		}
		__finally541:
		{
			VideoRow* _tmp25_ = NULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp25_ = self->priv->backing_row;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9126 "VideoSupport.c"
		}
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9130 "VideoSupport.c"
			guint64 _tmp26_ = 0ULL;
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 1001 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return _tmp26_;
#line 9138 "VideoSupport.c"
		}
	}
#line 1016 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = additional_alteration;
#line 1016 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_notify_flags_altered (self, _tmp27_);
#line 1018 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = new_flags;
#line 1018 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9149 "VideoSupport.c"
}


gboolean video_is_flag_set (Video* self, guint64 flag) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 1021 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), FALSE);
#line 9158 "VideoSupport.c"
	{
		VideoRow* _tmp0_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->backing_row;
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9166 "VideoSupport.c"
		{
			VideoRow* _tmp1_ = NULL;
			guint64 _tmp2_ = 0ULL;
			guint64 _tmp3_ = 0ULL;
			gboolean _tmp4_ = FALSE;
#line 1023 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = self->priv->backing_row;
#line 1023 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = _tmp1_->flags;
#line 1023 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp3_ = flag;
#line 1023 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = media_source_internal_is_flag_set (_tmp2_, _tmp3_);
#line 1023 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			result = _tmp4_;
#line 9182 "VideoSupport.c"
			{
				VideoRow* _tmp5_ = NULL;
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = self->priv->backing_row;
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9189 "VideoSupport.c"
			}
#line 1023 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return result;
#line 9193 "VideoSupport.c"
		}
		__finally543:
		{
			VideoRow* _tmp6_ = NULL;
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->priv->backing_row;
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9202 "VideoSupport.c"
		}
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 1022 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return _tmp7_;
#line 9210 "VideoSupport.c"
	}
}


static void video_real_set_master_file (Monitorable* base, GFile* file) {
	Video * self;
	gchar* new_filepath = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* old_filepath = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	GFile* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	Alteration* _tmp25_ = NULL;
	Alteration* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
#line 1027 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO, Video);
#line 1027 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = g_file_get_path (_tmp0_);
#line 1028 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	new_filepath = _tmp1_;
#line 1029 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old_filepath = NULL;
#line 9241 "VideoSupport.c"
	{
		{
			VideoRow* _tmp2_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = self->priv->backing_row;
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_rec_mutex_lock (&self->priv->__lock_backing_row);
#line 9249 "VideoSupport.c"
			{
				VideoRow* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				VideoRow* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				VideoTable* _tmp10_ = NULL;
				VideoTable* _tmp11_ = NULL;
				VideoRow* _tmp12_ = NULL;
				VideoID _tmp13_ = {0};
				const gchar* _tmp14_ = NULL;
				VideoRow* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
#line 1032 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = self->priv->backing_row;
#line 1032 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = _tmp3_->filepath;
#line 1032 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = new_filepath;
#line 1032 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 9273 "VideoSupport.c"
					{
						VideoRow* _tmp6_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						_tmp6_ = self->priv->backing_row;
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
						g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9280 "VideoSupport.c"
					}
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (old_filepath);
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					_g_free0 (new_filepath);
#line 1033 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					return;
#line 9288 "VideoSupport.c"
				}
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = self->priv->backing_row;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _tmp7_->filepath;
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = g_strdup (_tmp8_);
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (old_filepath);
#line 1035 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				old_filepath = _tmp9_;
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = video_table_get_instance ();
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = _tmp10_;
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = self->priv->backing_row;
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp13_ = _tmp12_->video_id;
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp14_ = new_filepath;
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_table_set_filepath (_tmp11_, &_tmp13_, _tmp14_, &_inner_error_);
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_database_table_unref0 (_tmp11_);
#line 1037 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9316 "VideoSupport.c"
					goto __finally545;
				}
#line 1038 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_ = self->priv->backing_row;
#line 1038 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = new_filepath;
#line 1038 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = g_strdup (_tmp16_);
#line 1038 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (_tmp15_->filepath);
#line 1038 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp15_->filepath = _tmp17_;
#line 9329 "VideoSupport.c"
			}
			__finally545:
			{
				VideoRow* _tmp18_ = NULL;
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = self->priv->backing_row;
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_rec_mutex_unlock (&self->priv->__lock_backing_row);
#line 9338 "VideoSupport.c"
			}
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 9344 "VideoSupport.c"
					goto __catch544_database_error;
				}
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (old_filepath);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_free0 (new_filepath);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				g_clear_error (&_inner_error_);
#line 1031 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 9357 "VideoSupport.c"
			}
		}
	}
	goto __finally544;
	__catch544_database_error:
	{
		GError* err = NULL;
		GError* _tmp19_ = NULL;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		err = _inner_error_;
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_inner_error_ = NULL;
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp19_ = err;
#line 1041 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		app_window_database_error (_tmp19_);
#line 1043 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_error_free0 (err);
#line 1043 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (old_filepath);
#line 1043 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (new_filepath);
#line 1043 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 9382 "VideoSupport.c"
	}
	__finally544:
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (old_filepath);
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_free0 (new_filepath);
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_clear_error (&_inner_error_);
#line 1030 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 9397 "VideoSupport.c"
	}
#line 1046 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp20_ = old_filepath;
#line 1046 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_assert (_tmp20_ != NULL, "old_filepath != null");
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp21_ = old_filepath;
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp22_ = g_file_new_for_path (_tmp21_);
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp23_ = _tmp22_;
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp24_ = file;
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp23_, _tmp24_);
#line 1047 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp23_);
#line 1049 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp25_ = alteration_new_from_list ("backing:master,metadata:name");
#line 1049 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = _tmp25_;
#line 1049 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp26_);
#line 1049 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_alteration_unref0 (_tmp26_);
#line 1027 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (old_filepath);
#line 1027 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_free0 (new_filepath);
#line 9427 "VideoSupport.c"
}


VideoMetadata* video_read_metadata (Video* self, GError** error) {
	VideoMetadata* result = NULL;
	VideoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	VideoReader* _tmp3_ = NULL;
	VideoReader* _tmp4_ = NULL;
	VideoMetadata* _tmp5_ = NULL;
	VideoMetadata* _tmp6_ = NULL;
	VideoMetadata* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 1052 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (self), NULL);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = _tmp1_;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_reader_new (_tmp2_);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = video_reader_read_metadata (_tmp4_, &_inner_error_);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = _tmp5_;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_reader_unref0 (_tmp4_);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = _tmp6_;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return NULL;
#line 9468 "VideoSupport.c"
	}
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = _tmp0_;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = NULL;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp7_;
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_media_metadata_unref0 (_tmp0_);
#line 1053 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 9480 "VideoSupport.c"
}


VideoInterpretableResults* video_interpretable_results_construct (GType object_type, Video* video) {
	VideoInterpretableResults* self = NULL;
	Video* _tmp0_ = NULL;
	Video* _tmp1_ = NULL;
#line 335 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO (video), NULL);
#line 335 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoInterpretableResults*) g_type_create_instance (object_type);
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video;
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->video);
#line 336 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->video = _tmp1_;
#line 335 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 9502 "VideoSupport.c"
}


VideoInterpretableResults* video_interpretable_results_new (Video* video) {
#line 335 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_interpretable_results_construct (VIDEO_TYPE_INTERPRETABLE_RESULTS, video);
#line 9509 "VideoSupport.c"
}


void video_interpretable_results_foreground_finish (VideoInterpretableResults* self) {
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp3_ = NULL;
	GError * _inner_error_ = NULL;
#line 339 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (VIDEO_IS_INTERPRETABLE_RESULTS (self));
#line 340 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->update_interpretable;
#line 340 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_) {
#line 9523 "VideoSupport.c"
		Video* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = self->video;
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = self->is_interpretable;
#line 341 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_set_is_interpretable (_tmp1_, _tmp2_);
#line 9532 "VideoSupport.c"
	}
#line 343 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = self->new_thumbnail;
#line 343 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp3_ != NULL) {
#line 9538 "VideoSupport.c"
		{
			Video* _tmp4_ = NULL;
			GdkPixbuf* _tmp5_ = NULL;
			Video* _tmp6_ = NULL;
			GdkPixbuf* _tmp7_ = NULL;
			Video* _tmp8_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = self->video;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = self->new_thumbnail;
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_BIG, _tmp5_, &_inner_error_);
#line 345 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9553 "VideoSupport.c"
				goto __catch546_g_error;
			}
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = self->video;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = self->new_thumbnail;
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_cache_replace (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), THUMBNAIL_CACHE_SIZE_MEDIUM, _tmp7_, &_inner_error_);
#line 346 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 9564 "VideoSupport.c"
				goto __catch546_g_error;
			}
#line 348 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = self->video;
#line 348 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			thumbnail_source_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 9571 "VideoSupport.c"
		}
		goto __finally546;
		__catch546_g_error:
		{
			GError* err = NULL;
			Video* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			GError* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			err = _inner_error_;
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_inner_error_ = NULL;
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = self->video;
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_OBJECT, DataObject));
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = _tmp10_;
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = err;
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = _tmp12_->message;
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_message ("VideoSupport.vala:350: Unable to update video thumbnails for %s: %s", _tmp11_, _tmp13_);
#line 350 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_free0 (_tmp11_);
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_error_free0 (err);
#line 9602 "VideoSupport.c"
		}
		__finally546:
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			g_clear_error (&_inner_error_);
#line 344 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return;
#line 9613 "VideoSupport.c"
		}
	}
}


static void video_value_interpretable_results_init (GValue* value) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	value->data[0].v_pointer = NULL;
#line 9622 "VideoSupport.c"
}


static void video_value_interpretable_results_free_value (GValue* value) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (value->data[0].v_pointer) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (value->data[0].v_pointer);
#line 9631 "VideoSupport.c"
	}
}


static void video_value_interpretable_results_copy_value (const GValue* src_value, GValue* dest_value) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (src_value->data[0].v_pointer) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = video_interpretable_results_ref (src_value->data[0].v_pointer);
#line 9641 "VideoSupport.c"
	} else {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		dest_value->data[0].v_pointer = NULL;
#line 9645 "VideoSupport.c"
	}
}


static gpointer video_value_interpretable_results_peek_pointer (const GValue* value) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 9653 "VideoSupport.c"
}


static gchar* video_value_interpretable_results_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (collect_values[0].v_pointer) {
#line 9660 "VideoSupport.c"
		VideoInterpretableResults* object;
		object = collect_values[0].v_pointer;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (object->parent_instance.g_class == NULL) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9667 "VideoSupport.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 9671 "VideoSupport.c"
		}
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = video_interpretable_results_ref (object);
#line 9675 "VideoSupport.c"
	} else {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9679 "VideoSupport.c"
	}
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 9683 "VideoSupport.c"
}


static gchar* video_value_interpretable_results_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	VideoInterpretableResults** object_p;
	object_p = collect_values[0].v_pointer;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!object_p) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 9694 "VideoSupport.c"
	}
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (!value->data[0].v_pointer) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = NULL;
#line 9700 "VideoSupport.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = value->data[0].v_pointer;
#line 9704 "VideoSupport.c"
	} else {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*object_p = video_interpretable_results_ref (value->data[0].v_pointer);
#line 9708 "VideoSupport.c"
	}
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return NULL;
#line 9712 "VideoSupport.c"
}


GParamSpec* video_param_spec_interpretable_results (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	VideoParamSpecInterpretableResults* spec;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (g_type_is_a (object_type, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return G_PARAM_SPEC (spec);
#line 9726 "VideoSupport.c"
}


gpointer video_value_get_interpretable_results (const GValue* value) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS), NULL);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return value->data[0].v_pointer;
#line 9735 "VideoSupport.c"
}


void video_value_set_interpretable_results (GValue* value, gpointer v_object) {
	VideoInterpretableResults* old;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_ref (value->data[0].v_pointer);
#line 9755 "VideoSupport.c"
	} else {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9759 "VideoSupport.c"
	}
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (old);
#line 9765 "VideoSupport.c"
	}
}


void video_value_take_interpretable_results (GValue* value, gpointer v_object) {
	VideoInterpretableResults* old;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	old = value->data[0].v_pointer;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (v_object) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VIDEO_TYPE_INTERPRETABLE_RESULTS));
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = v_object;
#line 9784 "VideoSupport.c"
	} else {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		value->data[0].v_pointer = NULL;
#line 9788 "VideoSupport.c"
	}
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (old) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		video_interpretable_results_unref (old);
#line 9794 "VideoSupport.c"
	}
}


static void video_interpretable_results_class_init (VideoInterpretableResultsClass * klass) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_interpretable_results_parent_class = g_type_class_peek_parent (klass);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((VideoInterpretableResultsClass *) klass)->finalize = video_interpretable_results_finalize;
#line 9804 "VideoSupport.c"
}


static void video_interpretable_results_instance_init (VideoInterpretableResults * self) {
#line 331 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->update_interpretable = FALSE;
#line 332 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->is_interpretable = FALSE;
#line 333 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->new_thumbnail = NULL;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->ref_count = 1;
#line 9817 "VideoSupport.c"
}


static void video_interpretable_results_finalize (VideoInterpretableResults* obj) {
	VideoInterpretableResults * self;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_handlers_destroy (self);
#line 330 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->video);
#line 333 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->new_thumbnail);
#line 9831 "VideoSupport.c"
}


GType video_interpretable_results_get_type (void) {
	static volatile gsize video_interpretable_results_type_id__volatile = 0;
	if (g_once_init_enter (&video_interpretable_results_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { video_value_interpretable_results_init, video_value_interpretable_results_free_value, video_value_interpretable_results_copy_value, video_value_interpretable_results_peek_pointer, "p", video_value_interpretable_results_collect_value, "p", video_value_interpretable_results_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (VideoInterpretableResultsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_interpretable_results_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoInterpretableResults), 0, (GInstanceInitFunc) video_interpretable_results_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType video_interpretable_results_type_id;
		video_interpretable_results_type_id = g_type_register_fundamental (g_type_fundamental_next (), "VideoInterpretableResults", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&video_interpretable_results_type_id__volatile, video_interpretable_results_type_id);
	}
	return video_interpretable_results_type_id__volatile;
}


gpointer video_interpretable_results_ref (gpointer instance) {
	VideoInterpretableResults* self;
	self = instance;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_atomic_int_inc (&self->ref_count);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return instance;
#line 9856 "VideoSupport.c"
}


void video_interpretable_results_unref (gpointer instance) {
	VideoInterpretableResults* self;
	self = instance;
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		VIDEO_INTERPRETABLE_RESULTS_GET_CLASS (self)->finalize (self);
#line 329 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 9869 "VideoSupport.c"
	}
}


static void video_class_init (VideoClass * klass) {
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_parent_class = g_type_class_peek_parent (klass);
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoPrivate));
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->commit_backlinks = (void (*)(DataSource*, SourceCollection*, const gchar*)) video_real_commit_backlinks;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*)(MediaSource*, EventID*)) video_real_set_event_id;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*)(MediaSource*, int*)) video_real_get_backing_files_state;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*)(ThumbnailSource*, gint, GError**)) video_real_get_thumbnail;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*)(MediaSource*)) video_real_get_master_md5;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*)(MediaSource*, Scaling*, GError**)) video_real_get_preview_pixbuf;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*)(ThumbnailSource*, gint, GError**)) video_real_create_thumbnail;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->get_typename = (gchar* (*)(DataSource*)) video_real_get_typename;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*)(DataSource*)) video_real_get_instance_id;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_import_id = (void (*)(MediaSource*, ImportID*)) video_real_get_import_id;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*)(ThumbnailSource*)) video_real_get_preferred_thumbnail_format;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_title = (gchar* (*)(MediaSource*)) video_real_get_title;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_title = (void (*)(MediaSource*, const gchar*)) video_real_set_title;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_comment = (gchar* (*)(MediaSource*)) video_real_get_comment;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_comment = (gboolean (*)(MediaSource*, const gchar*)) video_real_set_comment;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_rating = (Rating (*)(MediaSource*)) video_real_get_rating;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->set_rating = (void (*)(MediaSource*, Rating)) video_real_set_rating;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->increase_rating = (void (*)(MediaSource*)) video_real_increase_rating;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->decrease_rating = (void (*)(MediaSource*)) video_real_decrease_rating;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*)(MediaSource*)) video_real_is_trashed;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->is_offline = (gboolean (*)(MediaSource*)) video_real_is_offline;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->mark_offline = (void (*)(MediaSource*)) video_real_mark_offline;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->mark_online = (void (*)(MediaSource*)) video_real_mark_online;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->trash = (void (*)(MediaSource*)) video_real_trash;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->untrash = (void (*)(MediaSource*)) video_real_untrash;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_event_id = (void (*)(MediaSource*, EventID*)) video_real_get_event_id;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataObjectClass *) klass)->to_string = (gchar* (*)(DataObject*)) video_real_to_string;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_exposure_time = (time_t (*)(MediaSource*)) video_real_get_exposure_time;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_dimensions = (void (*)(MediaSource*, PhotoException, Dimensions*)) video_real_get_dimensions;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*)(MediaSource*)) video_real_get_filesize;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*)(MediaSource*)) video_real_get_master_filesize;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_timestamp = (time_t (*)(MediaSource*)) video_real_get_timestamp;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_file = (GFile* (*)(MediaSource*)) video_real_get_file;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*)(MediaSource*)) video_real_get_master_file;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->destroy = (void (*)(DataSource*)) video_real_destroy;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*)(DataSource*, GError**)) video_real_internal_delete_backing;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_OBJECT_CLASS (klass)->finalize = video_finalize;
#line 9953 "VideoSupport.c"
}


static void video_flaggable_interface_init (FlaggableIface * iface) {
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_flaggable_parent_iface = g_type_interface_peek_parent (iface);
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->is_flagged = (gboolean (*)(Flaggable*)) video_real_is_flagged;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_flagged = (void (*)(Flaggable*)) video_real_mark_flagged;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_unflagged = (void (*)(Flaggable*)) video_real_mark_unflagged;
#line 9966 "VideoSupport.c"
}


static void video_monitorable_interface_init (MonitorableIface * iface) {
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_monitorable_parent_iface = g_type_interface_peek_parent (iface);
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->is_offline = (gboolean (*)(Monitorable*)) video_real_is_offline;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_offline = (void (*)(Monitorable*)) video_real_mark_offline;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->mark_online = (void (*)(Monitorable*)) video_real_mark_online;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_master_timestamp = (void (*)(Monitorable*, GFileInfo*)) video_real_set_master_timestamp;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_master_file = (void (*)(Monitorable*, GFile*)) video_real_set_master_file;
#line 9983 "VideoSupport.c"
}


static void video_dateable_interface_init (DateableIface * iface) {
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_dateable_parent_iface = g_type_interface_peek_parent (iface);
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->get_exposure_time = (time_t (*)(Dateable*)) video_real_get_exposure_time;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	iface->set_exposure_time = (void (*)(Dateable*, time_t)) video_real_set_exposure_time;
#line 9994 "VideoSupport.c"
}


static void video_instance_init (Video * self) {
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_GET_PRIVATE (self);
#line 363 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_rec_mutex_init (&self->priv->__lock_backing_row);
#line 10003 "VideoSupport.c"
}


static void video_finalize (GObject* obj) {
	Video * self;
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO, Video);
#line 363 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_rec_mutex_clear (&self->priv->__lock_backing_row);
#line 363 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_video_row_unref0 (self->priv->backing_row);
#line 322 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	G_OBJECT_CLASS (video_parent_class)->finalize (obj);
#line 10017 "VideoSupport.c"
}


GType video_get_type (void) {
	static volatile gsize video_type_id__volatile = 0;
	if (g_once_init_enter (&video_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Video), 0, (GInstanceInitFunc) video_instance_init, NULL };
		static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) video_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) video_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) video_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType video_type_id;
		video_type_id = g_type_register_static (TYPE_VIDEO_SOURCE, "Video", &g_define_type_info, 0);
		g_type_add_interface_static (video_type_id, TYPE_FLAGGABLE, &flaggable_info);
		g_type_add_interface_static (video_type_id, TYPE_MONITORABLE, &monitorable_info);
		g_type_add_interface_static (video_type_id, TYPE_DATEABLE, &dateable_info);
		g_once_init_leave (&video_type_id__volatile, video_type_id);
	}
	return video_type_id__volatile;
}


GType video_source_collection_state_get_type (void) {
	static volatile gsize video_source_collection_state_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_collection_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN, "VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {VIDEO_SOURCE_COLLECTION_STATE_ONLINE, "VIDEO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {VIDEO_SOURCE_COLLECTION_STATE_OFFLINE, "VIDEO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {VIDEO_SOURCE_COLLECTION_STATE_TRASH, "VIDEO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {0, NULL, NULL}};
		GType video_source_collection_state_type_id;
		video_source_collection_state_type_id = g_enum_register_static ("VideoSourceCollectionState", values);
		g_once_init_leave (&video_source_collection_state_type_id__volatile, video_source_collection_state_type_id);
	}
	return video_source_collection_state_type_id__volatile;
}


static gint _uint64_compare_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = uint64_compare ((guint64*) a, (guint64*) b);
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10056 "VideoSupport.c"
}


static guint64* _uint64_dup (guint64* self) {
	guint64* dup;
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	dup = g_new0 (guint64, 1);
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	memcpy (dup, self, sizeof (guint64));
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return dup;
#line 10068 "VideoSupport.c"
}


static gint64 _video_source_collection_get_video_key_get_source_database_key (DataSource* source, gpointer self) {
	gint64 result;
	result = video_source_collection_get_video_key (source);
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10077 "VideoSupport.c"
}


static void _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self) {
#line 1081 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_on_trashcan_contents_altered ((VideoSourceCollection*) self, added, removed);
#line 10084 "VideoSupport.c"
}


static void _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender, GeeCollection* added, GeeCollection* removed, gpointer self) {
#line 1082 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_on_offline_contents_altered ((VideoSourceCollection*) self, added, removed);
#line 10091 "VideoSupport.c"
}


VideoSourceCollection* video_source_collection_construct (GType object_type) {
	VideoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_ = NULL;
	MediaSourceHoldingTank* _tmp1_ = NULL;
	MediaSourceHoldingTank* _tmp2_ = NULL;
	MediaSourceHoldingTank* _tmp3_ = NULL;
#line 1079 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = (VideoSourceCollection*) media_source_collection_construct (object_type, "VideoSourceCollection", _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1081 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1081 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 1081 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
#line 1081 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp1_);
#line 1082 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1082 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = _tmp2_;
#line 1082 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _video_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
#line 1082 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp3_);
#line 1078 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return self;
#line 10121 "VideoSupport.c"
}


VideoSourceCollection* video_source_collection_new (void) {
#line 1078 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return video_source_collection_construct (TYPE_VIDEO_SOURCE_COLLECTION);
#line 10128 "VideoSupport.c"
}


static gboolean _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self) {
	gboolean result;
	result = video_source_collection_is_video_trashed (source);
#line 1086 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10137 "VideoSupport.c"
}


static MediaSourceHoldingTank* video_source_collection_real_create_trashcan (MediaSourceCollection* base) {
	VideoSourceCollection * self;
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_ = NULL;
#line 1085 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1086 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_trashed_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1086 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1086 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10153 "VideoSupport.c"
}


static gboolean _video_source_collection_is_video_offline_source_holding_tank_check_to_keep (DataSource* source, Alteration* alteration, gpointer self) {
	gboolean result;
	result = video_source_collection_is_video_offline (source);
#line 1090 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10162 "VideoSupport.c"
}


static MediaSourceHoldingTank* video_source_collection_real_create_offline_bin (MediaSourceCollection* base) {
	VideoSourceCollection * self;
	MediaSourceHoldingTank* result = NULL;
	MediaSourceHoldingTank* _tmp0_ = NULL;
#line 1089 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1090 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = media_source_holding_tank_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _video_source_collection_is_video_offline_source_holding_tank_check_to_keep, NULL, _video_source_collection_get_video_key_get_source_database_key, NULL);
#line 1090 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1090 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10178 "VideoSupport.c"
}


static MediaMonitor* video_source_collection_real_create_media_monitor (MediaSourceCollection* base, Workers* workers, GCancellable* cancellable) {
	VideoSourceCollection * self;
	MediaMonitor* result = NULL;
	GCancellable* _tmp0_ = NULL;
	VideoMonitor* _tmp1_ = NULL;
#line 1093 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1093 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
#line 1093 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_CANCELLABLE (cancellable), NULL);
#line 1094 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = cancellable;
#line 1094 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_monitor_new (_tmp0_);
#line 1094 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_MONITOR, MediaMonitor);
#line 1094 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10201 "VideoSupport.c"
}


static gboolean video_source_collection_real_holds_type_of_source (SourceCollection* base, DataSource* source) {
	VideoSourceCollection * self;
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
#line 1097 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1097 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1098 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1098 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_VIDEO);
#line 1098 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10219 "VideoSupport.c"
}


static gchar* video_source_collection_real_get_typename (MediaSourceCollection* base) {
	VideoSourceCollection * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 1101 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = g_strdup (VIDEO_TYPENAME);
#line 1102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp0_;
#line 1102 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10235 "VideoSupport.c"
}


static gboolean video_source_collection_real_is_file_recognized (MediaSourceCollection* base, GFile* file) {
	VideoSourceCollection * self;
	gboolean result = FALSE;
	GFile* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1105 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 1106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 1106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = video_reader_is_supported_video_file (_tmp0_);
#line 1106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 1106 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10256 "VideoSupport.c"
}


static void video_source_collection_on_trashcan_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 1109 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1111 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = added;
#line 1111 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = removed;
#line 1111 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 10275 "VideoSupport.c"
}


static void video_source_collection_on_offline_contents_altered (VideoSourceCollection* self, GeeCollection* added, GeeCollection* removed) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_COLLECTION (added));
#line 1115 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_COLLECTION (removed));
#line 1117 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = added;
#line 1117 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = removed;
#line 1117 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
#line 10294 "VideoSupport.c"
}


static MediaSource* video_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base, gint64 numeric_id) {
	VideoSourceCollection * self;
	MediaSource* result = NULL;
	gint64 _tmp0_ = 0LL;
	VideoID _tmp1_ = {0};
	Video* _tmp2_ = NULL;
#line 1121 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = numeric_id;
#line 1122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp1_, _tmp0_);
#line 1122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video_source_collection_fetch (self, &_tmp1_);
#line 1122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_MEDIA_SOURCE, MediaSource);
#line 1122 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10316 "VideoSupport.c"
}


gint64 video_source_collection_get_video_key (DataSource* source) {
	gint64 result = 0LL;
	Video* video = NULL;
	DataSource* _tmp0_ = NULL;
	Video* _tmp1_ = NULL;
	VideoID video_id = {0};
	VideoID _tmp2_ = {0};
	VideoID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
#line 1125 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
#line 1126 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1126 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video));
#line 1126 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = _tmp1_;
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_get_video_id (video, &_tmp2_);
#line 1127 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id = _tmp2_;
#line 1129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_id;
#line 1129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_.id;
#line 1129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 1129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1129 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10351 "VideoSupport.c"
}


gboolean video_source_collection_is_video_trashed (DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1132 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 1133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 1133 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10369 "VideoSupport.c"
}


gboolean video_source_collection_is_video_offline (DataSource* source) {
	gboolean result = FALSE;
	DataSource* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1136 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
#line 1137 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = source;
#line 1137 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_VIDEO, Video), TYPE_MEDIA_SOURCE, MediaSource));
#line 1137 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp1_;
#line 1137 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10387 "VideoSupport.c"
}


Video* video_source_collection_fetch (VideoSourceCollection* self, VideoID* video_id) {
	Video* result = NULL;
	VideoID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	DataSource* _tmp2_ = NULL;
#line 1140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
#line 1140 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (video_id != NULL, NULL);
#line 1141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = *video_id;
#line 1141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_.id;
#line 1141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp1_);
#line 1141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_VIDEO, Video);
#line 1141 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10410 "VideoSupport.c"
}


static GeeCollection* video_source_collection_real_get_event_source_ids (MediaSourceCollection* base, EventID* event_id) {
	VideoSourceCollection * self;
	GeeCollection* result = NULL;
	VideoTable* _tmp0_ = NULL;
	VideoTable* _tmp1_ = NULL;
	EventID _tmp2_ = {0};
	GeeArrayList* _tmp3_ = NULL;
	GeeCollection* _tmp4_ = NULL;
#line 1144 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1144 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video_table_get_instance ();
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = _tmp0_;
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = *event_id;
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_table_get_event_source_ids (_tmp1_, &_tmp2_);
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_database_table_unref0 (_tmp1_);
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp4_;
#line 1145 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10442 "VideoSupport.c"
}


Video* video_source_collection_get_state_by_file (VideoSourceCollection* self, GFile* file, VideoSourceCollectionState* state) {
	VideoSourceCollectionState _vala_state = 0;
	Video* result = NULL;
	Video* video = NULL;
	GFile* _tmp0_ = NULL;
	MediaSource* _tmp1_ = NULL;
	Video* _tmp2_ = NULL;
	MediaSourceHoldingTank* _tmp3_ = NULL;
	MediaSourceHoldingTank* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	MediaSource* _tmp6_ = NULL;
	Video* _tmp7_ = NULL;
	MediaSourceHoldingTank* _tmp8_ = NULL;
	MediaSourceHoldingTank* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	MediaSource* _tmp11_ = NULL;
	Video* _tmp12_ = NULL;
#line 1148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), NULL);
#line 1148 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 1149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = file;
#line 1149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_collection_fetch_by_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), _tmp0_);
#line 1149 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_VIDEO, Video);
#line 1150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = video;
#line 1150 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp2_ != NULL) {
#line 1151 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_ONLINE;
#line 1153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10485 "VideoSupport.c"
		}
#line 1153 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10489 "VideoSupport.c"
	}
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = _tmp3_;
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = file;
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = media_source_holding_tank_fetch_by_master_file (_tmp4_, _tmp5_);
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_VIDEO, Video);
#line 1156 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp4_);
#line 1157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp7_ = video;
#line 1157 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp7_ != NULL) {
#line 1158 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_TRASH;
#line 1160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10517 "VideoSupport.c"
		}
#line 1160 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10521 "VideoSupport.c"
	}
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp9_ = _tmp8_;
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp10_ = file;
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp11_ = media_source_holding_tank_fetch_by_master_file (_tmp9_, _tmp10_);
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_VIDEO, Video);
#line 1163 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_source_holding_tank_unref0 (_tmp9_);
#line 1164 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp12_ = video;
#line 1164 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp12_ != NULL) {
#line 1165 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_vala_state = VIDEO_SOURCE_COLLECTION_STATE_OFFLINE;
#line 1167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		result = video;
#line 1167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		if (state) {
#line 1167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			*state = _vala_state;
#line 10549 "VideoSupport.c"
		}
#line 1167 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return result;
#line 10553 "VideoSupport.c"
	}
#line 1170 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_vala_state = VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN;
#line 1172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = NULL;
#line 1172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (video);
#line 1172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (state) {
#line 1172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		*state = _vala_state;
#line 10565 "VideoSupport.c"
	}
#line 1172 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 10569 "VideoSupport.c"
}


static void video_source_collection_compare_backing (VideoSourceCollection* self, Video* video, GFileInfo* info, GeeCollection* matching_master) {
	Video* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	GFileInfo* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	Video* _tmp4_ = NULL;
	time_t _tmp5_ = 0;
	GFileInfo* _tmp6_ = NULL;
	GTimeVal _tmp7_ = {0};
	glong _tmp8_ = 0L;
#line 1175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO (video));
#line 1175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1175 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (GEE_IS_COLLECTION (matching_master));
#line 1176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = video;
#line 1176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = media_source_get_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = info;
#line 1176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = g_file_info_get_size (_tmp2_);
#line 1176 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp1_ != ((guint64) _tmp3_)) {
#line 1177 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		return;
#line 10603 "VideoSupport.c"
	}
#line 1179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp4_ = video;
#line 1179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp5_ = media_source_get_timestamp (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp6_ = info;
#line 1179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_file_info_get_modification_time (_tmp6_, &_tmp7_);
#line 1179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp8_ = _tmp7_.tv_sec;
#line 1179 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp5_ == ((time_t) _tmp8_)) {
#line 10617 "VideoSupport.c"
		GeeCollection* _tmp9_ = NULL;
		Video* _tmp10_ = NULL;
#line 1180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp9_ = matching_master;
#line 1180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp10_ = video;
#line 1180 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		gee_collection_add (_tmp9_, _tmp10_);
#line 10626 "VideoSupport.c"
	}
}


void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self, GFileInfo* info, GeeCollection* matching_master) {
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (G_IS_FILE_INFO (info));
#line 1183 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (GEE_IS_COLLECTION (matching_master));
#line 10638 "VideoSupport.c"
	{
		GeeIterator* _object_it = NULL;
		GeeCollection* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = _tmp0_;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp1_);
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_object_it = _tmp3_;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10659 "VideoSupport.c"
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			DataObject* object = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			DataObject* _tmp8_ = NULL;
			GFileInfo* _tmp9_ = NULL;
			GeeCollection* _tmp10_ = NULL;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp4_ = _object_it;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp5_ = gee_iterator_next (_tmp4_);
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp5_) {
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10676 "VideoSupport.c"
			}
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _object_it;
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = gee_iterator_get (_tmp6_);
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			object = (DataObject*) _tmp7_;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = object;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = info;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = matching_master;
#line 1185 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_VIDEO, Video), _tmp9_, _tmp10_);
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (object);
#line 10694 "VideoSupport.c"
		}
#line 1184 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_object_it);
#line 10698 "VideoSupport.c"
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp11_ = NULL;
		GeeCollection* _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _tmp14_ = NULL;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp11_ = media_source_collection_get_offline_bin_contents (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp12_ = _tmp11_;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp14_ = _tmp13_;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp12_);
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_media_it = _tmp14_;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10720 "VideoSupport.c"
			GeeIterator* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			MediaSource* media = NULL;
			GeeIterator* _tmp17_ = NULL;
			gpointer _tmp18_ = NULL;
			MediaSource* _tmp19_ = NULL;
			GFileInfo* _tmp20_ = NULL;
			GeeCollection* _tmp21_ = NULL;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = _media_it;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = gee_iterator_next (_tmp15_);
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp16_) {
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10737 "VideoSupport.c"
			}
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp17_ = _media_it;
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp18_ = gee_iterator_get (_tmp17_);
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			media = (MediaSource*) _tmp18_;
#line 1188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp19_ = media;
#line 1188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp20_ = info;
#line 1188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp21_ = matching_master;
#line 1188 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_VIDEO, Video), _tmp20_, _tmp21_);
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (media);
#line 10755 "VideoSupport.c"
		}
#line 1187 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_media_it);
#line 10759 "VideoSupport.c"
	}
}


static void video_source_collection_real_notify_contents_altered (DataCollection* base, GeeIterable* added, GeeIterable* removed) {
	VideoSourceCollection * self;
	GeeIterable* _tmp0_ = NULL;
	GeeIterable* _tmp13_ = NULL;
	GeeIterable* _tmp26_ = NULL;
	GeeIterable* _tmp27_ = NULL;
#line 1191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((added == NULL) || GEE_IS_ITERABLE (added));
#line 1191 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail ((removed == NULL) || GEE_IS_ITERABLE (removed));
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = added;
#line 1193 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ != NULL) {
#line 10780 "VideoSupport.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp1_ = NULL;
			GeeIterator* _tmp2_ = NULL;
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp1_ = added;
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp2_ = gee_iterable_iterator (_tmp1_);
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_object_it = _tmp2_;
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 10793 "VideoSupport.c"
				GeeIterator* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				DataObject* object = NULL;
				GeeIterator* _tmp5_ = NULL;
				gpointer _tmp6_ = NULL;
				Video* video = NULL;
				DataObject* _tmp7_ = NULL;
				Video* _tmp8_ = NULL;
				GeeMultiMap* _tmp9_ = NULL;
				Video* _tmp10_ = NULL;
				guint64 _tmp11_ = 0ULL;
				Video* _tmp12_ = NULL;
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp3_ = _object_it;
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp4_) {
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 10814 "VideoSupport.c"
				}
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp5_ = _object_it;
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				object = (DataObject*) _tmp6_;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp7_ = object;
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video));
#line 1195 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp8_;
#line 1197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp9_ = self->priv->filesize_to_video;
#line 1197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp10_ = video;
#line 1197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp11_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp12_ = video;
#line 1197 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gee_multi_map_set (_tmp9_, &_tmp11_, _tmp12_);
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (object);
#line 10842 "VideoSupport.c"
			}
#line 1194 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_object_it);
#line 10846 "VideoSupport.c"
		}
	}
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp13_ = removed;
#line 1201 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp13_ != NULL) {
#line 10853 "VideoSupport.c"
		{
			GeeIterator* _object_it = NULL;
			GeeIterable* _tmp14_ = NULL;
			GeeIterator* _tmp15_ = NULL;
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = removed;
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = gee_iterable_iterator (_tmp14_);
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_object_it = _tmp15_;
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			while (TRUE) {
#line 10866 "VideoSupport.c"
				GeeIterator* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				DataObject* object = NULL;
				GeeIterator* _tmp18_ = NULL;
				gpointer _tmp19_ = NULL;
				Video* video = NULL;
				DataObject* _tmp20_ = NULL;
				Video* _tmp21_ = NULL;
				GeeMultiMap* _tmp22_ = NULL;
				Video* _tmp23_ = NULL;
				guint64 _tmp24_ = 0ULL;
				Video* _tmp25_ = NULL;
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp16_ = _object_it;
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = gee_iterator_next (_tmp16_);
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				if (!_tmp17_) {
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
					break;
#line 10887 "VideoSupport.c"
				}
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp18_ = _object_it;
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp19_ = gee_iterator_get (_tmp18_);
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				object = (DataObject*) _tmp19_;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp20_ = object;
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_VIDEO, Video));
#line 1203 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video = _tmp21_;
#line 1205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp22_ = self->priv->filesize_to_video;
#line 1205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp23_ = video;
#line 1205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp24_ = media_source_get_master_filesize (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp25_ = video;
#line 1205 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				gee_multi_map_remove (_tmp22_, &_tmp24_, _tmp25_);
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (object);
#line 10915 "VideoSupport.c"
			}
#line 1202 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_object_it);
#line 10919 "VideoSupport.c"
		}
	}
#line 1209 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp26_ = added;
#line 1209 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp27_ = removed;
#line 1209 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_DATA_COLLECTION, DataCollection), _tmp26_, _tmp27_);
#line 10928 "VideoSupport.c"
}


void video_source_collection_get_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize, VideoID* result) {
	VideoID _tmp19_ = {0};
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (IS_VIDEO_SOURCE_COLLECTION (self));
#line 1212 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_if_fail (basename != NULL);
#line 10938 "VideoSupport.c"
	{
		GeeIterator* _video_it = NULL;
		GeeMultiMap* _tmp0_ = NULL;
		guint64 _tmp1_ = 0ULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp0_ = self->priv->filesize_to_video;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = filesize;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp2_ = gee_multi_map_get (_tmp0_, &_tmp1_);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp3_ = _tmp2_;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp5_ = _tmp4_;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_tmp3_);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_video_it = _tmp5_;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		while (TRUE) {
#line 10965 "VideoSupport.c"
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			Video* video = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			Video* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gboolean _tmp16_ = FALSE;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp6_ = _video_it;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (!_tmp7_) {
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				break;
#line 10986 "VideoSupport.c"
			}
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp8_ = _video_it;
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			video = (Video*) _tmp9_;
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp10_ = video;
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp11_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_MEDIA_SOURCE, MediaSource));
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp12_ = _tmp11_;
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp13_ = g_file_get_basename (_tmp12_);
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp14_ = basename;
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp15_ = utf8_ci_compare (_tmp13_, _tmp14_);
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_tmp16_ = _tmp15_ == 0;
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (_tmp12_);
#line 1214 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			if (_tmp16_) {
#line 11012 "VideoSupport.c"
				Video* _tmp17_ = NULL;
				VideoID _tmp18_ = {0};
#line 1215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_tmp17_ = video;
#line 1215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				video_get_video_id (_tmp17_, &_tmp18_);
#line 1215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				*result = _tmp18_;
#line 1215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (video);
#line 1215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				_g_object_unref0 (_video_it);
#line 1215 "/home/jens/Source/shotwell/src/VideoSupport.vala"
				return;
#line 11027 "VideoSupport.c"
			}
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
			_g_object_unref0 (video);
#line 11031 "VideoSupport.c"
		}
#line 1213 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_g_object_unref0 (_video_it);
#line 11035 "VideoSupport.c"
	}
#line 1218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_id_init (&_tmp19_, VIDEO_ID_INVALID);
#line 1218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	*result = _tmp19_;
#line 1218 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return;
#line 11043 "VideoSupport.c"
}


gboolean video_source_collection_has_basename_filesize_duplicate (VideoSourceCollection* self, const gchar* basename, guint64 filesize) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	VideoID _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 1222 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (IS_VIDEO_SOURCE_COLLECTION (self), FALSE);
#line 1222 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_return_val_if_fail (basename != NULL, FALSE);
#line 1223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = basename;
#line 1223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp1_ = filesize;
#line 1223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_get_basename_filesize_duplicate (self, _tmp0_, _tmp1_, &_tmp2_);
#line 1223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp3_ = video_id_is_valid (&_tmp2_);
#line 1223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp3_;
#line 1223 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 11069 "VideoSupport.c"
}


static TransactionController* video_source_collection_real_get_transaction_controller (MediaSourceCollection* base) {
	TransactionController* result;
	VideoSourceCollection* self;
	TransactionController* _tmp0_ = NULL;
	TransactionController* _tmp2_ = NULL;
#line 1066 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1067 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = self->priv->_transaction_controller;
#line 1067 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	if (_tmp0_ == NULL) {
#line 11084 "VideoSupport.c"
		MediaSourceTransactionController* _tmp1_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_tmp1_ = media_source_transaction_controller_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		_transaction_controller_unref0 (self->priv->_transaction_controller);
#line 1068 "/home/jens/Source/shotwell/src/VideoSupport.vala"
		self->priv->_transaction_controller = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TRANSACTION_CONTROLLER, TransactionController);
#line 11092 "VideoSupport.c"
	}
#line 1070 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp2_ = self->priv->_transaction_controller;
#line 1070 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	result = _tmp2_;
#line 1070 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	return result;
#line 11100 "VideoSupport.c"
}


static void video_source_collection_class_init (VideoSourceCollectionClass * klass) {
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	video_source_collection_parent_class = g_type_class_peek_parent (klass);
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataCollectionClass *) klass)->finalize = video_source_collection_finalize;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	g_type_class_add_private (klass, sizeof (VideoSourceCollectionPrivate));
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*)(MediaSourceCollection*)) video_source_collection_real_create_trashcan;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*)(MediaSourceCollection*)) video_source_collection_real_create_offline_bin;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*)(MediaSourceCollection*, Workers*, GCancellable*)) video_source_collection_real_create_media_monitor;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*)(SourceCollection*, DataSource*)) video_source_collection_real_holds_type_of_source;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*)(MediaSourceCollection*)) video_source_collection_real_get_typename;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*)(MediaSourceCollection*, GFile*)) video_source_collection_real_is_file_recognized;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*)(MediaSourceCollection*, gint64)) video_source_collection_real_fetch_by_numeric_id;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*)(MediaSourceCollection*, EventID*)) video_source_collection_real_get_event_source_ids;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*)(DataCollection*, GeeIterable*, GeeIterable*)) video_source_collection_real_notify_contents_altered;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = video_source_collection_real_get_transaction_controller;
#line 11131 "VideoSupport.c"
}


static void video_source_collection_instance_init (VideoSourceCollection * self) {
	GeeTreeMultiMap* _tmp0_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv = VIDEO_SOURCE_COLLECTION_GET_PRIVATE (self);
#line 1074 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->_transaction_controller = NULL;
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_tmp0_ = gee_tree_multi_map_new (G_TYPE_UINT64, (GBoxedCopyFunc) _uint64_dup, (GDestroyNotify) g_free, TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _uint64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self->priv->filesize_to_video = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
#line 11145 "VideoSupport.c"
}


static void video_source_collection_finalize (DataCollection* obj) {
	VideoSourceCollection * self;
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection);
#line 1074 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_transaction_controller_unref0 (self->priv->_transaction_controller);
#line 1075 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	_g_object_unref0 (self->priv->filesize_to_video);
#line 1057 "/home/jens/Source/shotwell/src/VideoSupport.vala"
	DATA_COLLECTION_CLASS (video_source_collection_parent_class)->finalize (obj);
#line 11159 "VideoSupport.c"
}


GType video_source_collection_get_type (void) {
	static volatile gsize video_source_collection_type_id__volatile = 0;
	if (g_once_init_enter (&video_source_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (VideoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoSourceCollection), 0, (GInstanceInitFunc) video_source_collection_instance_init, NULL };
		GType video_source_collection_type_id;
		video_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "VideoSourceCollection", &g_define_type_info, 0);
		g_once_init_leave (&video_source_collection_type_id__volatile, video_source_collection_type_id);
	}
	return video_source_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



