/* org-bluez.c generated by valac 0.36.1.697-2b74, the Vala compiler
 * generated from org-bluez.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Arun Raghavan <arun.raghavan@collabora.co.uk>
 *       Gustavo Padovan <gustavo.padovan@collabora.co.uk>
 *       Matthieu Bouron <matthieu.bouron@collabora.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define ORG_BLUEZ_TYPE_DEVICE (org_bluez_device_get_type ())
#define ORG_BLUEZ_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_TYPE_DEVICE, orgbluezDevice))
#define ORG_BLUEZ_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_TYPE_DEVICE))
#define ORG_BLUEZ_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_TYPE_DEVICE, orgbluezDeviceIface))

typedef struct _orgbluezDevice orgbluezDevice;
typedef struct _orgbluezDeviceIface orgbluezDeviceIface;

#define ORG_BLUEZ_TYPE_DEVICE_PROXY (org_bluez_device_proxy_get_type ())
typedef GDBusProxy orgbluezDeviceProxy;
typedef GDBusProxyClass orgbluezDeviceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	ORG_BLUEZ_ERROR_NOT_READY,
	ORG_BLUEZ_ERROR_FAILED,
	ORG_BLUEZ_ERROR_IN_PROGRESS,
	ORG_BLUEZ_ERROR_ALREADY_CONNECTED,
	ORG_BLUEZ_ERROR_NOT_CONNECTED,
	ORG_BLUEZ_ERROR_DOES_NOT_EXIST,
	ORG_BLUEZ_ERROR_CONNECT_FAILED,
	ORG_BLUEZ_ERROR_NOT_SUPPORTED,
	ORG_BLUEZ_ERROR_INVALID_ARGUMENTS,
	ORG_BLUEZ_ERROR_AUTHENTICATION_CANCELED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_FAILED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_REJECTED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_TIMEOUT,
	ORG_BLUEZ_ERROR_CONNECTION_ATTEMPT_FAILED
} orgbluezError;
#define ORG_BLUEZ_ERROR org_bluez_error_quark ()
struct _orgbluezDeviceIface {
	GTypeInterface parent_iface;
	void (*connect) (orgbluezDevice* self, GError** error);
	void (*disconnect) (orgbluezDevice* self, GError** error);
	void (*disconnect_profile) (orgbluezDevice* self, const gchar* uuid, GError** error);
	void (*pair) (orgbluezDevice* self, GError** error);
	void (*cancel_pairing) (orgbluezDevice* self, GError** error);
	gchar* (*get_address) (orgbluezDevice* self);
	gchar* (*get_name) (orgbluezDevice* self);
	gchar* (*get_icon) (orgbluezDevice* self);
	guint32 (*get_bluetooth_class) (orgbluezDevice* self);
	guint16 (*get_appearance) (orgbluezDevice* self);
	gchar** (*get_uuids) (orgbluezDevice* self, int* result_length1);
	gboolean (*get_paired) (orgbluezDevice* self);
	gboolean (*get_connected) (orgbluezDevice* self);
	gboolean (*get_trusted) (orgbluezDevice* self);
	void (*set_trusted) (orgbluezDevice* self, gboolean value);
	gboolean (*get_blocked) (orgbluezDevice* self);
	void (*set_blocked) (orgbluezDevice* self, gboolean value);
	gchar* (*get_alias) (orgbluezDevice* self);
	void (*set_alias) (orgbluezDevice* self, const gchar* value);
	char* (*get_adapter) (orgbluezDevice* self);
	gboolean (*get_legacy_pairing) (orgbluezDevice* self);
	gchar* (*get_mod_alias) (orgbluezDevice* self);
	gint16 (*get_rssi) (orgbluezDevice* self);
};



GQuark org_bluez_error_quark (void);
GType org_bluez_device_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_device_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_device_get_type (void) G_GNUC_CONST;
void org_bluez_device_connect (orgbluezDevice* self, GError** error);
void org_bluez_device_disconnect (orgbluezDevice* self, GError** error);
void org_bluez_device_disconnect_profile (orgbluezDevice* self, const gchar* uuid, GError** error);
void org_bluez_device_pair (orgbluezDevice* self, GError** error);
void org_bluez_device_cancel_pairing (orgbluezDevice* self, GError** error);
gchar* org_bluez_device_get_address (orgbluezDevice* self);
gchar* org_bluez_device_get_name (orgbluezDevice* self);
gchar* org_bluez_device_get_icon (orgbluezDevice* self);
guint32 org_bluez_device_get_bluetooth_class (orgbluezDevice* self);
guint16 org_bluez_device_get_appearance (orgbluezDevice* self);
gchar** org_bluez_device_get_uuids (orgbluezDevice* self, int* result_length1);
gboolean org_bluez_device_get_paired (orgbluezDevice* self);
gboolean org_bluez_device_get_connected (orgbluezDevice* self);
gboolean org_bluez_device_get_trusted (orgbluezDevice* self);
void org_bluez_device_set_trusted (orgbluezDevice* self, gboolean value);
gboolean org_bluez_device_get_blocked (orgbluezDevice* self);
void org_bluez_device_set_blocked (orgbluezDevice* self, gboolean value);
gchar* org_bluez_device_get_alias (orgbluezDevice* self);
void org_bluez_device_set_alias (orgbluezDevice* self, const gchar* value);
char* org_bluez_device_get_adapter (orgbluezDevice* self);
gboolean org_bluez_device_get_legacy_pairing (orgbluezDevice* self);
gchar* org_bluez_device_get_mod_alias (orgbluezDevice* self);
gint16 org_bluez_device_get_rssi (orgbluezDevice* self);
static void org_bluez_device_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void org_bluez_device_proxy_connect (orgbluezDevice* self, GError** error);
static void org_bluez_device_proxy_disconnect (orgbluezDevice* self, GError** error);
static void org_bluez_device_proxy_disconnect_profile (orgbluezDevice* self, const gchar* uuid, GError** error);
static void org_bluez_device_proxy_pair (orgbluezDevice* self, GError** error);
static void org_bluez_device_proxy_cancel_pairing (orgbluezDevice* self, GError** error);
static gchar* org_bluez_device_dbus_proxy_get_address (orgbluezDevice* self);
static gchar* org_bluez_device_dbus_proxy_get_name (orgbluezDevice* self);
static gchar* org_bluez_device_dbus_proxy_get_icon (orgbluezDevice* self);
static guint32 org_bluez_device_dbus_proxy_get_bluetooth_class (orgbluezDevice* self);
static guint16 org_bluez_device_dbus_proxy_get_appearance (orgbluezDevice* self);
static gchar** org_bluez_device_dbus_proxy_get_uuids (orgbluezDevice* self, int* result_length1);
static gboolean org_bluez_device_dbus_proxy_get_paired (orgbluezDevice* self);
static gboolean org_bluez_device_dbus_proxy_get_connected (orgbluezDevice* self);
static gboolean org_bluez_device_dbus_proxy_get_trusted (orgbluezDevice* self);
static void org_bluez_device_dbus_proxy_set_trusted (orgbluezDevice* self, gboolean value);
static gboolean org_bluez_device_dbus_proxy_get_blocked (orgbluezDevice* self);
static void org_bluez_device_dbus_proxy_set_blocked (orgbluezDevice* self, gboolean value);
static gchar* org_bluez_device_dbus_proxy_get_alias (orgbluezDevice* self);
static void org_bluez_device_dbus_proxy_set_alias (orgbluezDevice* self, const gchar* value);
static char* org_bluez_device_dbus_proxy_get_adapter (orgbluezDevice* self);
static gboolean org_bluez_device_dbus_proxy_get_legacy_pairing (orgbluezDevice* self);
static gchar* org_bluez_device_dbus_proxy_get_mod_alias (orgbluezDevice* self);
static gint16 org_bluez_device_dbus_proxy_get_rssi (orgbluezDevice* self);
static void org_bluez_device_proxy_org_bluez_device_interface_init (orgbluezDeviceIface* iface);
static void _dbus_org_bluez_device_connect (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_device_disconnect (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_device_disconnect_profile (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_device_pair (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_device_cancel_pairing (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void org_bluez_device_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* org_bluez_device_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_org_bluez_device_get_address (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_name (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_icon (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_bluetooth_class (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_appearance (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_uuids (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_paired (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_connected (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_trusted (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_blocked (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_alias (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_adapter (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_legacy_pairing (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_mod_alias (orgbluezDevice* self);
static GVariant* _dbus_org_bluez_device_get_rssi (orgbluezDevice* self);
static gboolean org_bluez_device_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_org_bluez_device_set_trusted (orgbluezDevice* self, GVariant* _value);
static void _dbus_org_bluez_device_set_blocked (orgbluezDevice* self, GVariant* _value);
static void _dbus_org_bluez_device_set_alias (orgbluezDevice* self, GVariant* _value);
static void _org_bluez_device_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusErrorEntry org_bluez_error_entries[] = {{ORG_BLUEZ_ERROR_NOT_READY, "org.bluez.Error.NotReady"}, {ORG_BLUEZ_ERROR_FAILED, "org.bluez.Error.Failed"}, {ORG_BLUEZ_ERROR_IN_PROGRESS, "org.bluez.Error.InProgress"}, {ORG_BLUEZ_ERROR_ALREADY_CONNECTED, "org.bluez.Error.AlreadyConnected"}, {ORG_BLUEZ_ERROR_NOT_CONNECTED, "org.bluez.Error.NotConnected"}, {ORG_BLUEZ_ERROR_DOES_NOT_EXIST, "org.bluez.Error.DoesNotExist"}, {ORG_BLUEZ_ERROR_CONNECT_FAILED, "org.bluez.Error.ConnectFailed"}, {ORG_BLUEZ_ERROR_NOT_SUPPORTED, "org.bluez.Error.NotSupported"}, {ORG_BLUEZ_ERROR_INVALID_ARGUMENTS, "org.bluez.Error.InvalidArguments"}, {ORG_BLUEZ_ERROR_AUTHENTICATION_CANCELED, "org.bluez.Error.AuthenticationCanceled"}, {ORG_BLUEZ_ERROR_AUTHENTICATION_FAILED, "org.bluez.Error.AuthenticationFailed"}, {ORG_BLUEZ_ERROR_AUTHENTICATION_REJECTED, "org.bluez.Error.AuthenticationRejected"}, {ORG_BLUEZ_ERROR_AUTHENTICATION_TIMEOUT, "org.bluez.Error.AuthenticationTimeout"}, {ORG_BLUEZ_ERROR_CONNECTION_ATTEMPT_FAILED, "org.bluez.Error.ConnectionAttemptFailed"}};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_connect_in[] = {NULL};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_connect_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_device_dbus_method_info_connect = {-1, "Connect", (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_connect_in), (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_connect_out)};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_disconnect_in[] = {NULL};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_disconnect_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_device_dbus_method_info_disconnect = {-1, "Disconnect", (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_disconnect_in), (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_disconnect_out)};
static const GDBusArgInfo _org_bluez_device_dbus_arg_info_disconnect_profile_uuid = {-1, "uuid", "s"};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_disconnect_profile_in[] = {&_org_bluez_device_dbus_arg_info_disconnect_profile_uuid, NULL};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_disconnect_profile_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_device_dbus_method_info_disconnect_profile = {-1, "DisconnectProfile", (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_disconnect_profile_in), (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_disconnect_profile_out)};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_pair_in[] = {NULL};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_pair_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_device_dbus_method_info_pair = {-1, "Pair", (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_pair_in), (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_pair_out)};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_cancel_pairing_in[] = {NULL};
static const GDBusArgInfo * const _org_bluez_device_dbus_arg_info_cancel_pairing_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_device_dbus_method_info_cancel_pairing = {-1, "CancelPairing", (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_cancel_pairing_in), (GDBusArgInfo **) (&_org_bluez_device_dbus_arg_info_cancel_pairing_out)};
static const GDBusMethodInfo * const _org_bluez_device_dbus_method_info[] = {&_org_bluez_device_dbus_method_info_connect, &_org_bluez_device_dbus_method_info_disconnect, &_org_bluez_device_dbus_method_info_disconnect_profile, &_org_bluez_device_dbus_method_info_pair, &_org_bluez_device_dbus_method_info_cancel_pairing, NULL};
static const GDBusSignalInfo * const _org_bluez_device_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_address = {-1, "Address", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_name = {-1, "Name", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_icon = {-1, "Icon", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_bluetooth_class = {-1, "Class", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_appearance = {-1, "Appearance", "q", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_uuids = {-1, "UUIDs", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_paired = {-1, "Paired", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_connected = {-1, "Connected", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_trusted = {-1, "Trusted", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_blocked = {-1, "Blocked", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_alias = {-1, "Alias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_adapter = {-1, "Adapter", "o", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_legacy_pairing = {-1, "LegacyPairing", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_mod_alias = {-1, "Modalias", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _org_bluez_device_dbus_property_info_rssi = {-1, "RSSI", "n", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _org_bluez_device_dbus_property_info[] = {&_org_bluez_device_dbus_property_info_address, &_org_bluez_device_dbus_property_info_name, &_org_bluez_device_dbus_property_info_icon, &_org_bluez_device_dbus_property_info_bluetooth_class, &_org_bluez_device_dbus_property_info_appearance, &_org_bluez_device_dbus_property_info_uuids, &_org_bluez_device_dbus_property_info_paired, &_org_bluez_device_dbus_property_info_connected, &_org_bluez_device_dbus_property_info_trusted, &_org_bluez_device_dbus_property_info_blocked, &_org_bluez_device_dbus_property_info_alias, &_org_bluez_device_dbus_property_info_adapter, &_org_bluez_device_dbus_property_info_legacy_pairing, &_org_bluez_device_dbus_property_info_mod_alias, &_org_bluez_device_dbus_property_info_rssi, NULL};
static const GDBusInterfaceInfo _org_bluez_device_dbus_interface_info = {-1, "org.bluez.Device1", (GDBusMethodInfo **) (&_org_bluez_device_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_device_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_device_dbus_property_info)};
static const GDBusInterfaceVTable _org_bluez_device_dbus_interface_vtable = {org_bluez_device_dbus_interface_method_call, org_bluez_device_dbus_interface_get_property, org_bluez_device_dbus_interface_set_property};

GQuark org_bluez_error_quark (void) {
	static volatile gsize org_bluez_error_quark_volatile = 0;
	g_dbus_error_register_error_domain ("org_bluez_error-quark", &org_bluez_error_quark_volatile, org_bluez_error_entries, G_N_ELEMENTS (org_bluez_error_entries));
	return (GQuark) org_bluez_error_quark_volatile;
}


void org_bluez_device_connect (orgbluezDevice* self, GError** error) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->connect (self, error);
}


void org_bluez_device_disconnect (orgbluezDevice* self, GError** error) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->disconnect (self, error);
}


void org_bluez_device_disconnect_profile (orgbluezDevice* self, const gchar* uuid, GError** error) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->disconnect_profile (self, uuid, error);
}


void org_bluez_device_pair (orgbluezDevice* self, GError** error) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->pair (self, error);
}


void org_bluez_device_cancel_pairing (orgbluezDevice* self, GError** error) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->cancel_pairing (self, error);
}


gchar* org_bluez_device_get_address (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_address (self);
}


gchar* org_bluez_device_get_name (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_name (self);
}


gchar* org_bluez_device_get_icon (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_icon (self);
}


guint32 org_bluez_device_get_bluetooth_class (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_bluetooth_class (self);
}


guint16 org_bluez_device_get_appearance (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_appearance (self);
}


gchar** org_bluez_device_get_uuids (orgbluezDevice* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_uuids (self, result_length1);
}


gboolean org_bluez_device_get_paired (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_paired (self);
}


gboolean org_bluez_device_get_connected (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_connected (self);
}


gboolean org_bluez_device_get_trusted (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_trusted (self);
}


void org_bluez_device_set_trusted (orgbluezDevice* self, gboolean value) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->set_trusted (self, value);
}


gboolean org_bluez_device_get_blocked (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_blocked (self);
}


void org_bluez_device_set_blocked (orgbluezDevice* self, gboolean value) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->set_blocked (self, value);
}


gchar* org_bluez_device_get_alias (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_alias (self);
}


void org_bluez_device_set_alias (orgbluezDevice* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->set_alias (self, value);
}


char* org_bluez_device_get_adapter (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_adapter (self);
}


gboolean org_bluez_device_get_legacy_pairing (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_legacy_pairing (self);
}


gchar* org_bluez_device_get_mod_alias (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_mod_alias (self);
}


gint16 org_bluez_device_get_rssi (orgbluezDevice* self) {
	g_return_val_if_fail (self != NULL, 0);
	return ORG_BLUEZ_DEVICE_GET_INTERFACE (self)->get_rssi (self);
}


static void org_bluez_device_base_init (orgbluezDeviceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType org_bluez_device_get_type (void) {
	static volatile gsize org_bluez_device_type_id__volatile = 0;
	if (g_once_init_enter (&org_bluez_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (orgbluezDeviceIface), (GBaseInitFunc) org_bluez_device_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType org_bluez_device_type_id;
		org_bluez_device_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezDevice", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (org_bluez_device_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (org_bluez_device_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_device_proxy_get_type);
		g_type_set_qdata (org_bluez_device_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Device1");
		g_type_set_qdata (org_bluez_device_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_device_dbus_interface_info));
		g_type_set_qdata (org_bluez_device_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_device_register_object);
		g_once_init_leave (&org_bluez_device_type_id__volatile, org_bluez_device_type_id);
	}
	return org_bluez_device_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (orgbluezDeviceProxy, org_bluez_device_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_TYPE_DEVICE, org_bluez_device_proxy_org_bluez_device_interface_init) )
static void org_bluez_device_proxy_class_init (orgbluezDeviceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_device_proxy_g_signal;
}


static void org_bluez_device_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void org_bluez_device_proxy_init (orgbluezDeviceProxy* self) {
}


static void org_bluez_device_proxy_connect (orgbluezDevice* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	ORG_BLUEZ_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Connect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_device_proxy_disconnect (orgbluezDevice* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	ORG_BLUEZ_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Disconnect");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_device_proxy_disconnect_profile (orgbluezDevice* self, const gchar* uuid, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	ORG_BLUEZ_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "DisconnectProfile");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uuid));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_device_proxy_pair (orgbluezDevice* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	ORG_BLUEZ_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "Pair");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_device_proxy_cancel_pairing (orgbluezDevice* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	ORG_BLUEZ_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Device1", "CancelPairing");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gchar* org_bluez_device_dbus_proxy_get_address (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Address");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Address"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* org_bluez_device_dbus_proxy_get_name (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Name");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Name"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* org_bluez_device_dbus_proxy_get_icon (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Icon");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Icon"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static guint32 org_bluez_device_dbus_proxy_get_bluetooth_class (orgbluezDevice* self) {
	GVariant *_inner_reply;
	guint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Class");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Class"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint32 _tmp65_ = 0U;
			return _tmp65_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static guint16 org_bluez_device_dbus_proxy_get_appearance (orgbluezDevice* self) {
	GVariant *_inner_reply;
	guint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Appearance");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Appearance"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint16 _tmp66_ = 0U;
			return _tmp66_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar** org_bluez_device_dbus_proxy_get_uuids (orgbluezDevice* self, int* result_length1) {
	GVariant *_inner_reply;
	gchar** _result;
	int _result_length1;
	gchar** _tmp67_;
	int _tmp67__length;
	int _tmp67__size;
	int _tmp67__length1;
	GVariantIter _tmp68_;
	GVariant* _tmp69_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "UUIDs");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("UUIDs"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp67_ = g_new (gchar*, 5);
	_tmp67__length = 0;
	_tmp67__size = 4;
	_tmp67__length1 = 0;
	g_variant_iter_init (&_tmp68_, _inner_reply);
	for (; (_tmp69_ = g_variant_iter_next_value (&_tmp68_)) != NULL; _tmp67__length1++) {
		if (_tmp67__size == _tmp67__length) {
			_tmp67__size = 2 * _tmp67__size;
			_tmp67_ = g_renew (gchar*, _tmp67_, _tmp67__size + 1);
		}
		_tmp67_[_tmp67__length++] = g_variant_dup_string (_tmp69_, NULL);
		g_variant_unref (_tmp69_);
	}
	_result_length1 = _tmp67__length1;
	_tmp67_[_tmp67__length] = NULL;
	_result = _tmp67_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean org_bluez_device_dbus_proxy_get_paired (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Paired");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Paired"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp70_ = FALSE;
			return _tmp70_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean org_bluez_device_dbus_proxy_get_connected (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Connected");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Connected"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp71_ = FALSE;
			return _tmp71_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean org_bluez_device_dbus_proxy_get_trusted (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Trusted");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp72_ = FALSE;
			return _tmp72_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void org_bluez_device_dbus_proxy_set_trusted (orgbluezDevice* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Trusted"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gboolean org_bluez_device_dbus_proxy_get_blocked (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Blocked");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp73_ = FALSE;
			return _tmp73_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void org_bluez_device_dbus_proxy_set_blocked (orgbluezDevice* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Blocked"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gchar* org_bluez_device_dbus_proxy_get_alias (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Alias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void org_bluez_device_dbus_proxy_set_alias (orgbluezDevice* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Alias"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static char* org_bluez_device_dbus_proxy_get_adapter (orgbluezDevice* self) {
	GVariant *_inner_reply;
	char* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Adapter");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Adapter"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean org_bluez_device_dbus_proxy_get_legacy_pairing (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LegacyPairing");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LegacyPairing"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp74_ = FALSE;
			return _tmp74_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* org_bluez_device_dbus_proxy_get_mod_alias (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Modalias");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Modalias"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gint16 org_bluez_device_dbus_proxy_get_rssi (orgbluezDevice* self) {
	GVariant *_inner_reply;
	gint16 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "RSSI");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.bluez.Device1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("RSSI"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint16 _tmp75_ = 0;
			return _tmp75_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int16 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void org_bluez_device_proxy_org_bluez_device_interface_init (orgbluezDeviceIface* iface) {
	iface->connect = org_bluez_device_proxy_connect;
	iface->disconnect = org_bluez_device_proxy_disconnect;
	iface->disconnect_profile = org_bluez_device_proxy_disconnect_profile;
	iface->pair = org_bluez_device_proxy_pair;
	iface->cancel_pairing = org_bluez_device_proxy_cancel_pairing;
	iface->get_address = org_bluez_device_dbus_proxy_get_address;
	iface->get_name = org_bluez_device_dbus_proxy_get_name;
	iface->get_icon = org_bluez_device_dbus_proxy_get_icon;
	iface->get_bluetooth_class = org_bluez_device_dbus_proxy_get_bluetooth_class;
	iface->get_appearance = org_bluez_device_dbus_proxy_get_appearance;
	iface->get_uuids = org_bluez_device_dbus_proxy_get_uuids;
	iface->get_paired = org_bluez_device_dbus_proxy_get_paired;
	iface->get_connected = org_bluez_device_dbus_proxy_get_connected;
	iface->get_trusted = org_bluez_device_dbus_proxy_get_trusted;
	iface->set_trusted = org_bluez_device_dbus_proxy_set_trusted;
	iface->get_blocked = org_bluez_device_dbus_proxy_get_blocked;
	iface->set_blocked = org_bluez_device_dbus_proxy_set_blocked;
	iface->get_alias = org_bluez_device_dbus_proxy_get_alias;
	iface->set_alias = org_bluez_device_dbus_proxy_set_alias;
	iface->get_adapter = org_bluez_device_dbus_proxy_get_adapter;
	iface->get_legacy_pairing = org_bluez_device_dbus_proxy_get_legacy_pairing;
	iface->get_mod_alias = org_bluez_device_dbus_proxy_get_mod_alias;
	iface->get_rssi = org_bluez_device_dbus_proxy_get_rssi;
}


static void _dbus_org_bluez_device_connect (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	org_bluez_device_connect (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_org_bluez_device_disconnect (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	org_bluez_device_disconnect (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_org_bluez_device_disconnect_profile (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* uuid = NULL;
	GVariant* _tmp76_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp76_ = g_variant_iter_next_value (&_arguments_iter);
	uuid = g_variant_dup_string (_tmp76_, NULL);
	g_variant_unref (_tmp76_);
	org_bluez_device_disconnect_profile (self, uuid, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (uuid);
}


static void _dbus_org_bluez_device_pair (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	org_bluez_device_pair (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_org_bluez_device_cancel_pairing (orgbluezDevice* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	org_bluez_device_cancel_pairing (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void org_bluez_device_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Connect") == 0) {
		_dbus_org_bluez_device_connect (object, parameters, invocation);
	} else if (strcmp (method_name, "Disconnect") == 0) {
		_dbus_org_bluez_device_disconnect (object, parameters, invocation);
	} else if (strcmp (method_name, "DisconnectProfile") == 0) {
		_dbus_org_bluez_device_disconnect_profile (object, parameters, invocation);
	} else if (strcmp (method_name, "Pair") == 0) {
		_dbus_org_bluez_device_pair (object, parameters, invocation);
	} else if (strcmp (method_name, "CancelPairing") == 0) {
		_dbus_org_bluez_device_cancel_pairing (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_org_bluez_device_get_address (orgbluezDevice* self) {
	gchar* result;
	GVariant* _reply;
	result = org_bluez_device_get_address (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_name (orgbluezDevice* self) {
	gchar* result;
	GVariant* _reply;
	result = org_bluez_device_get_name (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_icon (orgbluezDevice* self) {
	gchar* result;
	GVariant* _reply;
	result = org_bluez_device_get_icon (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_bluetooth_class (orgbluezDevice* self) {
	guint32 result;
	GVariant* _reply;
	result = org_bluez_device_get_bluetooth_class (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_appearance (orgbluezDevice* self) {
	guint16 result;
	GVariant* _reply;
	result = org_bluez_device_get_appearance (self);
	_reply = g_variant_new_uint16 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_uuids (orgbluezDevice* self) {
	gchar** result;
	int result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp77_;
	GVariantBuilder _tmp78_;
	int _tmp79_;
	result = org_bluez_device_get_uuids (self, &result_length1);
	_tmp77_ = result;
	g_variant_builder_init (&_tmp78_, G_VARIANT_TYPE ("as"));
	for (_tmp79_ = 0; _tmp79_ < result_length1; _tmp79_++) {
		g_variant_builder_add_value (&_tmp78_, g_variant_new_string (*_tmp77_));
		_tmp77_++;
	}
	_reply = g_variant_builder_end (&_tmp78_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_paired (orgbluezDevice* self) {
	gboolean result;
	GVariant* _reply;
	result = org_bluez_device_get_paired (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_connected (orgbluezDevice* self) {
	gboolean result;
	GVariant* _reply;
	result = org_bluez_device_get_connected (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_trusted (orgbluezDevice* self) {
	gboolean result;
	GVariant* _reply;
	result = org_bluez_device_get_trusted (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_blocked (orgbluezDevice* self) {
	gboolean result;
	GVariant* _reply;
	result = org_bluez_device_get_blocked (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_alias (orgbluezDevice* self) {
	gchar* result;
	GVariant* _reply;
	result = org_bluez_device_get_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_adapter (orgbluezDevice* self) {
	char* result;
	GVariant* _reply;
	result = org_bluez_device_get_adapter (self);
	_reply = g_variant_new_object_path (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_legacy_pairing (orgbluezDevice* self) {
	gboolean result;
	GVariant* _reply;
	result = org_bluez_device_get_legacy_pairing (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_mod_alias (orgbluezDevice* self) {
	gchar* result;
	GVariant* _reply;
	result = org_bluez_device_get_mod_alias (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_org_bluez_device_get_rssi (orgbluezDevice* self) {
	gint16 result;
	GVariant* _reply;
	result = org_bluez_device_get_rssi (self);
	_reply = g_variant_new_int16 (result);
	return _reply;
}


static GVariant* org_bluez_device_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Address") == 0) {
		return _dbus_org_bluez_device_get_address (object);
	} else if (strcmp (property_name, "Name") == 0) {
		return _dbus_org_bluez_device_get_name (object);
	} else if (strcmp (property_name, "Icon") == 0) {
		return _dbus_org_bluez_device_get_icon (object);
	} else if (strcmp (property_name, "Class") == 0) {
		return _dbus_org_bluez_device_get_bluetooth_class (object);
	} else if (strcmp (property_name, "Appearance") == 0) {
		return _dbus_org_bluez_device_get_appearance (object);
	} else if (strcmp (property_name, "UUIDs") == 0) {
		return _dbus_org_bluez_device_get_uuids (object);
	} else if (strcmp (property_name, "Paired") == 0) {
		return _dbus_org_bluez_device_get_paired (object);
	} else if (strcmp (property_name, "Connected") == 0) {
		return _dbus_org_bluez_device_get_connected (object);
	} else if (strcmp (property_name, "Trusted") == 0) {
		return _dbus_org_bluez_device_get_trusted (object);
	} else if (strcmp (property_name, "Blocked") == 0) {
		return _dbus_org_bluez_device_get_blocked (object);
	} else if (strcmp (property_name, "Alias") == 0) {
		return _dbus_org_bluez_device_get_alias (object);
	} else if (strcmp (property_name, "Adapter") == 0) {
		return _dbus_org_bluez_device_get_adapter (object);
	} else if (strcmp (property_name, "LegacyPairing") == 0) {
		return _dbus_org_bluez_device_get_legacy_pairing (object);
	} else if (strcmp (property_name, "Modalias") == 0) {
		return _dbus_org_bluez_device_get_mod_alias (object);
	} else if (strcmp (property_name, "RSSI") == 0) {
		return _dbus_org_bluez_device_get_rssi (object);
	}
	return NULL;
}


static void _dbus_org_bluez_device_set_trusted (orgbluezDevice* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	org_bluez_device_set_trusted (self, value);
}


static void _dbus_org_bluez_device_set_blocked (orgbluezDevice* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	org_bluez_device_set_blocked (self, value);
}


static void _dbus_org_bluez_device_set_alias (orgbluezDevice* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	org_bluez_device_set_alias (self, value);
	_g_free0 (value);
}


static gboolean org_bluez_device_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Trusted") == 0) {
		_dbus_org_bluez_device_set_trusted (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Blocked") == 0) {
		_dbus_org_bluez_device_set_blocked (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Alias") == 0) {
		_dbus_org_bluez_device_set_alias (object, value);
		return TRUE;
	}
	return FALSE;
}


guint org_bluez_device_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_device_dbus_interface_info), &_org_bluez_device_dbus_interface_vtable, data, _org_bluez_device_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _org_bluez_device_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



