\name{krige.map}
\alias{krige.map}
\title{A Kriging map object}
\description{
  Object that holds various kriging output maps, intended to be used
  by specialized plotting functions.
}
\arguments{
  components:
  \item{x }{vector of x coordinates of grid}
  \item{y }{vector of y coordinates of grid}
  \item{z }{matrix of predicted values, see also \code{mode}}
  \item{var }{matrix of prediction variances}
  \item{done }{matrix with 0-1 coding of success of kriging}
  \item{tiles } { only present if generated by
    \code{\link{krige.tiles}}: a matrix containing the tile pattern, same dimension
    as \code{z}, values represent the tile number the actual grid point
    belongs to. }  
  \item{snb }{matrix with 0-1 coded search neighbourhood,
    columns refer to grid points, rows to data points} 
  \item{data }{a copy of the dataset \code{point.obj} used for kriging}
  \item{at}{name of variable from \code{point.obj} used for kriging}
}

\details{
  This object contains the output grid of \code{link{krige.grid}} and
  \code{link{krige.tiles}} functions. 
}

\references{
   ftp://ftp-stat.uni-klu.ac.at/pub/R/contrib
}
\seealso{\code{link{krige.grid}}, \code{link{krige.tiles}},
  \code{link{plot.krige.map}}
}
\author{A. Gebhardt <agebhard@uni-klu.ac.at>}
\keyword{rgeostat}