"add.legend" <-
  function (zlim,zlevels,col.levels,x.range,y.range,ngrid=100,width=0.075,
            nwidth=10,
            legend.pos="bottom",label="",half="full") 
{
  
  dx <- diff(range(x.range))
  dy <- diff(range(y.range))
  if(legend.pos=="bottom" || legend.pos=="top"){
    if(half=="left")
      xx <- seq(min(x.range) + 0.1 * dx,
                sum(x.range)/2 - 0.1 * dx, length = ngrid)
    if(half=="right")
      xx <- seq(sum(x.range)/2 + 0.1 * dx,
                max(x.range) - 0.1 * dx, length = ngrid)
    if(half=="full")
      xx <- seq(min(x.range) + 0.1 * dx,
                max(x.range) - 0.1 * dx, length = ngrid)
  } else if (legend.pos=="left" || legend.pos=="right"){
    if(half=="left")
      yy <- seq(min(y.range) + 0.1 * dy,
                sum(y.range)/2 - 0.1 * dy, length = ngrid)
    if(half=="right")
      yy <- seq(sum(y.range)/2 + 0.1 * dy,
                max(y.range) - 0.1 * dy, length = ngrid)
    if(half=="full")
      yy <- seq(min(y.range) + 0.1 * dy, max(y.range)
                - 0.1 * dy, length = ngrid)
  }
  
  if(legend.pos=="left"){
      xx <- seq(min(x.range) + 0.5*width * dx, min(x.range)
              + 1.5*width * dx, length = nwidth)
  } else if (legend.pos=="right"){
      xx <- seq(max(x.range) - 1.5*width * dx, max(x.range)
              - 0.5*width * dx, length = nwidth)
  }

  if(legend.pos=="top"){
    yy <- seq(max(y.range) - 1.5*width * dy, max(y.range)
              - 0.5 * width * dy, length = nwidth)
  } else if (legend.pos=="bottom"){
    yy <- seq(min(y.range) + 0.5*width * dy, min(y.range)
              + 1.5*width * dy, length = nwidth)
  }
  
  xy <- matrix(0, nwidth, ngrid)
  for (j in 1:ngrid) xy[, j] <- zlim[1] +
    (j - 1)/ngrid * (diff(zlim))
  if(legend.pos=="bottom" || legend.pos=="top"){
    xy<-t(xy)
  } else if  (legend.pos=="left" || legend.pos=="right"){
  }
  image(xx, yy, xy, add = T, zlim = zlim,
        col = col.levels)
  contour(xx, yy, xy, levels = zlevels, add = T)
  if(legend.pos=="bottom" || legend.pos=="top"){
    lines(c(xx[1], xx[ngrid], xx[ngrid], xx[1], xx[1]), 
          c(yy[1], yy[1], yy[nwidth], yy[nwidth], yy[1]))
    if (legend.pos=="bottom"){
      text(xx[1],yy[1],
           label, adj = c(0, 1),srt=0)
      text(xx[1],yy[nwidth],
           round(zlim[1],2), adj = c(0, 0),srt=0)
      text(xx[ngrid],yy[nwidth],
           round(zlim[2],2), adj = c(1, 0),srt=0)
    }
    if (legend.pos=="top"){
      text(xx[1],yy[nwidth],
           label, adj = c(0, 0),srt=0)
      text(xx[1],yy[1],
           round(zlim[1],2), adj = c(0, 1),srt=0)
      text(xx[ngrid],yy[1],
           round(zlim[2],2), adj = c(1, 1),srt=0)
    }
  } else if  (legend.pos=="left" || legend.pos=="right"){
    lines(c(xx[1], xx[nwidth], xx[nwidth], xx[1], xx[1]), 
          c(yy[1], yy[1], yy[ngrid], yy[ngrid], yy[1]))
    if (legend.pos=="left"){
      text(xx[1],yy[1],
           label, adj = c(0, 0),srt=90)
      text(xx[nwidth],yy[1],
           round(zlim[1],2), adj = c(0, 1),srt=90)
      text(xx[nwidth],yy[ngrid],
           round(zlim[2],2), adj = c(1, 1),srt=90)
    }
    if (legend.pos=="right"){
      text(xx[nwidth],yy[1],
           label, adj = c(0, 1),srt=90)
      text(xx[1],yy[ngrid],
           round(zlim[1],2), adj = c(1, 0),srt=90)
      text(xx[1],yy[1],
           round(zlim[2],2), adj = c(0, 0),srt=90)
    }
  }
#  text(xx[1] + c(0:(length(zlevels) - 1)) *
#        (xx[ngrid] - xx[1]) * (diff(zlevels)[1])/(diff(zlim)),
#       rep(yy[1] - 0.04 * dy, length(zlevels)),
#       as.character(zlevels))
}
